/* 
    This is a simple gtk+ application that monitors /tmp using fam++

    Copyright (C) 2000 Ben Martin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gtk/gtk.h>
#include <gnome.h>
// include gdk.h before fam.hh if you want the fampp_gdk class to be defined.
#include <gdk/gdk.h> 
#include <fam.hh>
// only include famStatic in one cpp file. It has a few global (in __FAM_NAMESPACE) functions
#include <famStatic.hh> 
#include <handle.hh>
using namespace __FAM_NAMESPACE;

static gint delete_event_cb(GtkWidget* w, GdkEventAny* e, gpointer data);
static void button_click_cb(GtkWidget* w, gpointer data);

/*
	A simple functor that is called whenever a file in /tmp is changed.
*/
class myFileChangedHandler {
	GtkWidget* w;
	GtkWidget* label;
public:
	myFileChangedHandler(
		GtkWidget* _w,GtkWidget* _label
	):
		w(_w),label(_label)
	{}

	void operator()(FamppChangedEvent &ev) { 

		gtk_label_set_text(GTK_LABEL(label), 
			(gchar*)ev.getFileName().c_str());
	}
};

class myFileDeletedHandler {
public:

	void operator()(FamppDeletedEvent &ev) { 

		printf("deleted file:%s\n", ev.getFileName().c_str());
	}
};

int 
main(int argc, char* argv[])
{
  GtkWidget* window;
  GtkWidget* button;
  GtkWidget* label;

  gtk_init(&argc, &argv);  

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  button = gtk_button_new();

  label  = gtk_label_new("Change /tmp!");

  gtk_container_add(GTK_CONTAINER(button), label);
  gtk_container_add(GTK_CONTAINER(window), button);

  gtk_window_set_title(GTK_WINDOW(window), "Hello");
  gtk_container_set_border_width(GTK_CONTAINER(button), 10);
  
  gtk_signal_connect(GTK_OBJECT(window),
                     "delete_event",
                     GTK_SIGNAL_FUNC(delete_event_cb),
                     NULL);

  gtk_signal_connect(GTK_OBJECT(button),
                     "clicked",
                     GTK_SIGNAL_FUNC(button_click_cb),
                     label);

	
	try {

		// Begin FAM code //

		// get fam to hook into gdk for select(), automatic event handling
		Fampp_gdk fam(true);	

		// Create a request for /tmp
		Handle<FamppRequest> req(fam.MonitorDirectory("/tmp"));

		// set our handler functor.
		req->setHandler(FamppChangedEvent(),
			myFileChangedHandler(
				GTK_WIDGET(button),
				GTK_WIDGET(label)));
		
		req->setHandler(FamppDeletedEvent(),myFileDeletedHandler());

		// end of fam specific code, (fam) callbacks initiated by gtk_main() for us 
		// gtk only code from here!
		gtk_widget_show_all(window);
		gtk_main();
		return 0;
		}
	catch(FamppException e) {
		cout << e << endl;
	}
}

static gint 
delete_event_cb(GtkWidget* window, GdkEventAny* e, gpointer data)
{
  gtk_main_quit();
  return FALSE;
}

static void 
button_click_cb(GtkWidget* w, gpointer data)
{
  GtkWidget* label;
  gchar* text;
  gchar* tmp;

  label = GTK_WIDGET(data);

  gtk_label_get(GTK_LABEL(label), &text);

  tmp = g_strdup(text);

  g_strreverse(tmp);

  gtk_label_set_text(GTK_LABEL(label), tmp);

  g_free(tmp);
}
