/*
 * Decompiled with CFR 0.152.
 */
package FesiForm;

import FESI.jslib.JSException;
import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSUtil;
import FesiForm.DefaultErrorHandler;
import FesiForm.GuiContext;
import FesiForm.GuiDocumentHandler;
import java.io.FileReader;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;

public class FesiForm {
    private JSGlobalObject global;
    private static String[] extensions = new String[]{"FESI.Extensions.BasicIOs", "FESI.Extensions.FileIO", "FESI.Extensions.JavaAccess", "FESI.Extensions.Database"};
    private InputSource inputSource;
    private boolean trace = false;

    public FesiForm(InputSource inputSource) throws JSException {
        this.inputSource = inputSource;
        this.global = JSUtil.makeEvaluator((String[])extensions);
    }

    public FesiForm(InputSource inputSource, JSGlobalObject jSGlobalObject) throws JSException {
        this.inputSource = inputSource;
        this.global = jSGlobalObject;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public GuiContext process() throws JSException {
        Parser parser;
        try {
            parser = ParserFactory.makeParser();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JSException("SAX Parser not found", (Throwable)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSException("SAX Parser cannot be loaded", (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new JSException("SAX Parser cannot be instanciated", (Throwable)instantiationException);
        }
        parser.setErrorHandler(new DefaultErrorHandler());
        GuiContext guiContext = new GuiContext(this.global, parser);
        try {
            this.global.setMember("__guiContext", (Object)guiContext);
            this.global.eval("function getById(_id) {return __guiContext.getById(_id);}");
        }
        catch (JSException jSException) {
            System.err.println("Cannot initialize FESI: " + jSException.getMessage());
            jSException.printStackTrace();
            System.exit(1);
        }
        GuiDocumentHandler guiDocumentHandler = new GuiDocumentHandler(guiContext, this.trace);
        parser.setDocumentHandler(guiDocumentHandler);
        try {
            parser.parse(this.inputSource);
        }
        catch (IOException iOException) {
            throw new JSException("IO error processing xml", (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            throw new JSException("Parsing error processing xml", (Throwable)sAXException);
        }
        return guiContext;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            String string = "form.xml";
            if (stringArray.length > 1) {
                if (stringArray[0].equals("-t")) {
                    bl = true;
                }
                string = stringArray[1];
            } else if (stringArray.length > 0) {
                string = stringArray[0];
            }
            FileReader fileReader = new FileReader(string);
            InputSource inputSource = new InputSource(fileReader);
            inputSource.setPublicId(string);
            FesiForm fesiForm = new FesiForm(inputSource);
            fesiForm.setTrace(bl);
            GuiContext guiContext = fesiForm.process();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }
}

