/*
 * Decompiled with CFR 0.152.
 */
package FESI.AST;

import FESI.AST.EcmaScriptTreeConstants;
import FESI.AST.EcmaScriptVisitor;
import FESI.AST.Node;
import FESI.Exceptions.ProgrammingError;
import FESI.Parser.EcmaScript;
import FESI.Parser.EcmaScriptConstants;

public abstract class SimpleNode
implements Node,
EcmaScriptConstants {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected EcmaScript parser;
    protected int line;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(EcmaScript ecmaScript, int n) {
        this(n);
        this.parser = ecmaScript;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.length;
    }

    public Object jjtAccept(EcmaScriptVisitor ecmaScriptVisitor, Object object) {
        return ecmaScriptVisitor.visit(this, object);
    }

    public Object childrenAccept(EcmaScriptVisitor ecmaScriptVisitor, Object object) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n].jjtAccept(ecmaScriptVisitor, object);
                ++n;
            }
        }
        return object;
    }

    public String toString() {
        return EcmaScriptTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return String.valueOf(string) + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(String.valueOf(string) + " ");
                }
                ++n;
            }
        }
    }

    public void setLineNumber(int n) {
        this.line = n;
    }

    public int getLineNumber() {
        return this.line;
    }

    public void assertNoChildren() {
        if (this.jjtGetNumChildren() > 0) {
            throw new ProgrammingError("AST Should have no children");
        }
    }

    public void assertOneChild() {
        if (this.jjtGetNumChildren() != 1) {
            throw new ProgrammingError("AST Should have 1 child");
        }
    }

    public void assertTwoChildren() {
        if (this.jjtGetNumChildren() != 2) {
            throw new ProgrammingError("AST Should have 2 children");
        }
    }

    public void assertThreeChildren() {
        if (this.jjtGetNumChildren() != 3) {
            throw new ProgrammingError("AST Should have 3 children");
        }
    }

    public void assertFourChildren() {
        if (this.jjtGetNumChildren() != 4) {
            throw new ProgrammingError("AST Should have 4 children");
        }
    }
}

