/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.DateObject;
import FESI.Data.DatePrototype;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateObject
extends BuiltinFunctionObject {
    private DateObject(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator, "Date", 7);
    }

    public String toString() {
        return "<Date>";
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        return new ESString(new Date().toString());
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        DatePrototype datePrototype = null;
        ESObject eSObject2 = this.evaluator.getDatePrototype();
        datePrototype = new DatePrototype(eSObject2, this.evaluator);
        int n = eSValueArray.length;
        if (n == 2 || n == 0) {
            datePrototype.date = new Date();
        } else if (n == 1) {
            double d = eSValueArray[0].doubleValue();
            datePrototype.date = Double.isNaN(d) ? null : new Date((long)d);
        } else {
            int n2 = eSValueArray[0].toInt32();
            if (n2 >= 0 && n2 <= 99) {
                n2 += 1900;
            }
            int n3 = eSValueArray[1].toInt32();
            int n4 = eSValueArray[2].toInt32();
            int n5 = n > 3 ? eSValueArray[3].toInt32() : 0;
            int n6 = n > 4 ? eSValueArray[4].toInt32() : 0;
            int n7 = n > 5 ? eSValueArray[5].toInt32() : 0;
            int n8 = n > 6 ? eSValueArray[6].toInt32() : 0;
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3, n4, n5, n6, n7);
            if (n8 != 0) {
                gregorianCalendar.set(14, n8);
            }
            datePrototype.date = gregorianCalendar.getTime();
        }
        return datePrototype;
    }

    public static DateObject makeDateObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        DatePrototype datePrototype = new DatePrototype(objectPrototype, evaluator);
        DateObject dateObject = new DateObject(functionPrototype, evaluator);
        try {
            dateObject.putHiddenProperty("prototype", datePrototype);
            dateObject.putHiddenProperty("length", new ESNumber(7.0));
            dateObject.putHiddenProperty("parse", new 1.DateObjectParse("parse", evaluator, functionPrototype));
            dateObject.putHiddenProperty("UTC", new 1.DateObjectUTC("UTC", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("constructor", dateObject);
            datePrototype.putHiddenProperty("toString", new 1.DatePrototypeToString("toString", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("toLocaleString", new 1.DatePrototypeToLocaleString("toLocaleString", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("toGMTString", new 1.DatePrototypeToGMTString("toGMTString", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("toUTCString", new 1.DatePrototypeToGMTString("toUTCString", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("valueOf", new 1.DatePrototypeValueOf("valueOf", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getTime", new 1.DatePrototypeValueOf("getTime", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getYear", new 1.DatePrototypeGetYear("getYear", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getFullYear", new 1.DatePrototypeGetFullYear("getFullYear", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getUTCFullYear", new 1.DatePrototypeGetUTCFullYear("getUTCFullYear", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getMonth", new 1.DatePrototypeGetMonth("getMonth", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getUTCMonth", new 1.DatePrototypeGetUTCMonth("getUTCMonth", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getDate", new 1.DatePrototypeGetDate("getDate", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getUTCDate", new 1.DatePrototypeGetUTCDate("getUTCDate", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getDay", new 1.DatePrototypeGetDay("getDay", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getUTCDay", new 1.DatePrototypeGetUTCDay("getUTCDay", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getHours", new 1.DatePrototypeGetHours("getHours", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getUTCHours", new 1.DatePrototypeGetUTCHours("getUTCHours", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getMinutes", new 1.DatePrototypeGetMinutes("getMinutes", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getUTCMinutes", new 1.DatePrototypeGetUTCMinutes("getUTCMinutes", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getSeconds", new 1.DatePrototypeGetSeconds("getSeconds", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getUTCSeconds", new 1.DatePrototypeGetUTCSeconds("getUTCSeconds", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getMilliseconds", new 1.DatePrototypeGetMilliseconds("getMilliseconds", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getUTCMilliseconds", new 1.DatePrototypeGetUTCMilliseconds("getUTCMilliseconds", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setYear", new 1.DatePrototypeSetYear("setYear", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setFullYear", new 1.DatePrototypeSetFullYear("setFullYear", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setUTCFullYear", new 1.DatePrototypeSetUTCFullYear("setUTCFullYear", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setMonth", new 1.DatePrototypeSetMonth("setMonth", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setUTCMonth", new 1.DatePrototypeSetUTCMonth("setUTCMonth", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setDate", new 1.DatePrototypeSetDate("setDate", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setUTCDate", new 1.DatePrototypeSetUTCDate("setUTCDate", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setHours", new 1.DatePrototypeSetHours("setHours", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setUTCHours", new 1.DatePrototypeSetUTCHours("setUTCHours", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setMinutes", new 1.DatePrototypeSetMinutes("setMinutes", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setUTCMinutes", new 1.DatePrototypeSetUTCMinutes("setUTCMinutes", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setSeconds", new 1.DatePrototypeSetSeconds("setSeconds", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setUTCSeconds", new 1.DatePrototypeSetUTCSeconds("setUTCSeconds", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setMilliseconds", new 1.DatePrototypeSetMilliseconds("setMilliseconds", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setUTCMilliseconds", new 1.DatePrototypeSetUTCMilliseconds("setUTCMilliseconds", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getTimezoneOffset", new 1.DatePrototypeGetTimezoneOffset("getTimezoneOffset", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("setTime", new 1.DatePrototypeSetTime("setTime", evaluator, functionPrototype));
        }
        catch (EcmaScriptException ecmaScriptException) {
            ecmaScriptException.printStackTrace();
            throw new ProgrammingError(ecmaScriptException.getMessage());
        }
        evaluator.setDatePrototype(datePrototype);
        return dateObject;
    }
}

