/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.AST.ASTAllocationExpression;
import FESI.AST.ASTAndExpressionSequence;
import FESI.AST.ASTAssignmentExpression;
import FESI.AST.ASTBinaryExpressionSequence;
import FESI.AST.ASTBreakStatement;
import FESI.AST.ASTCompositeReference;
import FESI.AST.ASTConditionalExpression;
import FESI.AST.ASTContinueStatement;
import FESI.AST.ASTEmptyExpression;
import FESI.AST.ASTExpressionList;
import FESI.AST.ASTForInStatement;
import FESI.AST.ASTForStatement;
import FESI.AST.ASTForVarInStatement;
import FESI.AST.ASTForVarStatement;
import FESI.AST.ASTFormalParameterList;
import FESI.AST.ASTFunctionCallParameters;
import FESI.AST.ASTFunctionDeclaration;
import FESI.AST.ASTIdentifier;
import FESI.AST.ASTIfStatement;
import FESI.AST.ASTLiteral;
import FESI.AST.ASTOperator;
import FESI.AST.ASTOrExpressionSequence;
import FESI.AST.ASTPostfixExpression;
import FESI.AST.ASTProgram;
import FESI.AST.ASTPropertyIdentifierReference;
import FESI.AST.ASTPropertyValueReference;
import FESI.AST.ASTReturnStatement;
import FESI.AST.ASTStatement;
import FESI.AST.ASTStatementList;
import FESI.AST.ASTThisReference;
import FESI.AST.ASTUnaryExpression;
import FESI.AST.ASTVariableDeclaration;
import FESI.AST.ASTWhileStatement;
import FESI.AST.ASTWithStatement;
import FESI.AST.EcmaScriptVisitor;
import FESI.AST.Node;
import FESI.AST.SimpleNode;
import FESI.Data.ESArguments;
import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESReference;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LineEvaluationSource;
import FESI.Interpreter.PackagedException;
import FESI.Parser.EcmaScriptConstants;
import java.util.Enumeration;

public class EcmaScriptEvaluateVisitor
implements EcmaScriptVisitor,
EcmaScriptConstants {
    public static final int C_NORMAL = 0;
    public static final int C_RETURN = 1;
    public static final int C_BREAK = 2;
    public static final int C_CONTINUE = 3;
    private static final int COMPARE_TRUE = -1;
    private static final int COMPARE_UNDEFINED = 0;
    private static final int COMPARE_FALSE = 1;
    private boolean debug = false;
    private static final Object FOR_VALUE = new Object();
    private static final Object FOR_REFERENCE = new Object();
    private Evaluator evaluator;
    private int completionCode = -1;

    public EcmaScriptEvaluateVisitor(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public int getCompletionCode() {
        return this.completionCode;
    }

    public String getCompletionCodeString() {
        String[] stringArray = new String[]{"normal", "return", "break", "continue"};
        return stringArray[this.completionCode];
    }

    public ESValue evaluateProgram(ASTProgram aSTProgram, EvaluationSource evaluationSource) throws EcmaScriptException {
        if (this.completionCode != -1) {
            throw new ProgrammingError("Multiple use of evalution visitor");
        }
        this.completionCode = 0;
        ESValue eSValue = null;
        if (this.debug) {
            System.out.println("evaluateProgram for: " + aSTProgram);
        }
        try {
            eSValue = (ESValue)aSTProgram.jjtAccept(this, FOR_VALUE);
        }
        catch (PackagedException packagedException) {
            packagedException.exception.appendEvaluationSource(new LineEvaluationSource(packagedException.node.getLineNumber(), evaluationSource));
            throw packagedException.exception;
        }
        if (this.debug) {
            System.out.println("evaluateProgram result: " + eSValue);
        }
        return eSValue;
    }

    public ESValue evaluateFunction(ASTStatementList aSTStatementList, EvaluationSource evaluationSource) throws EcmaScriptException {
        if (this.completionCode != -1) {
            throw new ProgrammingError("Multiple use of evaluation visitor");
        }
        this.completionCode = 0;
        ESValue eSValue = null;
        if (this.debug) {
            System.out.println("evaluateFunction for: " + aSTStatementList);
        }
        try {
            eSValue = (ESValue)aSTStatementList.jjtAccept(this, FOR_VALUE);
        }
        catch (PackagedException packagedException) {
            packagedException.exception.appendEvaluationSource(new LineEvaluationSource(packagedException.node.getLineNumber(), evaluationSource));
            throw packagedException.exception;
        }
        if (this.debug) {
            System.out.println("evaluateFunction result: " + eSValue);
        }
        return eSValue;
    }

    public ESValue evaluateWith(ASTStatement aSTStatement, EvaluationSource evaluationSource) throws EcmaScriptException {
        if (this.completionCode != -1) {
            throw new ProgrammingError("Multiple use of evalution visitor");
        }
        this.completionCode = 0;
        ESValue eSValue = null;
        if (this.debug) {
            System.out.println("evaluateWith for: " + aSTStatement);
        }
        try {
            eSValue = (ESValue)aSTStatement.jjtAccept(this, FOR_VALUE);
        }
        catch (PackagedException packagedException) {
            packagedException.exception.appendEvaluationSource(new LineEvaluationSource(packagedException.node.getLineNumber(), evaluationSource));
            throw packagedException.exception;
        }
        if (this.debug) {
            System.out.println("evaluateWith result: " + eSValue);
        }
        return eSValue;
    }

    private int compare(ESValue eSValue, ESValue eSValue2) throws EcmaScriptException {
        ESValue eSValue3 = eSValue.toESPrimitive(4);
        ESValue eSValue4 = eSValue2.toESPrimitive(4);
        if (eSValue3 instanceof ESString && eSValue4 instanceof ESString) {
            String string;
            String string2 = eSValue.toString();
            int n = string2.compareTo(string = eSValue2.toString());
            if (n < 0) {
                return -1;
            }
            return 1;
        }
        double d = eSValue.doubleValue();
        double d2 = eSValue2.doubleValue();
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return 0;
        }
        int n = eSValue.doubleValue() < eSValue2.doubleValue() ? -1 : 1;
        return n;
    }

    private boolean equal(ESValue eSValue, ESValue eSValue2) throws EcmaScriptException {
        if (eSValue.getTypeOf() == eSValue2.getTypeOf()) {
            if (eSValue instanceof ESUndefined) {
                return true;
            }
            if (eSValue instanceof ESNull) {
                return true;
            }
            if (eSValue instanceof ESNumber) {
                double d;
                double d2 = eSValue.doubleValue();
                return d2 == (d = eSValue2.doubleValue());
            }
            if (eSValue instanceof ESString) {
                String string = eSValue.toString();
                String string2 = eSValue2.toString();
                return string.equals(string2);
            }
            if (eSValue instanceof ESBoolean) {
                boolean bl;
                boolean bl2 = eSValue.booleanValue();
                return bl2 == (bl = eSValue2.booleanValue());
            }
            return eSValue == eSValue2;
        }
        if (eSValue instanceof ESUndefined && eSValue2 instanceof ESNull) {
            return true;
        }
        if (eSValue2 instanceof ESUndefined && eSValue instanceof ESNull) {
            return true;
        }
        if (eSValue instanceof ESNumber && eSValue2 instanceof ESString || eSValue2 instanceof ESNumber && eSValue instanceof ESString) {
            double d;
            double d3 = eSValue.doubleValue();
            return d3 == (d = eSValue2.doubleValue());
        }
        if (eSValue instanceof ESBoolean || eSValue2 instanceof ESBoolean) {
            double d;
            double d4 = eSValue.doubleValue();
            return d4 == (d = eSValue2.doubleValue());
        }
        if (eSValue instanceof ESNumber && eSValue2 instanceof ESObject || eSValue instanceof ESString && eSValue2 instanceof ESObject) {
            return this.equal(eSValue, eSValue2.toESPrimitive());
        }
        if (eSValue2 instanceof ESNumber && eSValue instanceof ESObject || eSValue2 instanceof ESString && eSValue instanceof ESObject) {
            return this.equal(eSValue2, eSValue.toESPrimitive());
        }
        return false;
    }

    public Object visit(SimpleNode simpleNode, Object object) {
        throw new ProgrammingError("Visitor not implemented for node type " + simpleNode.getClass());
    }

    public Object visit(ASTProgram aSTProgram, Object object) {
        int n = aSTProgram.jjtGetNumChildren();
        if (n <= 0) {
            throw new ProgrammingError("Empty program not implemented");
        }
        Object object2 = aSTProgram.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
        int n2 = 1;
        while (n2 < aSTProgram.jjtGetNumChildren()) {
            Node node = aSTProgram.jjtGetChild(n2);
            object2 = node.jjtAccept(this, FOR_VALUE);
            ++n2;
        }
        return object2;
    }

    public Object visit(ASTStatementList aSTStatementList, Object object) {
        aSTStatementList.jjtGetNumChildren();
        Object object2 = ESUndefined.theUndefined;
        int n = 0;
        while (n < aSTStatementList.jjtGetNumChildren()) {
            if (this.completionCode != 0) {
                return object2;
            }
            Node node = aSTStatementList.jjtGetChild(n);
            object2 = node.jjtAccept(this, FOR_VALUE);
            ++n;
        }
        return object2;
    }

    public Object visit(ASTFunctionDeclaration aSTFunctionDeclaration, Object object) {
        return null;
    }

    public Object visit(ASTFormalParameterList aSTFormalParameterList, Object object) {
        throw new ProgrammingError("Should not visit this");
    }

    public Object visit(ASTStatement aSTStatement, Object object) {
        Object object2 = null;
        int n = aSTStatement.jjtGetNumChildren();
        if (n == 1) {
            object2 = aSTStatement.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
        } else if (n != 0) {
            throw new ProgrammingError("Bad AST in statement (>1 child");
        }
        return object2;
    }

    public Object visit(ASTVariableDeclaration aSTVariableDeclaration, Object object) {
        ESValue eSValue = null;
        int n = aSTVariableDeclaration.jjtGetNumChildren();
        if (n < 1 || n > 2) {
            throw new ProgrammingError("Bad AST in variable declaration");
        }
        if (n == 2) {
            try {
                Object object2 = aSTVariableDeclaration.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
                if (!(object2 instanceof ESReference)) {
                    throw new ProgrammingError("Value '" + object2.toString() + "' is not a variable");
                }
                ESReference eSReference = (ESReference)object2;
                ESValue eSValue2 = (ESValue)aSTVariableDeclaration.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                eSReference.putValue(null, eSValue2);
                eSValue = eSValue2;
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new PackagedException(ecmaScriptException, aSTVariableDeclaration);
            }
        }
        return eSValue;
    }

    public Object visit(ASTIfStatement aSTIfStatement, Object object) {
        Object object2 = null;
        int n = aSTIfStatement.jjtGetNumChildren();
        if (n < 2 || n > 3) {
            throw new ProgrammingError("Bad AST in IF statement");
        }
        try {
            ESValue eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTIfStatement.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            boolean bl = eSValue.booleanValue();
            if (bl) {
                object2 = aSTIfStatement.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
            } else if (n == 3) {
                object2 = aSTIfStatement.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTIfStatement);
        }
        return object2;
    }

    public Object visit(ASTWhileStatement aSTWhileStatement, Object object) {
        Object object2 = null;
        aSTWhileStatement.assertTwoChildren();
        try {
            ESValue eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTWhileStatement.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            while (eSValue.booleanValue()) {
                object2 = aSTWhileStatement.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) {
                    return object2;
                }
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    return object2;
                }
                if (this.completionCode == 3) {
                    eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTWhileStatement.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
                    this.completionCode = 0;
                    continue;
                }
                eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTWhileStatement.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTWhileStatement);
        }
        return object2;
    }

    public Object visit(ASTForStatement aSTForStatement, Object object) {
        Object object2 = null;
        try {
            aSTForStatement.assertFourChildren();
            aSTForStatement.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
            Node node = aSTForStatement.jjtGetChild(1);
            ESValue eSValue = node instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(node.jjtAccept(this, FOR_VALUE));
            while (((ESValue)eSValue).booleanValue()) {
                object2 = aSTForStatement.jjtGetChild(3).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) {
                    return object2;
                }
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    return object2;
                }
                if (this.completionCode == 3) {
                    aSTForStatement.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                    eSValue = node instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(node.jjtAccept(this, FOR_VALUE));
                    this.completionCode = 0;
                    continue;
                }
                aSTForStatement.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                eSValue = node instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(node.jjtAccept(this, FOR_VALUE));
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTForStatement);
        }
        return object2;
    }

    public Object visit(ASTForVarStatement aSTForVarStatement, Object object) {
        Object object2 = null;
        try {
            aSTForVarStatement.assertFourChildren();
            aSTForVarStatement.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
            Node node = aSTForVarStatement.jjtGetChild(1);
            ESValue eSValue = node instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(node.jjtAccept(this, FOR_VALUE));
            while (((ESValue)eSValue).booleanValue()) {
                object2 = aSTForVarStatement.jjtGetChild(3).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) {
                    return object2;
                }
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    return object2;
                }
                if (this.completionCode == 3) {
                    aSTForVarStatement.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                    eSValue = node instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(node.jjtAccept(this, FOR_VALUE));
                    this.completionCode = 0;
                    continue;
                }
                aSTForVarStatement.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                eSValue = node instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(node.jjtAccept(this, FOR_VALUE));
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTForVarStatement);
        }
        return object2;
    }

    public Object visit(ASTForInStatement aSTForInStatement, Object object) {
        Object object2 = null;
        aSTForInStatement.assertThreeChildren();
        try {
            ESValue eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTForInStatement.jjtGetChild(1).jjtAccept(this, FOR_VALUE));
            ESObject eSObject = (ESObject)eSValue.toESObject(this.evaluator);
            boolean bl = eSObject.isDirectEnumerator();
            Enumeration enumeration = eSObject.getProperties();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                ESValue eSValue2 = bl ? ESLoader.normalizeValue(e, this.evaluator) : new ESString(e.toString());
                Object object3 = aSTForInStatement.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
                if (!(object3 instanceof ESReference)) {
                    throw new EcmaScriptException("Value '" + object3.toString() + "' is not an assignable object or property");
                }
                ESReference eSReference = (ESReference)object3;
                this.evaluator.putValue(eSReference, eSValue2);
                object2 = aSTForInStatement.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) break;
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    break;
                }
                if (this.completionCode != 3) continue;
                this.completionCode = 0;
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTForInStatement);
        }
        return object2;
    }

    public Object visit(ASTForVarInStatement aSTForVarInStatement, Object object) {
        Object object2 = null;
        aSTForVarInStatement.assertFourChildren();
        try {
            Object object3 = aSTForVarInStatement.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
            if (!(object3 instanceof ESReference)) {
                throw new ProgrammingError("Value '" + object3.toString() + "' is not a variable");
            }
            ESReference eSReference = (ESReference)object3;
            ESValue eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTForVarInStatement.jjtGetChild(1).jjtAccept(this, FOR_VALUE));
            this.evaluator.putValue(eSReference, eSValue);
            ESValue eSValue2 = EcmaScriptEvaluateVisitor.acceptNull(aSTForVarInStatement.jjtGetChild(2).jjtAccept(this, FOR_VALUE));
            ESObject eSObject = (ESObject)eSValue2.toESObject(this.evaluator);
            boolean bl = eSObject.isDirectEnumerator();
            Enumeration enumeration = eSObject.getProperties();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                ESValue eSValue3 = bl ? ESLoader.normalizeValue(e, this.evaluator) : new ESString(e.toString());
                eSReference = (ESReference)aSTForVarInStatement.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
                this.evaluator.putValue(eSReference, eSValue3);
                object2 = aSTForVarInStatement.jjtGetChild(3).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) break;
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    break;
                }
                if (this.completionCode != 3) continue;
                this.completionCode = 0;
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTForVarInStatement);
        }
        return object2;
    }

    public Object visit(ASTContinueStatement aSTContinueStatement, Object object) {
        aSTContinueStatement.assertNoChildren();
        this.completionCode = 3;
        return null;
    }

    public Object visit(ASTBreakStatement aSTBreakStatement, Object object) {
        aSTBreakStatement.assertNoChildren();
        this.completionCode = 2;
        return null;
    }

    public Object visit(ASTReturnStatement aSTReturnStatement, Object object) {
        aSTReturnStatement.assertOneChild();
        Object object2 = aSTReturnStatement.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
        this.completionCode = 1;
        return object2;
    }

    public Object visit(ASTWithStatement aSTWithStatement, Object object) {
        aSTWithStatement.assertTwoChildren();
        ESValue eSValue = null;
        try {
            EvaluationSource evaluationSource = (EvaluationSource)aSTWithStatement.getEvaluationSource();
            ESValue eSValue2 = EcmaScriptEvaluateVisitor.acceptNull(aSTWithStatement.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            ASTStatement aSTStatement = (ASTStatement)aSTWithStatement.jjtGetChild(1);
            ESObject eSObject = (ESObject)eSValue2.toESObject(this.evaluator);
            eSValue = this.evaluator.evaluateWith(aSTStatement, eSObject, evaluationSource);
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTWithStatement);
        }
        return eSValue;
    }

    public Object visit(ASTThisReference aSTThisReference, Object object) {
        aSTThisReference.assertNoChildren();
        return this.evaluator.getThisObject();
    }

    public Object visit(ASTCompositeReference aSTCompositeReference, Object object) {
        int n = aSTCompositeReference.jjtGetNumChildren();
        if (n < 2) {
            throw new ProgrammingError("Bad ast");
        }
        try {
            Object object2;
            Object object3;
            Object object4;
            ESValue eSValue;
            Object object5;
            Node node = aSTCompositeReference.jjtGetChild(0);
            if (node instanceof ASTIdentifier) {
                object5 = null;
                String string = ((ASTIdentifier)node).getName();
                eSValue = new ESString(string);
            } else {
                object5 = EcmaScriptEvaluateVisitor.acceptNull(node.jjtAccept(this, FOR_VALUE));
                eSValue = null;
            }
            int n2 = 1;
            while (n2 < n) {
                Object object6;
                object4 = aSTCompositeReference.jjtGetChild(n2);
                if (object4 instanceof ASTPropertyValueReference || object4 instanceof ASTPropertyIdentifierReference) {
                    if (eSValue != null) {
                        object3 = eSValue.toString();
                        if (object5 == null) {
                            object2 = this.evaluator.getValue((String)object3, ((String)object3).hashCode());
                            if (object2 instanceof ESUndefined) {
                                throw new EcmaScriptException("The property '" + (String)object3 + "' is not defined in global object");
                            }
                        } else {
                            object6 = (ESObject)((ESValue)object5).toESObject(this.evaluator);
                            object2 = ((ESObject)object6).getProperty((String)object3, ((String)object3).hashCode());
                            if (object2 instanceof ESUndefined) {
                                throw new EcmaScriptException("The property '" + (String)object3 + "' is not defined in object '" + ((ESObject)object6).toString() + "'");
                            }
                        }
                        object5 = object2;
                        eSValue = null;
                    }
                    eSValue = (ESValue)object4.jjtAccept(this, FOR_VALUE);
                } else if (object4 instanceof ASTFunctionCallParameters) {
                    object2 = (ESValue[])object4.jjtAccept(this, FOR_VALUE);
                    if (eSValue != null) {
                        object3 = object5 == null ? this.evaluator.getGlobalObject() : (ESObject)((ESValue)object5).toESObject(this.evaluator);
                        if (object3 instanceof ESArguments) {
                            object3 = this.evaluator.getGlobalObject();
                        }
                    } else {
                        object3 = this.evaluator.getGlobalObject();
                    }
                    if (eSValue != null) {
                        object6 = eSValue.toString();
                        if (object5 == null) {
                            object5 = this.evaluator.doIndirectCall((ESObject)object3, (String)object6, ((String)object6).hashCode(), (ESValue[])object2);
                        } else {
                            try {
                                object5 = ((ESObject)object3).doIndirectCall(this.evaluator, (ESObject)object3, (String)object6, (ESValue[])object2);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                throw new EcmaScriptException(noSuchMethodException.getMessage());
                            }
                        }
                        eSValue = null;
                    } else {
                        System.out.println("--->Last result: " + object5 + " " + object5.getClass() + "<---");
                        object6 = (ESObject)((ESValue)object5).toESObject(this.evaluator);
                        object5 = ((ESValue)object6).callFunction((ESObject)object3, (ESValue[])object2);
                    }
                    this.completionCode = 0;
                } else {
                    throw new ProgrammingError("Bad AST");
                }
                ++n2;
            }
            if (object == FOR_VALUE) {
                if (eSValue != null) {
                    if (object5 == null) {
                        throw new EcmaScriptException("'undefined' is not an object with properties");
                    }
                    object2 = (ESValue[])((ESValue)object5).toESObject(this.evaluator);
                    object3 = eSValue.toString();
                    object4 = object2.getProperty((String)object3, ((String)object3).hashCode());
                } else {
                    object4 = object5;
                }
            } else {
                if (object5 == null) {
                    throw new EcmaScriptException("'undefined' is not an assignable value");
                }
                if (eSValue == null) {
                    throw new EcmaScriptException("'" + object5.toString() + "' is not an assignable value");
                }
                object2 = (ESObject)((ESValue)object5).toESObject(this.evaluator);
                object3 = eSValue.toString();
                object4 = new ESReference((ESValue)object2, (String)object3, ((String)object3).hashCode());
            }
            return object4;
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTCompositeReference);
        }
    }

    public Object visit(ASTFunctionCallParameters aSTFunctionCallParameters, Object object) {
        int n = aSTFunctionCallParameters.jjtGetNumChildren();
        ESValue[] eSValueArray = new ESValue[n];
        int n2 = 0;
        while (n2 < n) {
            eSValueArray[n2] = (ESValue)aSTFunctionCallParameters.jjtGetChild(n2).jjtAccept(this, FOR_VALUE);
            ++n2;
        }
        return eSValueArray;
    }

    public Object visit(ASTPropertyValueReference aSTPropertyValueReference, Object object) {
        aSTPropertyValueReference.assertOneChild();
        return EcmaScriptEvaluateVisitor.acceptNull(aSTPropertyValueReference.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
    }

    public Object visit(ASTPropertyIdentifierReference aSTPropertyIdentifierReference, Object object) {
        aSTPropertyIdentifierReference.assertOneChild();
        ESString eSString = null;
        Node node = aSTPropertyIdentifierReference.jjtGetChild(0);
        if (!(node instanceof ASTIdentifier)) {
            throw new ProgrammingError("Bad AST");
        }
        String string = ((ASTIdentifier)node).getName();
        eSString = new ESString(string);
        return eSString;
    }

    public Object visit(ASTAllocationExpression aSTAllocationExpression, Object object) {
        aSTAllocationExpression.assertTwoChildren();
        ESObject eSObject = null;
        try {
            aSTAllocationExpression.jjtGetNumChildren();
            Node node = aSTAllocationExpression.jjtGetChild(0);
            ESValue eSValue = EcmaScriptEvaluateVisitor.acceptNull(node.jjtAccept(this, FOR_VALUE));
            Node node2 = aSTAllocationExpression.jjtGetChild(1);
            if (node2 instanceof ASTFunctionCallParameters) {
                ASTFunctionCallParameters aSTFunctionCallParameters = (ASTFunctionCallParameters)node2;
                ESValue[] eSValueArray = (ESValue[])aSTFunctionCallParameters.jjtAccept(this, FOR_VALUE);
                eSObject = eSValue.doConstruct(this.evaluator.getThisObject(), eSValueArray);
                if (!(eSObject instanceof ESObject)) {
                    throw new EcmaScriptException("new " + node2 + " did not return an object");
                }
            } else {
                throw new ProgrammingError("Bad AST");
            }
            this.completionCode = 0;
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTAllocationExpression);
        }
        return eSObject;
    }

    public Object visit(ASTOperator aSTOperator, Object object) {
        throw new ProgrammingError("Bad AST walk");
    }

    public Object visit(ASTPostfixExpression aSTPostfixExpression, Object object) {
        ESValue eSValue;
        try {
            aSTPostfixExpression.assertTwoChildren();
            Object object2 = aSTPostfixExpression.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
            if (!(object2 instanceof ESReference)) {
                throw new EcmaScriptException("Value '" + object2.toString() + "' is not an assignable object or property");
            }
            ESReference eSReference = (ESReference)object2;
            int n = ((ASTOperator)aSTPostfixExpression.jjtGetChild(1)).getOperator();
            eSValue = eSReference.getValue();
            double d = eSValue.doubleValue();
            if (n == 79) {
                d += 1.0;
            } else if (n == 80) {
                d -= 1.0;
            } else {
                throw new ProgrammingError("Bad operator");
            }
            ESNumber eSNumber = new ESNumber(d);
            this.evaluator.putValue(eSReference, eSNumber);
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTPostfixExpression);
        }
        return eSValue;
    }

    public Object visit(ASTUnaryExpression aSTUnaryExpression, Object object) {
        ESValue eSValue = null;
        try {
            aSTUnaryExpression.assertTwoChildren();
            int n = ((ASTOperator)aSTUnaryExpression.jjtGetChild(0)).getOperator();
            switch (n) {
                case 13: {
                    Object object2 = aSTUnaryExpression.jjtGetChild(1).jjtAccept(this, FOR_REFERENCE);
                    if (!(object2 instanceof ESReference)) {
                        throw new EcmaScriptException("Value '" + object2.toString() + "' is not a property reference");
                    }
                    ESReference eSReference = (ESReference)object2;
                    ESValue eSValue2 = eSReference.getBase();
                    String string = eSReference.getPropertyName();
                    eSValue = eSValue2 instanceof ESObject ? ESBoolean.makeBoolean(((ESObject)eSValue2).deleteProperty(string, string.hashCode())) : ESBoolean.makeBoolean(true);
                    break;
                }
                case 24: {
                    eSValue = null;
                    break;
                }
                case 22: {
                    Node node = aSTUnaryExpression.jjtGetChild(1);
                    if (node instanceof ASTIdentifier) {
                        ESReference eSReference = (ESReference)node.jjtAccept(this, FOR_REFERENCE);
                        if (eSReference == null || eSReference.getBase() == null) {
                            eSValue = new ESString("undefined");
                        } else {
                            ESValue eSValue3 = eSReference.getValue();
                            eSValue = new ESString(eSValue3.getTypeofString());
                        }
                    } else {
                        ESValue eSValue4 = EcmaScriptEvaluateVisitor.acceptNull(node.jjtAccept(this, FOR_VALUE));
                        eSValue = new ESString(eSValue4.getTypeofString());
                    }
                    break;
                }
                case 79: {
                    Object object3 = aSTUnaryExpression.jjtGetChild(1).jjtAccept(this, FOR_REFERENCE);
                    if (!(object3 instanceof ESReference)) {
                        throw new EcmaScriptException("Value '" + object3.toString() + "' is not an assignable object or property");
                    }
                    ESReference eSReference = (ESReference)object3;
                    ESValue eSValue5 = eSReference.getValue();
                    double d = eSValue5.doubleValue();
                    eSValue = new ESNumber(d += 1.0);
                    this.evaluator.putValue(eSReference, eSValue);
                    break;
                }
                case 80: {
                    Object object4 = aSTUnaryExpression.jjtGetChild(1).jjtAccept(this, FOR_REFERENCE);
                    if (!(object4 instanceof ESReference)) {
                        throw new EcmaScriptException("Value '" + object4.toString() + "' is not an assignable object or property");
                    }
                    ESReference eSReference = (ESReference)object4;
                    ESValue eSValue6 = eSReference.getValue();
                    double d = eSValue6.doubleValue();
                    eSValue = new ESNumber(d -= 1.0);
                    this.evaluator.putValue(eSReference, eSValue);
                    break;
                }
                case 81: {
                    ESValue eSValue7 = (ESValue)aSTUnaryExpression.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                    eSValue = eSValue7.toESNumber();
                    break;
                }
                case 82: {
                    ESValue eSValue8 = (ESValue)aSTUnaryExpression.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                    double d = eSValue8.doubleValue();
                    eSValue = new ESNumber(-d);
                    break;
                }
                case 70: {
                    ESValue eSValue9 = (ESValue)aSTUnaryExpression.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                    int n2 = eSValue9.toInt32();
                    eSValue = new ESNumber(~n2);
                    break;
                }
                case 69: {
                    ESValue eSValue10 = (ESValue)aSTUnaryExpression.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                    boolean bl = eSValue10.booleanValue();
                    eSValue = ESBoolean.makeBoolean(!bl);
                    break;
                }
                default: {
                    throw new ProgrammingError("Unimplemented unary");
                }
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTUnaryExpression);
        }
        return eSValue;
    }

    public Object visit(ASTBinaryExpressionSequence aSTBinaryExpressionSequence, Object object) {
        ESPrimitive eSPrimitive = null;
        try {
            ESValue eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTBinaryExpressionSequence.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            int n = 0;
            while (n < aSTBinaryExpressionSequence.jjtGetNumChildren() - 1) {
                ESValue eSValue2 = EcmaScriptEvaluateVisitor.acceptNull(aSTBinaryExpressionSequence.jjtGetChild(n + 2).jjtAccept(this, FOR_VALUE));
                int n2 = ((ASTOperator)aSTBinaryExpressionSequence.jjtGetChild(n + 1)).getOperator();
                switch (n2) {
                    case 81: {
                        ESValue eSValue3 = eSValue.toESPrimitive();
                        ESValue eSValue4 = eSValue2.toESPrimitive();
                        if (eSValue3 instanceof ESString || eSValue4 instanceof ESString) {
                            eSPrimitive = new ESString(String.valueOf(eSValue.toString()) + eSValue2.toString());
                            break;
                        }
                        eSPrimitive = new ESNumber(eSValue.doubleValue() + eSValue2.doubleValue());
                        break;
                    }
                    case 82: {
                        eSPrimitive = new ESNumber(eSValue.doubleValue() - eSValue2.doubleValue());
                        break;
                    }
                    case 83: {
                        eSPrimitive = new ESNumber(eSValue.doubleValue() * eSValue2.doubleValue());
                        break;
                    }
                    case 84: {
                        eSPrimitive = new ESNumber(eSValue.doubleValue() / eSValue2.doubleValue());
                        break;
                    }
                    case 88: {
                        eSPrimitive = new ESNumber(eSValue.doubleValue() % eSValue2.doubleValue());
                        break;
                    }
                    case 89: {
                        eSPrimitive = new ESNumber(eSValue.toInt32() << eSValue2.toUInt32());
                        break;
                    }
                    case 90: {
                        eSPrimitive = new ESNumber(eSValue.toInt32() >> eSValue2.toUInt32());
                        break;
                    }
                    case 91: {
                        eSPrimitive = new ESNumber(eSValue.toUInt32() >>> eSValue2.toUInt32());
                        break;
                    }
                    case 68: {
                        int n3 = this.compare(eSValue, eSValue2);
                        if (n3 == -1) {
                            eSPrimitive = ESBoolean.makeBoolean(true);
                            break;
                        }
                        eSPrimitive = ESBoolean.makeBoolean(false);
                        break;
                    }
                    case 67: {
                        int n4 = this.compare(eSValue2, eSValue);
                        if (n4 == -1) {
                            eSPrimitive = ESBoolean.makeBoolean(true);
                            break;
                        }
                        eSPrimitive = ESBoolean.makeBoolean(false);
                        break;
                    }
                    case 74: {
                        int n5 = this.compare(eSValue2, eSValue);
                        if (n5 == 1) {
                            eSPrimitive = ESBoolean.makeBoolean(true);
                            break;
                        }
                        eSPrimitive = ESBoolean.makeBoolean(false);
                        break;
                    }
                    case 75: {
                        int n6 = this.compare(eSValue, eSValue2);
                        if (n6 == 1) {
                            eSPrimitive = ESBoolean.makeBoolean(true);
                            break;
                        }
                        eSPrimitive = ESBoolean.makeBoolean(false);
                        break;
                    }
                    case 73: {
                        eSPrimitive = ESBoolean.makeBoolean(this.equal(eSValue, eSValue2));
                        break;
                    }
                    case 76: {
                        eSPrimitive = ESBoolean.makeBoolean(!this.equal(eSValue, eSValue2));
                        break;
                    }
                    case 85: {
                        int n7 = eSValue.toInt32();
                        int n8 = eSValue2.toInt32();
                        eSPrimitive = new ESNumber(n7 & n8);
                        break;
                    }
                    case 86: {
                        int n9 = eSValue.toInt32();
                        int n10 = eSValue2.toInt32();
                        eSPrimitive = new ESNumber(n9 | n10);
                        break;
                    }
                    case 87: {
                        int n11 = eSValue.toInt32();
                        int n12 = eSValue2.toInt32();
                        eSPrimitive = new ESNumber(n11 ^ n12);
                        break;
                    }
                    default: {
                        throw new ProgrammingError("Unimplemented binary");
                    }
                }
                eSValue = eSPrimitive;
                n += 2;
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTBinaryExpressionSequence);
        }
        return eSPrimitive;
    }

    public Object visit(ASTAndExpressionSequence aSTAndExpressionSequence, Object object) {
        ESValue eSValue = null;
        int n = aSTAndExpressionSequence.jjtGetNumChildren();
        try {
            eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTAndExpressionSequence.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            int n2 = 1;
            while (eSValue.booleanValue() && n2 < n) {
                eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTAndExpressionSequence.jjtGetChild(n2).jjtAccept(this, FOR_VALUE));
                ++n2;
            }
            eSValue = ESBoolean.makeBoolean(eSValue.booleanValue());
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTAndExpressionSequence);
        }
        return eSValue;
    }

    public Object visit(ASTOrExpressionSequence aSTOrExpressionSequence, Object object) {
        int n = aSTOrExpressionSequence.jjtGetNumChildren();
        ESValue eSValue = null;
        try {
            eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTOrExpressionSequence.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            int n2 = 1;
            while (!eSValue.booleanValue() && n2 < n) {
                eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTOrExpressionSequence.jjtGetChild(n2).jjtAccept(this, FOR_VALUE));
                ++n2;
            }
            eSValue = ESBoolean.makeBoolean(eSValue.booleanValue());
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTOrExpressionSequence);
        }
        return eSValue;
    }

    public Object visit(ASTEmptyExpression aSTEmptyExpression, Object object) {
        aSTEmptyExpression.assertNoChildren();
        return ESUndefined.theUndefined;
    }

    public Object visit(ASTConditionalExpression aSTConditionalExpression, Object object) {
        aSTConditionalExpression.assertThreeChildren();
        Object object2 = null;
        try {
            ESValue eSValue = EcmaScriptEvaluateVisitor.acceptNull(aSTConditionalExpression.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            boolean bl = eSValue.booleanValue();
            object2 = bl ? aSTConditionalExpression.jjtGetChild(1).jjtAccept(this, FOR_VALUE) : aSTConditionalExpression.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTConditionalExpression);
        }
        return object2;
    }

    public Object visit(ASTAssignmentExpression aSTAssignmentExpression, Object object) {
        aSTAssignmentExpression.assertThreeChildren();
        ESValue eSValue = null;
        try {
            Object object2 = aSTAssignmentExpression.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
            if (!(object2 instanceof ESReference)) {
                throw new EcmaScriptException("Value '" + object2.toString() + "' is not an assignable object or property");
            }
            ESReference eSReference = (ESReference)object2;
            ESValue eSValue2 = EcmaScriptEvaluateVisitor.acceptNull(aSTAssignmentExpression.jjtGetChild(2).jjtAccept(this, FOR_VALUE));
            int n = ((ASTOperator)aSTAssignmentExpression.jjtGetChild(1)).getOperator();
            if (n == 66) {
                this.evaluator.putValue(eSReference, eSValue2);
                eSValue = eSValue2;
            } else {
                ESValue eSValue3 = eSReference.getValue();
                switch (n) {
                    case 92: {
                        ESValue eSValue4 = eSValue3.toESPrimitive();
                        ESValue eSValue5 = eSValue2.toESPrimitive();
                        if (eSValue4 instanceof ESString || eSValue5 instanceof ESString) {
                            eSValue = new ESString(String.valueOf(eSValue3.toString()) + eSValue2.toString());
                            break;
                        }
                        eSValue = new ESNumber(eSValue3.doubleValue() + eSValue2.doubleValue());
                        break;
                    }
                    case 93: {
                        eSValue = new ESNumber(eSValue3.doubleValue() - eSValue2.doubleValue());
                        break;
                    }
                    case 94: {
                        eSValue = new ESNumber(eSValue3.doubleValue() * eSValue2.doubleValue());
                        break;
                    }
                    case 95: {
                        eSValue = new ESNumber(eSValue3.doubleValue() / eSValue2.doubleValue());
                        break;
                    }
                    case 96: {
                        int n2 = eSValue3.toInt32();
                        int n3 = eSValue2.toInt32();
                        eSValue = new ESNumber(n2 & n3);
                        break;
                    }
                    case 97: {
                        int n4 = eSValue3.toInt32();
                        int n5 = eSValue2.toInt32();
                        eSValue = new ESNumber(n4 | n5);
                        break;
                    }
                    case 98: {
                        int n6 = eSValue3.toInt32();
                        int n7 = eSValue2.toInt32();
                        eSValue = new ESNumber(n6 ^ n7);
                        break;
                    }
                    case 99: {
                        eSValue = new ESNumber(eSValue3.doubleValue() % eSValue2.doubleValue());
                        break;
                    }
                    case 100: {
                        eSValue = new ESNumber(eSValue3.toInt32() << eSValue2.toUInt32());
                        break;
                    }
                    case 101: {
                        eSValue = new ESNumber(eSValue3.toInt32() >> eSValue2.toUInt32());
                        break;
                    }
                    case 102: {
                        eSValue = new ESNumber(eSValue3.toUInt32() >>> eSValue2.toUInt32());
                        break;
                    }
                    default: {
                        throw new ProgrammingError("Unimplemented assign operator");
                    }
                }
                this.evaluator.putValue(eSReference, eSValue);
                eSValue2 = eSValue;
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTAssignmentExpression);
        }
        return eSValue;
    }

    public Object visit(ASTExpressionList aSTExpressionList, Object object) {
        int n = aSTExpressionList.jjtGetNumChildren();
        Object object2 = null;
        if (n <= 0) {
            throw new ProgrammingError("Empty expression list");
        }
        object2 = aSTExpressionList.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
        int n2 = 1;
        while (n2 < aSTExpressionList.jjtGetNumChildren()) {
            Node node = aSTExpressionList.jjtGetChild(n2);
            object2 = node.jjtAccept(this, FOR_VALUE);
            ++n2;
        }
        return object2;
    }

    public Object visit(ASTLiteral aSTLiteral, Object object) {
        aSTLiteral.assertNoChildren();
        return aSTLiteral.getValue();
    }

    public Object visit(ASTIdentifier aSTIdentifier, Object object) {
        Object object2;
        try {
            object2 = object == FOR_VALUE ? this.evaluator.getValue(aSTIdentifier.getName(), aSTIdentifier.hashCode()) : this.evaluator.getReference(aSTIdentifier.getName(), aSTIdentifier.hashCode());
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new PackagedException(ecmaScriptException, aSTIdentifier);
        }
        return object2;
    }

    protected static ESValue acceptNull(Object object) {
        if (object == null) {
            return ESUndefined.theUndefined;
        }
        return (ESValue)object;
    }
}

