/*
 * Decompiled with CFR 0.152.
 */
import FESI.jslib.JSException;
import com.oroinc.net.ftp.FTPFile;

public class FTPController
extends FTPModel {
    private FTPInterface GUIinterface;
    private String eol = System.getProperty("line.separator", "\n");
    public String defaultServer = "";
    public String defaultUsername = "anonymous";
    public String defaultPassword = "anonymous";

    public FTPController(FTPInterface fTPInterface) {
        this.GUIinterface = fTPInterface;
    }

    public void logError(String string) {
        this.GUIinterface.logMessage("** " + string + this.eol);
        this.GUIinterface.logError(string);
    }

    public void logMessage(String string) {
        this.GUIinterface.logMessage(string);
    }

    public void logMessageEol(String string) {
        this.GUIinterface.logMessage(String.valueOf(string) + this.eol);
    }

    public String requestDialog(String string, String string2, String string3) {
        return this.GUIinterface.requestDialog(string, string2, string3);
    }

    public String requestDialog(String string, String string2) {
        return this.GUIinterface.requestDialog(string, string2, "");
    }

    public ConnectionInfo requestConnectionInfo(String string, String string2, String string3) {
        return this.GUIinterface.requestConnectionInfo(string, string2, string3);
    }

    public void addMacro(String string, String string2) {
        this.GUIinterface.addMacro(string, string2);
    }

    public boolean doConnect() {
        if (this.isConnected()) {
            this.logError("Already connected");
            return false;
        }
        ConnectionInfo connectionInfo = this.requestConnectionInfo(this.defaultServer, this.defaultUsername, this.defaultPassword);
        if (connectionInfo == null) {
            this.logMessage(">> Connection request cancelled " + this.eol);
            return true;
        }
        String string = connectionInfo.server.trim();
        String string2 = connectionInfo.username.trim();
        String string3 = connectionInfo.password.trim();
        this.logMessage(">> Connecting to '" + string + "'" + this.eol);
        try {
            if (this.connect(string, string2, string3)) {
                this.appendReplyStrings();
                this.logMessage(">> Connected" + this.eol);
                return true;
            }
        }
        catch (JSException jSException) {}
        this.appendReplyStrings();
        this.logError("Connect error: " + this.lastError);
        return false;
    }

    public boolean doDisconnect() {
        if (!this.connected()) {
            return false;
        }
        this.logMessage(">> Disconnecting ... " + this.eol);
        try {
            this.disconnect();
            this.appendReplyStrings();
            this.logMessage(String.valueOf(this.eol) + ">> Disconnection done" + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doRemotePrintWorkingDirectory() {
        if (!this.connected()) {
            return false;
        }
        try {
            String string = this.remoteGetWorkingDirectory();
            if (string == null) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage(">> Current remote directory: " + this.eol + string + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doRemoteChangeWorkingDirectory() {
        if (!this.connected()) {
            return false;
        }
        try {
            String string = this.requestDialog("Directory request", "Directory:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage(">> Change remote working directory cancelled " + this.eol);
                return true;
            }
            boolean bl = this.remoteChangeWorkingDirectory(string);
            if (bl) {
                String string2 = null;
                try {
                    string2 = this.remoteGetWorkingDirectory();
                }
                catch (JSException jSException) {}
                if (string2 == null) {
                    this.logMessage(">> Remote working directory changed " + this.eol);
                } else {
                    this.logMessage(">> New remote working directory: " + this.eol + string2 + this.eol);
                }
                return true;
            }
            this.logError(this.lastError);
            return false;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doRemoteChangeToParentDirectory() {
        if (!this.connected()) {
            return false;
        }
        try {
            boolean bl = this.remoteChangeToParentDirectory();
            if (bl) {
                String string = null;
                try {
                    string = this.remoteGetWorkingDirectory();
                }
                catch (JSException jSException) {}
                if (string == null) {
                    this.logMessage(">> Remote working directory changed to parent" + this.eol);
                } else {
                    this.logMessage(">> New remote working directory: " + this.eol + string + this.eol);
                }
                return true;
            }
            this.logError(this.lastError);
            return false;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doRemoteListDirectory() {
        if (!this.connected()) {
            return false;
        }
        try {
            this.logMessage(">> Remote directory listing" + this.eol);
            String string = null;
            try {
                string = this.remoteGetWorkingDirectory();
            }
            catch (JSException jSException) {}
            if (string == null) {
                this.logMessage("Current directory listing" + this.eol);
            } else {
                this.logMessage("Directory: " + string + this.eol);
            }
            FTPFile[] fTPFileArray = this.remoteGetFileList();
            if (fTPFileArray == null) {
                this.logError(this.lastError);
                return false;
            }
            if (fTPFileArray.length == 0) {
                this.logMessage(" no file" + this.eol);
            } else {
                int n = 0;
                while (n < fTPFileArray.length) {
                    this.logMessage(" " + fTPFileArray[n].toString() + this.eol);
                    ++n;
                }
                this.logMessage("   " + fTPFileArray.length + " file(s)" + this.eol);
            }
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
        return true;
    }

    public boolean doRemoteMakeDirectory() {
        if (!this.connected()) {
            return false;
        }
        try {
            String string = this.requestDialog("Directory request", "Directory:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage(">> Make remote directory cancelled " + this.eol);
                return true;
            }
            if (!this.remoteMakeDirectory(string)) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage(">> Remote directory '" + string + "' created" + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doRemoteRenameFile() {
        if (!this.connected()) {
            return false;
        }
        try {
            String string = this.requestDialog("File request", "File to rename:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage("Rename remote file cancelled " + this.eol);
                return true;
            }
            String string2 = this.requestDialog("File request", "Rename to:", "");
            if (string2 == null || string2.trim().equals("")) {
                this.logMessage("Rename remote file cancelled " + this.eol);
                return true;
            }
            if (!this.remoteRenameFile(string, string2)) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage(">> Remote file '" + string + "' renamed to '" + string2 + "'" + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doRemoteDeleteFile() {
        if (!this.connected()) {
            return false;
        }
        try {
            String string = this.requestDialog("File request", "File:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage("Delete remote file cancelled " + this.eol);
                return true;
            }
            if (!this.remoteDeleteFile(string)) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage(">> Remote file '" + string + "' deleted" + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doRemoteRemoveDirectory() {
        if (!this.connected()) {
            return false;
        }
        try {
            String string = this.requestDialog("Directory request", "File:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage(">> Remove remote directory cancelled " + this.eol);
                return true;
            }
            if (!this.remoteRemoveDirectory(string)) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage(">> Remote directory '" + string + "' removed" + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doLocalPrintWorkingDirectory() {
        try {
            this.logMessage(">> Current local directory:" + this.eol + this.localGetWorkingDirectory() + this.eol);
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
        return true;
    }

    public boolean doLocalChangeWorkingDirectory() {
        try {
            String string = this.requestDialog("Directory request", "Directory:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage(">> Change local working directory cancelled " + this.eol);
                return true;
            }
            String string2 = this.localChangeWorkingDirectory(string);
            if (string2 != null) {
                this.logMessage(">> New local working directory: " + this.eol + string2 + this.eol);
                return true;
            }
            this.logError(this.lastError);
            return false;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doLocalChangeToParentDirectory() {
        try {
            String string = this.localChangeToParentDirectory();
            if (string != null) {
                this.logMessage(">> New local working directory: " + this.eol + string + this.eol);
                return true;
            }
            this.logError(this.lastError);
            return false;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doLocalListDirectory() {
        try {
            this.logMessage(">> Local directory listing" + this.eol);
            String string = this.localGetWorkingDirectory();
            if (string == null) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage("Directory: " + string + this.eol);
            FTPFile[] fTPFileArray = this.localGetFileList();
            if (fTPFileArray == null) {
                this.logError(this.lastError);
                return false;
            }
            if (fTPFileArray.length == 0) {
                this.logMessage(" no file" + this.eol);
            } else {
                int n = 0;
                while (n < fTPFileArray.length) {
                    this.logMessage(" " + fTPFileArray[n].toString() + this.eol);
                    ++n;
                }
                this.logMessage("   " + fTPFileArray.length + " file(s)" + this.eol);
            }
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doLocalMakeDirectory() {
        try {
            String string = this.requestDialog("Directory request", "Directory:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage(">> Make local directory cancelled " + this.eol);
                return true;
            }
            if (!this.localMakeDirectory(string)) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage(">> Remote directory '" + string + "' created" + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doLocalRenameFile() {
        try {
            String string = this.requestDialog("File request", "File to rename:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage("Rename local file cancelled " + this.eol);
                return true;
            }
            String string2 = this.requestDialog("File request", "Rename to:", "");
            if (string2 == null || string2.trim().equals("")) {
                this.logMessage("Rename local file cancelled " + this.eol);
                return true;
            }
            if (!this.localRenameFile(string, string2)) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage(">> Local file '" + string + "' renamed to '" + string2 + "'" + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doLocalDeleteFile() {
        try {
            String string = this.requestDialog("File request", "File:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage("Delete local file cancelled " + this.eol);
                return true;
            }
            if (!this.localDeleteFile(string)) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage(">> Local file '" + string + "' deleted" + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doLocalRemoveDirectory() {
        try {
            String string = this.requestDialog("Directory request", "Directory:", "");
            if (string == null || string.trim().equals("")) {
                this.logMessage(">> Remove local directory cancelled " + this.eol);
                return true;
            }
            if (!this.localDeleteFile(string)) {
                this.logError(this.lastError);
                return false;
            }
            this.logMessage(">> Local directory '" + string + "' removed" + this.eol);
            return true;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doGetTextFile() {
        return this.doGetFile(0);
    }

    public boolean doGetBinaryFile() {
        return this.doGetFile(2);
    }

    private boolean doGetFile(int n) {
        if (!this.connected()) {
            return false;
        }
        try {
            String string = n == 0 ? "text" : "binary";
            String string2 = this.requestDialog("Remote file to get", "File:", "");
            if (string2 == null || string2.trim().equals("")) {
                this.logMessage(">> Get file cancelled " + this.eol);
                return true;
            }
            this.logMessage(">> Getting file '" + string2 + " in " + string + " mode ..." + this.eol);
            if (this.getFile(n, string2, string2)) {
                this.logMessage(">> ... Done" + this.eol);
                return true;
            }
            this.logError(this.lastError);
            return false;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    public boolean doSendTextFile() {
        return this.doSendFile(0);
    }

    public boolean doSendBinaryFile() {
        return this.doSendFile(2);
    }

    private boolean doSendFile(int n) {
        if (!this.connected()) {
            return false;
        }
        try {
            String string = n == 0 ? "text" : "binary";
            String string2 = this.requestDialog("Local file to send", "File:", "");
            if (string2 == null || string2.trim().equals("")) {
                this.logMessage(">> Send file cancelled " + this.eol);
                return true;
            }
            this.logMessage(">> Sending file '" + string2 + " in " + string + " mode ..." + this.eol);
            if (this.sendFile(n, string2, string2)) {
                this.logMessage(">> ... Done" + this.eol);
                return true;
            }
            this.logError(this.lastError);
            return false;
        }
        catch (JSException jSException) {
            this.logError(this.lastError);
            return false;
        }
    }

    private void appendReplyStrings() {
        if (this.lastReply != null) {
            this.logMessage(this.lastReply);
        }
    }

    boolean connected() {
        if (this.isConnected()) {
            return true;
        }
        this.lastError = "Not connected";
        this.logError(this.lastError);
        return false;
    }
}

