//----------------------------------------------------------------------------
//
// Module:      FTPInterface.java      
//
// Description: FesiFTP interface to the GUI object
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

import java.awt.Frame;

interface FTPInterface {
    
    /**
     * Log a message via the GUI
     *
     * @param   text  The message to log
     */
    public void logMessage(String text);
    
   /**
     * log an error via the GUI
     *
     * @param   text  The text of the error
     */
    public void logError(String text);


    /**
     * Request a string parameter from the user, with a default value
     *
     * @param   requestTitle  The title of the dialog box
     * @param   requestText   The label of the request
     * @param   defaultAnswer Default value of the request
     * @return  The entered string, null if cancelled  
     */
    public String requestDialog(
                    String requestTitle, 
                    String requestText,
                    String defaultAnswer);
    public ConnectionInfo requestConnectionInfo(String defaultServer,
                                                String defaultUsername,
                                                String defaultPassword);
    /**
     * Add the macro to the macro menu
     *
     * @param   name  The name of the macro
     * @param   text  The command to execute
     */
    public void addMacro(String name, String text);

}