//----------------------------------------------------------------------------
//
// Module:      JSplitPaneDocumentHandler.java      
//
// Description: Handles JSplitPane elements
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

package FesiForm;

import org.xml.sax.*;
import FESI.jslib.*;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;


public class JSplitPaneDocumentHandler extends DefaultDocumentHandler 
                                   implements DocumentHandler {

    DocumentHandler previousDocumentHandler;
    String script = null;
    JSplitPane splitPane = null;
    String containerName;
    Container container;
    String constraint = null;
    
    public JSplitPaneDocumentHandler(String cn,
                                    DocumentHandler pdh, 
                                    Container ct,
                                    GuiContext guiContext, 
                                    boolean trace) {
        super(guiContext, trace);
        this.containerName = cn;
        this.container = ct;
        this.previousDocumentHandler = pdh;
        // Validate assumption
        if (!cn.equals("JSplitPane")) 
                throw new IllegalArgumentException("** Unexpected container name for JSplitPane: " + cn);
    }
  
      
    // Receive notification of the beginning of an element.
    public void startElement(String name, AttributeList atts) throws SAXException {
        if (trace) System.out.println("JSplitPane START_ELEMENT: <" + name + ">, " + 
                                         atts.getLength() + " attribute(s)");
        if (name.equals("JSplitPane")) {
            processOptionalId(splitPane, atts);
            splitPane = (JSplitPane) createComponent(JSplitPane.class, atts);
            processComponentAttributes(splitPane, atts);
            processORIENTATION(splitPane, atts);
            constraint = getAttribute("constraint", atts);
            script = saveScript(splitPane, atts);
            DocumentHandler dh = 
                new ContentDocumentHandler("JSplitPane", this, null, splitPane, guiContext, trace, 2);
            guiContext.parser.setDocumentHandler(dh);
            dh.startElement(name, atts);
        } else {
            throw new SAXException("Unexpected ELEMENT in splitPane ignored: " + name);
        }
    }

    // Receive notification of the end of an element. 
    public void endElement(String name) throws SAXException {
        if (trace) System.out.println("JSplitPane END_ELEMENT: </" + name + ">");
        if (name.equals("JSplitPane")) {  
            addConstrained(container, splitPane, constraint);
            processScript(splitPane, script);
            previousDocumentHandler.endElement(name);
        } else {
            throw new SAXException("Unexpected ELEMENT end in splitPane ignored: " + name);
        }
    }
    
     protected int processORIENTATION(JSplitPane jsp, AttributeList atts) throws SAXException {
         int orientation = JSplitPane.VERTICAL_SPLIT;
         String p = getAttribute("orientation", atts);
         if (p != null) {
             p = p.toLowerCase();
             if (trace) System.out.println("  ORIENTATION: " + p);
             if (p.equals("horizontal")) {
                 orientation = JSplitPane.HORIZONTAL_SPLIT;
             } else if (!p.equals("vertical")) {
                 throw new SAXException("Bad orientation name for split pane: " + p);
             }
             jsp.setOrientation(orientation);
         }
         return orientation;
     }
 }