//----------------------------------------------------------------------------
//
// Module:      GuiContext.java      
//
// Description: Information on GUI passed around and back to caller
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

package FesiForm;

import java.util.Hashtable;

import org.xml.sax.*;

import FESI.jslib.*;

public class GuiContext {
    private Hashtable allObjects = new Hashtable();
    boolean useNative = false;     // Use platform independent look and feel
    JSGlobalObject global;         // EcmaScript global object of interpreter
    Parser parser;                 // Sax parser
     
    GuiContext(JSGlobalObject global, Parser parser) {
        super();
        this.global = global;
        this.parser = parser;
    }
    
    void putId(String key, Object o) {
        allObjects.put(key, o);
    }
    // For access by EcmaScript
    public Object getById(String key) {
        return allObjects.get(key);
    }
}