/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.apps.Service;
import org.apache.fop.apps.StreamRenderer;
import org.apache.fop.apps.Version;
import org.apache.fop.configuration.ConfigurationReader;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOTreeBuilder;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.mif.MIFRenderer;
import org.apache.fop.render.pcl.PCLRenderer;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.ps.PSRenderer;
import org.apache.fop.render.svg.SVGRenderer;
import org.apache.fop.render.txt.TXTRenderer;
import org.apache.fop.render.xml.XMLRenderer;
import org.apache.fop.system.BufferManager;
import org.apache.fop.tools.DocumentInputSource;
import org.apache.fop.tools.DocumentReader;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Driver {
    public static final int RENDER_PDF = 1;
    public static final int RENDER_AWT = 2;
    public static final int RENDER_MIF = 3;
    public static final int RENDER_XML = 4;
    public static final int RENDER_PRINT = 5;
    public static final int RENDER_PCL = 6;
    public static final int RENDER_PS = 7;
    public static final int RENDER_TXT = 8;
    public static final int RENDER_SVG = 9;
    private FOTreeBuilder _treeBuilder;
    private AreaTree _areaTree;
    private Renderer _renderer;
    private InputSource _source;
    private OutputStream _stream = null;
    private XMLReader _reader;
    private boolean _errorDump = false;
    private BufferManager _bufferManager = new BufferManager();
    private Logger log;
    static /* synthetic */ Class class$org$apache$fop$fo$ElementMapping;

    public Driver() {
        this._treeBuilder = new FOTreeBuilder();
        this._treeBuilder.setBufferManager(this._bufferManager);
        this.setupDefaultMappings();
    }

    public Driver(InputSource inputSource, OutputStream outputStream) {
        this();
        this._source = inputSource;
        this._stream = outputStream;
    }

    public void addElementMapping(String string) throws IllegalArgumentException {
        try {
            ElementMapping elementMapping = (ElementMapping)Class.forName(string).newInstance();
            this.addElementMapping(elementMapping);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(String.valueOf(string) + " is not an ElementMapping");
        }
    }

    public void addElementMapping(ElementMapping elementMapping) {
        elementMapping.addToBuilder(this._treeBuilder);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void dumpError(Exception exception) {
        if (this._errorDump) {
            Logger logger = this.getLogger();
            if (exception instanceof SAXException) {
                logger.error("", (Throwable)exception);
                if (((SAXException)exception).getException() != null) {
                    logger.error("", (Throwable)((SAXException)exception).getException());
                }
            } else if (exception instanceof FOPException) {
                exception.printStackTrace();
                if (((FOPException)exception).getException() != null) {
                    logger.error("", ((FOPException)exception).getException());
                }
            } else {
                logger.error("", (Throwable)exception);
            }
        }
    }

    public ContentHandler getContentHandler() {
        StreamRenderer streamRenderer = new StreamRenderer(this._stream, this._renderer);
        streamRenderer.setLogger(this.getLogger());
        this._treeBuilder.setLogger(this.getLogger());
        this._treeBuilder.setStreamRenderer(streamRenderer);
        return this._treeBuilder;
    }

    private Logger getLogger() {
        if (this.log == null) {
            this.log = new ConsoleLogger(1);
            this.log.error("Logger not set");
        }
        return this.log;
    }

    public static final String getParserClassName() {
        try {
            return SAXParserFactory.newInstance().newSAXParser().getXMLReader().getClass().getName();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public Renderer getRenderer() {
        return this._renderer;
    }

    public FormattingResults getResults() {
        try {
            return this._treeBuilder.getStreamRenderer().getResults();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean hasData() {
        return this._treeBuilder.hasData();
    }

    public synchronized void render(Document document) throws FOPException {
        DocumentInputSource documentInputSource = new DocumentInputSource(document);
        DocumentReader documentReader = new DocumentReader();
        this.render(documentReader, documentInputSource);
    }

    public synchronized void render(XMLReader xMLReader, InputSource inputSource) throws FOPException {
        xMLReader.setContentHandler(this.getContentHandler());
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof FOPException) {
                throw (FOPException)sAXException.getException();
            }
            throw new FOPException(sAXException);
        }
        catch (IOException iOException) {
            throw new FOPException(iOException);
        }
    }

    public synchronized void reset() {
        this._areaTree = null;
        this._source = null;
        this._stream = null;
        this._reader = null;
        this._treeBuilder.reset();
    }

    public synchronized void run() throws IOException, FOPException {
        if (this._renderer == null) {
            this.setRenderer(1);
        }
        if (this._source == null) {
            throw new FOPException("InputSource is not set.");
        }
        if (this._reader == null && !(this._source instanceof DocumentInputSource)) {
            this._reader = ConfigurationReader.createParser();
        }
        if (this._source instanceof DocumentInputSource) {
            this.render(((DocumentInputSource)this._source).getDocument());
        } else {
            this.render(this._reader, this._source);
        }
    }

    public void setBufferFile(File file) {
        this._bufferManager.addBufferFile(file);
    }

    public void setErrorDump(boolean bl) {
        this._errorDump = bl;
    }

    public void setInputSource(InputSource inputSource) {
        this._source = inputSource;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._stream = outputStream;
    }

    public void setRenderer(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                this.setRenderer(new PDFRenderer());
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Use renderer form of setRenderer() for AWT");
            }
            case 5: {
                throw new IllegalArgumentException("Use renderer form of setRenderer() for PRINT");
            }
            case 6: {
                this.setRenderer(new PCLRenderer());
                break;
            }
            case 7: {
                this.setRenderer(new PSRenderer());
                break;
            }
            case 8: {
                this.setRenderer(new TXTRenderer());
                break;
            }
            case 3: {
                this.setRenderer(new MIFRenderer());
                break;
            }
            case 4: {
                this.setRenderer(new XMLRenderer());
                break;
            }
            case 9: {
                this.setRenderer(new SVGRenderer());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown renderer type");
            }
        }
    }

    public void setRenderer(String string) throws IllegalArgumentException {
        try {
            this._renderer = (Renderer)Class.forName(string).newInstance();
            this._renderer.setProducer(Version.getVersion());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(String.valueOf(string) + " is not a renderer");
        }
    }

    public void setRenderer(String string, String string2) {
        this.setRenderer(string);
    }

    public void setRenderer(Renderer renderer) {
        renderer.setLogger(this.getLogger());
        this._renderer = renderer;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this._reader = xMLReader;
    }

    public void setupDefaultMappings() {
        this.addElementMapping("org.apache.fop.fo.StandardElementMapping");
        this.addElementMapping("org.apache.fop.svg.SVGElementMapping");
        this.addElementMapping("org.apache.fop.extensions.ExtensionElementMapping");
        Enumeration enumeration = Service.providers(class$org$apache$fop$fo$ElementMapping != null ? class$org$apache$fop$fo$ElementMapping : (class$org$apache$fop$fo$ElementMapping = Driver.class$("org.apache.fop.fo.ElementMapping")));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    this.addElementMapping(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }
}

