/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;

public class Character
extends FObj {
    public static final int OK = 0;
    public static final int DOESNOT_FIT = 1;

    public Character(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:character";
    }

    public Status layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            this.log.warn("currently Character can only be in a BlockArea");
            return new Status(1);
        }
        BlockArea blockArea = (BlockArea)area;
        AuralProps auralProps = this.propMgr.getAuralProps();
        BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
        BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
        HyphenationProps hyphenationProps = this.propMgr.getHyphenationProps();
        MarginInlineProps marginInlineProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
        ColorType colorType = this.properties.get("color").getColorType();
        float f = colorType.red();
        float f2 = colorType.green();
        float f3 = colorType.blue();
        int n = this.properties.get("white-space-collapse").getEnum();
        int n2 = this.parent.properties.get("wrap-option").getEnum();
        int n3 = this.properties.get("text-decoration").getEnum();
        boolean bl = n3 == 86;
        char c = this.properties.get("character").getCharacter();
        String string = this.properties.get("id").getString();
        blockArea.getIDReferences().initializeID(string, blockArea);
        LineArea lineArea = blockArea.getCurrentLineArea();
        if (lineArea == null) {
            return new Status(2);
        }
        lineArea.changeFont(this.propMgr.getFontState(area.getFontInfo()));
        lineArea.changeColor(f, f2, f3);
        lineArea.changeWrapOption(n2);
        lineArea.changeWhiteSpaceCollapse(n);
        blockArea.setupLinkSet(this.getLinkSet());
        int n4 = lineArea.addCharacter(c, this.getLinkSet(), bl);
        if (n4 == 1) {
            lineArea = blockArea.createNextLineArea();
            if (lineArea == null) {
                return new Status(2);
            }
            lineArea.changeFont(this.propMgr.getFontState(area.getFontInfo()));
            lineArea.changeColor(f, f2, f3);
            lineArea.changeWrapOption(n2);
            lineArea.changeWhiteSpaceCollapse(n);
            blockArea.setupLinkSet(this.getLinkSet());
            lineArea.addCharacter(c, this.getLinkSet(), bl);
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Character(fObj, propertyList);
        }
    }
}

