/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.TTFCmapEntry;
import org.apache.fop.fonts.TTFFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TTFReader {
    private boolean invokedStandalone = false;

    public Document constructFontXML(TTFFile tTFFile, String string, String string2, String string3, String string4, boolean bl, String string5) {
        Object object;
        Object object2;
        Enumeration enumeration;
        Document document;
        System.out.println("Creating xml font file...");
        System.out.println();
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Can't create DOM implementation " + parserConfigurationException.getMessage());
            return null;
        }
        Element element = document.createElement("font-metrics");
        document.appendChild(element);
        if (bl) {
            element.setAttribute("type", "TYPE0");
        } else {
            element.setAttribute("type", "TRUETYPE");
        }
        Element element2 = document.createElement("font-name");
        element.appendChild(element2);
        String string6 = this.stripWhiteSpace(tTFFile.getPostscriptName());
        if (string != null) {
            element2.appendChild(document.createTextNode(this.stripWhiteSpace(string)));
        } else {
            element2.appendChild(document.createTextNode(string6));
        }
        element2 = document.createElement("embed");
        element.appendChild(element2);
        if (string4 != null && tTFFile.isEmbeddable()) {
            element2.setAttribute("file", string4);
        }
        if (string3 != null && tTFFile.isEmbeddable()) {
            element2.setAttribute("class", string3);
        }
        element2 = document.createElement("cap-height");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(String.valueOf(tTFFile.getCapHeight())));
        element2 = document.createElement("x-height");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(String.valueOf(tTFFile.getXHeight())));
        element2 = document.createElement("ascender");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(String.valueOf(tTFFile.getLowerCaseAscent())));
        element2 = document.createElement("descender");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(String.valueOf(tTFFile.getLowerCaseDescent())));
        Element element3 = document.createElement("bbox");
        element.appendChild(element3);
        int[] nArray = tTFFile.getFontBBox();
        String[] stringArray = new String[]{"left", "bottom", "right", "top"};
        int n = 0;
        while (n < 4) {
            element2 = document.createElement(stringArray[n]);
            element3.appendChild(element2);
            element2.appendChild(document.createTextNode(String.valueOf(nArray[n])));
            ++n;
        }
        element2 = document.createElement("flags");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(String.valueOf(tTFFile.getFlags())));
        element2 = document.createElement("stemv");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(tTFFile.getStemV()));
        element2 = document.createElement("italicangle");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(tTFFile.getItalicAngle()));
        if (string5 != null) {
            element2 = document.createElement("ttc-name");
            element.appendChild(element2);
            element2.appendChild(document.createTextNode(string5));
        }
        element2 = document.createElement("subtype");
        element.appendChild(element2);
        if (bl) {
            Object object3;
            element2.appendChild(document.createTextNode("TYPE0"));
            enumeration = document.createElement("multibyte-extras");
            element.appendChild((Node)((Object)enumeration));
            element2 = document.createElement("cid-type");
            enumeration.appendChild(element2);
            element2.appendChild(document.createTextNode("CIDFontType2"));
            element2 = document.createElement("default-width");
            enumeration.appendChild(element2);
            element2.appendChild(document.createTextNode("0"));
            element2 = document.createElement("bfranges");
            enumeration.appendChild(element2);
            object2 = tTFFile.getCMaps().elements();
            while (object2.hasMoreElements()) {
                object3 = (TTFCmapEntry)object2.nextElement();
                Element element4 = document.createElement("bf");
                element2.appendChild(element4);
                element4.setAttribute("us", String.valueOf(((TTFCmapEntry)object3).unicodeStart));
                element4.setAttribute("ue", String.valueOf(((TTFCmapEntry)object3).unicodeEnd));
                element4.setAttribute("gi", String.valueOf(((TTFCmapEntry)object3).glyphStartIndex));
            }
            element2 = document.createElement("cid-widths");
            element2.setAttribute("start-index", "0");
            enumeration.appendChild(element2);
            object3 = tTFFile.getWidths();
            int n2 = 0;
            while (n2 < ((Object)object3).length) {
                object = document.createElement("wx");
                object.setAttribute("w", String.valueOf((int)object3[n2]));
                element2.appendChild((Node)object);
                ++n2;
            }
        } else {
            element2.appendChild(document.createTextNode("TRUETYPE"));
            enumeration = document.createElement("singlebyte-extras");
            element.appendChild((Node)((Object)enumeration));
            element2 = document.createElement("encoding");
            enumeration.appendChild(element2);
            element2.appendChild(document.createTextNode(tTFFile.getCharSetName()));
            element2 = document.createElement("first-char");
            enumeration.appendChild(element2);
            element2.appendChild(document.createTextNode(String.valueOf(tTFFile.getFirstChar())));
            element2 = document.createElement("last-char");
            enumeration.appendChild(element2);
            element2.appendChild(document.createTextNode(String.valueOf(tTFFile.getLastChar())));
            object2 = document.createElement("widths");
            enumeration.appendChild((Node)object2);
            short s = tTFFile.getFirstChar();
            while (s <= tTFFile.getLastChar()) {
                element2 = document.createElement("char");
                object2.appendChild(element2);
                element2.setAttribute("idx", String.valueOf(s));
                element2.setAttribute("wdt", String.valueOf(tTFFile.getCharWidth(s)));
                s = (short)(s + 1);
            }
        }
        enumeration = bl ? tTFFile.getKerning().keys() : tTFFile.getAnsiKerning().keys();
        while (enumeration.hasMoreElements()) {
            object2 = (Integer)enumeration.nextElement();
            element2 = document.createElement("kerning");
            element2.setAttribute("kpx1", ((Integer)object2).toString());
            element.appendChild(element2);
            Element element5 = null;
            Hashtable hashtable = bl ? (Hashtable)tTFFile.getKerning().get(object2) : (Hashtable)tTFFile.getAnsiKerning().get(object2);
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                Integer n3 = (Integer)object.nextElement();
                if (!bl && n3 >= 256) continue;
                element5 = document.createElement("pair");
                element5.setAttribute("kpx2", n3.toString());
                Integer n4 = (Integer)hashtable.get(n3);
                element5.setAttribute("kern", n4.toString());
                element2.appendChild(element5);
            }
        }
        return document;
    }

    private static final void displayUsage() {
        System.out.println(" java org.apache.fop.fonts.apps.TTFReader [options] fontfile.ttf xmlfile.xml\n");
        System.out.println(" where options can be:\n");
        System.out.println("-enc ansi");
        System.out.println("     With this option you create a WinAnsi encoded font.\n");
        System.out.println("     The default is to create a CID keyed font.");
        System.out.println("     If you're not going to use characters outside the");
        System.out.println("     pdfencoding range (almost the same as iso-8889-1)");
        System.out.println("     you can add this option.");
        System.out.println("-ttcname <fontname>");
        System.out.println("     If you're reading data from a TrueType Collection");
        System.out.println("     (.ttc file) you must specify which font from the");
        System.out.println("     collection you will read metrics from. If you read");
        System.out.println("     from a .ttc file without this option, the fontnames");
        System.out.println("      will be listed for you.");
        System.out.println(" -fn <fontname>\n");
        System.out.println("     default is to use the fontname in the .ttf file, but\n     you can override that name to make sure that the\n");
        System.out.println("     embedded font is used (if you're embedding fonts)\n");
        System.out.println("     instead of installed fonts when viewing documents with Acrobat Reader.\n");
    }

    private String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public TTFFile loadTTF(String string, String string2) {
        TTFFile tTFFile = new TTFFile();
        try {
            System.out.println("Reading " + string + "...");
            System.out.println();
            FontFileReader fontFileReader = new FontFileReader(string);
            tTFFile.readFont(fontFileReader, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return tTFFile;
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = true;
        Hashtable hashtable = new Hashtable();
        String[] stringArray2 = TTFReader.parseArguments(hashtable, stringArray);
        TTFReader tTFReader = new TTFReader();
        tTFReader.invokedStandalone = true;
        System.out.println("TTF Reader v1.1.1");
        System.out.println();
        if (hashtable.get("-enc") != null && "ansi".equals(object = (String)hashtable.get("-enc"))) {
            bl = false;
        }
        if (hashtable.get("-ttcname") != null) {
            string5 = (String)hashtable.get("-ttcname");
        }
        if (hashtable.get("-ef") != null) {
            string = (String)hashtable.get("-ef");
        }
        if (hashtable.get("-er") != null) {
            string2 = (String)hashtable.get("-er");
        }
        if (hashtable.get("-fn") != null) {
            string4 = (String)hashtable.get("-fn");
        }
        if (hashtable.get("-cn") != null) {
            string3 = (String)hashtable.get("-cn");
        }
        if (stringArray2.length != 2 || hashtable.get("-h") != null || hashtable.get("-help") != null || hashtable.get("--help") != null) {
            TTFReader.displayUsage();
        } else {
            object = tTFReader.loadTTF(stringArray2[0], string5);
            if (object != null) {
                Document document = tTFReader.constructFontXML((TTFFile)object, string4, string3, string2, string, bl, string5);
                if (bl) {
                    System.out.println("Creating CID encoded metrics");
                } else {
                    System.out.println("Creating WinAnsi encoded metrics");
                }
                if (document != null) {
                    tTFReader.writeFontXML(document, stringArray2[1]);
                }
                if (((TTFFile)object).isEmbeddable()) {
                    System.out.println("This font contains no embedding license restrictions");
                } else {
                    System.out.println("** Note: This font contains license retrictions for\n         embedding. This font shouldn't be embedded.");
                }
            }
        }
    }

    private static String[] parseArguments(Hashtable hashtable, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (n + 1 < stringArray.length && !stringArray[n + 1].startsWith("-")) {
                    hashtable.put(stringArray[n], stringArray[n + 1]);
                    ++n;
                } else {
                    hashtable.put(stringArray[n], "");
                }
            } else {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String stripWhiteSpace(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] != ' ' && cArray[n] != '\r' && cArray[n] != '\n' && cArray[n] != '\t') {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void writeFontXML(Document document, String string) {
        System.out.println("Writing xml font file " + string + "...");
        System.out.println();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(new File(string)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

