/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.io.IOException;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.StreamRenderer;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.Page;

public class AreaTree {
    FontInfo fontInfo;
    Vector rootExtensions = null;
    private StreamRenderer streamRenderer;

    public AreaTree(StreamRenderer streamRenderer) {
        this.streamRenderer = streamRenderer;
    }

    public void addExtension(ExtensionObj extensionObj) {
        if (this.rootExtensions == null) {
            this.rootExtensions = new Vector();
        }
        this.rootExtensions.addElement(extensionObj);
    }

    public void addPage(Page page) throws FOPException {
        try {
            page.setExtensions(this.rootExtensions);
            this.rootExtensions = null;
            this.streamRenderer.queuePage(page);
        }
        catch (IOException iOException) {
            throw new FOPException(iOException);
        }
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public IDReferences getIDReferences() {
        return this.streamRenderer.getIDReferences();
    }

    public Page getNextPage(Page page, boolean bl, boolean bl2) {
        return this.streamRenderer.getNextPage(page, bl, bl2);
    }

    public Page getPreviousPage(Page page, boolean bl, boolean bl2) {
        return this.streamRenderer.getPreviousPage(page, bl, bl2);
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }
}

