/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.pdf.PDFObject;

public class PDFEncoding
extends PDFObject {
    public static final String MacRomanEncoding = "MacRomanEncoding";
    public static final String MacExpertEncoding = "MacExpertEncoding";
    public static final String WinAnsiEncoding = "WinAnsiEncoding";
    protected String basename;
    protected Hashtable differences;

    public PDFEncoding(int n, String string) {
        super(n);
        this.basename = string;
        this.differences = new Hashtable();
    }

    public void addDifferences(int n, Vector vector) {
        this.differences.put(new Integer(n), vector);
    }

    public byte[] toPDF() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.number) + " " + this.generation + " obj\n<< /Type /Encoding");
        if (this.basename != null && !this.basename.equals("")) {
            stringBuffer.append("\n/BaseEncoding /" + this.basename);
        }
        if (!this.differences.isEmpty()) {
            stringBuffer.append("\n/Differences [ ");
            Enumeration enumeration = this.differences.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                stringBuffer.append(" ");
                stringBuffer.append(k);
                Vector vector = (Vector)this.differences.get(k);
                int n = 0;
                while (n < vector.size()) {
                    stringBuffer.append(" /");
                    stringBuffer.append((String)vector.elementAt(n));
                    ++n;
                }
            }
            stringBuffer.append(" ]");
        }
        stringBuffer.append(" >>\nendobj\n");
        try {
            return stringBuffer.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return stringBuffer.toString().getBytes();
        }
    }
}

