/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.FontInfo;
import org.apache.fop.configuration.FontTriplet;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.fonts.Courier;
import org.apache.fop.render.pdf.fonts.CourierBold;
import org.apache.fop.render.pdf.fonts.CourierBoldOblique;
import org.apache.fop.render.pdf.fonts.CourierOblique;
import org.apache.fop.render.pdf.fonts.Helvetica;
import org.apache.fop.render.pdf.fonts.HelveticaBold;
import org.apache.fop.render.pdf.fonts.HelveticaBoldOblique;
import org.apache.fop.render.pdf.fonts.HelveticaOblique;
import org.apache.fop.render.pdf.fonts.LazyFont;
import org.apache.fop.render.pdf.fonts.Symbol;
import org.apache.fop.render.pdf.fonts.TimesBold;
import org.apache.fop.render.pdf.fonts.TimesBoldItalic;
import org.apache.fop.render.pdf.fonts.TimesItalic;
import org.apache.fop.render.pdf.fonts.TimesRoman;
import org.apache.fop.render.pdf.fonts.ZapfDingbats;

public class FontSetup {
    public static void addConfiguredFonts(org.apache.fop.layout.FontInfo fontInfo, int n) throws FOPException {
        String string = null;
        Object var3_3 = null;
        Vector vector = Configuration.getFonts();
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            FontInfo fontInfo2 = (FontInfo)enumeration.nextElement();
            try {
                String string2 = fontInfo2.getMetricsFile();
                if (string2 == null) continue;
                string = "F" + n;
                ++n;
                LazyFont lazyFont = new LazyFont(fontInfo2.getEmbedFile(), string2, fontInfo2.getKerning());
                fontInfo.addMetrics(string, lazyFont);
                Vector vector2 = fontInfo2.getFontTriplets();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    FontTriplet fontTriplet = (FontTriplet)enumeration2.nextElement();
                    fontInfo.addFontProperties(string, fontTriplet.getName(), fontTriplet.getStyle(), fontTriplet.getWeight());
                }
            }
            catch (Exception exception) {
                MessageHandler.error("Failed to read font metrics file " + fontInfo2.getMetricsFile() + " : " + exception.getMessage());
            }
        }
    }

    public static void addToResources(PDFDocument pDFDocument, org.apache.fop.layout.FontInfo fontInfo) {
        Hashtable hashtable = fontInfo.getUsedFonts();
        Enumeration enumeration = hashtable.keys();
        PDFResources pDFResources = pDFDocument.getResources();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Font font = (Font)hashtable.get(string);
            FontDescriptor fontDescriptor = null;
            if (font instanceof FontDescriptor) {
                fontDescriptor = (FontDescriptor)((Object)font);
            }
            pDFResources.addFont(pDFDocument.makeFont(string, font.fontName(), font.encoding(), font, fontDescriptor));
        }
    }

    public static void setup(org.apache.fop.layout.FontInfo fontInfo) throws FOPException {
        MessageHandler.logln("setting up fonts");
        fontInfo.addMetrics("F1", new Helvetica());
        fontInfo.addMetrics("F2", new HelveticaOblique());
        fontInfo.addMetrics("F3", new HelveticaBold());
        fontInfo.addMetrics("F4", new HelveticaBoldOblique());
        fontInfo.addMetrics("F5", new TimesRoman());
        fontInfo.addMetrics("F6", new TimesItalic());
        fontInfo.addMetrics("F7", new TimesBold());
        fontInfo.addMetrics("F8", new TimesBoldItalic());
        fontInfo.addMetrics("F9", new Courier());
        fontInfo.addMetrics("F10", new CourierOblique());
        fontInfo.addMetrics("F11", new CourierBold());
        fontInfo.addMetrics("F12", new CourierBoldOblique());
        fontInfo.addMetrics("F13", new Symbol());
        fontInfo.addMetrics("F14", new ZapfDingbats());
        fontInfo.addFontProperties("F5", "any", "normal", "normal");
        fontInfo.addFontProperties("F6", "any", "italic", "normal");
        fontInfo.addFontProperties("F6", "any", "oblique", "normal");
        fontInfo.addFontProperties("F7", "any", "normal", "bold");
        fontInfo.addFontProperties("F8", "any", "italic", "bold");
        fontInfo.addFontProperties("F8", "any", "oblique", "bold");
        fontInfo.addFontProperties("F1", "sans-serif", "normal", "normal");
        fontInfo.addFontProperties("F2", "sans-serif", "oblique", "normal");
        fontInfo.addFontProperties("F2", "sans-serif", "italic", "normal");
        fontInfo.addFontProperties("F3", "sans-serif", "normal", "bold");
        fontInfo.addFontProperties("F4", "sans-serif", "oblique", "bold");
        fontInfo.addFontProperties("F4", "sans-serif", "italic", "bold");
        fontInfo.addFontProperties("F5", "serif", "normal", "normal");
        fontInfo.addFontProperties("F6", "serif", "oblique", "normal");
        fontInfo.addFontProperties("F6", "serif", "italic", "normal");
        fontInfo.addFontProperties("F7", "serif", "normal", "bold");
        fontInfo.addFontProperties("F8", "serif", "oblique", "bold");
        fontInfo.addFontProperties("F8", "serif", "italic", "bold");
        fontInfo.addFontProperties("F9", "monospace", "normal", "normal");
        fontInfo.addFontProperties("F10", "monospace", "oblique", "normal");
        fontInfo.addFontProperties("F10", "monospace", "italic", "normal");
        fontInfo.addFontProperties("F11", "monospace", "normal", "bold");
        fontInfo.addFontProperties("F12", "monospace", "oblique", "bold");
        fontInfo.addFontProperties("F12", "monospace", "italic", "bold");
        fontInfo.addFontProperties("F1", "Helvetica", "normal", "normal");
        fontInfo.addFontProperties("F2", "Helvetica", "oblique", "normal");
        fontInfo.addFontProperties("F2", "Helvetica", "italic", "normal");
        fontInfo.addFontProperties("F3", "Helvetica", "normal", "bold");
        fontInfo.addFontProperties("F4", "Helvetica", "oblique", "bold");
        fontInfo.addFontProperties("F4", "Helvetica", "italic", "bold");
        fontInfo.addFontProperties("F5", "Times", "normal", "normal");
        fontInfo.addFontProperties("F6", "Times", "oblique", "normal");
        fontInfo.addFontProperties("F6", "Times", "italic", "normal");
        fontInfo.addFontProperties("F7", "Times", "normal", "bold");
        fontInfo.addFontProperties("F8", "Times", "oblique", "bold");
        fontInfo.addFontProperties("F8", "Times", "italic", "bold");
        fontInfo.addFontProperties("F9", "Courier", "normal", "normal");
        fontInfo.addFontProperties("F10", "Courier", "oblique", "normal");
        fontInfo.addFontProperties("F10", "Courier", "italic", "normal");
        fontInfo.addFontProperties("F11", "Courier", "normal", "bold");
        fontInfo.addFontProperties("F12", "Courier", "oblique", "bold");
        fontInfo.addFontProperties("F12", "Courier", "italic", "bold");
        fontInfo.addFontProperties("F13", "Symbol", "normal", "normal");
        fontInfo.addFontProperties("F14", "ZapfDingbats", "normal", "normal");
        fontInfo.addFontProperties("F5", "Times-Roman", "normal", "normal");
        fontInfo.addFontProperties("F6", "Times-Roman", "oblique", "normal");
        fontInfo.addFontProperties("F6", "Times-Roman", "italic", "normal");
        fontInfo.addFontProperties("F7", "Times-Roman", "normal", "bold");
        fontInfo.addFontProperties("F8", "Times-Roman", "oblique", "bold");
        fontInfo.addFontProperties("F8", "Times-Roman", "italic", "bold");
        fontInfo.addFontProperties("F5", "Times Roman", "normal", "normal");
        fontInfo.addFontProperties("F6", "Times Roman", "oblique", "normal");
        fontInfo.addFontProperties("F6", "Times Roman", "italic", "normal");
        fontInfo.addFontProperties("F7", "Times Roman", "normal", "bold");
        fontInfo.addFontProperties("F8", "Times Roman", "oblique", "bold");
        fontInfo.addFontProperties("F8", "Times Roman", "italic", "bold");
        fontInfo.addFontProperties("F9", "Computer-Modern-Typewriter", "normal", "normal");
        FontSetup.addConfiguredFonts(fontInfo, 15);
    }
}

