/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ClipBridge;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.FilterBridge;
import org.apache.batik.bridge.MaskBridge;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.util.CSSConstants;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class CSSUtilities
implements CSSConstants,
ErrorConstants,
XMLConstants {
    public static final Composite TRANSPARENT = AlphaComposite.getInstance(3, 0.0f);

    protected CSSUtilities() {
    }

    public static CSSEngine getCSSEngine(Element element) {
        return ((SVGOMDocument)element.getOwnerDocument()).getCSSEngine();
    }

    public static Value getComputedStyle(Element element, int n) {
        return CSSUtilities.getCSSEngine(element).getComputedStyle((CSSStylableElement)element, null, n);
    }

    public static int convertPointerEvents(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 40);
        String string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'v': {
                if (string.length() == 7) {
                    return 3;
                }
                switch (string.charAt(7)) {
                    case 'p': {
                        return 0;
                    }
                    case 'f': {
                        return 1;
                    }
                    case 's': {
                        return 2;
                    }
                }
                throw new Error();
            }
            case 'p': {
                return 4;
            }
            case 'f': {
                return 5;
            }
            case 's': {
                return 6;
            }
            case 'a': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        throw new Error();
    }

    public static Rectangle2D convertEnableBackground(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 14);
        if (value.getCssValueType() != 2) {
            return null;
        }
        ListValue listValue = (ListValue)value;
        int n = listValue.getLength();
        switch (n) {
            case 1: {
                return CompositeGraphicsNode.VIEWPORT;
            }
            case 5: {
                float f = listValue.item(1).getFloatValue();
                float f2 = listValue.item(2).getFloatValue();
                float f3 = listValue.item(3).getFloatValue();
                float f4 = listValue.item(4).getFloatValue();
                return new Rectangle2D.Float(f, f2, f3, f4);
            }
        }
        throw new InternalError();
    }

    public static boolean convertColorInterpolationFilters(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 7);
        return "linearrgb" == value.getStringValue();
    }

    public static MultipleGradientPaint.ColorSpaceEnum convertColorInterpolation(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 6);
        return "linearrgb" == value.getStringValue() ? MultipleGradientPaint.LINEAR_RGB : MultipleGradientPaint.SRGB;
    }

    public static RenderingHints convertShapeRendering(Element element, RenderingHints renderingHints) {
        Value value = CSSUtilities.getComputedStyle(element, 41);
        String string = value.getStringValue();
        if (string.charAt(0) == 'a') {
            return renderingHints;
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        switch (string.charAt(0)) {
            case 'o': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'c': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'g': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        return renderingHints;
    }

    public static RenderingHints convertTextRendering(Element element, RenderingHints renderingHints) {
        Value value = CSSUtilities.getComputedStyle(element, 54);
        String string = value.getStringValue();
        if (string.charAt(0) == 'a') {
            return renderingHints;
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        switch (string.charAt(8)) {
            case 's': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                break;
            }
            case 'l': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                break;
            }
            case 'c': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
        }
        return renderingHints;
    }

    public static RenderingHints convertImageRendering(Element element, RenderingHints renderingHints) {
        Value value = CSSUtilities.getComputedStyle(element, 30);
        String string = value.getStringValue();
        if (string.charAt(0) == 'a') {
            return renderingHints;
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        switch (string.charAt(8)) {
            case 's': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                break;
            }
            case 'q': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        return renderingHints;
    }

    public static RenderingHints convertColorRendering(Element element, RenderingHints renderingHints) {
        Value value = CSSUtilities.getComputedStyle(element, 9);
        String string = value.getStringValue();
        if (string.charAt(0) == 'a') {
            return renderingHints;
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        switch (string.charAt(8)) {
            case 's': {
                renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                break;
            }
            case 'q': {
                renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            }
        }
        return renderingHints;
    }

    public static boolean convertDisplay(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 12);
        return value.getStringValue().charAt(0) != 'n';
    }

    public static boolean convertVisibility(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 56);
        return value.getStringValue().charAt(0) == 'v';
    }

    public static Composite convertOpacity(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 38);
        float f = value.getFloatValue();
        if (f <= 0.0f) {
            return TRANSPARENT;
        }
        if (f >= 1.0f) {
            return AlphaComposite.SrcOver;
        }
        return AlphaComposite.getInstance(3, f);
    }

    public static boolean convertOverflow(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 39);
        String string = value.getStringValue();
        return string.charAt(0) == 'h' || string.charAt(0) == 's';
    }

    public static float[] convertClip(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 2);
        switch (value.getPrimitiveType()) {
            case 24: {
                float[] fArray = new float[]{value.getTop().getFloatValue(), value.getRight().getFloatValue(), value.getBottom().getFloatValue(), value.getLeft().getFloatValue()};
                return fArray;
            }
            case 21: {
                return null;
            }
        }
        throw new Error();
    }

    public static Filter convertFilter(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 18);
        switch (value.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                String string = value.getStringValue();
                Element element2 = bridgeContext.getReferencedElement(element, string);
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null || !(bridge instanceof FilterBridge)) {
                    throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
                }
                return ((FilterBridge)bridge).createFilter(bridgeContext, element2, element, graphicsNode);
            }
        }
        throw new InternalError();
    }

    public static ClipRable convertClipPath(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 3);
        switch (value.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                String string = value.getStringValue();
                Element element2 = bridgeContext.getReferencedElement(element, string);
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null || !(bridge instanceof ClipBridge)) {
                    throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
                }
                return ((ClipBridge)bridge).createClip(bridgeContext, element2, element, graphicsNode);
            }
        }
        throw new InternalError();
    }

    public static int convertClipRule(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 4);
        return value.getStringValue().charAt(0) == 'n' ? 1 : 0;
    }

    public static Mask convertMask(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 37);
        switch (value.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                String string = value.getStringValue();
                Element element2 = bridgeContext.getReferencedElement(element, string);
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null || !(bridge instanceof MaskBridge)) {
                    throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
                }
                return ((MaskBridge)bridge).createMask(bridgeContext, element2, element, graphicsNode);
            }
        }
        throw new InternalError();
    }

    public static int convertFillRule(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 17);
        return value.getStringValue().charAt(0) == 'n' ? 1 : 0;
    }

    public static Color convertLightingColor(Element element, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 33);
        if (value.getCssValueType() == 1) {
            return PaintServer.convertColor(value, 1.0f);
        }
        return PaintServer.convertRGBICCColor(element, value.item(0), (ICCColor)value.item(1), 1.0f, bridgeContext);
    }

    public static Color convertFloodColor(Element element, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 19);
        Value value2 = CSSUtilities.getComputedStyle(element, 20);
        float f = PaintServer.convertOpacity(value2);
        if (value.getCssValueType() == 1) {
            return PaintServer.convertColor(value, f);
        }
        return PaintServer.convertRGBICCColor(element, value.item(0), (ICCColor)value.item(1), f, bridgeContext);
    }

    public static Color convertStopColor(Element element, float f, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 42);
        Value value2 = CSSUtilities.getComputedStyle(element, 43);
        f *= PaintServer.convertOpacity(value2);
        if (value.getCssValueType() == 1) {
            return PaintServer.convertColor(value, f);
        }
        return PaintServer.convertRGBICCColor(element, value.item(0), (ICCColor)value.item(1), f, bridgeContext);
    }

    public static void computeStyleAndURIs(Element element, Element element2, String string) {
        Object object;
        Attr attr = element2.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "xml:base");
        if (attr != null) {
            object = new ParsedURL(string, attr.getNodeValue());
            string = ((ParsedURL)object).toString();
        }
        element2.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", string);
        object = CSSUtilities.getCSSEngine(element2);
        CSSEngine cSSEngine = CSSUtilities.getCSSEngine(element);
        ((CSSEngine)object).importCascadedStyleMaps(element, cSSEngine, element2);
    }

    protected static int rule(CSSValue cSSValue) {
        return ((CSSPrimitiveValue)cSSValue).getStringValue().charAt(0) == 'n' ? 1 : 0;
    }
}

