/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AffineRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class SVGFeImageElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feImage";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        String string = XLinkSupport.getXLinkHref(element);
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"xlink:href"});
        }
        Rectangle2D rectangle2D2 = rectangle2D;
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        Filter filter2 = null;
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        URL uRL = ((SVGOMDocument)sVGDocument).getURLObject();
        ParsedURL parsedURL = uRL != null ? new ParsedURL(uRL.toString(), string) : new ParsedURL(string);
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        URIResolver uRIResolver = new URIResolver(sVGDocument, documentLoader);
        boolean bl = false;
        try {
            Element element3 = null;
            Node node = uRIResolver.getNode(parsedURL.toString(), element);
            if (node.getNodeType() == 9) {
                element3 = ((SVGDocument)node).getRootElement();
            } else if (node.getNodeType() == 1) {
                element3 = (Element)node;
                bl = true;
            } else {
                throw new BridgeException(element, "uri.image.invalid", new Object[]{string});
            }
            filter2 = SVGFeImageElementBridge.createSVGFeImage(bridgeContext, rectangle2D3, element3, bl, element, graphicsNode);
        }
        catch (BridgeException bridgeException) {
            throw bridgeException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (filter2 == null) {
            filter2 = SVGFeImageElementBridge.createRasterFeImage(bridgeContext, rectangle2D3, parsedURL);
        }
        if (filter2 == null) {
            throw new BridgeException(element, "uri.image.invalid", new Object[]{"xlink:href", string});
        }
        AbstractSVGFilterPrimitiveElementBridge.handleColorInterpolationFilters(filter2, element);
        filter2 = new PadRable8Bit(filter2, rectangle2D3, PadMode.ZERO_PAD);
        AbstractSVGFilterPrimitiveElementBridge.updateFilterMap(element, filter2, map);
        return filter2;
    }

    protected static Filter createSVGFeImage(BridgeContext bridgeContext, Rectangle2D rectangle2D, Element element, boolean bl, Element element2, GraphicsNode graphicsNode) {
        GraphicsNode graphicsNode2 = bridgeContext.getGVTBuilder().build(bridgeContext, element);
        Filter filter = graphicsNode2.getGraphicsNodeRable(true);
        AffineTransform affineTransform = new AffineTransform();
        if (bl) {
            Element element3 = (Element)element2.getParentNode();
            String string = SVGUtilities.getChainableAttributeNS(element3, null, "primitiveUnits", bridgeContext);
            short s = string.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element3, "primitiveUnits", string);
            if (s == 2) {
                affineTransform = SVGUtilities.toObjectBBox(affineTransform, graphicsNode);
            }
            Rectangle2D rectangle2D2 = graphicsNode.getGeometryBounds();
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(rectangle2D.getX() - rectangle2D2.getX(), rectangle2D.getY() - rectangle2D2.getY()));
        } else {
            affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
        }
        return new AffineRable8Bit(filter, affineTransform);
    }

    protected static Filter createRasterFeImage(BridgeContext bridgeContext, Rectangle2D rectangle2D, ParsedURL parsedURL) {
        Filter filter = ImageTagRegistry.getRegistry().readURL(parsedURL);
        Rectangle2D rectangle2D2 = filter.getBounds2D();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
        affineTransform.scale(rectangle2D.getWidth() / (rectangle2D2.getWidth() - 1.0), rectangle2D.getHeight() / (rectangle2D2.getHeight() - 1.0));
        affineTransform.translate(-rectangle2D2.getX(), -rectangle2D2.getY());
        return new AffineRable8Bit(filter, affineTransform);
    }
}

