/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.ClipKey;
import org.apache.batik.svggen.SVGClipDescriptor;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGShape;
import org.w3c.dom.Element;

public class SVGClip
extends AbstractSVGConverter {
    public static final SVGClipDescriptor NO_CLIP = new SVGClipDescriptor("none", null);
    private SVGShape shapeConverter;

    public SVGClip(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
        this.shapeConverter = new SVGShape(sVGGeneratorContext);
    }

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Shape shape = graphicContext.getClip();
        return this.toSVG(shape);
    }

    public SVGClipDescriptor toSVG(Shape shape) {
        SVGClipDescriptor sVGClipDescriptor = null;
        if (shape != null) {
            StringBuffer stringBuffer = new StringBuffer("url(");
            GeneralPath generalPath = new GeneralPath(shape);
            ClipKey clipKey = new ClipKey(generalPath);
            sVGClipDescriptor = (SVGClipDescriptor)this.descMap.get(clipKey);
            if (sVGClipDescriptor == null) {
                Element element = this.clipToSVG(shape);
                if (element == null) {
                    sVGClipDescriptor = NO_CLIP;
                } else {
                    stringBuffer.append("#");
                    stringBuffer.append(element.getAttributeNS(null, "id"));
                    stringBuffer.append(")");
                    sVGClipDescriptor = new SVGClipDescriptor(stringBuffer.toString(), element);
                    this.descMap.put(clipKey, sVGClipDescriptor);
                    this.defSet.add(element);
                }
            }
        } else {
            sVGClipDescriptor = NO_CLIP;
        }
        return sVGClipDescriptor;
    }

    private Element clipToSVG(Shape shape) {
        Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "clipPath");
        element.setAttributeNS(null, "clipPathUnits", "userSpaceOnUse");
        element.setAttributeNS(null, "id", this.generatorContext.idGenerator.generateID("clipPath"));
        Element element2 = this.shapeConverter.toSVG(shape);
        if (element2 != null) {
            element.appendChild(element2);
            return element;
        }
        return null;
    }
}

