/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.FileOutputStream;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Starter;
import org.apache.fop.apps.Version;
import org.apache.fop.configuration.Configuration;
import org.xml.sax.XMLReader;

public class CommandLineStarter
extends Starter {
    CommandLineOptions commandLineOptions;
    boolean errorDump;

    public CommandLineStarter(CommandLineOptions commandLineOptions) throws FOPException {
        this.commandLineOptions = commandLineOptions;
        this.options.setCommandLineOptions(commandLineOptions);
        this.errorDump = Configuration.getBooleanValue("debugMode");
        super.setInputHandler(commandLineOptions.getInputHandler());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws FOPException {
        String string = Version.getVersion();
        this.log.info(string);
        XMLReader xMLReader = this.inputHandler.getParser();
        Driver driver = new Driver();
        driver.setLogger(this.log);
        driver.setBufferFile(this.commandLineOptions.getBufferFile());
        if (this.errorDump) {
            driver.setErrorDump(true);
        }
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(this.commandLineOptions.getOutputFile());
                driver.setRenderer(this.commandLineOptions.getRenderer());
                driver.setOutputStream(fileOutputStream);
                driver.getRenderer().setOptions(this.commandLineOptions.getRendererOptions());
                driver.render(xMLReader, this.inputHandler.getInputSource());
            }
            catch (Exception exception) {
                if (!(exception instanceof FOPException)) throw new FOPException(exception);
                throw (FOPException)exception;
            }
            Object var6_6 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {}
    }
}

