/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.expr.Numeric;
import org.apache.fop.messaging.MessageHandler;

public class FixedLength
extends Length {
    public FixedLength(double d, int n) {
        this.setComputedValue((int)(d * (double)n));
    }

    public FixedLength(double d, String string) {
        this.convert(d, string);
    }

    public FixedLength(int n) {
        this.setComputedValue(n);
    }

    public Numeric asNumeric() {
        return new Numeric(this);
    }

    protected void convert(double d, String string) {
        boolean bl = true;
        if (string.equals("in")) {
            d *= 72.0;
        } else if (string.equals("cm")) {
            d *= 28.3464567;
        } else if (string.equals("mm")) {
            d *= 2.83464567;
        } else if (!string.equals("pt")) {
            if (string.equals("pc")) {
                d *= 12.0;
            } else if (string.equals("px")) {
                d *= (double)bl;
            } else {
                d = 0.0;
                MessageHandler.errorln("unknown length unit '" + string + "'");
            }
        }
        this.setComputedValue((int)(d * 1000.0));
    }
}

