/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaClass;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.system.BufferManager;

public abstract class FONode {
    protected FObj parent;
    protected String areaClass = AreaClass.UNASSIGNED;
    public BufferManager bufferManager;
    protected Vector children = new Vector();
    public static final int START = -1000;
    public static final int BREAK_AFTER = -1001;
    protected int marker = -1000;
    protected boolean isInTableCell = false;
    protected int forcedStartOffset = 0;
    protected int forcedWidth = 0;
    protected int widows = 0;
    protected int orphans = 0;
    protected LinkSet linkSet;
    public int areasGenerated = 0;
    protected Hashtable markers;
    protected Logger log;

    protected FONode(FObj fObj) {
        this.parent = fObj;
        if (fObj != null) {
            this.bufferManager = fObj.bufferManager;
        }
        this.markers = new Hashtable();
        if (fObj != null) {
            this.areaClass = fObj.areaClass;
        }
    }

    protected void addChild(FONode fONode) {
        this.children.addElement(fONode);
    }

    public void addMarker(Marker marker) throws FOPException {
        String string = marker.getMarkerClassName();
        if (this.markers.containsKey(string) || !this.children.isEmpty()) {
            this.log.error("fo:marker must be an initial child,and 'marker-class-name' must be unique for same parent");
            throw new FOPException("fo:marker must be an initial child,and 'marker-class-name' must be unique for same parent");
        }
        this.markers.put(string, marker);
    }

    public void forceStartOffset(int n) {
        this.forcedStartOffset = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            fONode.forceStartOffset(n);
            ++n2;
        }
    }

    public void forceWidth(int n) {
        this.forcedWidth = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            fONode.forceWidth(n);
            ++n2;
        }
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public LinkSet getLinkSet() {
        return this.linkSet;
    }

    public Vector getMarkerSnapshot(Vector vector) {
        vector.addElement(new Integer(this.marker));
        if (this.marker < 0) {
            return vector;
        }
        if (this.children.isEmpty()) {
            return vector;
        }
        return ((FONode)this.children.elementAt(this.marker)).getMarkerSnapshot(vector);
    }

    public Vector getMarkers() {
        return new Vector(this.markers.values());
    }

    public FObj getParent() {
        return this.parent;
    }

    public Property getProperty(String string) {
        return null;
    }

    public boolean hasMarkers() {
        return this.markers.isEmpty() ^ true;
    }

    public abstract Status layout(Area var1) throws FOPException;

    public void removeAreas() {
    }

    public void resetMarker() {
        this.marker = -1000;
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            ((FONode)this.children.elementAt(n2)).resetMarker();
            ++n2;
        }
    }

    public void rollback(Vector vector) {
        this.marker = (Integer)vector.elementAt(0);
        vector.removeElementAt(0);
        if (this.marker == -1000) {
            this.resetMarker();
            return;
        }
        if (this.marker == -1 || this.children.isEmpty()) {
            return;
        }
        int n = this.children.size();
        if (this.marker <= -1000) {
            return;
        }
        int n2 = this.marker + 1;
        while (n2 < n) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            fONode.resetMarker();
            ++n2;
        }
        ((FONode)this.children.elementAt(this.marker)).rollback(vector);
    }

    public void setBufferManager(BufferManager bufferManager) {
        this.bufferManager = bufferManager;
    }

    public void setIsInTableCell() {
        this.isInTableCell = true;
        int n = 0;
        while (n < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n);
            fONode.setIsInTableCell();
            ++n;
        }
    }

    public void setLinkSet(LinkSet linkSet) {
        this.linkSet = linkSet;
        int n = 0;
        while (n < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n);
            fONode.setLinkSet(linkSet);
            ++n;
        }
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void setOrphans(int n) {
        this.orphans = n;
    }

    public void setWidows(int n) {
        this.widows = n;
    }
}

