/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.util.UnitProcessor;
import org.apache.fop.apps.Driver;
import org.apache.fop.image.SVGImage;
import org.apache.fop.image.analyser.AbstractImageReader;
import org.apache.fop.messaging.MessageHandler;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGReader
extends AbstractImageReader {
    public String getMimeType() {
        return "image/svg+xml";
    }

    protected boolean loadImage(String string) {
        try {
            SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(SVGImage.getParserName());
            SVGOMDocument sVGOMDocument = sAXSVGDocumentFactory.createDocument(string, (InputStream)this.imageStream);
            SVGSVGElement sVGSVGElement = sVGOMDocument.getRootElement();
            MUserAgent mUserAgent = new MUserAgent(new AffineTransform());
            BridgeContext bridgeContext = new BridgeContext((UserAgent)mUserAgent);
            UnitProcessor.Context context = UnitProcessor.createContext((BridgeContext)bridgeContext, (Element)sVGSVGElement);
            String string2 = sVGSVGElement.getAttributeNS(null, "width");
            if (string2.length() == 0) {
                string2 = "100%";
            }
            this.width = (int)UnitProcessor.svgHorizontalLengthToUserSpace((String)string2, (String)"width", (UnitProcessor.Context)context);
            string2 = sVGSVGElement.getAttributeNS(null, "height");
            if (string2.length() == 0) {
                string2 = "100%";
            }
            this.height = (int)UnitProcessor.svgVerticalLengthToUserSpace((String)string2, (String)"height", (UnitProcessor.Context)context);
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            MessageHandler.errorln("Batik not in class path");
            return false;
        }
        catch (Exception exception) {
            MessageHandler.errorln("Could not load external SVG: " + exception.getMessage());
            return false;
        }
    }

    public boolean verifySignature(String string, BufferedInputStream bufferedInputStream) throws IOException {
        this.imageStream = bufferedInputStream;
        return this.loadImage(string);
    }

    protected class MUserAgent
    extends UserAgentAdapter {
        AffineTransform currentTransform = null;

        protected MUserAgent(AffineTransform affineTransform) {
            this.currentTransform = affineTransform;
        }

        public void displayError(Exception exception) {
            exception.printStackTrace(System.err);
        }

        public void displayError(String string) {
            System.err.println(string);
        }

        public void displayMessage(String string) {
            System.out.println(string);
        }

        public String getLanguages() {
            return "en";
        }

        public String getMedia() {
            return "print";
        }

        public float getPixelToMM() {
            return 0.35277778f;
        }

        public float getPixelUnitToMillimeter() {
            return 0.35277778f;
        }

        public AffineTransform getTransform() {
            return this.currentTransform;
        }

        public String getUserStyleSheetURI() {
            return null;
        }

        public Dimension2D getViewportSize() {
            return new Dimension(100, 100);
        }

        public String getXMLParserClassName() {
            return Driver.getParserClassName();
        }

        public boolean isXMLParserValidating() {
            return true;
        }
    }
}

