/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFilterException;

public class FlateFilter
extends PDFFilter {
    public static final int PREDICTION_NONE = 1;
    public static final int PREDICTION_TIFF2 = 2;
    public static final int PREDICTION_PNG_NONE = 10;
    public static final int PREDICTION_PNG_SUB = 11;
    public static final int PREDICTION_PNG_UP = 12;
    public static final int PREDICTION_PNG_AVG = 13;
    public static final int PREDICTION_PNG_PAETH = 14;
    public static final int PREDICTION_PNG_OPT = 15;
    private int _predictor = 1;
    private int _colors;
    private int _bitsPerComponent;
    private int _columns;

    public byte[] encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this._predictor = 1;
        try {
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(byArray, 0, byArray.length);
            ((FilterOutputStream)deflaterOutputStream).flush();
            deflaterOutputStream.close();
        }
        catch (IOException iOException) {
            MessageHandler.error("Fatal error: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getBitsPerComponent() {
        return this._bitsPerComponent;
    }

    public int getColors() {
        return this._colors;
    }

    public int getColumns() {
        return this._columns;
    }

    public String getDecodeParms() {
        if (this._predictor > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<< /Predictor ");
            stringBuffer.append(this._predictor);
            if (this._colors > 0) {
                stringBuffer.append(" /Colors " + this._colors);
            }
            if (this._bitsPerComponent > 0) {
                stringBuffer.append(" /BitsPerComponent " + this._bitsPerComponent);
            }
            if (this._columns > 0) {
                stringBuffer.append(" /Columns " + this._columns);
            }
            stringBuffer.append(" >> ");
            return stringBuffer.toString();
        }
        return null;
    }

    public String getName() {
        return "/FlateDecode";
    }

    public int getPredictor() {
        return this._predictor;
    }

    public void setBitsPerComponent(int n) throws PDFFilterException {
        if (this._predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set bitsPerComponent");
        }
        this._bitsPerComponent = n;
    }

    public void setColors(int n) throws PDFFilterException {
        if (this._predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set Colors");
        }
        this._colors = n;
    }

    public void setColumns(int n) throws PDFFilterException {
        if (this._predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set Columns");
        }
        this._columns = n;
    }

    public void setPredictor(int n) throws PDFFilterException {
        this._predictor = n;
    }
}

