/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.fonts;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFT1Stream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.render.pdf.CodePointMapping;
import org.apache.fop.render.pdf.Font;

public class SingleByteFont
extends Font
implements FontDescriptor {
    public String fontName = null;
    public String encoding = "WinAnsiEncoding";
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    public int capHeight = 0;
    public int xHeight = 0;
    public int ascender = 0;
    public int descender = 0;
    public int[] fontBBox = new int[4];
    public String embedFileName = null;
    public String embedResourceName = null;
    public PDFStream embeddedFont = null;
    public int firstChar = 0;
    public int lastChar = 255;
    public int flags = 4;
    public int stemV = 0;
    public int italicAngle = 0;
    public int missingWidth = 0;
    public Hashtable kerning = new Hashtable();
    public boolean useKerning = true;
    public int[] width = null;
    public byte subType = 0;

    public String encoding() {
        return this.encoding;
    }

    public String fontName() {
        return this.fontName;
    }

    public int getAscender() {
        return this.ascender;
    }

    public int getAscender(int n) {
        return n * this.ascender;
    }

    public int getAvgWidth() {
        return -1;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public int getCapHeight(int n) {
        return n * this.capHeight;
    }

    public String getCharEncoding() {
        return this.encoding;
    }

    public int getDescender() {
        return this.descender;
    }

    public int getDescender(int n) {
        return n * this.descender;
    }

    public int getFirstChar() {
        return 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getFontBBox() {
        return this.fontBBox;
    }

    public PDFStream getFontFile(int n) {
        InputStream inputStream = null;
        if (this.embedFileName != null) {
            try {
                inputStream = new FileInputStream(this.embedFileName);
            }
            catch (Exception exception) {
                System.out.println("Failed to embed fontfile: " + this.embedFileName);
            }
        }
        if (inputStream == null && this.embedResourceName != null) {
            try {
                inputStream = new BufferedInputStream(this.getClass().getResourceAsStream(this.embedResourceName));
            }
            catch (Exception exception) {
                System.out.println("Failed to embed fontresource: " + this.embedResourceName);
            }
        }
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = new byte[128000];
        int n2 = 0;
        try {
            int n3 = inputStream.read(byArray, 0, 128000);
            n2 += n3;
            if (n3 == 128000) {
                while (n3 > 0) {
                    byte[] byArray2 = new byte[byArray.length + 64000];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    n3 = inputStream.read(byArray2, byArray.length, 64000);
                    n2 += n3;
                    byArray = byArray2;
                    if (n3 >= 64000) continue;
                    n3 = 0;
                }
            }
            if (this.subType == 1) {
                this.embeddedFont = new PDFT1Stream(n, n2);
                ((PDFT1Stream)this.embeddedFont).setData(byArray, n2);
            } else {
                this.embeddedFont = new PDFTTFStream(n, n2);
                ((PDFTTFStream)this.embeddedFont).setData(byArray, n2);
            }
            this.embeddedFont.addFilter("flate");
            this.embeddedFont.addFilter("ascii-85");
            inputStream.close();
        }
        catch (Exception exception) {}
        return this.embeddedFont;
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public final Hashtable getKerningInfo() {
        if (this.useKerning) {
            return this.kerning;
        }
        return new Hashtable();
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public int getMaxWidth() {
        return -1;
    }

    public int getMinWidth() {
        return -1;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    public int getStemH() {
        return 0;
    }

    public int getStemV() {
        return this.stemV;
    }

    public byte getSubType() {
        return this.subType;
    }

    public int[] getWidths(int n) {
        int[] nArray = new int[this.width.length];
        System.arraycopy(this.width, 0, nArray, 0, this.width.length - 1);
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] * n;
        }
        return nArray;
    }

    public int getXHeight(int n) {
        return n * this.xHeight;
    }

    public int getleading() {
        return -1;
    }

    public final boolean hasKerningInfo() {
        return this.useKerning & this.kerning.isEmpty();
    }

    public boolean isEmbeddable() {
        return this.embedFileName != null || this.embedResourceName != null;
    }

    public char mapChar(char c) {
        char c2 = this.mapping.mapChar(c);
        if (c2 != '\u0000') {
            return c2;
        }
        return '#';
    }

    public int width(int n, int n2) {
        return n2 * this.width[n];
    }
}

