/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipScanner;

public class ZipFileSet
extends FileSet {
    private File srcFile = null;
    private String prefix = "";
    private String fullpath = "";
    private boolean hasDir = false;

    public void setDir(File file) throws BuildException {
        if (this.srcFile != null) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        super.setDir(file);
        this.hasDir = true;
    }

    public void setSrc(File file) {
        if (this.hasDir) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        this.srcFile = file;
    }

    public File getSrc() {
        return this.srcFile;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setFullpath(String string) {
        this.fullpath = string;
    }

    public String getFullpath() {
        return this.fullpath;
    }

    public DirectoryScanner getDirectoryScanner(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDirectoryScanner(project);
        }
        if (this.srcFile != null) {
            ZipScanner zipScanner = new ZipScanner();
            zipScanner.setSrc(this.srcFile);
            super.setDir(project.getBaseDir());
            this.setupDirectoryScanner(zipScanner, project);
            zipScanner.init();
            return zipScanner;
        }
        return super.getDirectoryScanner(project);
    }
}

