/********************************************************************************
*                                                                               *
*                    M u l t i - L i ne   T e x t   W i d g e t                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXText.h,v 1.86 2001/07/06 21:33:10 jeroen Exp $                         *
********************************************************************************/
#ifndef FXTEXT_H
#define FXTEXT_H


struct FXTimer;


/// Text widget options
enum {
  TEXT_READONLY      = 0x00100000,              /// Text is NOT editable
  TEXT_WORDWRAP      = 0x00200000,              /// Wrap at word breaks
  TEXT_OVERSTRIKE    = 0x00400000,              /// Overstrike mode
  TEXT_FIXEDWRAP     = 0x00800000,              /// Fixed wrap columns
  TEXT_NO_TABS       = 0x01000000,              /// Insert spaces for tabs
  TEXT_AUTOINDENT    = 0x02000000               /// Autoindent
  };


/// Selection modes
enum FXTextSelectionMode {
  SELECT_CHARS,
  SELECT_WORDS,
  SELECT_LINES
  };


/// Multiline text widget
class FXAPI FXText : public FXScrollArea {
  FXDECLARE(FXText)
protected:
  FXchar       *buffer;               // Text buffer being edited
  FXint        *visrows;              // Starts of rows in buffer
  FXint         length;               // Length of the actual text in the buffer.
  FXint         nrows;                // Total number of rows
  FXint         nvisrows;             // Number of visible rows
  FXint         gapstart;             // Start of the insertion point (the gap)
  FXint         gapend;               // End of the insertion point+1
  FXint         toppos;               // Start position of first visible row
  FXint         keeppos;              // Position to keep on top visible row
  FXint         toprow;               // Row number of first visible row
  FXint         selstartpos;          // Start of selection
  FXint         selendpos;            // End of selection
  FXint         anchorpos;            // Anchor position
  FXint         cursorpos;            // Cursor position
  FXint         cursorrow;            // Cursor row
  FXint         cursorcol;            // Cursor column
  FXint         prefcol;              // Preferred cursor column
  FXint         margintop;            // Margins top
  FXint         marginbottom;         // Margin bottom
  FXint         marginleft;           // Margin left
  FXint         marginright;          // Margin right
  FXint         wrapwidth;            // Wrap width in pixels
  FXint         wrapcolumns;          // Wrap columns
  FXint         tabwidth;             // Tab width in pixels
  FXint         tabcolumns;           // Tab columns
  FXFont       *font;                 // Text font
  FXColor       textColor;            // Normal text color
  FXColor       selbackColor;         // Select background color
  FXColor       seltextColor;         // Select text color
  FXColor       cursorColor;          // Cursor color
  FXTimer      *blinker;              // Timer to blick cursor
  FXint         textWidth;            // Total width of all text
  FXint         textHeight;           // Total height of all text
  FXchar       *clipbuffer;           // Clipped text
  FXint         cliplength;           // Length of clipped text
  FXCharset     delimiters;           // Delimiters
  FXint         vrows;                // Default visible rows
  FXint         vcols;                // Default visible columns
  FXString      help;                 // Status line help
  FXString      tip;                  // Tooltip
  FXuint        matchtime;            // Match time (us)
  FXbool        modified;             // User has modified text
  FXuint        mode;                 // Mode widget is in
  FXint         grabx;                // Grab point x
  FXint         graby;                // Grab point y
protected:
  FXText();
  virtual void layout();
  void calcVisRows(FXint s,FXint e);
  void showCursor(FXuint state);
  void drawCursor(FXuint state);
  void eraseCursorOverhang();
  virtual void drawBufString(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXint pos,FXint n,FXuint style);
  virtual void drawTextRow(FXDCWindow& dc,FXint line,FXint lclip,FXint rclip,FXint fc,FXint tc);
  void drawTextRange(FXDCWindow& dc,FXint beg,FXint end);
  void drawTextRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  FXint posToLine(FXint pos,FXint ln) const;
  FXbool posVisible(FXint pos) const;
  void updateRange(FXint beg,FXint end);
  void movegap(FXint pos);
  void sizegap(FXint sz);
  void squeezegap();
  FXint getChar(FXint pos) const;
  FXuint getWChar(FXint pos) const;
  FXint wcharLen(FXint pos) const;
  FXint wcharRLen(FXint pos) const;
  void setChar(FXint pos,FXchar ch);
  FXuint getStyleAt(FXint linepos,FXint linelen,FXint column) const;
  FXint charWidth(FXchar ch,FXint indent) const;
  FXint wcharWidth(FXuint ch,FXint indent) const;
  FXint wrap(FXint start) const;
  FXint countRows(FXint start,FXint end) const;
  FXint countCols(FXint start,FXint end) const;
  FXint countLines(FXint start,FXint end) const;
  FXint measureText(FXint start,FXint end,FXint& wmax,FXint& hmax) const;
  FXint lineWidth(FXint pos,FXint n) const;
  FXint getYOfPos(FXint pos) const;
  FXint getXOfPos(FXint pos) const;
  FXint changeBeg(FXint pos) const;
  FXint changeEnd(FXint pos) const;
  void mutation(FXint pos,FXint ncins,FXint ncdel,FXint nrins,FXint nrdel);
  virtual void replace(FXint pos,FXint m,const FXchar *text,FXint n);
  void recompute();
  FXint matchForward(FXint pos,FXint end,FXchar l,FXchar r,FXint level) const;
  FXint matchBackward(FXint pos,FXint beg,FXchar l,FXchar r,FXint level) const;
  FXint findMatching(FXint pos,FXint beg,FXint end,FXchar ch,FXint level) const;
  FXint findText(const FXchar* text,FXint n,FXint pos,FXuint flags=SEARCH_FORWARD|SEARCH_WRAP) const;
  //FXbool matches(const FXchar* subject,const FXchar* search,FXuint flags) const;
  //FXbool findText(const FXchar* text,FXint n,FXint& pos,FXint& len,FXint start=-1,FXuint flags=SEARCH_FORWARD|SEARCH_WRAP|SEARCH_EXACT) const;
protected:
  enum {
    STYLE_MASK      = 0x00FF,   // Mask color table
    STYLE_UNDERLINE = 0x0100,   // Underlined
    STYLE_FILL      = 0x0200,   // Fill
    STYLE_SELECTED  = 0x0400,   // Selected
    STYLE_CONTROL   = 0x0800    // Control character
    };
  enum {
    MOUSE_NONE,
    MOUSE_CHARS,
    MOUSE_WORDS,
    MOUSE_LINES,
    MOUSE_SCROLL,
    MOUSE_DRAG,
    MOUSE_PASTE,
    MOUSE_TRYDRAG
    };
private:
  FXText(const FXText&);
  FXText& operator=(const FXText&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onUpdate(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMiddleBtnPress(FXObject*,FXSelector,void*);
  long onMiddleBtnRelease(FXObject*,FXSelector,void*);
  long onRightBtnPress(FXObject*,FXSelector,void*);
  long onRightBtnRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onBeginDrag(FXObject*,FXSelector,void*);
  long onEndDrag(FXObject*,FXSelector,void*);
  long onDragged(FXObject*,FXSelector,void*);
  long onDNDEnter(FXObject*,FXSelector,void*);
  long onDNDLeave(FXObject*,FXSelector,void*);
  long onDNDMotion(FXObject*,FXSelector,void*);
  long onDNDDrop(FXObject*,FXSelector,void*);
  long onDNDRequest(FXObject*,FXSelector,void*);
  long onSelectionLost(FXObject*,FXSelector,void*);
  long onSelectionGained(FXObject*,FXSelector,void*);
  long onSelectionRequest(FXObject*,FXSelector,void* ptr);
  long onClipboardLost(FXObject*,FXSelector,void*);
  long onClipboardGained(FXObject*,FXSelector,void*);
  long onClipboardRequest(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onBlink(FXObject*,FXSelector,void*);
  long onAutoScroll(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);

  // Control commands
  long onCmdToggleEditable(FXObject*,FXSelector,void*);
  long onUpdToggleEditable(FXObject*,FXSelector,void*);
  long onCmdToggleOverstrike(FXObject*,FXSelector,void*);
  long onUpdToggleOverstrike(FXObject*,FXSelector,void*);
  long onCmdCursorRow(FXObject*,FXSelector,void*);
  long onUpdCursorRow(FXObject*,FXSelector,void*);
  long onCmdCursorColumn(FXObject*,FXSelector,void*);
  long onUpdCursorColumn(FXObject*,FXSelector,void*);
  long onUpdHaveSelection(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);
  long onCmdTabColumns(FXObject*,FXSelector,void*);
  long onUpdTabColumns(FXObject*,FXSelector,void*);
  long onCmdWrapColumns(FXObject*,FXSelector,void*);
  long onUpdWrapColumns(FXObject*,FXSelector,void*);
  long onCmdHardTabs(FXObject*,FXSelector,void*);
  long onUpdHardTabs(FXObject*,FXSelector,void*);
  long onCmdAutoIndent(FXObject*,FXSelector,void*);
  long onUpdAutoIndent(FXObject*,FXSelector,void*);
  long onCmdSearchSel(FXObject*,FXSelector,void*);
  long onCmdSearch(FXObject*,FXSelector,void*);
  long onCmdReplace(FXObject*,FXSelector,void*);

  // Cursor movement
  long onCmdCursorTop(FXObject*,FXSelector,void*);
  long onCmdCursorBottom(FXObject*,FXSelector,void*);
  long onCmdCursorHome(FXObject*,FXSelector,void*);
  long onCmdCursorEnd(FXObject*,FXSelector,void*);
  long onCmdCursorRight(FXObject*,FXSelector,void*);
  long onCmdCursorLeft(FXObject*,FXSelector,void*);
  long onCmdCursorUp(FXObject*,FXSelector,void*);
  long onCmdCursorDown(FXObject*,FXSelector,void*);
  long onCmdCursorWordLeft(FXObject*,FXSelector,void*);
  long onCmdCursorWordRight(FXObject*,FXSelector,void*);
  long onCmdCursorPageDown(FXObject*,FXSelector,void*);
  long onCmdCursorPageUp(FXObject*,FXSelector,void*);
  long onCmdCursorScreenTop(FXObject*,FXSelector,void*);
  long onCmdCursorScreenBottom(FXObject*,FXSelector,void*);
  long onCmdCursorScreenCenter(FXObject*,FXSelector,void*);
  long onCmdCursorParHome(FXObject*,FXSelector,void*);
  long onCmdCursorParEnd(FXObject*,FXSelector,void*);
  long onCmdBlockBeg(FXObject*,FXSelector,void*);
  long onCmdBlockEnd(FXObject*,FXSelector,void*);
  long onCmdGotoMatching(FXObject*,FXSelector,void*);
  long onCmdGotoSelected(FXObject*,FXSelector,void*);
  long onCmdGotoLine(FXObject*,FXSelector,void*);
  long onCmdScrollUp(FXObject*,FXSelector,void*);
  long onCmdScrollDown(FXObject*,FXSelector,void*);

  // Mark and extend
  long onCmdMark(FXObject*,FXSelector,void*);
  long onCmdExtend(FXObject*,FXSelector,void*);

  // Inserting
  long onCmdInsertChar(FXObject*,FXSelector,void*);
  long onCmdInsertString(FXObject*,FXSelector,void*);
  long onCmdInsertNewline(FXObject*,FXSelector,void*);
  long onCmdInsertTab(FXObject*,FXSelector,void*);

  // Manipulation Selection
  long onCmdCutSel(FXObject*,FXSelector,void*);
  long onCmdCopySel(FXObject*,FXSelector,void*);
  long onCmdPasteSel(FXObject*,FXSelector,void*);
  long onCmdDeleteSel(FXObject*,FXSelector,void*);
  long onCmdChangeCase(FXObject*,FXSelector,void*);
  long onCmdShiftText(FXObject*,FXSelector,void*);

  // Changing Selection
  long onCmdSelectChar(FXObject*,FXSelector,void*);
  long onCmdSelectWord(FXObject*,FXSelector,void*);
  long onCmdSelectLine(FXObject*,FXSelector,void*);
  long onCmdSelectAll(FXObject*,FXSelector,void*);
  long onCmdSelectMatching(FXObject*,FXSelector,void*);
  long onCmdSelectBlock(FXObject*,FXSelector,void*);
  long onCmdDeselectAll(FXObject*,FXSelector,void*);

  // Deletion
  long onCmdBackspace(FXObject*,FXSelector,void*);
  long onCmdBackspaceWord(FXObject*,FXSelector,void*);
  long onCmdBackspaceBol(FXObject*,FXSelector,void*);
  long onCmdDelete(FXObject*,FXSelector,void*);
  long onCmdDeleteWord(FXObject*,FXSelector,void*);
  long onCmdDeleteEol(FXObject*,FXSelector,void*);
  long onCmdDeleteLine(FXObject*,FXSelector,void*);

  // Colors
  long onCmdTextColor(FXObject*,FXSelector,void*);
  long onUpdTextColor(FXObject*,FXSelector,void*);
  long onCmdSelTextColor(FXObject*,FXSelector,void*);
  long onUpdSelTextColor(FXObject*,FXSelector,void*);
  long onCmdSelBackColor(FXObject*,FXSelector,void*);
  long onUpdSelBackColor(FXObject*,FXSelector,void*);
  long onCmdBackColor(FXObject*,FXSelector,void*);
  long onUpdBackColor(FXObject*,FXSelector,void*);
  long onCmdCursorColor(FXObject*,FXSelector,void*);
  long onUpdCursorColor(FXObject*,FXSelector,void*);

public:

  enum {
    ID_CURSOR_TOP=FXScrollArea::ID_LAST,
    ID_CURSOR_BOTTOM,
    ID_CURSOR_HOME,
    ID_CURSOR_END,
    ID_CURSOR_RIGHT,
    ID_CURSOR_LEFT,
    ID_CURSOR_UP,
    ID_CURSOR_DOWN,
    ID_CURSOR_WORD_LEFT,
    ID_CURSOR_WORD_RIGHT,
    ID_CURSOR_PAGEDOWN,
    ID_CURSOR_PAGEUP,
    ID_CURSOR_SCRNTOP,
    ID_CURSOR_SCRNBTM,
    ID_CURSOR_SCRNCTR,
    ID_CURSOR_PAR_HOME,
    ID_CURSOR_PAR_END,
    ID_SCROLL_UP,
    ID_SCROLL_DOWN,
    ID_MARK,
    ID_EXTEND,
    ID_INSERT_CHAR,
    ID_INSERT_STRING,
    ID_INSERT_NEWLINE,
    ID_INSERT_TAB,
    ID_CUT_SEL,
    ID_COPY_SEL,
    ID_PASTE_SEL,
    ID_DELETE_SEL,
    ID_SELECT_CHAR,
    ID_SELECT_WORD,
    ID_SELECT_LINE,
    ID_SELECT_ALL,
    ID_SELECT_MATCHING,
    ID_SELECT_BRACE,
    ID_SELECT_BRACK,
    ID_SELECT_PAREN,
    ID_SELECT_ANG,
    ID_DESELECT_ALL,
    ID_BACKSPACE,
    ID_BACKSPACE_WORD,
    ID_BACKSPACE_BOL,
    ID_DELETE,
    ID_DELETE_WORD,
    ID_DELETE_EOL,
    ID_DELETE_LINE,
    ID_TOGGLE_EDITABLE,
    ID_TOGGLE_OVERSTRIKE,
    ID_CURSOR_ROW,
    ID_CURSOR_COLUMN,
    ID_WRAP_COLUMNS,
    ID_TAB_COLUMNS,
    ID_TEXT_COLOR,
    ID_BACK_COLOR,
    ID_SELTEXT_COLOR,
    ID_SELBACK_COLOR,
    ID_CURSOR_COLOR,
    ID_TOGGLE_TABS,
    ID_TOGGLE_AUTOINDENT,
    ID_CLEAN_INDENT,
    ID_SHIFT_LEFT,
    ID_SHIFT_RIGHT,
    ID_SHIFT_TABLEFT,
    ID_SHIFT_TABRIGHT,
    ID_UPPER_CASE,
    ID_LOWER_CASE,
    ID_GOTO_MATCHING,
    ID_GOTO_SELECTED,
    ID_GOTO_LINE,
    ID_SEARCH_FORW_SEL,
    ID_SEARCH_BACK_SEL,
    ID_SEARCH,
    ID_REPLACE,
    ID_LEFT_BRACE,
    ID_LEFT_BRACK,
    ID_LEFT_PAREN,
    ID_LEFT_ANG,
    ID_RIGHT_BRACE,
    ID_RIGHT_BRACK,
    ID_RIGHT_PAREN,
    ID_RIGHT_ANG,
    ID_LAST
    };

public:

  /// Construct multi-line text widget
  FXText(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// Create server-side resources
  virtual void create();

  /// Detach server-side resources
  virtual void detach();

  /// Return default width
  virtual FXint getDefaultWidth();

  /// Return default height
  virtual FXint getDefaultHeight();

  /// Enable the text widget
  virtual void enable();

  /// Disable the text widget
  virtual void disable();

  /// Need to recalculate size
  virtual void recalc();

  /// Resize this window to the specified width and height
  virtual void resize(FXint w,FXint h);

  /// Move and resize this window in the parent's coordinates
  virtual void position(FXint x,FXint y,FXint w,FXint h);

  /// Get default width
  virtual FXint getContentWidth();

  /// Get default height
  virtual FXint getContentHeight();

  /// Returns true because a text widget can receive focus
  virtual FXbool canFocus() const;

  /// Scroll the contents
  void moveContents(FXint x,FXint y);

  /// Change top margin
  void setMarginTop(FXint pt);

  /// Return top margin
  FXint getMarginTop() const { return margintop; }

  /// Change bottom margin
  void setMarginBottom(FXint pb);

  /// Return bottom margin
  FXint getMarginBottom() const { return marginbottom; }

  /// Change left margin
  void setMarginLeft(FXint pl);

  /// Return left margin
  FXint getMarginLeft() const { return marginleft; }

  /// Change right margin
  void setMarginRight(FXint pr);

  /// Return right margin
  FXint getMarginRight() const { return marginright; }

  /// Return wrap columns
  FXint getWrapColumns() const { return wrapcolumns; }

  /// Set wrap columns
  void setWrapColumns(FXint cols);

  /// Return tab columns
  FXint getTabColumns() const { return tabcolumns; }

  /// Change tab columns
  void setTabColumns(FXint cols);

  /// Return TRUE if text was modified
  FXbool isModified() const { return modified; }

  /// Set modified flag
  void setModified(FXbool mod=TRUE){ modified=mod; }

  /// Return TRUE if text is editable
  FXbool isEditable() const;

  /// Set editable flag
  void setEditable(FXbool edit=TRUE);

  /// Change delimiters of words
  void setDelimiters(const FXCharset& delims){ delimiters=delims; }

  /// Return word delimiters
  FXCharset getDelimiters() const { return delimiters; }

  /// Change text font
  void setFont(FXFont* fnt);

  /// Return text font
  FXFont* getFont() const { return font; }

  /// Change text color
  void setTextColor(FXColor clr);

  /// Return text color
  FXColor getTextColor() const { return textColor; }

  /// Change selected background color
  void setSelBackColor(FXColor clr);

  /// Return selected background color
  FXColor getSelBackColor() const { return selbackColor; }

  /// Change selected text color
  void setSelTextColor(FXColor clr);

  /// Return selected text color
  FXColor getSelTextColor() const { return seltextColor; }

  /// Change cursor color
  void setCursorColor(FXColor clr);

  /// Return cursor color
  FXColor getCursorColor() const { return cursorColor; }

  /// Set help text
  void setHelpText(const FXString& text);

  /// Return help text
  FXString getHelpText() const { return help; }

  /// Set the tool tip message for this text field
  void setTipText(const FXString& text);

  /// Get the tool tip message for this text field
  FXString getTipText() const { return tip; }

  /// Extract n characters of text from position pos
  void extractText(FXchar *text,FXint pos,FXint n) const;

  /// Replace m characters at pos by n characters
  void replaceText(FXint pos,FXint m,const FXchar *text,FXint n,FXbool notify=FALSE);

  /// Append n characters of text at the end of the buffer
  void appendText(const FXchar *text,FXint n,FXbool notify=FALSE);

  /// Insert n characters of text at position pos into the buffer
  void insertText(FXint pos,const FXchar *text,FXint n,FXbool notify=FALSE);

  /// Remove n characters of text at position pos from the buffer
  void removeText(FXint pos,FXint n,FXbool notify=FALSE);

  /// Change the text in the buffer to new text
  void setText(const FXchar* text,FXint n);

  /// Change the text
  void setText(const FXString& text);

  /// Retrieve text into buffer
  void getText(FXchar* text,FXint n) const;

  /// Return text in the widget
  FXString getText() const;

  /// Return length of buffer
  FXint getLength() const { return length; }

  /// Shift block of lines from position start up to end by given amount
  FXint shiftText(FXint start,FXint end,FXint amount,FXbool notify=FALSE);

  /// Return TRUE if position pos is selected
  FXbool isPosSelected(FXint pos) const;

  /// Return TRUE if position is fully visible
  FXbool isPosVisible(FXint pos) const;

  /// Return text position at given visible x,y coordinate
  FXint getPosAt(FXint x,FXint y) const;

  /// Return position of begin of line containing position pos
  FXint lineStart(FXint pos) const;

  /// Return position of end of line containing position pos
  FXint lineEnd(FXint pos) const;

  /// Return start of next line
  FXint nextLine(FXint pos,FXint nl=1) const;

  /// Return start of previous line
  FXint prevLine(FXint pos,FXint nl=1) const;

  /// Return row start
  FXint rowStart(FXint pos) const;

  /// Return row end
  FXint rowEnd(FXint pos) const;

  /// Return start of next row
  FXint nextRow(FXint pos,FXint nr=1) const;

  /// Return start of previous row
  FXint prevRow(FXint pos,FXint nr=1) const;

  /// Return end of previous word
  FXint leftWord(FXint pos) const;

  /// Return begin of next word
  FXint rightWord(FXint pos) const;

  /// Return begin of word
  FXint wordStart(FXint pos) const;

  /// Return end of word
  FXint wordEnd(FXint pos) const;

  /// Return validated position
  FXint validPos(FXint pos) const;

  /// Make line containing pos the top line
  void setTopLine(FXint pos);

  /// Return position of top line
  FXint getTopLine() const;

  /// Make line containing pos the bottom line
  void setBottomLine(FXint pos);

  /// Return the position of the bottom line
  FXint getBottomLine() const;

  /// Make line containing pos the center line
  void setCenterLine(FXint pos);

  /// Set the anchor position
  void setAnchorPos(FXint pos);

  /// Return the anchor position
  FXint getAnchorPos() const { return anchorpos; }

  /// Set the cursor position
  virtual void setCursorPos(FXint pos,FXbool notify=FALSE);

  /// Set cursor row
  void setCursorRow(FXint row,FXbool notify=FALSE);

  /// Return cursor row
  FXint getCursorRow() const { return cursorrow; }

  /// Set cursor column
  void setCursorCol(FXint col,FXbool notify=FALSE);

  /// Return cursor row
  FXint getCursorCol() const { return cursorcol; }

  /// Return the cursor position
  FXint getCursorPos() const { return cursorpos; }

  /// Return selstartpos
  FXint getSelStartPos() const { return selstartpos; }

  /// Return selendpos
  FXint getSelEndPos() const { return selendpos; }

  /// Select all text
  FXbool selectAll(FXbool notify=FALSE);

  /// Select len characters starting at given position pos
  FXbool setSelection(FXint pos,FXint len,FXbool notify=FALSE);

  /// Extend the selection from the anchor to the given position
  virtual FXbool extendSelection(FXint pos,FXTextSelectionMode select=SELECT_CHARS,FXbool notify=FALSE);

  /// Unselect the text
  virtual FXbool killSelection(FXbool notify=FALSE);

  /// Scroll text to make the given position visible
  void makePositionVisible(FXint pos);

  /// Change text style
  void setTextStyle(FXuint style);

  /// Return text style
  FXuint getTextStyle() const;

  /// Change number of visible rows
  void setVisRows(FXint rows);

  /// Return number of visible rows
  FXint getVisRows() const { return vrows; }

  /// Change number of visible columns
  void setVisCols(FXint cols);

  /// Return number of visible columns
  FXint getVisCols() const { return vcols; }

  /**
  * Change brace and parenthesis match highlighting time, in us.
  * A match highlight time of 0 disables brace matching.
  */
  void setHiliteMatchTime(FXuint t){ matchtime=t; }

  /**
  * Return brace and parenthesis match highlighting time, in us.
  */
  FXuint getHiliteMatchTime() const { return matchtime; }

  /// Save to a stream
  virtual void save(FXStream& store) const;

  /// Load from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXText();
  };



#endif
