DROP TABLE news;
DROP SEQUENCE news_id_seq;
CREATE TABLE news (
  id serial,
  topic_id int NOT NULL,
  section_id int NOT NULL,
  author_id int NOT NULL,
  lang_id int NOT NULL,
  user_id int DEFAULT '0',
  state int DEFAULT '0',
  main_page int DEFAULT '0',
  timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
  title varchar(150) DEFAULT '' NOT NULL,
  departement text,
  ip varchar(9) NOT NULL,
  CONSTRAINT PK_NEWS PRIMARY KEY (id)
);

DROP TABLE news_moderated;
CREATE TABLE news_moderated (
  news_id int NOT NULL,
  user_id int NOT NULL,
  state int NOT NULL,
  timestamp timestamp DEFAULT CURRENT_TIMESTAMP
);

DROP TABLE news_body;
DROP SEQUENCE news_body_id_seq;
CREATE TABLE news_body (
  id serial,
  body text NOT NULL,
  content_type varchar(16) DEFAULT 'text/plain' NOT NULL,
  CONSTRAINT PK_NEWS_BODY PRIMARY KEY (id)
);

DROP TABLE news_author;
DROP SEQUENCE news_author_id_seq;
CREATE TABLE news_author (
  id serial,
  name varchar(50),
  contact varchar(100),
  CONSTRAINT PK_NEWS_AUTHOR PRIMARY KEY (id)
);

DROP TABLE news_attachements;
DROP SEQUENCE news_attachements_id_seq;
CREATE TABLE news_attachements (
  id serial,
  news_id int NOT NULL,
  content_type varchar(128),
  size int,
  name varchar(128) DEFAULT '' NOT NULL,
  attachement text NOT NULL,
  CONSTRAINT PK_NEWS_ATTACHEMENTS PRIMARY KEY (id)
);

DROP TABLE news_urls;
DROP SEQUENCE news_urls_id_seq;
CREATE TABLE news_urls (
  id serial,
  news_id int NOT NULL,
  lang_id int NOT NULL,
  urls_id int NOT NULL,
  name text,
  CONSTRAINT PK_NEWS_URLS PRIMARY KEY (id)
);

DROP TABLE urls;
DROP SEQUENCE urls_id_seq;
CREATE TABLE urls (
  id serial,
  url varchar(200) not null,
  CONSTRAINT PK_URLS PRIMARY KEY (id),
  UNIQUE(url)
);

DROP TABLE news_vote;
CREATE TABLE news_vote (
  news_id int NOT NULL,
  user_id int NOT NULL,
  vote int NOT NULL
);

DROP TABLE users;
DROP SEQUENCE users_id_seq;
CREATE TABLE users (
  id serial,
  lname varchar(40),
  fname varchar(40),
  login varchar(20) NOT NULL,
  passwd varchar(40) NOT NULL,
  email varchar(128) NOT NULL,
  fake_email varchar(128),
  homesite varchar(255),
  level int DEFAULT '0',
  param int DEFAULT '0',
  created timestamp DEFAULT CURRENT_TIMESTAMP,
  sig_id int DEFAULT '1' NOT NULL,
  theme int DEFAULT '0',
  status int DEFAULT '0',
  score int DEFAULT '1',
  CONSTRAINT PK_USERS PRIMARY KEY (id),
  UNIQUE (email)
);
CREATE UNIQUE INDEX login2 ON users (login);
CREATE UNIQUE INDEX id2 ON users (id);

DROP TABLE users_supp;
DROP SEQUENCE users_supp_id_seq;
CREATE TABLE users_supp (
  user_id int NOT NULL,
  supp_info text
);
CREATE UNIQUE INDEX id ON users_supp (supp_id);

DROP TABLE sessions;
CREATE TABLE sessions (
  id varchar(20) NOT NULL,
  user_id int NOT NULL,
  ip varchar(9) NOT NULL,
  lastseen timestamp DEFAULT CURRENT_TIMESTAMP,
  expire timestamp,
  CONSTRAINT PK_SESSIONS PRIMARY KEY (id,user_id),UNIQUE(id)
);

DROP TABLE topics;
DROP SEQUENCE topics_id_seq;
CREATE TABLE topics (
  id serial,
  topic varchar(50),
  longname varchar(50),
  state int default '1' NOT NULL,
  CONSTRAINT PK_TOPICS PRIMARY KEY (id)
);

DROP TABLE sections;
DROP SEQUENCE sections_id_seq;
CREATE TABLE sections (
  id serial,
  section varchar(50),
  state int DEFAULT '1' NOT NULL,
  CONSTRAINT PK_SECTIONS PRIMARY KEY (id)
);

DROP TABLE lang;
DROP SEQUENCE lang_id_seq;
CREATE TABLE lang (
  id serial,
  lang char(2),
  description varchar(30),
  CONSTRAINT PK_LANG PRIMARY KEY (id)
);

DROP TABLE nospider;
CREATE TABLE nospider (
  host varchar(128) NOT NULL,
  timestamp timestamp NOT NULL
);

DROP TABLE urls_hits;
CREATE TABLE urls_hits (
  news_urls_id int NOT NULL,
  hits int DEFAULT '0' NOT NULL,
  CONSTRAINT PK_URLS_HITS PRIMARY KEY (news_urls_id),
  UNIQUE (news_urls_id)
);

DROP TABLE redirect;
CREATE TABLE redirect (
  urls_id int NOT NULL,
  hits int DEFAULT '0' NOT NULL,
  CONSTRAINT PK_REDIRECT PRIMARY KEY (urls_id),
  UNIQUE (urls_id)
);

DROP TABLE board;
DROP SEQUENCE board_id_seq;
CREATE TABLE board (
  id serial,
  message varchar(255) NOT NULL,
  timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
  ip varchar(9) NOT NULL,
  info varchar(60) DEFAULT '0' NOT NULL,
  section int DEFAULT '1' NOT NULL
);

DROP TABLE comments;
DROP SEQUENCE comments_id_seq;
CREATE TABLE comments (
  id serial,
  subject varchar(80) DEFAULT '' NOT NULL,
  body text NOT NULL,
  timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
  news_id int NOT NULL,
  user_id int DEFAULT '1' NOT NULL,
  com_parent int DEFAULT '0' NOT NULL,
  ip varchar(9) DEFAULT '0' NOT NULL,
  sig_id int DEFAULT '1' NOT NULL,
  CONSTRAINT PK_COMMENTS PRIMARY KEY (id)
);

DROP TABLE comments_scored;
CREATE TABLE comments_scored (
  comments_id int DEFAULT '0' NOT NULL,
  user_id int DEFAULT '0' NOT NULL,
  score int DEFAULT '-1' NOT NULL,
  timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
  info varchar(30) DEFAULT ''
);

DROP TABLE sig;
DROP SEQUENCE sig_id_seq;
CREATE TABLE sig (
  id serial,
  sig varchar(250) NOT NULL,
  CONSTRAINT PK_SIG PRIMARY KEY (id)
);

DROP TABLE poll_questions;
DROP SEQUENCE poll_questions_id_seq;
CREATE TABLE poll_questions (
  id serial, 
  question varchar(255) NOT NULL, 
  comment varchar(255),
  date int NOT NULL,
  accept int DEFAULT '0' NOT NULL
);

DROP TABLE poll_answers;
CREATE TABLE poll_answers (
  question_id int NOT NULL,
  answer varchar(255) NOT NULL,
  number int DEFAULT '0' NOT NULL,
  question_number int NOT NULL
);

DROP TABLE poll_ip;
CREATE TABLE poll_ip(
  ip varchar(15) NOT NULL,
  date int NOT NULL
);

DROP TABLE themes;
DROP SEQUENCE themes_id_seq;
CREATE TABLE themes (
  id serial,
  name varchar(50) NOT NULL,
  html text NOT NULL,
  typ varchar(50) NOT NULL
);

DROP TABLE messages;
DROP SEQUENCE messages_id_seq;
CREATE TABLE messages (
  id serial,
  timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
  user_id_source int DEFAULT '0' NOT NULL,
  user_id_dest   int DEFAULT '0' NOT NULL,
  read_ok bool DEFAULT '0' NOT NULL,
  subject varchar(150) DEFAULT '0' NOT NULL,
  body text NOT NULL
);

DROP TABLE ip_sessions;
DROP SEQUENCE ip_sessions_id_seq;
CREATE TABLE ip_sessions (
  id serial,
  ip varchar(9) NOT NULL,
  created timestamp DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT PK_IP_SESSIONS PRIMARY KEY (id)
);

DROP TABLE webcam;
DROP SEQUENCE webcam_id_seq;
CREATE TABLE webcam (
  id serial,
  user_id int DEFAULT '0' NOT NULL,
  state int DEFAULT '0' NOT NULL,
  image text NOT NULL,
  comment text,
  timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
  content_type varchar(128),
  size int,
  name varchar(128) DEFAULT '' NOT NULL,
  CONSTRAINT PK_WEBCAM PRIMARY KEY (id)
);

DROP TABLE tips;
DROP SEQUENCE tips_id_seq;
CREATE TABLE tips (
  id serial,
  tip_section_id int DEFAULT '0' NOT NULL,
  user_id int DEFAULT '0' NOT NULL,
  state int DEFAULT '0' NOT NULL,
  name varchar(128) DEFAULT '' NOT NULL,
  tip text DEFAULT '' NOT NULL,
  timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT PK_TIPS PRIMARY KEY (id)
);

DROP TABLE tips_sections;
DROP SEQUENCE tips_sections_id_seq;
CREATE TABLE tips_sections (
  id serial,
  tip_section_referer_id int DEFAULT '0' NOT NULL,
  tip_section varchar(50),
  state int DEFAULT '1' NOT NULL,
  CONSTRAINT PK_TIPS_SECTIONS PRIMARY KEY (id)
);

INSERT INTO users (login,passwd,email) VALUES ('Anonyme','X','');
INSERT INTO users (login,passwd,level,email) VALUES ('admin','X','6291456','root');
INSERT INTO sig (sig) VALUES ('');
INSERT INTO lang (lang, description) VALUES ('fr','Francais');
INSERT INTO lang (lang, description) VALUES ('en','Anglais');
INSERT INTO sections (section, state) VALUES ('Articles',1);
INSERT INTO topics (topic, longname, state) VALUES ('Linux','Linux',1);

