<?php
	$topdir = '.';

	require $topdir."/dacode.php3";

	//  Variable used in this file
	$utils = LoadClass('Utils');
	$cache = LoadClass('Cache');

	// Remove cache directory from PATH_INFO
	if (!ereg('\?$', $config->newsfile)) {
		if (isset($PATH_INFO)) {
			$path = ereg_replace('^/'.$config->htmldir, '/', $PATH_INFO);
		} else {
			$path = '/';
		}
	} else {
		if (!empty($QUERY_STRING)) {
			$path = ereg_replace('^/'.$config->htmldir, '/', $QUERY_STRING);
		} else {
			$path = '/';
		}
	}
	if (ereg("^(.*)\\.(html|$config->php)", $path, $res)) {
		$path = $res[1];
		$config->ext = '.'.$res[2];
	}

	// Adjust theme
	$config->score = $session->score;
	$config->hide_sig = $session->hide_sig;
	if (ereg('^([^,]*)(,.+)$', $path, $res)) {
		$path = $res[1];
		$opts = explode(',', $res[2]);
		$nbopts = count($opts);
		if ($nbopts >= 3) {
			$config->hide_sig = $opts[1];
			$config->score = $opts[2];
		} elseif ($nbopts == 2) {
			$config->score = $opts[1];
		}
		$config->theme = $opts[$nbopts-1];
		$config->theme_name = $config->listofthemes[$config->theme];
		//  Make sure this theme is valid
		if (empty($config->theme_name)) {
			$config->theme = $config->dft_prefs['theme'];
			$config->theme_name=$config->listofthemes[$config->theme];
		}
		$config->ext = ','.$config->theme.$config->ext;
	}

	// and prepends cache directory to $file. This oddity is because
	// requests may have this cache directory prepended or not.
	$file = $config->htmldir . substr($path, 1);

	//   Initialize variables
	$section = $topic = $news_id = $date = $title = $template = '';

	if (ereg('^/section/([^/]+)$', $path, $res)) {
		$section  = urldecode($res[1]);
		$template = 'newssection.tmpl';
	} elseif (ereg('^/topic/([^/]+)$', $path, $res)) {
		$topic    = urldecode($res[1]);
		$template = 'newssection.tmpl';
	} elseif (ereg('^/([0-9]+/[0-9]+/[0-9]+)/([0-9]+)$', $path, $res)) {
		$news_id  = $res[2];
		$template = 'news.tmpl';
	} elseif (ereg('^/section/([^/]+)/([0-9]+)$', $path, $res)) {
		$section  = urldecode($res[1]);
		$news_id  = $res[2];
		$template = 'news.tmpl';
	} elseif (ereg('^/topic/([^/]+)/([0-9]+)$', $path, $res)) {
		$topic    = urldecode($res[1]);
		$news_id  = $res[2];
		$template = 'news.tmpl';
	} elseif (ereg('^/([0-9]+)/([0-9]+)/([0-9]+)/index$', $path, $res)) {
		$date     = $res[1] . $res[2] . $res[3];
		$pageday  = $res[3];
		$pagemonth= $res[2];
		$pageyear = $res[1];

		$title    = $config->titledefault .': '.
			$utils->stamp2date($date,"short");
		$template = 'newsindex.tmpl';
	} else {
		$file     = $config->htmldir.'index';
		$title    = $config->titledefault;
		$template = 'newsindex.tmpl';
	}
	$config->extraopts = ','.$config->hide_sig.','.$config->score;
	$file .= $config->extraopts;

	if (!$date) {
		$pageday   = date("d");
		$pagemonth = date("n");
		$pageyear  = date("Y");
	}

	//   Check whether file already exists
	$temp = ereg_replace('^'.$config->htmldir,'', $file.$config->ext);
	$cache->check_html($temp);

	//  Declare all variables found in above template files
	$comments = LoadClass('Comments');
	$html = LoadClass('Html');
	$user = LoadClass('User');
	if ($config->ldap_hostname) {
	    $ldap  = LoadClass('Ldap');
	}
	$sidebox = LoadClass('Sidebox');
	$hits = LoadClass('Hits');
	$admin = LoadClass('Admin');
	$board = LoadClass('Board');
	$message = LoadClass('Message');
	$news = LoadClass('News');
	$poll = LoadClass('Poll');
	$webcam = LoadClass('Webcam');
	$backends = LoadClass('Backends');
	$fortune  = LoadClass('Fortunes');
	$cal  = LoadClass('Cal');
	$tips = LoadClass('Tips');

	if ($config->nodb == 1) {
		$text = lecho("Sorry but the site is currently down for maintenance.").
			"<br>\n".lecho("Thank you to come back in a few minutes !");
		echo $html->parsetemplate("basic.tmpl");
		exit;
	}

	$text = $html->parsetemplate($template);

	//  And write text to file
	$cache->write_html($file.$config->ext,$text);
?>
