<?php
/* daCode http://www.dacode.org/
 * src/phplib/backends.php3
 * $Id: backends.php3,v 1.44 2001/07/17 20:08:03 barbier Exp $
 *
 * All function which are able to get infos from outside will be here
 *
 *
 * Depends: Config Utils Html Cache
*/

Class Backends {
	var $html,$cache,$utils;

	Function Backends() {
		//echo '<br>Backends';
		$this->utils  = LoadClass('Utils');
		$this->html   = LoadClass('Html');
		$this->cache  = LoadClass('Cache');
	}

	/*
	 *  Generic function to extract informations from external websites
	 *     $nb:          number of items
	 *     $ttl:         duration of cached file
	 *     $url_site:    URL of backend file
	 *     $title_site:  title of website
	 *     $template:    string describing how items must be
	 *                   rendered, with $x being replaced by x-th
	 *                   line of input
	 *     $delim:       separator between items
	 *     $raw:         if set, text is returned without decoration
	 */
	Function generic($nb,$ttl,$url_site,$title_site,$template,$delim="%%",$striphtml="0",$raw="0") {
		global $config;

		$site = str_replace("http://","",$url_site);
		list ($site,$file) = split("/",$site,2);
		$file = "/" . $file;
		if ( $title_site == "") {
			$title_site = $site;
		}

		$fcontents = $this->cache->check_box($ttl,"backends_".$site, $config->ext);
		if (!empty($fcontents)) {
			return $fcontents;
		}
		
		$sidebox_title = "<a href=\"http://".$site."/\">".$title_site."</a>";
		$nbocc = preg_match_all('/\$([0-9])/', $template, $res, PREG_SET_ORDER);
		$max = 0;
		for ($i=0; $i<$nbocc; $i++) {
			$max = max($max, $res[$i][1]);
		}

		$fpread = fsockopen($site, 80, &$errno, &$errstr, 5);
		if (!$fpread) {
			$out = "<!-- Connection trouble: $errstr ($errno) -->\n";
			$out .= lecho("Down...")."\n";
			$out = $this->html->sidebox($sidebox_title,$out);
			$this->cache->write_box("backends_$site",$config->ext,$out);
			return $out;
		}

		fputs($fpread, "GET ".$file." HTTP/1.1\r\n");
		fputs($fpread, "Host: ".$site."\r\n\r\n");

		$out = "";
		$nbread=0;
		while (!feof($fpread)) {
			if ($nbread >= $nb) {
				break;
			}
			$buffer = trim(fgets($fpread, 256));
			if ($buffer == $delim) {
				$nbread++;
				for ($i=1; $i<=$max; $i++) {
					$line[$i] = trim(fgets($fpread, 256));
					if ($striphtml) {
						$line[$i] = ereg_replace("^<[^>]+>(.*)</[^>]+>$", "\\1", $line[$i]);
					}
				}
				$tmp = $template;
				for ($i=1; $i<=$max; $i++) {
					$tmp = str_replace('$'.$i, $line[$i], $tmp);
				}
				$out .= $tmp."\n";
			}
		}
		fclose($fpread);
		if ($nbread == 0) {
			$out = lecho("Down...")."\n";
		}

		if (!$raw) {
			$out = $this->html->sidebox($sidebox_title,$out);
		}
		$this->cache->write_box("backends_".$site,$config->ext,$out);
		return $out;
	}

	//   Get agenda from
	//     http://agenda.lolix.org/backend/backend-full.php3
	Function agenda($nb="5") {
		$title = lecho("Calendar");
		$tmp = $this->generic($nb, 3600, "agenda.lolix.org/backend/backend-full.php3",
			$title, '$1|$2|&nbsp;-&nbsp;$5: <a href="$4">$3</a><br>', '%%', 0, 1);
		$list = split("\n", $tmp);

		$dateold = $out = '';
		while($row = current($list)) {
			$res = explode("|", $row);
			$date = $this->utils->stamp2date($res[0],"short",1);
			if ($dateold != $res[0]) {
				if (!empty($dateold)) {
					$out .= "<br>";
				}
				$out .= "<b>$date</b><br>\n";
			}

			$out .= $res[2];
			$dateold = $res[0];
			next($list);
		}

		return $this->html->sidebox("Agenda",$out);
	}

	//  Prints information on current Linux kernels
	Function kernel() {
		global $config;

		$fcontents = $this->cache->check_box("3600","backends_kernel", $config->ext);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = '';

		$fpread = fsockopen('finger.kernel.org', 79, &$errno, &$errstr, 5);
		if (!$fpread) {
			$out = "<!-- Erreur de connexion:$errstr ($errno) -->\n";
			// exit;
			$out .= lecho("Down...")."\n";
			$out = $this->html->sidebox(
				'<a href="ftp://ftp.kernel.org/pub/linux/kernel/">'.lecho("Kernels").'</a>',$out);
			$this->cache->write_box("backends_kernel",$config->ext,$out);
			return $out;
		}
		fputs($fpread, "\n");
		$i = 0;
		while (!feof ($fpread)) {
			$buffer = chop(fgets($fpread, 128));
			if (ereg(": +(([0-9]+\.[0-9]+)\..+)", $buffer, $regs)) {
				$version[$i] = $regs[1];
				$major[$i] = $regs[2];
				$i++;
			}
		}
		fclose($fpread);
		$out = '<center>';
		$out .= 'Stable : <a href="ftp://ftp.kernel.org/pub/linux/kernel/v'.
				$major[0].'/linux-'.$version[0].'.tar.bz2">'.
				$version[0]."</a> (".
				'<a href="ftp://ftp.kernel.org/pub/linux/kernel/v'.
				$major[0].'/patch-'.$version[0].'.bz2">'."patch</a>)<br>\n";
		if (isset($version[1])) {
			$out .= 'Beta : <a href="ftp://ftp.kernel.org/pub/linux/kernel/v'.
				$major[1].'/linux-'.$version[1].'.tar.bz2">'.$version[1].
				"</a> (".
				'<a href="ftp://ftp.kernel.org/pub/linux/kernel/v'.
				$major[1].'/patch-'.$version[1].'.bz2">'."patch</a>)<br>\n";
		}
		if (isset($version[2])) {
			//$major[2] = ereg_replace("^[^-]+-", "", $version[2]);
			$out .= 'Alpha : <a href="ftp://ftp.kernel.org/pub/linux/kernel/testing/patch-'.
				$version[2].'.bz2">'.$version[2]."</a>\n";
		}

		$out .= "</center>";

		$out = $this->html->sidebox(
			'<a href="ftp://ftp.kernel.org/pub/linux/kernel/">'.lecho("Kernels").'</a>',$out);

		$this->cache->write_box("backends_kernel",$config->ext,$out);
		return $out;
	}

	/*
	 * LinuxFR News
	 */
	Function linuxfr($nb="10") {
		return $this->generic($nb, 300, "linuxfr.org/short.php3",
			'LinuxFR', '&nbsp;-&nbsp;[$5] <a href="$2">$1</a><br>');
	}

	/*
	 *  JeSuisLibre
	 */
	Function jesuislibre($nb="10") {
		return $this->generic($nb, 300, "www.jesuislibre.org/backend.php3",
			'JeSuisLibre', '&nbsp;- <a href="$5">$1</a> ($4)<br>');
	}

	/*
	 *  Lolix France
	 */
	Function lolixfr($nb="10") {
		return $this->generic($nb, 300, "back.fr.lolix.org/long.php3",
			'Lolix France', '&nbsp;- [$1] <a href="$3\">$2</a><br>');
	}

	/*
	 *   Slashdot News
	 */
	Function slashdot($nb="10") {
		return $this->generic($nb, 300, "www.slashdot.org/slashdot.xml",
			'Slashdot', '&nbsp;- [$6] <a href="$2">$1</a> ($7)<br>', '<story>', 1);
	}

	/*
	 *  Freshmeat.net
	 */
	Function freshmeat($nb="10") {
		return $this->generic($nb, 300, "www.freshmeat.net/backend/fm.rdf",
			'Freshmeat', '&nbsp;- <a href="$2">$1</a><br>', '<item>', 1);
	}

}

?>
