<?php
/* daCode http://www.dacode.org/
 * src/phplib/webcam.php3
 * $Id: webcam.php3,v 1.53 2001/07/12 20:09:46 penso Exp $
 * Fabien Penso <penso@linuxfr.org>
 *
 * This module will give you the possibility to put webcam shots online :)
 *
 * Depends: Config Db Html User
*/

Class Webcam {
	var $db, $html, $session;

	Function Webcam() {
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->html = LoadClass('Html');
	}

	Function get_random() {
		global $config;

		$sqlc_q = "SELECT count(*) FROM ".$config->tables['webcam'].
			" WHERE state='1'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()." -->\n";
			return;
		}
		$row = $this->db->fetch_array();
		$this->db->free();

		if ($row[0] == 0) {
			$tmp = lecho("No pic yet<br>");
			$title = lecho("Webcam...");
		} else {

			if ($row[0] >= 2) {
				$number = mt_rand(0,($row[0] - 1));
			} else {
				$number = $row[0] - 1;
			}

			$sqlc_q = "SELECT ".
				$config->tables['webcam'].".comment,".
				$config->tables['webcam'].".timestamp,".
				$config->tables['users'].".login,".
				$config->tables['users'].".fname,".
				$config->tables['users'].".lname,".
				$config->tables['webcam'].".id AS id".
				" FROM ".$config->tables['webcam'].",".
				$config->tables['users'] . " WHERE ".
				$config->tables['webcam'].".user_id=".
				$config->tables['users'].".id AND ".
				$config->tables['webcam'].".state='1' ".
				$this->db->compat_limit(1,$number);
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: ".$this->db->error()." -->\n";
				return;
			}
			$row = $this->db->fetch_array();
			$this->db->free();

			$tmp = "<center><a href=\"".$config->basehref.
				"webcam/image.".$config->php."?image_id=".$row['id']."\"><img src=\"".
				$config->basehref.
				"webcam/image.".$config->php."?image_id=".$row['id']."\" border=\"0\" ".
				"width=\"200\" alt=\"webcam\">".
				"</a><br>".
				ereg_replace("((ftp://)|(http://))(([[:alnum:]]|[[:punct:]])*)",
						"<a href=\"\\0\"><b>[url]</b></a>",
						htmlentities($row['comment'])).
				" (";

			if (!empty($row['fname']) || !empty($row['lname'])) {
				$tmp .= htmlentities($row['fname']) . " " . htmlentities($row['lname']);
			} else {
				$tmp .= htmlentities($row['login']);
			}

			$tmp .= ") <br>\n";

			if (!$this->session->is_moderator && !$this->session->is_admin) {
				$title = "<!-- WEBCAMTITLE:".$row['id'].
						" -->Webcam...<!-- /WEBCAMTITLE -->\n";
			} else {
				$title = " <!-- WEBCAMTITLE:".$row['id'].
					" -->Webcam... - <a href=\"".$config->basehref.
					"webcam/".$config->webcamadminfile.
					"?webcam_id=".$row['id'].
					"\">".lecho("Edit!")."</a><!-- /WEBCAMTITLE -->\n";
			}
		}

		if ($this->session->checked == 1) {
			$tmp .= "<a href=\"".$config->basehref."webcam/submit.".$config->php.
				"\">". lecho("Submit a picture") ."</a>\n";
		} else {
			$tmp .= lecho("Must be logged to submit a picture.");
		}

		$tmp .= "</center>\n";

		return $this->html->sidebox($title,$tmp);
	}

	Function view_image($image_id) {
		global $config;

		//echo 'view_image';
		$sqlc_q = "SELECT image,content_type,size,name FROM ".$config->tables['webcam'].
			" WHERE id='".addslashes($image_id)."'";
		if (!$this->session->is_moderator && !$this->session->is_admin) {
			$sqlc_q .= " AND state='1'";
		}
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			exit;
		}
		if ($row = $this->db->fetch_array()) {
			header('Content-type: '.$row['content_type']);
			header('Content-Length: '.$row['size']);
			header('Content-disposition: inline; filename='.$row['name']);
			echo $row['image'];
			exit;
		}
		$this->db->free();
	}

	Function webcam_to_moderate() {
		global $config;
		$tmp = "";

		if (!$this->session->is_moderator && !$this->session->is_admin) {
			return;
		}


		$sqlc_q = "SELECT id,name,size FROM ".$config->tables['webcam'].
			" WHERE state='0'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return lecho("Webcam: SQL Error !")."<br>\n";
		}

		while($row=$this->db->fetch_array()) {
			$row['name'] = htmlentities(stripslashes($row['name']));
			$row['id'] = htmlentities(stripslashes($row['id']));
			$row['size'] = htmlentities(stripslashes($row['size']));
			$tmp .= "&nbsp;-&nbsp;[WEBCAM]&nbsp;<a href=\"".
			$config->basehref."webcam/".$config->webcamadminfile.
			"?webcam_id=".$row['id']."\">".$row['name']."</a><br>\n";

		};
		$this->db->free();

		return $tmp;
	}

	Function show_webcam_to_moderate($id) {
		global $config;

		if (!$this->session->is_moderator && !$this->session->is_admin) {
			return;
		}

		$sqlc_q = "SELECT id,user_id,comment,timestamp,content_type,size,name FROM ".
			$config->tables['webcam']." WHERE id='".addslashes($id)."'";

		$ret=$this->db->query($sqlc_q);
		if(!$ret) {
			return lecho("Webcam: SQL Request Failed: ").$sqlc_q."\n";
		}

		$row=$this->db->fetch_array();

		$tmp = "";
		$tmp .= "<form action=\"".$config->basehref."webcam/".
			$config->webcamchangefile."\">";

		$tmp .= "<center><a href=\"".$config->basehref.
			"webcam/image.".$config->php."?image_id=".$row['id'].
			"\"><img src=\"".$config->basehref."webcam/image.".$config->php.
			"?image_id=".$row['id']."\" border=\"0\"></a><br>";

		$tmp .= "<input type=\"hidden\" name=\"table[id]\" value=\"".$row['id']."\">".
			htmlentities($row['comment'])."<br>".
			"<input type=\"submit\" value=\"Valider\" name=\"table[submit]\">".
			"<input type=\"submit\" value=\"Effacer\" name=\"table[submit]\">".
			"</center></form>";

		return $tmp;
	}

	Function do_moderate($row) {
		global $config;

		if (!$this->session->is_moderator && !$this->session->is_admin) {
			return;
		}

		if ($row['submit'] == "Valider") {
			$sqlc_q = "UPDATE ". $config->tables['webcam']." SET state='1' WHERE ".
				"id='".addslashes($row['id'])."'";
		} elseif ($row['submit'] == "Effacer") {
			$sqlc_q = "DELETE FROM ". $config->tables['webcam']." WHERE id='".addslashes($row['id'])."'";
		} else {
			return;
		}

		$ret=$this->db->query($sqlc_q);
		if(!$ret) {
			return lecho("Webcam: SQL Request Failed: ").$sqlc_q."\n";
		}
		return;
	}


}

?>
