<?php
/* Fabien Seisen <seisen@linuxfr.org>
 * Db.php3
 * $Id: dbmysql.php3,v 1.8 2001/07/11 09:22:27 penso Exp $
 *
 * Classe Db
 *
 * booleen Db(host, login, passwd, database, persistant (0 ou 1));
 * booleen query($query_str);
 * free();
 * $array fetch_array();
 * int num_rows();
 * void error(); // affiche l erreur
 *
 * Depends: Config
 */

class Db {
	var $db, $results;

	Function Db() {
		global $config;

		//echo '<br>Db';
		if ($config->sql_persistant == 1) {
			$this->pconnect($config->sql_host,
				$config->sql_user, $config->sql_passwd);
		} else {
			$this->connect($config->sql_host,
				$config->sql_user, $config->sql_passwd);
		}

		if (! $this->db) {
			// echo "Db->Db() rat<br>\n";
			$config->nodb = 1;
			return 0;
		}

		$ret = $this->select_db($config->sql_db, $this->db);
		return $ret;
	}

	Function clone() {
		$db2 = new Db("", "", "", "", "");
		$db2->db = $this->db;
		return $db2;
	}
	Function connect($host, $login, $passwd) {
		$this->db  = @mysql_connect($host, $login, $passwd);
		return $this->db;
	}
	Function pconnect($host, $login, $passwd) {
		$this->db  = @mysql_pconnect($host, $login, $passwd);
		return $this->db;
	}
	Function close() {
		$this->ret = mysql_close($this->db);
		return $this->ret;
	}
	Function select_db($database) {
		return @mysql_select_db($database, $this->db);
	}
	Function query($query) {
		global $config;

		if (!empty($config->sql_logfile)) {
			if (!($fp = fopen($config->sql_logfile,"a"))) {
				echo "problem...";
			}
			$bytes_written = fputs($fp,$query."\n");
			fclose($fp);
			if ($bytes_written != strlen($query)+1) {
				@unlink($config->sql_logfile);
				$config->nosave = 1;
			}
		}

		$this->results = @mysql_query($query, $this->db);
		return $this->results;
	}
	Function result($nb, $fieldname) {
		return @mysql_result($this->results, $nb, $fieldname);
	}
	Function free() {
		return mysql_free_result($this->results);
	}
	Function fetch_array() {
		return mysql_fetch_array($this->results);
	}
	Function fetch_field() {
		return mysql_fetch_field($this->results);
	}
	Function num_rows() {
		return mysql_num_rows($this->results);
	}
	Function num_fields() {
		return mysql_num_fields($this->results);
	}
	Function error() {
		return mysql_error($this->db);
	}
	Function last_insert_id() {
		return mysql_insert_id();
	}
	Function affected_rows() {
		return mysql_affected_rows();
	}

	//   The compat_* functions are to handle with incompatibilities
	//   between SQL backends
	Function compat_limit($nb,$offset="0") {
		return "LIMIT $offset,$nb";
	}
	Function compat_date_add($sec) {
		return "DATE_ADD(CURRENT_TIMESTAMP,INTERVAL $sec SECOND)";
	}
}

?>
