<?php
/* daCode http://www.dacode.org/
 * src/phplib/messages.php3
 * $Id: messages.php3,v 1.25 2001/07/12 09:48:15 penso Exp $
 *
 * This is to handle all private messages between users
 *
 * Depends: Config Db User Html
 */

class Message {

	var $session, $html, $db;

	Function Message() {
//echo '<br>Message';
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->html = LoadClass('Html');
	}

	Function add_new_message($row) {
		global $config;

		$tmp = "";
		if (!$this->session->checked) {
			echo lecho("Must be logged...")."<br>\n";
			return $tmp;
		}
		if (!ereg("^[0-9]+$",$row['user_id_dest']) || $row['user_id_dest'] == 1) {
			echo lecho("Look likes trouble to me...");
			return $tmp;
		}

		if (empty($row['subject']) || empty($row['body'])) {
			echo lecho("Must enter subject AND body");
			exit;
		}

		$sqlc_q = "INSERT INTO ".$config->tables['messages'].
			"(user_id_source,user_id_dest,subject,body) VALUES ('".
			addslashes($this->session->user_id)."','".
			addslashes($row['user_id_dest'])."','".
			addslashes($row['subject'])."','".
			addslashes($row['body']). "')";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			exit;
		}

		header("Cache-Control: no-cache, must-revalidate");
		header("Pragma: no-cache");
		if (empty($row['url'])) {
			$row['url'] = $config->basehref;
		}
		header("Location: ".$row['url']);
	}

	Function show_new_message($row) {
		global $HTTP_REFERER;
		global $config;

		if (!$this->session->checked) {
			$tmp .= lecho("Must be logged...")."<br>\n";
			return $tmp;
		}

		if (!ereg("^[0-9]+$",$row['user_id_dest'])) {
			$tmp .= lecho("Look likes trouble to me...");
			return $tmp;
		}

		$sqlc_q = "SELECT login,fname,lname FROM ".$config->tables['users'].
			" WHERE id='".addslashes($row['user_id_dest'])."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}

		if ($this->db->num_rows()!=1) {
			$tmp .= lecho("No users exists with that ID!")."<br>\n";
			return $tmp;
		}
		$c = $this->db->fetch_array();

		$tmp .= "<form method=\"post\" action=\"".$config->basehref.
				"messages/add.".$config->php."\">\n";
		$tmp .= "<table>\n";
		$tmp .= "<tr><td align=\"right\">From</td><td><b> [ ";
		if (!empty($this->session->fname) ||
			!empty($this->session->lname)) {
			$tmp .= $this->session->fname." ".$this->session->lname;
		} else {
			$tmp .= $this->session->login;
		}
		$tmp .= " ] </b></td></tr>\n";
		$tmp .= "<tr><td align=\"right\">To</td><td><b> [ ";
		if (!empty($c[1]) || !empty($c[2])) {
			$tmp .= "$c[1] $c[2]";
		} else {
			$tmp .= "$c[0]";
		}

		$tmp .= " ] </B></TD></TR>\n";
		$tmp .= "<tr><td align=\"right\">".
				lecho("Subject").
				"</td><td><input type=\"text\" name=\"table[subject]\"".
				" value=\"\" size=\"50\" ".
				"maxlength=\"80\"></td></tr>".
				"<tr><td valign=top align=\"right\">".
				ucfirst(lecho("comment")).
				"</td><td>".
				"<textarea name=\"table[body]\" rows=10 cols=50 wrap=virtual>".
				"</textarea></td></tr>";
		$tmp .= "<tr><td colspan=2 align=center><input ".
				"type=\"submit\" name=\"table[submit]\" value=\"".
				lecho("Submit")."\">".
				"<input type=\"hidden\" name=\"table[user_id_dest]\" value=\"".
				$row['user_id_dest']."\">".
				"<input type=\"hidden\" name=\"table[url]\" value=\"".
				$HTTP_REFERER."\">".
				"</td>";


		$tmp .= "</tr></table></form>\n";
		$tmp = $this->html->simplebox($tmp);

		return $tmp;
	}

	Function show_new_title() {
		global $config;

		if (!$this->session->checked) {
			$tmp = "<!-- MESSAGESHOW -->";
			$tmp .= "<!-- /MESSAGESHOW -->";
			return $tmp;
		}
		$tmp = "";

		$sqlc_q = "SELECT subject,id FROM ".$config->tables['messages'].
			" WHERE read_ok='0' AND user_id_dest='".
			addslashes($this->session->user_id).
			"' ORDER BY timestamp DESC";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= "<!-- SQL failed: ".$this->db->error()." -->\n";
			return $tmp;
		}
		if (!$this->db->num_rows()) {
			$tmp = "<!-- MESSAGESHOW -->";
			$tmp .= "<!-- /MESSAGESHOW -->";
			return $tmp;
		}

		while($row=$this->db->fetch_array()) {
			$tmp .= "&nbsp;-&nbsp;<a href=\"".
					$config->basehref."messages/view.".$config->php."?id=$row[1]".
					"\">".htmlentities($row[0])."</a><br>";
		}
		$this->db->free();

		$tmp2 = "<!-- MESSAGESHOW -->".
				$this->html->sidebox("New Messages",$tmp).
				"<!-- /MESSAGESHOW -->";

		return $tmp2;
	}

	Function view_message($row) {
		global $config;

		$tmp = "";
		if (!$this->session->checked) {
			return;
		}

		if (!ereg("^[0-9]+$",$row['id'])) {
			$tmp .= lecho("Look likes trouble to me...");
			return $tmp;
		}

		$sqlc_q = "SELECT ".
			$config->tables['messages'].".timestamp,".
			$config->tables['messages'].".user_id_source,".
			$config->tables['messages'].".user_id_dest,".
			$config->tables['messages'].".subject,".
			$config->tables['messages'].".body,".
			$config->tables['users'].".login,".
			$config->tables['users'].".fname,".
			$config->tables['users'].".lname".
			" FROM ".
			$config->tables['messages'].",".
			$config->tables['users']." ".
			"WHERE ".
			$config->tables['messages'].".id='".
			addslashes($row['id'])."' AND ".
			$config->tables['users'].".id=".
			$config->tables['messages'].".user_id_source";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$c=$this->db->fetch_array();
		if ($c[2] != $this->session->user_id) {
			$tmp .= lecho("Trying to play with your life? ")."<br>\n";
			return $tmp;
		}

		$tmp .= "<table width=\"100%\"><tr><td align=\"right\" width=\"10%\"><b>From: </b></td>".
				"<td>";
		if (!empty($c[6]) || !empty($c[7])) {
			$tmp .= "$c[6] $c[7]";
		} else {
			$tmp .= "$c[5]";
		}
		$tmp .= "</td></tr>";
		$tmp .= "<tr><td align=\"right\"><b>".lecho("Subject").": </b></td>".
				"<td>$c[3]</td></tr>";
		$tmp .= "<tr><td colspan=\"2\"><br>".nl2br(htmlentities($c[4])).
				"</td></tr>";

		$tmp .= "<tr><td colspan=\"2\" align=\"center\"><a href=\"".
				$config->basehref."messages/post.".$config->php."?user_id_dest=$c[1]".
				"\">".lecho("Reply")."</a><br>\n";

		$tmp .= "</table>";

		$sqlc_q = "UPDATE ".$config->tables['messages']." SET read_ok='1'".
			" WHERE id='".addslashes($row['id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
		}

		return $this->html->simplebox($tmp);
	}

}

?>
