#
# FtpCube
# Copyright (C) 2001 Michael Gilfix
#
# This file is part of FtpCube.
#
# You should have received a file COPYING containing license terms
# along with this program; if not, write to Michael Gilfix
# (mgilfix@eecs.tufts.edu) for a copy.
#
# This version of FtpCube is open source; you can redistribute it and/or
# modify it under the terms listed in the file COPYING.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

import GtkExtra
import time
import main

from intl import _

class Log:
	"""A logging object.

	This object provides a wrapper for textual logging of FtpCube's commands.
	Marks are inserted into the log and start up, as well as some beautifying
	of the log messages."""

	def __init__ (self, log_file, mark=1):
		"""Initializes the logging object by opening the log file and inserting
		a mark (timestamp) unless 'mark' is set to 0."""

		self.file_delim = '\n'

		try:
			self.log = open (log_file, "a")
		except IOError:
			GtkExtra.message_box (title=_("ftpcube Error"), message=_("ftpcube Error: %s"), button=( [ _("Ok") ]))
			self.log = None

		if mark:
			self.mark ()

	def __del__ (self):
		"""Gracefully closes the logfile upon destruction of the object."""

		if self.log is not None:
			self.log.close ()

	def set_file_delim (self, delim):
		"""Sets the end-of-line delimeter used. Normally, you'd want a '\n' for
		unix systems and a '\n\r' for DOS-based systems."""

		self.file_delim = delim

	def write (self, msg):
		"""Adds a timestamp to the 'msg' string and writes out the message
		to the log file."""

		if self.log is not None:
			log_time = "%s: " %(time.asctime (time.localtime (time.time ())))
			self.log.write (log_time + msg + self.file_delim)
			self.log.flush ()

	def write_blank (self):
		self.write ('')

	def mark (self):
		"""Inserts a mark or timestamp into the log file."""

		self.write_blank ()
		self.write (_("----- MARK -----"))
		self.write_blank ()
