#
# FtpCube
# Copyright (C) 2001 Michael Gilfix
#
# This file is part of FtpCube.
#
# You should have received a file COPYING containing license terms
# along with this program; if not, write to Michael Gilfix
# (mgilfix@eecs.tufts.edu) for a copy.
#
# This version of FtpCube is open source; you can redistribute it and/or
# modify it under the terms listed in the file COPYING.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

import sys, os

from intl import _

# Try to figure out where the icon directory might be.
# For now we look in a few simple places
if sys.platform == "win32":
	PREFIX = "."
elif os.name == "posix":
	if os.path.exists ("/usr/local/share/ftpcube"):
		PREFIX = "/usr/local/share/ftpcube"
	elif os.path.exists ("/usr/share/ftpcube"):
		PREFIX = "/usr/share/ftpcube"
	else:
		PREFIX = "."
else:
	print _("ftpcube can't determine the location of it's icons on your OS.")
	print _("Please set the prefix manually in main.py")
	sys.exit (1)

import getopt, gtk
import app

ICONS_PREFIX = os.path.join (PREFIX, "icons")

cmdline_opts = { }

def main ():
	"""Start up procedure for the application. This function performs
	all necessary argument parsing and creates the application instance."""

	try:
		opts, args = getopt.getopt (sys.argv[1:], 'h', [
			'help',         # Print out help usage info
			'debug-level=', # The debugging output level to use
			'icons=',       # Directory where the icons are stored
		])
	except getopt.GetoptError:
		usage ()
		sys.exit (1)

	for o, a in opts:
		if o in ("-h", "--help"):
			usage ()
			sys.exit (1)
		elif o == "--debug-level":
			cmdline_opts['debug_level'] = a
		elif o == "--icons":
			# Override the icon finding code
			global PREFIX, ICONS_PREFIX
			PREFIX = os.path.dirname (a)
			ICONS_PREFIX = a

	# Instantiate the application and enter the main loop
	create_global_app (app.Application (_("ftpcube")))
	app.display_banner ()

	gtk.threads_enter ()
	gtk.mainloop ()
	gtk.threads_leave ()

def create_global_app (a):
	"""A convenience function for moving the application instance a
	into global namespace while avoiding any name collision."""

	global app
	app = a

def usage ():
	"""Prints a command-line usage string."""

	pass
