/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpServlet
extends GenericServlet
implements Serializable {
    private String optionString = null;

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(400, "Method \"DELETE\" is not supported by this servlet");
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(400, "Method \"GET\" is not supported by this servlet");
    }

    private void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HttpServlet httpServlet = this;
        if (httpServlet == null) {
            throw null;
        }
        this.doGet(httpServletRequest, httpServlet.new DoHeadHttpServletResponse(httpServletResponse));
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.optionString == null) {
            try {
                Method[] methodArray = this.getClass().getMethods();
                String string = "javax.servlet.http.HttpServlet";
                StringBuffer stringBuffer = new StringBuffer("");
                int n = 0;
                while (n < methodArray.length) {
                    if ("doGet".equals(methodArray[n].getName()) && !string.equals(methodArray[n].getDeclaringClass().getName())) {
                        stringBuffer.append("GET, ");
                    } else if ("doDelete".equals(methodArray[n].getName()) && !string.equals(methodArray[n].getDeclaringClass().getName())) {
                        stringBuffer.append("DELETE, ");
                    } else if ("doPut".equals(methodArray[n].getName()) && !string.equals(methodArray[n].getDeclaringClass().getName())) {
                        stringBuffer.append("PUT, ");
                    } else if ("doPost".equals(methodArray[n].getName()) && !string.equals(methodArray[n].getDeclaringClass().getName())) {
                        stringBuffer.append("POST, ");
                    }
                    ++n;
                }
                stringBuffer.append("HEAD, TRACE, OPTIONS");
                this.optionString = stringBuffer.toString();
            }
            catch (SecurityException securityException) {
                httpServletResponse.sendError(400, "Method \"OPTIONS\" is not supported by this servlet");
            }
        }
        httpServletResponse.setHeader("Allow", this.optionString);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(400, "Method \"POST\" is not supported by this servlet");
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(400, "Method \"PUT\" is not supported by this servlet");
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        StringBuffer stringBuffer = new StringBuffer("\r\n");
        stringBuffer.append("TRACE " + httpServletRequest.getRequestURI() + " " + httpServletRequest.getProtocol() + "\r\n");
        Object object = httpServletRequest.getHeaderNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            stringBuffer.append(string + ": " + httpServletRequest.getHeader(string) + "\r\n");
        }
        httpServletResponse.setContentType("message/http");
        httpServletResponse.setContentLength(stringBuffer.length());
        object = httpServletResponse.getWriter();
        ((PrintWriter)object).print(stringBuffer.toString());
        ((PrintWriter)object).close();
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return -1L;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (httpServletRequest.getMethod().equals("GET")) {
            if (this.testConditional(httpServletRequest, httpServletResponse)) {
                this.doGet(httpServletRequest, httpServletResponse);
            }
        } else if (httpServletRequest.getMethod().equals("HEAD")) {
            if (this.testConditional(httpServletRequest, httpServletResponse)) {
                this.doHead(httpServletRequest, httpServletResponse);
            }
        } else if (httpServletRequest.getMethod().equals("POST")) {
            this.doPost(httpServletRequest, httpServletResponse);
        } else if (httpServletRequest.getMethod().equals("DELETE")) {
            this.doDelete(httpServletRequest, httpServletResponse);
        } else if (httpServletRequest.getMethod().equals("OPTIONS")) {
            this.doOptions(httpServletRequest, httpServletResponse);
        } else if (httpServletRequest.getMethod().equals("PUT")) {
            this.doPut(httpServletRequest, httpServletResponse);
        } else if (httpServletRequest.getMethod().equals("TRACE")) {
            this.doTrace(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.sendError(400, "Method \"" + httpServletRequest.getMethod() + "\" is not supported by this servlet");
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            this.service((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        }
        catch (ClassCastException classCastException) {
            throw new ServletException("This servlet only excepts http requests");
        }
    }

    private boolean testConditional(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setDateHeader("Date", System.currentTimeMillis());
        httpServletResponse.setHeader("Server", this.getServletConfig().getServletContext().getServerInfo());
        long l = this.getLastModified(httpServletRequest);
        if (l >= 0L) {
            httpServletResponse.setDateHeader("Last-Modified", l);
            long l2 = httpServletRequest.getDateHeader("If-Modified-Since");
            if (l2 >= 0L && l2 <= l) {
                httpServletResponse.sendError(304);
                return false;
            }
        }
        return true;
    }

    private class DoHeadHttpServletResponse
    implements HttpServletResponse {
        HttpServletResponse myResponse;

        public void addCookie(Cookie cookie) {
            this.myResponse.addCookie(cookie);
        }

        public boolean containsHeader(String string) {
            return this.myResponse.containsHeader(string);
        }

        public void sendError(int n, String string) throws IOException {
            this.myResponse.sendError(n, string);
        }

        public void sendError(int n) throws IOException {
            this.myResponse.sendError(n);
        }

        public void sendRedirect(String string) throws IOException {
            this.myResponse.sendRedirect(string);
        }

        public void setDateHeader(String string, long l) {
            this.myResponse.setDateHeader(string, l);
        }

        public void setHeader(String string, String string2) {
            this.myResponse.setHeader(string, string2);
        }

        public void setIntHeader(String string, int n) {
            this.myResponse.setIntHeader(string, n);
        }

        public void setStatus(int n) {
            this.myResponse.setStatus(n);
        }

        public void setStatus(int n, String string) {
            this.myResponse.setStatus(n, string);
        }

        public String encodeUrl(String string) {
            return this.myResponse.encodeUrl(string);
        }

        public String encodeRedirectUrl(String string) {
            return this.myResponse.encodeRedirectUrl(string);
        }

        public void setContentLength(int n) {
            this.myResponse.setContentLength(n);
        }

        public void setContentType(String string) {
            this.myResponse.setContentType(string);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            DoHeadHttpServletResponse doHeadHttpServletResponse = this;
            if (doHeadHttpServletResponse == null) {
                throw null;
            }
            return new ServletOutputStream(doHeadHttpServletResponse){
                private final /* synthetic */ DoHeadHttpServletResponse this$0;

                public void write(int n) throws IOException {
                }

                public void write(byte[] byArray, int n, int n2) throws IOException {
                }
                {
                    this.this$0 = doHeadHttpServletResponse;
                    this.constructor$0(doHeadHttpServletResponse);
                }

                private final void constructor$0(DoHeadHttpServletResponse doHeadHttpServletResponse) {
                }
            };
        }

        public PrintWriter getWriter() throws IOException {
            return this.myResponse.getWriter();
        }

        public String getCharacterEncoding() {
            return this.myResponse.getCharacterEncoding();
        }

        DoHeadHttpServletResponse(HttpServletResponse httpServletResponse) {
            this.myResponse = httpServletResponse;
        }
    }
}

