#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
#  Copyright (c) 2002 Miguel Filgueiras (mig@ncc.up.pt) / Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: langengl.tcl
#  Last change:  1 February 2002
#
# Includes contributions by Brian Baulch (baulchb@onthenet.com.au)
#

# only 3 chars long names; check also ALLMONTH in file gpsman
set MONTHNAMES "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec"

set DLUNIT(KM,dist) km
set DLUNIT(KM,subdist) m
set DLUNIT(KM,speed) kph
set DLUNIT(KM,area) "sq km"
set DLUNIT(NAUTMILE,dist) "nm"
set DLUNIT(NAUTMILE,subdist) ft
set DLUNIT(NAUTMILE,speed) knot
set DLUNIT(NAUTMILE,area) "sq nm"
set DLUNIT(STATMILE,dist) "st ml"
set DLUNIT(STATMILE,subdist) ft
set DLUNIT(STATMILE,speed) mph
set DLUNIT(STATMILE,area) "section"

set DTUNIT $DLUNIT($DISTUNIT,dist)
set SPUNIT $DLUNIT($DISTUNIT,speed)
set ARUNIT $DLUNIT($DISTUNIT,area)

set MESS(RTcomp) "#\tWP\t\t$DTUNIT\tdeg\m"
set MESS(TRcomp) "#\t$DTUNIT\t$DTUNIT\tm\th:m:s\t$SPUNIT\tdeg"
set MESS(WPNearest) "WP\t\t$DTUNIT\tdeg"

array set MESS {
    notleap   "YEAR0 defined as %d is not a leap year"
    badscale   "Bad value for map scale"
    oktoexit   "Ok to exit (unsaved data will be lost)"
    okclrmap   "Ok to clear map"
    namelgth   "Name must not exceed %d characters"
    cmmtlgth   "Comment must not exceed %d characters"
    namevoid   "Name cannot be void"
    baddate   "Bad date"
    badhdg   "Bad heading %s: must be %s or +/-"
    badcoord   "Bad coordinate range or format: \"%s\" must be %s"
    outofrng   "Number out of range"
    UTMZN   "Must be a letter in A..H, J..N, or P..Z"
    badstrg "Bad character(s)"
    strgvoid   "String cannot be empty"
    nan   "\"%s\" is not a number"
    written   "Written by"
    undefWP   "Route %s has undefined WP(s); not saved/exported"
    bigRT   "Route %s > max number; not exported"
    unkndatum   "Unknown datum"
    badcommdWP   "Bad command when loading WPs; line"
    notabsWP   "Bad WP definition; no tabs, line"
    undefWP   "Reference to unknown WP: %s; line %d"
    nofieldsWP   "Bad WP, not enough fields; line"
    excfieldsWP  "Bad WP, too many fields; line"
    badWPsRT   "RT with bad waypoints list; line"
    toomuchWPs   "Warning: more than %d WPs in RT"
    badcommdTP   "Bad command when loading TPs; line"
    badTP   "Bad point in TR; line"
    badTPsTR   "TR with bad trackpoints list; line"
    noheader   "File does not start with header"
    loaderr   "Error when loading from file; line"
    unkncommd   "Unknown command when loading from file; line"
    noformat   "File does not start with Format line"
    badformat   "Bad format line"
    badRT   "Bad RT definition; line"
    badRTargs   "Bad RT arguments; line"
    badTR   "Bad TR definition; line"
    fileact   "%s %s file?"
    filexists   "File exists!"
    GPSok   "Connection ok"
    toomany   "Too many %ss (> %d)"
    cantfgt   "Cannot forget %s: belongs to mapped item"
    cantfgted   "Cannot forget %s: being edited"
    cantmapRTunkn   "Route not mapped; no info for WP"
    cantmapRTed   "Route not mapped; WP beig edited"
    cantrun   "Cannot run"
    inprogr   "Operation already in progress"
    cantread   "Cannot read auxiliary file"
    cantwrtopt   "Cannot write preferences file"
    voidRT   "Route contains no waypoints"
    activeRT   "Route 0 is active route; continue?"
    voidTR   "Track contains no points"
    idinuse   "Identifier already in use"
    cantunmap   "Cannot unmap %s: belongs to mapped item"
    askrevert   "Revert to initial data?"
    askforget   "Forget this %s?"
    notimpl   "Not implemented"
    forgetall   "Forget all items in %s list?"
    counted   "There are %d %ss defined"
    notlisted   "Item not listed"
    wrgval   "Bad value for"
    voidGR   "Group has no elements"
    initselfGR   "Group contains itself via"
    GRelout   "Command for element outside GR definition; line"
    badGRels   "Group with bad elements list; line"
    badcommdGRel   "Bad command when loading GR elements; line"
    notypeforGRel   "Element with no type; line"
    badGRel   "Bad element definition; line"
    check   "Checking connection"
    toomanyerr   "Too many errors; aborting..."
    getWP   "Getting WPoints"
    getRT   "Getting Routes"
    getTR   "Getting Tracks"
    putWP   "Putting WPoints"
    putRT   "Putting Routes"
    putTR   "Putting Tracks"
    fillbuffWP  "Loading WP buffer"
    fillbuffRT  "Loading RT buffer"
    noACKNAK  "Got packet when expecting ACK/NAK; check GPS connection"
    badplatform   "No I/O with serial port in this platform"
    badserial "Cannot open serial port %s"
    nodata    "No %ss in receiver"
    badimage "Bad image file"
    mapaskWPs "Please choose %d WPs to place on map"
    mapadjust "Please place WPs on map; click Ok when finished"
    duplicate "%s already selected"
    clrcurrmap "Clear current map?"
    cantfix "%d WPs are needed to fix the map; load or define some WPs first"
    mbkbaddatum "No or unknown datum"
    mbkbadscale "Scale must be non-negative"
    mbkbadat "Bad arguments"
    edityourrisk "Edit at your own risk!"
    okclrbkmap   "Ok to clear map background"
    okclrbkim    "Ok to clear image at"
    badWPfield "Wrong optional field"
    badWPattr "Unknown optional field name"
    badSYMBOLcode "Bad symbol code"
    badDISPOPTcode "Bad display option code"
    goingdown "Preferences saved; please restart"
    putwhat "Put what item types?"
    readwhat "Read what item types?"
    noWPinx "Too many WPs for receiver"
    noICinx "Too many ICs for receiver"
    getIC "Getting Icons"
    serial1 "Incorrect Header Preamble"
    serial2 "Incorrect Command returned"
    checksum1 "Incorrect Header Checksum"
    checksum2 "Data Checksum error"
    receiver "No serial connection!"
    importonly1 "Can only import 1 kind of data"
    exportonly1 "Can only export 1 kind of data"
    outdatedprefs "Preferences file outdated; please check it now"
    mustchoose1type "At least 1 kind of items must be selected"
    nosuchitems "No item corresponds to description"
    resultsin "Search results in Group"
    badWP "WP not given or undefined"
    badangle "Angle must be >0 and <360 degrees"
    georefhow  "Geo-referencing method"
    cantsolve  "Cannot solve equations"
    transfcantscale "No scaling with current transformation"
    oldfilefmt "Old file format; please save under new format!"
    unknProj "Unknown map projection"
    unknTransf "Unknown map transformation"
    badProjargs "Wrong arguments for projection"
    badTransfargs "Wrong arguments for transformation"
    badfield "Bad attribute=value pair"
    badattr "Bad attribute name"
    missattrs "Missing attribute(s)"
    mbkbadproj "Bad map projection"
    mbkbadtransf "Bad map transformation"
    notUTMproj "Saved info for UTM; proceed with projection set to"
    projchg    "Please confirm projection parameters"
    badparam "Bad value for %s"
    connectedto "Connected to %s"
    recnotsuppd "Receiver model not supported"
    gotprots "Got protocols definition"
    badprots "Bad protocols definition"
    defprots "Using table of protocols"
    nohidden "Discard hidden data?"
    badRS "Route stage outside RT definition; line"
    badWPsRSs "RT stage before 1st or after last WP; line"
    windowdestr "The window has been destroyed!"
    badhidden "Bad format for hidden value"
    replname "Replace \"%s\" by a name having at most %d of the following characters: %s"
    badalt "Bad value for altitude"
    baddistunit "Bad distance unit for map scale in preferences file"
    badgridzone "Invalid grid zone"
    outofgrid "Position out of grid scope"
    timeoffnotint "Time offset must be an integer"
    cantchkprot "Cannot check under current protocol"
    mustconn1st "Check connection with receiver first"
    rltmnotsupp "Real time log not supported by protocol in this receiver"
    createdir "Please create directory %s and restart"
    oktomkdir "Ok to create directory %s?"
    projnameabbr "Please give a name and a short name to the new projection"
    abbrevinuse "Short name already taken"
    nameinuse "Name already taken"
    projinuse "Projection is being used; changes will be discarded"
    gridneedsdatum "Bad grid definition for %s; no datum given"
    badgriddatum "Datum for the grid %s must be %s"
    cantchggriddatum "This grid needs the datum %s"
    gridinuse "Grid, used by %s, cannot be deleted; continue?"
    gridinusenochg "This grid is used by %s; no changes made"
    cantwrtprgr "Cannot write user projections file"
    cantwrtdtel "Cannot write user datums file"
    movingWP "Place %s with left-click\nCancel with right-click"
    missingdata "Not enough data!"
    needs1wp "Route must have at least 1 waypoint"
    emptypos "Position with empty field(s)"
    cantwrtsstate "Cannot write saved state file: %s"
    cantrdsstate "Cannot read saved state file: %s"
    corruptsstate "Corrupt saved state file: %s"
    editrisk "Edit at your own risk!"
    savestate "Save current state?"
    delsstate "Delete saved state files?"
    badmapinfo "Bad map parameters file"
    badMHloc "Wrong Maidenhead locator"
    areais "Area of (non-self intersecting) polygon is %.3f%s"
    areatoosmall "Area is too small (<%s sq km)"
    projarea "Computing projected area"
    selfintsct "Repeated WPs: RT cannot intersect itself!"
    badinvmdist "Approximation error when inverting meridional distance"
    badinvproj "Approximation error when inverting %s projection"
    negdlatlong "Lat/long range cannot be negative!"
    allundef "There are no definitions for the WPs in the GR"
    badfloats "Floating-point conversions not working correctly; are you sure you want to connect?"
}

set TXT(RTcompflds) "# WP {$DTUNIT} deg m stage label"
set TXT(TRcompflds) "TP {$DTUNIT} {$DTUNIT} m h:m:s {$SPUNIT} deg"
set TXT(starttoend) "Start: to end %s $DTUNIT;"
set TXT(startmax) "max %s $DTUNIT;"
set TXT(WPnearflds) "WP {$DTUNIT} deg"
set TXT(within) "Within (${DTUNIT}s)"
set TXT(between) "Between (${DTUNIT}s)"

array set TXT {
    GMtit   "GPS Manager - version"
    exit   Exit
    map   Map
    load   Load
    loadfrm   "Load from"
    save   Save
    saveels "Save elements"
    saveto   "Save to"
    clear   Clear
    clearall   "Clear All"
    newWP   "New WP"
    newRT   "New RT"
    newTR   "New TR"
    newGR   "New GR"
    import   Import
    importfrm   "Import from"
    export   Export
    exportels "Export elements"
    exportto   "Export to"
    count   Count
    trueN   "True North"
    automagn   "Auto Magnetic"
    usrdef   "User Defined"
    nameWP   WPoint
    nameRT   Route
    nameTR   Track
    nameGR   Group
    namePlot   Plot
    nameMap   Map
    nameRTComp   "Route Computation"
    nameTRComp   "Track Computation"
    GPSrec   "GPS receiver"
    turnoff   "Turn Off"
    get   Get
    put   Put
    all   All
    select   Select
    selection   Selection
    options   Options
    DMS   DMS
    DMM   DMM
    DDD   DDD
    UTM/UPS   UTM/UPS
    MH    MH
    message   Message
    cancel   Cancel
    file   File
    ovwrt   Overwrite
    app   Append
    online   online
    offline   offline
    check   check
    create   Create 
    revert   Revert
    colour   colour
    grey   grey
    mono   mono
    portr   portrait
    landsc   landscape
    legend   Legend
    incscale   "Include scale"
    more   More
    waypoint   Waypoint
    name   Name
    created   Created
    cmmt   Comment
    withWP  "With this WP:"
    displ   "Display on map"
    startRT "Start RT"
    route   Route
    number   Number
    insb   "Insert before"
    insa   "Insert after"
    del   Delete
    repl   "Replace by"
    comp   Compute
    RTcomp   "Route Computation"
    savecomp "Save computation"
    totdst   "Total distance"
    tottime   "Total time"
    track   Track
    chophd   "Chop head"
    choptl   "Chop tail"
    incb   "Include before"
    mkRT   "Make RT"
    date   Date
    newdate   "New date for next point"
    endprTR   "End of previous track"
    begnxt   "Beginning of next"
    date1st   "Date for 1st point of next"
    TRcomp   "Track Computation"
    avgsp   "Average speed"
    maxsp   "Max speed"
    minsp   "Min speed"
    lat   Lat
    long   Long
    ze   ZE
    zn   ZN
    eastng   Easting
    nrthng   Northing
    zone   Zone
    change   Change
    forget   Forget
    others   Others
    opt_Interf  Interface
    optLANG   Language
    optISOLATIN1   "Compose chars"
    optDELETE   "DEL deletes last char"
    optMWINDOWSCONF  "Main window"
    optGPSREC   "GPS Model"
    opt_GPSRecConf   "Receiver parameters"
    optNAMELENGTH   "Max name length"
    optINTERVAL "Sampling interval"
    optCOMMENTLENGTH   "Max comment length"
    optMAXWPOINTS   "Max # WPoints"
    optMAXROUTES   "Max # Routes"
    optMAXWPINROUTE   "Max # WPs in Route"
    optMAXTPOINTS   "Max # Trackpoints"
    optCREATIONDATE   "Rec has creation date"
    optNOLOWERCASE   "Rec has no lower case"
    optDEFAULTSYMBOL "Default WP symbol"
    optDEFAULTDISPOPT "Default WP display option"
    opt_Data "Data"
    optEQNAMEDATA "Data with same name"
    optKEEPHIDDEN "Keep hidden data"
    optDatum   Datum
    optTimeOffset   "Time offset"
    optACCFORMULAE "Accurate formulae"
    optASKPROJPARAMS "Confirm proj parameters"
    optBalloonHelp "Balloon help"
    optTRNUMBERINTVL "Show TP number on map at each"
    opt_Formats   "Units and formats"
    optDISTUNIT   "Distance"
    KM    km
    NAUTMILE    "nautical mile"
    STATMILE    "statute mile"
    optPositionFormat   "Position format"
    optDateFormat   "Date format"
    opt_Geom   "Window geometry"
    opt_MapGeom   "Map geometry"
    optMAPWIDTH   "Map width"
    optMAPHEIGHT   "Map height"
    optMAPSCLENGTH   "Map scale length"
    optMAPSCALE   "Map scale"
    optMAXMENUITEMS   "Max # menu items"
    optLPOSX   "Lists window x-pos"
    optLPOSY   "Lists window y-pos"
    optMPOSX   "Map window x-pos"
    optMPOSY   "Map window y-pos"
    optRPOSX   "Rec window x-pos"
    optRPOSY   "Rec window y-pos"
    optEPOSX   "Error window x-pos"
    optEPOSY   "Error window y-pos"
    optDPOSX   "Dialog x-pos"
    optDPOSY   "Dialog y-pos"
    optDPOSRTMAP "RT/map dialog offset"
    optLISTWIDTH   "List width"
    optLISTHEIGHT   "List height"
    optCOLOUR   Colours
    optCOLOUR,fg   Foreground
    optCOLOUR,bg   Background
    optCOLOUR,messbg   "Error background"
    optCOLOUR,confbg   "Confirmation background"
    optCOLOUR,selbg   "Selection background"
    optCOLOUR,dialbg   "Input background"
    optCOLOUR,offline   "Receiver offline"
    optCOLOUR,online   "Receiver online"
    optCOLOUR,check   "Selected checkbutton"
    optCOLOUR,ballbg   "Balloon help background"
    optCOLOUR,ballfg   "Balloon help foreground"
    optMAPCOLOUR  "Map colours"
    optMAPCOLOUR,mapsel   "Selected map item"
    optMAPCOLOUR,WP   "Wayponts on map"
    optMAPCOLOUR,RT   "Routes on map"
    optMAPCOLOUR,mkRT "Route defined on map"
    optMAPCOLOUR,TR   "Tracks on map"
    optMAPCOLOUR,TP   "Track points on map"
    optMAPCOLOUR,mapleg   "Map legends"
    optMAPCOLOUR,anim  "Animation on map"
    optMAPCOLOUR,emptygrid  "Empty image"
    optMAPCOLOUR,fullgrid   "Existing image"
    opt_Files Files
    optDEFSPORT "Serial port"
    optSAVESTATE "Save state on exit"
    optDELSTATE "Delete files after restoring state"
    optPERMS   "File permissions"
    optPAPERSIZE "Paper size"
    red   Red
    green   Green
    blue   Blue
    owner   Owner
    permgroup   Group
    others   Others
    fread   Read
    fwrite   Write
    fexec   Exec
    YYYYMMDD   YYYYMMDD
    MMDDYYYY   MMDDYYYY
    DDMMMYYYY   DDMMMYYYY
    YYYY-MM-DD  YYYY-MM-DD
    mainwd   "Main window"
    distazim   "Dist and bearing"
    nearestWPs   "Nearest WPs"
    fromto   "From %s to %s"
    degrees   degrees
    nameWPDistBear   "dist and bearing"
    nameWPNearest   "nearest WPs"
    inrect   "In rectangle"
    forthisWP   "for this WP"
    formappedWPs   "for mapped WPs"
    group   Group
    element   Element
    insert   Insert
    joinGR   "Join Group"
    TRtoRT   "Conversion from TR to RT"
    TRRTnpoints   "No. points to keep"
    TRRTdispl   "Display RT now"
    TRTRdispl   "Display TR now"
    WP   WP
    RT   RT
    TR   TR
    GR   GR
    commrec   "Communication with receiver"
    abort   Abort
    ACKs   ACKs
    NAKs   NAKs
    packets   packets
    unnamed   "(unknown)"
    fromTR    "From TR: %s"
    mapload "Geo-referencing image"
    loadmback Load
    savemback "Save geo-ref info"
    chgmback Change
    clearmback Clear
    backgrnd Backgrnd
    nameMapBkInfo "Background info"
    nameMapInfo "Map settings"
    mpbkchg "Change background"
    mpbkgrcs "Grid position"
    nameImage Image
    symbol Symbol
    SYCATgeneral "General use"
    SYCATland Land
    SYCATwater Water
    SYCATaviation Aviation
    SY1st_aid "First aid"
    SYWP_buoy_white "Buoy, white"
    SYWP_dot "WP"
    SYairport "Airport"
    SYamusement_park "Amusement park"
    SYanchor "Anchor"
    SYavn_danger "Danger (avn)"
    SYavn_faf "1st approach fix"
    SYavn_lom "Localizer outer marker"
    SYavn_map "Missed approach point"
    SYavn_ndb "ND beacon"
    SYavn_tacan "TACAN"
    SYavn_vor "VHF omni-range"
    SYavn_vordme "VOR-DME"
    SYavn_vortac "VOR/TACAN"
    SYball "Ball"
    SYbeach "Beach"
    SYbell "Bell"
    SYboat "Boat"
    SYboat_ramp "Boat ramp"
    SYborder "Border crossing"
    SYbowling "Bowling"
    SYbridge "Bridge"
    SYbuilding "Building"
    SYbuoy_amber "Buoy, amber"
    SYbuoy_black "Buoy, black"
    SYbuoy_blue "Buoy, blue"
    SYbuoy_green "Buoy, green"
    SYbuoy_green_red "Buoy, green red"
    SYbuoy_green_white "Buoy, green white"
    SYbuoy_orange "Buoy, orange"
    SYbuoy_red "Buoy, red"
    SYbuoy_red_green "Buoy, red green"
    SYbuoy_red_white "Buoy, red white"
    SYbuoy_violet "Buoy, violet"
    SYbuoy_white "Buoy, white"
    SYbuoy_white_green "Buoy, white green"
    SYbuoy_white_red "Buoy, white red"
    SYcamping "Camp site"
    SYcapitol_city "City, star"
    SYcar "Car"
    SYcar_rental "Rent-a-car"
    SYcar_repair "Car repair"
    SYcasino "Casino"
    SYcastle "Castle"
    SYcemetery "Cemetery"
    SYchapel "Chapel"
    SYchurch "Church"
    SYcircle_x "Circled X"
    SYcivil "Civil location"
    SYcontrolled "Controlled Area"
    SYcrossing "Crossing"
    SYdam "Dam"
    SYdanger "Danger"
    SYdeer "Deer"
    SYdiamond_green "Diamond, green"
    SYdiamond_red "Diamond, red"
    SYdiver_down_1 "Diver down 1"
    SYdiver_down_2 "Diver down 2"
    SYdollar "Dollar"
    SYdot "Dot"
    SYdrinking_water "Drinking water"
    SYduck "Duck"
    SYelevation "Elevation"
    SYexit_no_serv "Exit, no services"
    SYexit "Exit"
    SYfactory "Factory"
    SYfastfood "Fast food"
    SYfish "Fish"
    SYfitness "Fitness"
    SYflag "Flag"
    SYfreeway "Freeway"
    SYfuel "Fuel"
    SYfuel_store "Fuel & store"
    SYgeo_name_land "Geo name, land"
    SYgeo_name_man "Geo name, man-made"
    SYgeo_name_water "Geo name, water"
    SYglider "Glider"
    SYgolf "Golf"
    SYheliport "Heliport"
    SYhorn "Horn"
    SYhouse "House"
    SYice_skating "Ice skating"
    SYinfo "Info"
    SYintersection "Intersection"
    SYis_highway "Highway"
    SYknife_fork "Food"
    SYladder "Ladder"
    SYlanding "Landing"
    SYlarge_city "City, large"
    SYlarge_exit_ns "Exit no serv, large"
    SYlarge_ramp_int "Ramp int, large"
    SYlevee "Levee"
    SYlight "Light"
    SYlodging "Lodging"
    SYmany_fish "Fish bank"
    SYmany_tracks "Many tracks"
    SYmark_x "Mark, x"
    SYmedium_city "City, medium"
    SYmile_marker "Mile marker"
    SYmilitary "Military location"
    SYmine "Mine"
    SYMOB "Man over board"
    SYmonument "Monument"
    SYmountains "Mountains"
    SYmovie "Movie"
    SYmug "Mug"
    SYmuseum "Museum"
    SYntl_highway "National highway"
    SYnull "(transparent)"
    SYnull_2 "(void)"
    SYoil_field "Oil field"
    SYparachute "Parachute"
    SYpark "Park"
    SYparking "Parking"
    SYpharmacy "Pharmacy"
    SYphone "Phone"
    SYpicnic "Picnic"
    SYpizza "Pizza"
    SYpolice "Police"
    SYpost_office "Post-office"
    SYprivate "Private field"
    SYradio_beacon "Radio beacon"
    SYramp_int "Ramp intersection"
    SYrestricted "Restricted Area"
    SYrestrooms "WC"
    SYRV_park "Recreational Vehicle park"
    SYscenic "Scenic"
    SYschool "School"
    SYseaplane "Seaplane base"
    SYshopping_cart "Shopping"
    SYshort_tower "Tower, short"
    SYshowers "Showers"
    SYskiing "Water skiing"
    SYskull "Skull"
    SYsmall_city "City, small"
    SYsnow_skiing "Snow skiing"
    SYsoft_field "Soft field"
    SYsquare_green "Square, green"
    SYsquare_red "Square, red"
    SYst_highway "State highway"
    SYstadium "Stadium"
    SYstore "Store"
    SYstreet_int "Street intersection"
    SYsummit "Summit"
    SYswimming "Swimming"
    SYtake_off "Take-off"
    SYtall_tower "Tower, tall"
    SYtheater Theater
    SYtoll Toll
    SYtow_truck "Tow truck"
    SYtraceback "Trace-back"
    SYtracks Tracks
    SYtrail_head "Trail head"
    SYtree "Tree"
    SYtruck_stop "Truck stop"
    SYtunnel "Tunnel"
    SYultralight "Ultralight"
    SYus_highway "US highway"
    SYweight_station "Weight station"
    SYwreck "Wreck"
    SYzoo "Zoo"
    psvisible "Only visible part"
    DISPsymbol "Symbol only"
    DISPs_name "S & name"
    DISPs_comment "S & comment"
    DISPname "Name only"
    DISPcomment "Comment only"
    dispopt Display
    mapitems "Display items on map"
    nameIC Icon
    prod Product
    WPCapac "Waypoint Capacity"
    ICCapac "Icon Capacity"
    RTCapac "Route Capacity"
    TRCapac "Track Capacity"
    protcl "Protocol"
    ICGraph "Icon Graphics"
    WPperRT "Waypoints per Route"
    notinGR "not in (sub-)group"
    onlyinGR "only in (sub-)group"
    loadgrels "Load elements"
    importgrels "Import elements"
    about "On GPSMan..."
    contrib "With contributions by"
    errorsto "Error reports to:"
    obsTRToRT "WPs created by a TR to RT conversion"
    nameLists "Lists"
    nameData "Data"
    MWCmap "Map"
    MWClists "Lists"
    MWCsingle "Single window"
    search "Search"
    rmrk "NB"
    closeto "Close to"
    with "With"
    srchres "FOUND"
    database "Database"
    where "Where"
    what "What"
    list "list"
    distance "Distance"
    fromWP "from Waypont"
    fromPos "from position"
    azimuth "Bearing"
    any "any"
    opening "Opening"
    suggested "suggested"
    another "Another"
    srchdd1 "Search on"
    srchdd2Data "all items"
    srchdd2GR "Group(s)"
    from "from"
    started "starting on"
    transf  "Coords Transf"
    TRNSFAffine    "Affine"
    TRNSFAffineConf  "Aff Conformal"
    TRNSFNoRot      "Conf No Rot"
    projection "Projection"
    lat0  "Lat of centre"
    long0 "Long of centre"
    lat1  "Lat 1st st parallel"
    lat2  "Lat 2nd st parallel"
    latF  "Lat false origin"
    longF "Long false origin"
    gkklong0 "Long of centre"
    kkjplong0 "Long of centre"
    twglong0 "Long of centre"
    k0 "Scale factor"
    PRJUTM "UTM/UPS"
    PRJTM "Transverse Mercator"
    PRJCMP "Portuguese Mil Map"
    PRJBNG "British National Grid"
    PRJBWI "British West Indies"
    PRJITM "Irish Transv Mercator"
    PRJGKK "German Grid"
    PRJLCC1 "Lambert Conic Conf 1"
    PRJLCC2 "Lambert Conic Conf 2"
    PRJKKJP "Basic Finnish Grid"
    PRJKKJY "Uniform Finnish Grid"
    PRJSEG "Swedish Grid"
    PRJMerc1 "Mercator 1"
    PRJMerc2 "Mercator 2"
    PRJCS "Cassini-Soldner"
    PRJAPOLY "American Polyconic"
    PRJStereogr Stereographic
    PRJTWG "Taiwan Grid"
    dontaskagain "Stop asking"
    rename "Use new name"
    oname "Original name"
    never "Never"
    ask "Ask"
    always "Always"
    stage "Stage"
    label "Label"
    alt "Altitude"
    locate "Locate"
    animation  Animation
    fast Fast
    slow Slow
    start Start
    pause Pause
    speed Speed
    centred "Keep centred"
    state State
    animinit "at start/end"
    animon "running"
    animpause "paused"
    animabort "aborting"
    realtimelog "Real-time track log"
    garmin Garmin
    nmea "NMEA 0183"
    stext "Simple Text"
    simul "simulator"
    lowrance Lowrance
    getlog "Get Log"
    stop Stop
    dolog Record
    show Show
    hide Hide
    posfixerror error
    posfix_  ?
    posfix2D 2D
    posfix3D 3D
    posfix2D-diff "2D d"
    posfix3D-diff "3D d"
    posfixGPS GPS
    posfixDGPS DGPS
    posfixAuto ok
    posfixsimul simul
    restart Restart
    mkTR "Make TR"
    PVTflds "# t lat long alt fix EPE EPH EPV vel_x vel_y vel_z CMG"
    namePVTData "Log data"
    mkavgWP "Make avg WP"
    move Move
    define Define
    open Open
    defs "Definitions"
    baseproj "Base projection"
    abbrev "Short name"
    grid Grid
    use Use
    unit Unit
    feasting "False easting"
    fnorthing "False northing"
    bounds Bounds
    max Max
    min Min
    easting Easting
    northing Northing
    fixeddatum "fixed datum"
    elevation Elevation
    usewps "Use WPs"
    chgpfrmt "Change position format"
    here Here
    atprevwp "At previous WP"
    prevwp "Previous WP"
    firstwp "First WP"
    chglstrs "Edit previous stage"
    chgnxtrs "Edit next stage"
    contnend "Add to end"
    closemenu "Close menu"
    ellpsd Ellipsoid
    datum Datum
    userdefs "User definitions"
    edmap "Edit on map"
    actual actual
    rtimelogintv "Log interval"
    inca "Include after"
    invert "Invert"
    recwindow "Receiver window"
    volume "Volume"
    latS "Lat S"
    latN "Lat N"
    longW "Long W"
    longE "Long E"
    no No
    computations Computations
    comparea "Compute area"
    cluster Cluster
    centre  Centre
    mkclusters "Make clusters"
    quadr Quadrangle
    dlat "Latitude range"
    dlong "Longitude range"
    collcntr "Collecting centres..."
    compclstr "Computing clusters..."
    crtgclstrgrs "Creating groups..."
    chgdatum "Change datum..."
}

    # the following definitions must be coherent with $TXT
array set INVTXT {
    DMS   DMS
    DMM   DMM
    DDD   DDD
    UTM/UPS   UTM/UPS
    MH   MH
    WP   WP
    RT   RT
    TR   TR
    GR   GR
}

