#ifndef __GSK_CONSTRAINT_H_
#define __GSK_CONSTRAINT_H_

#include "gskgtk.h"

/* Note: message_out may be NULL.  And the validator func doesn't
 *       need to give a message.  The caller should initialize *message_out
 *       to NULL if they plan on using it.
 */
typedef gboolean (*GskConstraintFunc)(GtkArg          *arg,
				      gpointer         constraint_data,
				      char           **message_out);

/* --- adding constraints --- */
void           gsk_constraint_add_for_arg   (GtkType              type,
                                             const char          *arg_name,
                                             GskConstraintFunc    func,
                                             gpointer             data,
                                             GDestroyNotify       destroy);
void           gsk_constraint_add_for_array (GtkType              type,
                                             const char          *arg_name,
                                             GskConstraintFunc    func,
                                             gpointer             data,
                                             GDestroyNotify       destroy);
void           gsk_constraint_add_for_signal(guint                signal_id,
                                             guint                param_index,
                                             GskConstraintFunc    func,
                                             gpointer             data,
                                             GDestroyNotify       destroy);

/* --- testing constraints --- */
gboolean       gsk_constraint_check_arg     (GtkType              type,
                                             GtkArg              *arg,
					     char               **message_out);
gboolean       gsk_constraint_check_sig     (guint                signal_id,
			                     guint                num_args,
			                     GtkArg              *args,
			                     char               **message_out);
/* For arrayed arguments */
gboolean       gsk_constraint_check_array   (GtkType              type,
			                     const char          *name,
			                     guint                num_args,
			                     GtkArg              *args,
			                     char               **message_out);

/* --- helper functions (like various non-constrained versions) --- */
gboolean       gsk_constrained_setv         (GtkObject           *object,
					     guint                num_args,
					     GtkArg              *args,
					     char               **message_out);
gboolean       gsk_constrained_emitv        (GtkObject           *object,
			                     guint                signal_id,
			                     guint                num_args,
			                     GtkArg              *args,
			                     char               **message_out);
gboolean       gsk_constrained_append_args  (GtkObject           *object,
			                     const char          *name,
			                     guint                num_args,
			                     GtkArg              *args,
			                     char               **message_out);

/* --- Stock Constraint Testers --- */

/* Test that an argument implements an interface.
 *
 * Pass in GUINT_TO_POINTER (GSK_TYPE_WHATEVER_IFACE) for
 * the constraint data.
 */
gboolean gsk_constraint_test_implements    (GtkArg          *arg,
                                            gpointer         constraint_data,
                                            char           **message_out);

#endif
