#ifndef __GSK_RESOLVER_H_
#define __GSK_RESOLVER_H_

#include  "gskdnsinterfaces.h"

typedef void (*GskResolverLookupFunc)   (GskSocketAddress   *address,
					 gpointer            func_data);

/* main interface to name resolution */
void            gsk_resolver_resolve (GskMainLoop             *main_loop,
				      const char              *host,
				      GskResolverLookupFunc    result_func,
				      GHookFunc                fail_func,
				      gpointer                 data,
				      GDestroyNotify           destroy);

/* main_loop may be NULL, but then the function will not create
   a new resolver. */
GskDnsResolver *gsk_resolver_peek    (GskMainLoop             *main_loop);

/* only required if you want a specially configured resolver */
void            gsk_resolver_init    (GskDnsResolver          *resolver);

/*< private: for debugging memory use >*/
void gsk_resolver_release_global ();
#endif
