#ifndef __GSK_XML_SERVLET_H_
#define __GSK_XML_SERVLET_H_

typedef struct _GskXmlServlet GskXmlServlet;
typedef struct _GskXmlServletIface GskXmlServletIface;

#include "../gskinterface.h"
#include "../gskactorbuffered.h"
#include "../gskactorlistener.h"
#include "gskxmlprocessor.h"

GskInterfaceType gsk_xml_servlet_iface_get_type ();
#define GSK_TYPE_XML_SERVLET_IFACE 		(gsk_xml_servlet_iface_get_type ())
#define GSK_IS_XML_SERVLET(obj)		GSK_INTERFACE_TEST (obj, GSK_TYPE_XML_SERVLET_IFACE)
#define GSK_XML_SERVLET(obj)		GSK_INTERFACE_CAST (GskXmlServlet, obj, GSK_TYPE_XML_SERVLET_IFACE)
#define GSK_XML_SERVLET_GET_IFACE(obj)	GSK_INTERFACE_GET_IFACE (GskXmlServletIface, obj, GSK_TYPE_XML_SERVLET_IFACE)

struct _GskXmlServletIface
{
  void   (*process_arg)(GskXmlServlet    *servlet,
			GskXmlArgCallback arg_callback,
			gpointer          arg_data,
			GDestroyNotify    arg_data_destroy);
};

GskActorBuffered *gsk_xml_servlet_worker_new (GskStreamSocket  *accepted,
                                              GskXmlConfig     *config,
                                              gboolean          one_shot);

GskActorListener *gsk_xml_listener_new (GskXmlConfig      *config,
					GskSocketListener *listener,
                                        gboolean           one_shot);

#endif
