/*
    GSK - a library to write servers
    Copyright (C) 1999    Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/


#ifndef __GSK_DAEMONIZE_H_
#define __GSK_DAEMONIZE_H_

/* These functions must be called *before* gsk_daemonize. */
void gsk_daemonize_set_user(const char* username);
void gsk_daemonize_set_group(const char* group);
void gsk_daemonize_set_chroot(const char *chroot_jail);

/* Fork this process into the background, as many daemons do. */
void gsk_daemonize(const char *log_file);

void gsk_daemonize_set_niceness(int niceness);

#endif
