/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/

/*
 * PRIVATE:  Internal routines used by both the client and server code.
 */

#ifndef __GSK_HTTP_COMMON_H_
#define __GSK_HTTP_COMMON_H_

#include <glib.h>

/*< private >*/

/* 
 * Process a buffer, looking for the end of the header.
 *
 * Trick to finding the end-of-header:
 *
 *    Since the header ends with either
 *           \n\r\n    or    \n\n
 *    we keep track of whether the last buffer
 *    ends with either:
 *   	     \n\r      or     \n
 *    and store that in `*was_newline' on exit.
 *
 *    If the line begins with
 *	     \r\n      or     \n
 *    and "*was_newline" was set, then that is the end-of-header.
 *
 * If the end-of-header is not found, -1 is returned.
 */
int gsk_http_scan_for_end_header(gboolean   *was_newline,
                                 const void *data,
		                 int         length);

#endif
