/* gdkDPSline.h --- DPS line representation in gdk
 *
 * Copyright (C) 1999 Masatake YAMATO
 *
 * Author:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
 * Time-stamp: <99/10/28 08:23:50 masata-y> 
 *
 * This file is part of gtkDPS Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GDK_DPS_LINE_H
#define GDK_DPS_LINE_H 

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Line style */
typedef enum 
{
  GDK_DPS_JOIN_MITER = 0,
  GDK_DPS_JOIN_ROUND,
  GDK_DPS_JOIN_BEVEL
} GdkDPSJoinStyle;
gboolean gdk_dps_join_style_is_in_range(GdkDPSJoinStyle join_style);

/* Line cap */
typedef enum 
{
  GDK_DPS_CAP_BUTT = 0, 
  GDK_DPS_CAP_ROUND,
  GDK_DPS_CAP_SQUARE
} GdkDPSCapStyle; 
gboolean gdk_dps_cap_style_is_in_range(GdkDPSCapStyle cap_style);

/* Dash pattern */
typedef struct _GdkDPSDashPattern GdkDPSDashPattern;
struct _GdkDPSDashPattern
{
  gfloat phase;
  GArray * pattern;		/* Elements are float */
};
GdkDPSDashPattern * gdk_dps_dash_pattern_new(gint default_length);
void gdk_dps_dash_pattern_free(GdkDPSDashPattern *);

gint gdk_dps_dash_pattern_length(GdkDPSDashPattern *);
gboolean gdk_dps_dash_pattern_empty(GdkDPSDashPattern *);
void gdk_dps_dash_pattern_set_at(GdkDPSDashPattern *, 
				 gint index,
				 gfloat value);
gfloat gdk_dps_dash_pattern_get_at(GdkDPSDashPattern *, 
				   gint index);
void gdk_dps_dash_pattern_get(GdkDPSDashPattern *, gfloat *);

gfloat gdk_dps_dash_pattern_phase(GdkDPSDashPattern *);
void gdk_dps_dash_pattern_set_phase(GdkDPSDashPattern *, gfloat);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* Not: GDK_DPS_LINE_H */
