// -*- c++ -*-
//  Generated by gtkmmproc from ./../table.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_TABLE_H
#define _GTKMM_TABLE_H

/* $Id: table.gen_h,v 1.66 2001/07/15 13:33:38 murrayc Exp $ */


/* table.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/container.h>
#include <gtk/gtktable.h>

namespace Gtk {
class Table;
class Table_Class;
}
namespace Gtk { Gtk::Table *wrap (GtkTable *o); }
namespace Gtk
{
class Table;

namespace Table_Helpers
{

  class TableList
    {
      public:
        typedef Widget*                       value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_List_Iterator<value_type>        iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;
        typedef G_List_ReverseIterator<iterator>   reverse_iterator;
        typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend class Gtk::Table;
        Gtk::Table *parent_;
        explicit TableList(Table* parent): parent_(parent) {}

        GList*& glist() const;      // front of list

        iterator begin_() const;
        iterator end_() const;

      public:
        ~TableList() {}

        inline iterator begin()
          {return begin_();}
        inline iterator end()
          {return end_();}

        inline const_iterator begin() const
          { return const_iterator(begin_()); }
        inline const_iterator end() const
          { return const_iterator(end_()); }

        inline reverse_iterator rbegin()
          { return reverse_iterator(end_()); }
        inline reverse_iterator rend()
          { return reverse_iterator(begin_()); }

        inline const_reverse_iterator rbegin() const
          { return const_reverse_iterator(reverse_iterator(end_())); }
        inline const_reverse_iterator rend() const
          { return const_reverse_iterator(reverse_iterator(begin_())); }

        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }


        void clear();

        iterator erase(iterator);
        void erase(iterator start, iterator stop);
        void remove(const_reference);

        void remove(Widget& w);

     };
};

//: Table Packing Widget
//- {\class Gtk::Table} is one of the primary methods for construction of
//- grouped widgets.  It consists of a set of lattice points to
//- to which widgets can be attached.  There are {\i (rows+1)} lattice
//- points vertically and {\i (columns+1)} lattice points horizontally.
//- Lattice points start counting from 0.
//- Lattice points can either be specified to be {homogeneous}  meaning
//- equally spaced or not {homogeneous} meaning each cell should
//- be calculated based on the widgets contained in the row and column.
//- Homogeneous defaults to FALSE.
//-
//- Widgets can be attached to the table at by specifying the top, bottom,
//- left and right points corresponding to upper, lefthand
//- lattice point and the lower, righthand lattice point with the
//- widget should span.  Widgets can
//- either be contained in a cell or may span cells.  A number of options
//- control the resizing behavior of widgets contained in the table.
//-
//- {\b Packing options:}
//-
//- There are a number of packing objections that can be specified
//- when adding a widget.  With {\enum GTK_EXPAND}, the lattice is
//- allowed to grow to fill space.  With {\enum GTK_SHRINK}, the lattice
//- is allowed to shrink when resized.  It is also possible to specify
//- the behaviour of the widgets allocation within the table.  The
//- flag {\enum GTK_FILL} declares the widget should grow to fill lattice.
//- If this is not set any extra space is used as padding.
//- The default is {\enum GTK_FILL} and {\enum GTK_EXPAND}.
//-
//- The table size is calculated
//- based on the size of the widgets contained within and the restrictions
//- imposed by specified options.
//-
//- Padding and spacing can be use
//- in the table.  Padding is added on either side of a widget, while spacing
//- is placed between widgets.
//-
//- The other generic packing widgets are:
//- {Gtk::Box::}, {Gtk::HBox::}, {Gtk::VBox::}
class Table : public Container {

public:
  typedef Table          CppObjectType;
  typedef Table_Class    CppClassType;
  typedef GtkTable           BaseObjectType;
  typedef GtkTableClass      BaseClassType;

private:
  friend class Table_Class;
  static CppClassType table_class;

  Table(const Table&);
  Table& operator=(const Table&); // not implemented

protected:
  void   initialize_class();
  explicit Table(GtkTable *castitem);

public:
  static GtkType get_type();
  GtkTable* gtkobj()             { return (GtkTable*)(gtkobject); }
  const GtkTable* gtkobj() const { return (GtkTable*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Table();

private:

public:

  explicit Table(gint rows=1, gint columns=1, gint homogeneous=FALSE);



  //: Binds a widget to a set of lattice points.
  //- At minumum
  //- specification of the lattice points is required.
  //- Additionally, the cell options as described above and paddings
  //- may be specified.  Default paddings are 0 pixels in both dimensions.

  void attach(Gtk::Widget& child,guint left_attach,guint right_attach,guint top_attach,guint bottom_attach,gint xoptions=(GTK_FILL|GTK_EXPAND),gint yoptions=(GTK_FILL|GTK_EXPAND),guint xpadding=0,guint ypadding=0);


  //: (Gtk 1.1) This function allows for dynamic resizing of
  //: a Table.

  void resize(guint rows,guint columns);


  void set_homogeneous(bool homogeneous);

  //: This function sets the number of pixels to appear between one row of cells and the next.
  //- {\var row} is the
  //- lattice row counted without the edges starting from 0.  Therefore, row
  //- 0 would denote between the first and second
  //- row of cells.  {\i row} has a range from  0 and {\i (rows-2)}
  //- Default spacing is 0 pixels.

  void set_row_spacing(gint row,gint spacing);

  //- This function sets the number of pixels to appear between one column of cells and the next.
  //- {\var column} is the
  //- lattice column counted without the edges starting from 0.  Therefore,
  //- column 0 would denote between the first and second
  //- row of cells.  {\var column} has a range from  0 and {\i (columns-2)}.
  //- Default spacing is 0 pixels.

  void set_col_spacing(gint column,gint spacing);

  //: This function sets the number of pixels to a appear between every
  //: row of cells.  Default is 0 pixels.

  void set_row_spacings(gint spacing);

  //: This function sets the number of pixels to a appear between every
  //: column of cells.  Default is 0 pixels.

  void set_col_spacings(gint spacing);

  void set_spacings(gint spacing);

  typedef Table_Helpers::TableList TableList;

  // *****WARNING - THESE METHODS DO NOT WORK IN STABLE
  //   CAN NOT BE FIXED BECAUSE OF BINARY COMPATIBLITY.  WILL
  //   FIX IN 1.4
  TableList& children()
    {return reinterpret_cast<TableList&>(container_self);}
  const TableList& children() const
    {return reinterpret_cast<const TableList&>(container_self);}

public:

protected:
  // impl functions

};

}


//+ PROPERTIES(Gtk_Table)
//. name: children
//. type: GList*
//. get:
//. set:
//. desc:

//. name: rows
//. type: GtkTableRowCol*
//. get:
//. set:
//. desc:

//. name: cols
//. type: GtkTableRowCol*
//. get:
//. set:
//. desc:

//. name: nrows
//. type: guint16
//. get:
//. set:
//. desc:

//. name: ncols
//. type: guint16
//. get:
//. set:
//. desc:

//. name: column_spacing
//. type: guint16
//. get:
//. set:
//. desc:

//. name: row_spacing
//. type: guint16
//. get:
//. set:
//. desc:

//. name: homogeneous
//. type: guint:1
//. get:
//. set:
//. desc:

#endif
