-----------------------------------------------------------------------------
-- |
-- Module      :  Data.STRef.Lazy
-- Copyright   :  (c) The University of Glasgow 2001
-- License     :  BSD-style (see the file libraries/base/LICENSE)
-- 
-- Maintainer  :  libraries@haskell.org
-- Stability   :  experimental
-- Portability :  non-portable (requires non-portable module ST)
--
-- Mutable references in the lazy ST monad.
--
-----------------------------------------------------------------------------
module Data.STRef.Lazy (
	-- * STRefs
	ST.STRef,	-- abstract, instance Eq
	newSTRef,	-- :: a -> ST s (STRef s a)
	readSTRef,	-- :: STRef s a -> ST s a
	writeSTRef,	-- :: STRef s a -> a -> ST s ()
	modifySTRef	-- :: STRef s a -> (a -> a) -> ST s ()
 ) where

import Control.Monad.ST.Lazy

import Hugs.LazyST as ST

