;;; i18n-man-de.el --- browse UNIX German manual pages
;;; $Id: i18n-man-de.el,v 1.1 1998/09/20 16:29:09 iwasaki Exp $:

;;;  This file part of i18n-man - i18nized man,
;;;  a GNU Emacs front end to browse the UNIX manual pages in various languages.

;;; Everyone is granted permission to copy, modify and redistribute
;;; this program.

;;; HISTORY
;;;
;;;	Written by Mitsuru IWASAKI 14 Sep, 1998 (FreeBSD Japanese man Project)
;;;

;;; Suggested USAGE
;;;
;;;  In your ~/.emacs
;;;(autoload 'dman "i18n-man-de" nil t)
;;;(autoload 'eman "i18n-man-en" nil t)
;;;  then
;;;  M-x dman
;;;    to get a German manual page thru man(1) and put it in a buffer.
;;;  M-x eman
;;;    to get a English manual page thru man(1) and put it in a buffer.

;;; NOTE: This code requires FreeBSD ports/german/manpages (or packages de-manpages-1.0)
;;; installed on your system, GNU troff version 1.10, man(1) of FreeBSD.
;;; To format manpages, this code setting several environment variables, 
;;; (setenv GROFF_TYPESETTER latin1, setenv MANPATH /usr/local/man/de_DE.ISO_8859-1:$MANPATH),
;;; and invoking man with -t to use /usr/bin/groff -man in current implementation.
;;; Other man(1) optoins (like -a, -k) may be ignored because of -t option.
;;; I'm not sure that this is the correct way to format the german manpages, and
;;; works well on other systems as well.  Please let me informed better solution if you know.
;;; iwasaki@jp.FreeBSD.org


(require 'i18n-man)

(defun i18n-Man-de-init-defvars ()
  "Used for initialising variables for German i18n-man."
  (i18n-Man-init-lang-depend-variables)
  (setq i18n-manual-lang-depend-program "man -t")
  (setq i18n-Man-lang-depend-language-string "German")
  (setq i18n-Man-lang-depend-heading-regexp
	"^\\([A-Z][A-Z ]+\\)$")
  (setq i18n-Man-lang-depend-see-also-regexp
	"SIEHE AUCH\\|^SEE ALSO")
  (setq i18n-Man-lang-depend-first-heading-regexp
	"^[ \t]*BEZEICHNUNG$\\|^[ \t]*NAME$\\|^[ \t]*No manual entry fo.*$")

  (setq i18n-Man-lang-depend-cooked-hook
	'i18n-Man-de-depend-softhyphen-to-minus)
  (setq i18n-Man-lang-depend-process-starting-hook
	'i18n-Man-de-depend-process-starting-hook)
  (setq i18n-Man-lang-depend-process-started-hook
	'i18n-Man-de-depend-process-started-hook))

(defun i18n-Man-de-depend-softhyphen-to-minus ()
  ;; \201\255 is some kind of dash in Latin-1.
  (goto-char (point-min))
  (if (i18n-Man-multibyteb-characters-enablep)
      (while (search-forward "\201\255" nil t)
	(let ((p (get-text-property (- (point) 3) 'face)))
	  (replace-match "-")
	  (put-text-property (- (point) 1) (point) 'face p)))))

;; for temporary use.
(defvar i18n-Man-de-depend-process-coding-system-alist nil)
(defvar i18n-Man-de-depend-default-process-coding-system nil)

(require 'cl)
(defun i18n-Man-de-depend-process-starting-hook ()
  "Hook for the German manpage depend man command and troff formatter setting.
Also save original values of variable to the local variable temporary."
  (setenv "MANPATH" (format "%s:%s" "/usr/local/man/de_DE.ISO_8859-1" (getenv "MANPATH")))
  (setenv "GROFF_TYPESETTER" "latin1")
  (if (featurep 'mule)
      (case emacs-major-version
	(20 ;; XEmacs or Emacs-20.x (Mule-2.4, 3.0 or later)
	 (setq i18n-Man-de-depend-process-coding-system-alist process-coding-system-alist)
	 (if (and (boundp 'mule-version)
		  (string-match "2.4" mule-version))
	     ;; Mule-2.4
	     (setq process-coding-system-alist '(("sh" coding-system-iso-8859-1 . coding-system-iso-8859-1)))
	   ;; XEmacs , Mule-3.0 or later
	     (setq process-coding-system-alist '(("sh" iso-8859-1 . iso-8859-1)))
	     ))
	(19 ;; Emacs-19.x (Mule-2.3)
	 (setq i18n-Man-de-depend-default-process-coding-system default-process-coding-system)
	 (setq default-process-coding-system (cons '*ctext* '*ctext*))))))

(defun i18n-Man-de-depend-process-started-hook (process)
  "Hook for global variable restoring."
  (if (featurep 'mule)
      (case emacs-major-version
	(20 ;; XEmacs or Emacs-20.x (Mule-2.4, 3.0 or later)
	 (setq process-coding-system-alist i18n-Man-de-depend-process-coding-system-alist))
	(19 ;; Emacs-19.x (Mule-2.3)
	 (setq default-process-coding-system i18n-Man-de-depend-default-process-coding-system))
	)))

;;;###autoload
(defun dman ()
  "i18n-man for German manpage."
  (interactive)
  (i18n-Man-de-init-defvars)
  (call-interactively 'i18n-man))

(provide 'dman)

;;; i18n-man-de.el ends here
