#
#    prefBinder Binder preference module
#
#			Tue Mar 16 22:25:23 JST 1999
#

set button -1

proc pref_save {tl} {
	global ttblibPath ttbdefPath
	global panelColor stageColor
	global panelText stageText
	global frameWidth frameHeight
	global stageWidth stageHeight
	global itemWidth itemHeight
	global binder_title binder_browseMode
	global binder_startupDir LANG
	global binder_upDateInterval
	global autoUpdateFlag autoUpdateFlagDefault
	global applicon

	set autoUpdateFlag false

	global button

	set binder_startupDir [$tl.u.lang.f3.e0 get]

	set fp [open $ttbdefPath/Binder w]

	puts $fp "global ttblibPath"
	puts $fp "global panelColor stageColor"
	puts $fp "global panelText stageText"
	puts $fp "global frameWidth frameHeight"
	puts $fp "global stageWidth stageHeight"
	puts $fp "global itemWidth itemHeight"
	puts $fp "global binder_title binder_browseMode"
	puts $fp "global binder_startupDir LANG"
	puts $fp "global binder_upDateInterval"
	puts $fp "global applicon"

	foreach i {ttblibPath panelColor stageColor panelText stageText frameWidth frameHeight stageWidth stageHeight itemWidth itemHeight binder_title binder_browseMode binder_startupDir LANG binder_upDateInterval autoUpdateFlag autoUpdateFlagDefault applicon} {
		eval puts $fp \"set $i \{\$$i\}\"
	}

	close $fp

	set button 0
}

proc pref_setInterval {val} {
	global binder_upDateInterval

	set binder_upDateInterval $val
}

proc pref_cancel {tl} {
	global button

	set button 1
}

proc pref_setColor {w name} {
	global panelColor stageColor
	global panelText stageText

	eval set backup \$$name

	set $name [tk_chooseColor -title "Choose a color" -parent . \
		-initialcolor $backup]

	eval set temp \$$name

	if {$temp==""} {
		set $name $backup
		set temp $backup
	}

	$w configure -bg $temp
}

proc binder_Preference {} {
	global button
	global autoUpdateFlag autoUpdateFlagDefault

	set autoUpdateFlag false

	set oldFocus [focus]
	set tl ".prefer"

	if {[winfo exists $tl]} {
		raise $tl
		return
	} else {
		toplevel $tl
	}

	grab $tl

	global ttblibPath
	global panelColor stageColor
	global panelText stageText
	global frameWidth frameHeight
	global stageWidth stageHeight
	global itemWidth itemHeight
	global binder_title binder_browseMode
	global binder_startupDir LANG
	global binder_upDateInterval
	global applicon

	set xFont "-adobe-courier-medium-r-normal--18-*"
	set lFont "-adobe-fixed-medium-r-normal--14-*"
	set mFont "-adobe-fixed-medium-r-normal--12-*"

	wm title $tl "$binder_title:preferences"

	$tl configure -bd 10 -bg $panelColor

	##################### Frames #########################

	frame $tl.u -bg $panelColor
	frame $tl.b -bg $panelColor
	pack $tl.u $tl.b -fill both

	frame $tl.u.color -bg $panelColor -bd 2 \
		-width 192 -height 260 -relief groove
	frame $tl.u.lang -bg $panelColor -bd 2 \
		-width 192 -height 260 -relief groove

	$tl.u.color configure -font $xFont -fg $panelText -text "Mode&Color"
	$tl.u.lang configure -font $xFont -fg $panelText -text Misc

	pack $tl.u.color $tl.u.lang -fill both -side left
	pack propagate $tl.u.color false
	pack propagate $tl.u.lang false

	######################## frame 0 #######################

	frame $tl.u.color.f5 -bd 5 -bg $panelColor
	frame $tl.u.color.f4 -bd 5 -bg $panelColor
	frame $tl.u.color.f3 -bd 5 -bg $panelColor
	frame $tl.u.color.f2 -bd 5 -bg $panelColor
	frame $tl.u.color.f1 -bd 5 -bg $panelColor
	frame $tl.u.color.f0 -bd 5 -bg $panelColor
	frame $tl.u.color.f6 -bd 5 -bg $panelColor
	frame $tl.u.color.f7 -bd 5 -bg $panelColor
	frame $tl.u.color.f8 -bd 5 -bg $panelColor

	pack $tl.u.color.f6 $tl.u.color.f0 $tl.u.color.f1 $tl.u.color.f2 \
		$tl.u.color.f3 $tl.u.color.f4 $tl.u.color.f5 \
		 $tl.u.color.f7 $tl.u.color.f8 -fill both -side bottom

	label $tl.u.color.f8.l1 -font $mFont -text "Default mode" \
		-fg $panelColor -bg $panelText -width 48
	pack $tl.u.color.f8.l1

	label $tl.u.color.f7.l1 -image Pref.icon -width 48 -bg $panelColor
	label $tl.u.color.f7.l3 -image Pref.list -width 48 -bg $panelColor

	radiobutton $tl.u.color.f7.l2 -relief flat -value iconMode\
		-variable binder_browseMode -bg $panelColor
	radiobutton $tl.u.color.f7.l4 -relief flat -value listMode\
		-variable binder_browseMode -bg $panelColor

	pack $tl.u.color.f7.l2 $tl.u.color.f7.l1 -side left
	pack $tl.u.color.f7.l4 $tl.u.color.f7.l3 -side left

	checkbutton $tl.u.color.f5.cb0 -text "Application icon" \
		-variable applicon -onvalue true -offvalue false

	pack $tl.u.color.f5.cb0


	label $tl.u.color.f4.l1 -font $mFont -text "Main panel color" \
		-fg $panelColor -bg $panelText -width 48
	pack $tl.u.color.f4.l1

	button $tl.u.color.f3.bg -fg $panelText -bg $panelColor -text "bg color" \
		-command  "pref_setColor $tl.u.color.f3.bg panelColor"
	button $tl.u.color.f3.fg -fg $panelColor -bg $panelText -text "text color" \
		-command  "pref_setColor $tl.u.color.f3.fg panelText"

	pack $tl.u.color.f3.bg $tl.u.color.f3.fg -side left

	label $tl.u.color.f2.l1 -font $mFont -text "Operation area color" \
		-fg $panelColor -bg $panelText -width 48
	pack $tl.u.color.f2.l1

	button $tl.u.color.f1.bg -fg $stageText -bg $stageColor -text "bg color" \
		-command  "pref_setColor $tl.u.color.f1.bg stageColor"
	button $tl.u.color.f1.fg -fg $stageColor -bg $stageText -text "text color" \
		-command  "pref_setColor $tl.u.color.f1.fg stageText"

	pack $tl.u.color.f1.bg $tl.u.color.f1.fg -side left

	######################## Frame 1 ######################

	frame $tl.u.lang.f4 -bd 5 -bg $panelColor
	frame $tl.u.lang.f3 -bd 5 -bg $panelColor
	frame $tl.u.lang.f2 -bd 5 -bg $panelColor
	frame $tl.u.lang.f1 -bd 5 -bg $panelColor
	frame $tl.u.lang.f0 -bd 5 -bg $panelColor

	pack [frame $tl.u.lang.f5 -bd 5 -bg $panelColor] -fill both -side bottom

	pack $tl.u.lang.f0 $tl.u.lang.f1 $tl.u.lang.f2 $tl.u.lang.f3 $tl.u.lang.f4 \
		-fill both -side bottom



	label $tl.u.lang.f3.l0 -font $lFont -text "Startup folder" \
		-fg $panelColor -bg $panelText -width 32
	pack $tl.u.lang.f3.l0

	entry $tl.u.lang.f3.e0 -fg $panelText -bg $panelColor
	pack $tl.u.lang.f3.e0 -pady 3

	$tl.u.lang.f3.e0 insert end $binder_startupDir



	label $tl.u.lang.f2.l0 -font $lFont -text "Update interval(ms)" \
		-fg $panelColor -bg $panelText -width 32
	pack $tl.u.lang.f2.l0

	scale $tl.u.lang.f2.s0 -trough $panelColor -from 5000 -to 60000 -length 500 \
		-resolution 20 -showvalue yes -orient horizontal \
		-tickinterval 20000 -command pref_setInterval \
		-fg $panelText -bg $panelColor
	pack $tl.u.lang.f2.s0

	$tl.u.lang.f2.s0 set $binder_upDateInterval

	checkbutton $tl.u.lang.f2.cb0 -text "Auto update" \
		-variable autoUpdateFlagDefault -onvalue true -offvalue false



	pack $tl.u.lang.f2.cb0

	label $tl.u.lang.f1.l1 -font $mFont -text "Default language" \
		-fg $panelColor -bg $panelText -width 48
	pack $tl.u.lang.f1.l1

	label $tl.u.lang.f0.l1 -image Pref.ja -width 48 -bg $panelColor
	label $tl.u.lang.f0.l3 -image Pref.en -width 48 -bg $panelColor

	radiobutton $tl.u.lang.f0.l2 -relief flat -value ja\
		-variable LANG -bg $panelColor
	radiobutton $tl.u.lang.f0.l4 -relief flat -value en\
		-variable LANG -bg $panelColor

	pack $tl.u.lang.f0.l2 $tl.u.lang.f0.l1 -side left
	pack $tl.u.lang.f0.l4 $tl.u.lang.f0.l3 -side left

	##################### bottom #########################

	button $tl.b.ok -text save -font $lFont -default active \
		-command "pref_save $tl" -bg $panelColor -fg $panelText
	button $tl.b.cancel -text cancel -font $lFont -default normal \
		-command "pref_cancel $tl" -bg $panelColor -fg $panelText

	pack $tl.b.cancel $tl.b.ok -side right -padx 5 -pady 5

	tkwait variable button
	destroy $tl
	set autoUpdateFlag $autoUpdateFlagDefault

	focus $oldFocus
	return $button
}
