#!/usr/bin/ruby -Ke
# goRua -- Gtk+ on Ruby User Agent for 2ch version
GORUA_VERSION = '0.13a'
# ջ  haruyama@unixuser.org
# $Id: goRua.rb,v 1.82 2002/04/22 13:55:49 haruyama Exp $

# ΥեGPLդƤޤ.
# Υץ̵ݾڤǤ.
require 'getopts'
require 'gtk'

$error_of_switch_page = false
if Gtk::BINDING_VERSION.join == "027" ||  Gtk::BINDING_VERSION.join == "028"
  STDERR.print "Ruby/Gtk 0.27,0.28(CVS snapshot)ˤ꤬뤿ᡢεǽưޤ\n"
  $error_of_switch_page = true
end

#require 'kconv'
require 'nkf'
require 'net/http'
require 'thread'
begin
  require 'zlib'
  $gzip=true
rescue LoadError
  STDERR.print "ruby-zlibޤǤ\ngzipǰ̤줿ȥ꡼򰷤ȤǤޤ\nߤread.cgiλͤǤgzipǰ̤줿ȥ꡼Τߤ󶡤褦Ǥ\nruby-zlibΥ󥹥ȡ侩ޤ\n"
  $gzip=false
#  exit
end

require 'connect2ch'

# ƥǥȥӥ塼ѹƤ
# >> ǥȥӥ塼
# Thanks: 餱@kondara 
GORUA_DATADIR = '/usr/share/goRua'

##### Ƽ #####
# ϢեΥ١ǥ쥯ȥ
$basedir = ENV["HOME"]+ "/.goRua_2ch/"

# Thanks: 餱@kondara 
Dir.mkdir($basedir) unless File.exist?($basedir)
Dir.mkdir("#{$basedir}/thread") unless File.exist?("#{$basedir}/thread")
Dir.mkdir("#{$basedir}/subject") unless File.exist?("#{$basedir}/subject")
unless File.exist?("#{$basedir}/board_info")
  system "cp #{GORUA_DATADIR}/board_info #{$basedir}/board_info"
end
unless File.exist?("#{$basedir}/bookmarks")
  system "cp #{GORUA_DATADIR}/bookmarks #{$basedir}/bookmarks"
end

#ǥե
$config={
  'proxy_addr' => nil,
  'proxy_port' => nil,
  'http_get_timeout' => 60,
  'http_command' => "galeon -n %u",
  'tab_string_size' => 7,
  'height' => 600,
  'select_width' => 250,
  'view_width' => 650,
  'post_width' => 600,
  'post_height' => 400,
  'hankaku_to_zenkaku' => nil,
  'thread_tooltips_delay' => 1500,
  'post_name_candidate' => [''],
  'post_mailto_candidate' => ['','sage'],
  'user_agent' => "goRua.rb #{GORUA_VERSION}",
  'background_get' => nil,
  'show_old_message' => nil,
  'colored_text' => true,
  'color0' => 'black',
  'color1' => 'red',
  'color2' => 'blue',
  'color3' => 'green',
  'set_last_page' => true,
}

config = $basedir + "config"

# Thanks: 餱@kondara 
#if File.exist?(config)
begin
  unless File.exist?(config)
    config = "#{GORUA_DATADIR}/config"
  end
  open(config,'r'){|file|
    while line=file.gets
      line=NKF::nkf('-ex',line)
      line.chop!
      if /^\#/ =~ line
	next
      elsif /^([a-z_0-9]+)\s*=\s*([0-9\-][0-9]*)\s*$/ =~ line
	tmp1=$1
	tmp2=$2
	if $config[tmp1].is_a? Fixnum  
	  $config[tmp1]=tmp2.to_i
	elsif !$config[tmp1]
	  $config[tmp1]=tmp2.to_i
	elsif $config[tmp1].is_a? String
	  $config[tmp1]=tmp2.strip
	else
	  STDERR.print "#{$1} ʤͤꤵƤޤ\n"
	end
      elsif /^([a-z_0-9]+)\s*=\s*\[(.*)\]\s*$/ =~ line
	if $config[$1].is_a? Array
	  $config[$1]=$2.split(/,/)
	else
	  STDERR.print "#{$1} ϻǤޤ\n"
	end
      elsif /^([a-z_0-9]+)\s*=\s*(.*)\s*$/ =~ line
	tmp1=$1
	tmp2=$2.strip
	if  $config[tmp1].is_a? String
	  $config[tmp1] = tmp2
	elsif  $config[tmp1].is_a? TrueClass
	  if tmp2 == 'true'
	    $config[tmp1] = true
	  elsif tmp2 == 'false'
	    $config[tmp1] = false
	  else
	    STDERR.print "#{tmp1} ˤ truefalseꤹɬפޤ\n"
	  end
	elsif !$config[tmp1]
	  $config[tmp1] = tmp2
	else
	  STDERR.print "#{tmp1} ʸϻǤޤ\n"
	end
      end
    end
  }
rescue
end


if $config['colored_text']
  begin
    require 'color_table'

    if COLOR_TABLE[$config['color0'].downcase]
      COLOR_OTHERS = COLOR_TABLE[$config['color0'].downcase]
    else
      STDERR.print "#{$config['color0'].downcase} ȤϸĤޤǤ\n"
      COLOR_OTHERS = COLOR_TABLE['black']
    end
    
    if COLOR_TABLE[$config['color1'].downcase]
      COLOR_CITE_NUMBER = COLOR_TABLE[$config['color1'].downcase]
    else
      STDERR.print "#{$config['color1'].downcase} ȤϸĤޤǤ\n"
      COLOR_CITE_NUMBER = COLOR_TABLE['red']
    end

    if COLOR_TABLE[$config['color2'].downcase]
      COLOR_CITE = COLOR_TABLE[$config['color2'].downcase]
    else
      STDERR.print "#{$config['color2'].downcase} ȤϸĤޤǤ\n"
      COLOR_CITE = COLOR_TABLE['blue']
    end

    if COLOR_TABLE[$config['color3'].downcase]
      COLOR_URL = COLOR_TABLE[$config['color3'].downcase]
    else
      STDERR.print "#{$config['color3'].downcase} ȤϸĤޤǤ\n"
      COLOR_URL = COLOR_TABLE['green']
    end


    #ꤵ줿뤫å
    
  rescue LoadError
#    $config['colored_text']=false
    STDERR.print "color_table.rb򸫤ĤޤǤ.ɸοȤޤ\n"
    COLOR_OTHERS = Gdk::Color.new(0,0,0)
    COLOR_CITE_NUMBER = Gdk::Color.new(65535,0,0)
    COLOR_CITE = Gdk::Color.new(0,0,65535)
    COLOR_URL = Gdk::Color.new(0,32896,0)
  end
end


if $config['hankaku_to_zenkaku']
  NKF_SJIS_TO_EUC = '-eS'
  NKF_TO_EUC = '-e'
  NKF_EUC_TO_SJIS = '-sE'
#  NKF_TO_SJIS = '-s'
else
  NKF_SJIS_TO_EUC = '-exS'
  NKF_TO_EUC = '-ex'
  NKF_EUC_TO_SJIS = '-sxE'
#  NKF_TO_SJIS = '-sx'
end

if $config['background_get']
  if RUBY_RELEASE_DATE >= '2002-01-30'
#  if RUBY_RELEASE_DATE >= '22002-01-30'
    STDERR.print "Хå饦ɤߤߤϼ¸ŪʵǽǤ\nղ\n"

  else
    STDERR.print "Хå饦ɤߤߤ 餯RUBY_RELEASE_DATE\n2002-01-30ʹߤrubyǤʤ˵ǽޤ\n"
    $config['background_get'] = nil
  end
end

$config['user_agent'].gsub!('%v',"#{GORUA_VERSION}")
# connect2ch
$connect2ch_config['proxy_addr']=$config['proxy_addr']
$connect2ch_config['proxy_port']=$config['proxy_port']
$connect2ch_config['http_get_timeout']=$config['http_get_timeout']
$connect2ch_config['user_agent']=  $config['user_agent'] + ' (' +$connect2ch_config['user_agent'] +')'

#Text礭
$text_width = $config['view_width']-32

#ƱƱեؤɤߤߤ򤱤뤿
#mutex,
$mutex_for_get = Mutex.new
$filenames_in_getting = []
$mutex_for_thread = Mutex.new
$num_of_background_threads = 0
# $background_thread=nil
# ޥɥ饤󥪥ץ
getopts("s")


#եȤ
gtkrc = $basedir + "gtkrc"
if File.exist?(gtkrc)
  Gtk::RC.parse(gtkrc)
# Thanks: 餱@kondara 
elsif File.exist?("#{GORUA_DATADIR}/gtkrc")
  Gtk::RC.parse("#{GORUA_DATADIR}/gtkrc")
else
  Gtk::RC.parse_string <<EOS
style "mona_14"
{
  fontset = "-mona-gothic-medium-r-normal--14-*"
}
widget_class "*" style "mona_14"
style "mona_12"
{
  fontset = "-mona-gothic-medium-r-normal--12-*"
}
widget "*NotebookTab*" style "mona_12"
EOS
end

# Textfontι⤵(եȤθ!)
text = Gtk::Text.new
text.set_name "Text"

style = Gtk::RC.get_style(text)

$text_font = style.font

$config['text_font_height'] =  $text_font.string_height("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")





#XPixmap
$batu_xpm = [
"12 12 2 1",
"  c black",
".       c None s None",

"  ........  ",
".  ......  .",
"..  ....  ..",
"...  ..  ...",
"....    ....",
".....  .....",
"....    ....",
"...  ..  ...",
"..  ....  ..",
".  ......  .",
"  ........  ",
"............"

]

# å popup ѿ
$menu_popup = false

# ɽ

$kensaku_kekka = ''

=begin
# w3m-0.2.2-inu-1.1 entity.c
$latin1_eucjp_map =
[
    " ", "!",  "", "", "CUR","", "|",  "",   
    "", "(C)","-a", "", "", "-",  "(R)","",  
    "", "", "^2", "^3", "'",  "", "", "",  
    ",",  "^1", "-o", "", "1/4","1/2","3/4","?",   
    "A`", "A'", "A^", "A~", "A:", "",  "AE","C,",  
    "E`", "E'", "E^", "E", "I`",  "I'", "I^", "I:",  
    "D-", "N~", "O`", "O'", "O^", "O~", "Oe", "",  
    "", "U`", "U'", "U^", "U:", "Y'", "th", "ss",  
    "a`", "a'", "a^", "a~", "a:", "a",  "ae", "c",   
    "e`", "e'", "e^", "e:", "i`", "i'", "i^", "i:",  
    "d-", "n~", "o`", "o'", "o^", "o~", "oe", "",  
    "", "u`", "u'", "u^", "u:", "y'", "th", "y:"   
]


# w3m-0.2.2-inu-1.1 entity.c conv_entity
def unquote_char(num)
  ret = " "
  if num < 0x80
    ret[0] = num 
  elsif num < 0xa0 
    # ϼǻʸˤ뤫...
    ret = " "
  elsif num < 0x100 
    ret = $latin1_eucjp_map[num-0xa0]
  else
    ret = "  "
    # ϼǻʸˤ뤫...
  end
  return ret
end
=end

# http://www.ruby-lang.org/~rubikitch/computer/myruby/replace-char/ ĥ
def replace_char(text)
# ȤꤢٹŪ

  [ 
# դ
    ["\xa1", ''],
    ["\xa2", ''],
    ["\xa3", ''],
    ["\xa4", ''],
    ["\xa5", ''],
    ["\xa6", ''],
    ["\xa7", ''],
    ["\xa8", ''],
    ["\xa9", ''],
    ["\xaa", '10'],
    ["\xab", '11'],
    ["\xac", '12'],
    ["\xad", '13'],
    ["\xae", '14'],
    ["\xaf", '15'],
    ["\xb0", '16'],
    ["\xb1", '17'],
    ["\xb2", '18'],
    ["\xb3", '19'],
    ["\xb4", '20'],
# ޿
    ["\xb5", 'I'],
    ["\xb6", 'II'],
    ["\xb7", 'III'],
    ["\xb8", 'IV'],
    ["\xb9", 'V'],
    ["\xba", 'VI'],
    ["\xbb", 'VII'],
    ["\xbc", 'VIII'],
    ["\xbd", 'IX'],
    ["\xbe", 'X'],
# ñ    
    ["\xc0", 'ߥ'],
    ["\xc1", ''],
    ["\xc2", ''],
    ["\xc3", '-ȥ'],
    ["\xc4", ''],
    ["\xc5", 'ȥ'],
    ["\xc6", '-'],
    ["\xc7", 'إ-'],
    ["\xc8", 'åȥ'],
    ["\xc9", 'å'],
    ["\xca", '-'],
    ["\xcb", 'ɥ'],
    ["\xcc", ''],
    ["\xcd", '-'],
    ["\xce", 'ߥ-ȥ'],
    ["\xcf", '-'],
# ñ
    ["\xd0", 'mm'],
    ["\xd1", 'cm'],
    ["\xd2", 'km'],
    ["\xd3", 'mg'],
    ["\xd4", 'kg'],
    ["\xd5", 'cc'],
    ["\xd6", 'm^2'],
    
    ["\xdf", 'ʿ'],
# ¾
    ["\xe0", '``'],
    ["\xe1", ',,'],
    ["\xe2", 'No'],
    ["\xe3", 'KK'],
    ["\xe4", 'Tel'],
    ["\xe5", ''],
    ["\xe6", ''],
    ["\xe7", ''],
    ["\xe8", ''],
    ["\xe9", ''],
    ["\xea", '()'],
    ["\xeb", '(ͭ)'],
    ["\xec", '()'],
    ["\xed", ''],
    ["\xee", ''],
    ["\xef", ''],
    ["\xf0", ''],
    ["\xf1", ''],
    ["\xf2", ''],
    ["\xf3", ''], #Ȳ.. ɽǤʤ...
    ["\xf4", ''],
    ["\xf5", ''],
    ["\xf6", ''],
    ["\xf7", ''],
    ["\xf8", ''],
    ["\xf9", ''],
    ["\xfa", ''],
    ["\xfb", ''],
    ["\xfc", ''],
  ].each do |a, b|
    text.gsub!(/#{"\xad"+a}/, b)
  end

  return text
end

#¿ʴؿ
def unquote(str)
  if str 
  #ȴ
    str.gsub! "&gt;", ">"
    str.gsub! "&lt;", "<"
    str.gsub! "&nbsp;", " "
    str.gsub! "&quot;", "\""

#ΤѤAAʤɤ?
#    str.gsub! "&reg;","\$"
#    str.gsub! "&copy;","@"
#    str.gsub! "&shy;","-"

#uuencodeƤΤʤɤʤǽ
#toggleǤ褦ˤ
#    str = str.gsub(/&#(\d+);/){ |s|
#      unquote_char($1.to_i)
#    }

#    str = str.gsub (/&#x([\da-fA-F]+);/){
#      unquote_char($1.hex)
#    }

#ɤϤƤʤ?
#    str.gsub! "&amp;", "&"
#ʤäƤΤ.....
#    str.gsub! "&amp", "&"

  end
  return str
end


# bookmarksե
def write_bookmarks(array,filename)

  open(filename,'w') { |file|
    str = ""
    array.each{|e|
      if e.is_a? String
	# ƥ꡼ȥ
#	str += "C #{e}\n"
	str += "#{e}\n"
      elsif e.is_a? Board2ch
	if e.get_special
	  str += "D #{e.get_title}\n"
	  e.get_thread_array.each { |thread|
	    if thread.get_dat 
	      str +=  "S #{thread.get_url} #{thread.get_title}\n"
	    else
	      str += "T #{thread.get_url} #{thread.get_title}\n"	
	    end
	  }

	elsif e.get_dat
	  str += "A #{e.get_url} #{e.get_title}\n"
	else
	  str += "B #{e.get_url} #{e.get_title}\n"
	end
#      elsif e.is_a? Thread2ch
#	if e.get_dat 
#	  str += "S #{e.get_url} #{e.get_title}\n"
#	else
#	  str += "T #{e.get_url} #{e.get_title}\n"	
#	end
      end
    }
    file.print NKF::nkf(NKF_EUC_TO_SJIS,str)
  }

end


#TextǱåݤ˽Ф˥塼Item
class UrlMenuItem < Gtk::MenuItem
  def initialize(text)
    @url = text
#2Ť˽뤳ȤˤʤΤǡޤ
#
    @text=nil
    host,port,path=parse_http_url(text)

    if host
# offlaw.cgi ǧھɬפˤʤä
#      if /\.(2ch|bbspink)\./=~ host  && %r!/test/(read|offlaw)\.cgi! =~ path
      if /\.(2ch|bbspink)\./=~ host  && %r!/test/read\.cgi! =~ path

	# Thanks: >>66
	@text = "goRuaǽ: " +text
      else
	@text = "֥饦ǽ: " +text
      end
    else
      @text = text
    end
    
    super @text
    self.set_name "UrlMenuItem"
    
    self.signal_connect('button_press_event'){|w,e|
      $vvbox.exec_entry_text(@url)
    }

  end

end

# ȯ1åȤޤե졼
class MessageFrame < Gtk::Frame
  def initialize(num,name,mailto,date_id,body)
    super "#{num}"
    self.set_label_align(0, 0)
    self.border_width(1)

    url = []

    table = Gtk::Table.new(2,2,false)
    self.add table
    name.gsub!("<.+?>","")
    name=unquote(name)

    # mailto ʤ Buttonˤtooltipsդ
    if mailto && mailto != "" 
      mailto.gsub!("<.+?>","")
      mailto=unquote(mailto)
      name_label = Gtk::Button.new(name)
      tooltips = Gtk::Tooltips::new()
      tooltips.set_tip(name_label,mailto,"")
      name_label.set_name "NameLabel"
    else
      name_label = Gtk::Label.new(name)
      name_label.set_name "NameLabel"
    end

    table.attach name_label,0,1,0,1,0,0

    date_id_label =  Gtk::Label.new(date_id)
    date_id_label.set_name "DateIdLabel"

    table.attach date_id_label,1,2,0,1,0,0

    if body
      lines  = body.split("<br>")
      text = Gtk::Text.new
      text.set_name "Text"

      text.set_word_wrap false
      table.attach text,0,2,1,2,nil,0
      
      tmp = lines.size+1
      
      lines.each { |tmp_line|
	
	tmp_line.sub!("\s+$","")
	# Ƭ˶򤬤ϤäƤΤ
	tmp_line.sub!("^ ","") 
	
	tmp_line.gsub!("<.*?>","")
	tmp_line=unquote(tmp_line)	    

# ŬˤäԤʤȤդ
	tmp+=$text_font.string_width(tmp_line)/ ($text_width-20)


	tmp_line_bak = tmp_line.dup

# ˥塼Ѿ
	while true
 	  if /^(.*?)(h?ttp:[a-zA-Z0-9%&\?\/\;\:\@\&\=\+\$\,\-\_\.\!\~\*\'\\(\)\#]+)\s?(.*)$/ =~ tmp_line
	    host,port,path=parse_http_url($2)
	    if host
	      url << $2
	    end
	    tmp_line = $1 +" " + $3
	  elsif />>(\d+-\d+)(.*)$/ =~ tmp_line
 	    url << $1	      
	    tmp_line = $2
	  elsif />>(\d+-)(.*)$/ =~ tmp_line
 	    url << $1	      
	    tmp_line = $2
	  elsif />>(\d+)(.*)$/ =~ tmp_line
 	    url << $1	      
	    tmp_line = $2
	  else
	    break
	  end
	end

	tmp_line = tmp_line_bak

# ʸ
#	M.Suzuki
	if $config['colored_text']
	  if /^(>)/ =~ tmp_line		# 
	    #	  if /^(>+\d+)/ =~ tmp_line	# 쥹
	    if /^(>+[\d\-]+)/ =~ tmp_line	# 쥹
	    #	    text.insert nil,TEXT_COLOR[3],nil, $1
	      text.insert nil,COLOR_CITE_NUMBER,nil, $1
	      tmp_line = $'
	    else
	      text.insert nil,COLOR_CITE,nil, tmp_line
	      tmp_line = ''
	    end
	  end

	  if /^(.*?)(h?ttp:[a-zA-Z0-9%&\?\/\;\:\@\&\=\+\$\,\-\_\.\!\~\*\'\\(\)\#]+)\s?(.*)$/ =~ tmp_line	# url
#	    text.insert nil,nil,nil, $1
	    text.insert nil,COLOR_OTHERS,nil, $1
	    text.insert nil,COLOR_URL,nil, $2
	    tmp_line = $'
	  end
	  text.insert nil,COLOR_OTHERS,nil, tmp_line + "\n"
	else
	  text.insert nil,nil,nil, tmp_line + "\n"
	end
      }
      
      text.set_usize $text_width,tmp*$config['text_font_height']

# ˥塼
      text.signal_connect('button_press_event'){|w,e|
	if e.instance_of?(Gdk::EventButton) &&  e.button==3
	  $menu_popup = true
	  menu = Gtk::Menu.new
	  menu.signal_connect('button_press_event'){
	    menu.popdown
	  }

	  item = Gtk::MenuItem.new('Menu')
	  menu.append item
	  separator = Gtk::MenuItem.new()
	  menu.append separator

	  url.each{ |text|
	    item = UrlMenuItem.new(text)
	    menu.append item
	  }
	  menu.popup(nil, nil, nil, e.button, e.time)
	  menu.show_all
	end
      }
      

    end

# Ȥ
=begin
    @name = name
    @mailto= mailto
    @date_id=date_id
    @body=body
=end
  end

end

# Window
class PostWindow < Gtk::Window
  include PostMessage2ch

  def initialize(thread)
    super Gtk::WINDOW_TOPLEVEL
    @thread = thread
    title = @thread.get_title
    self.set_title('񤭤: ' + title)
    self.set_position(Gtk::WIN_POS_CENTER)
    self.set_transient_for($main_window)

    vbox = Gtk::VBox.new false,0
    
    title_label = Gtk::Label.new(title + ' ؤν񤭤')
    vbox.pack_start title_label,false,false

    table = Gtk::Table.new(2,2,false)
    name_label = Gtk::Label.new('̾:')
    @name_combo = Gtk::Combo.new
    @name_combo.entry.set_editable(true)
    @name_combo.set_popdown_strings($config['post_name_candidate'])

    table.attach name_label,0,1,0,1,0,0
    table.attach @name_combo,1,2,0,1

    mailto_label = Gtk::Label.new('mailto:')
    @mailto_combo = Gtk::Combo.new
    @mailto_combo.entry.set_editable(true)
    @mailto_combo.set_popdown_strings($config['post_mailto_candidate'])
    table.attach mailto_label,0,1,1,2,0,0
    table.attach @mailto_combo,1,2,1,2
    vbox.pack_start table,false,false

    @message = Gtk::Text.new
    @message.set_name "PostText"
    @message.set_editable(true)
    vbox.pack_start @message

    self.add vbox

    hbox = Gtk::HBox.new false,10
    #񤭤ܥ
    kakikomu_button = Gtk::Button.new('񤭤')
    #󥻥ܥ
    cancel_button = Gtk::Button.new('󥻥')
    
    hbox.pack_start kakikomu_button
    hbox.pack_start cancel_button
    vbox.pack_start hbox,false,false
    self.set_usize $config['post_width'], $config['post_height']
    self.show_all

    cancel_button.signal_connect('clicked'){
      self.hide
    }

    kakikomu_button.signal_connect('clicked'){
      name = @name_combo.entry.get_text
      mailto = @mailto_combo.entry.get_text
      message=@message.get_chars(0,@message.get_length)
      if post_message(thread,name,mailto,message)
	$vvbox.push_entry_text('񤭤')
	self.hide
      else
	$vvbox.push_entry_text('񤭤߼')
      #Ԥݤɤ뤫
      end
    }

  end
end

#ThreadƤɽVBox
class ViewThreadVBox < Gtk::VBox

  def initialize(thread)
    @sw=nil
    super false,0

    @start = 1
    @view_num = 100
    @size = 0
    @thread = thread
    @file = @thread.get_file
    self.show

    self.signal_connect_after('button_press_event'){|w,e|
      if e.instance_of?(Gdk::EventButton) &&  e.button==3
	if $menu_popup
	  $menu_popup=false
	  break
	end

	menu = Gtk::Menu.new
	menu.signal_connect('button_press_event'){
	  menu.popdown
	}
	item = Gtk::MenuItem.new('Menu')
	menu.append item

	separator = Gtk::MenuItem.new()
	menu.append separator

	prev_item = Gtk::MenuItem.new('Prev')
	menu.append prev_item
	if @start > 1
	  prev_item.set_sensitive true
	else
	  prev_item.set_sensitive false
	end
	next_item = Gtk::MenuItem.new('Next')
	menu.append next_item
	if @start+@view_num-1 < @size
	  next_item.set_sensitive true
	else
	  next_item.set_sensitive false
	end
	menu.popup(nil, nil, nil, e.button, e.time)
	menu.show_all
	
	prev_item.signal_connect('button_press_event'){
	  self.set_start(@start-@view_num)
	  $vvbox.set_notebook_page
	}
	  
	next_item.signal_connect('button_press_event'){
	  self.set_start(@start+@view_num)
	  $vvbox.set_notebook_page
	}
	
      end
    }
  end

# ThreadΤɤƤ뤫
  def get_start
    return @start 
  end

# ThreadΥ쥹򲿸ıƤ뤫
  def get_view_num
    return @view_num 
  end

# ThreadΤΥ
  def get_size
    return @size 
  end

# ThreadαϾΥå
  def set_start(num)
    if num>0
      @start = num
    else
      @start =1
    end
  end

# ThreadΥ쥹αĿΥå
  def set_view_num(num)
    @view_num   = num
  end

# Υå
  def set_size(num)
    @size  = num
  end

# ScrollWindowΥå
  def set_sw(sw)
    if @sw
      self.remove @sw
    end
    @sw  = sw
    self.pack_start @sw
  end

  def get_sw
    return @sw
  end

  def get_thread
    return @thread
  end

  #ThreadƤparseɽ
  def make_view  
    $vvbox.push_entry_text('')
    
    @file.rewind
    vbox_view = Gtk::VBox.new(false,0)
    if @view_num <= 0
      return
    end
    

    tmp = self.get_thread.get_title 


    if  tmp ==nil || tmp== ""
# åɤΥȥ뤬狼ʤ
# ȥ򥻥å
      while line=@file.gets
	line.strip!	
	begin
	  line=NKF::nkf(NKF_SJIS_TO_EUC,line)
	  if /^(?:\+OK|-INCR)\s+(\d+)/ =~ line
	    next
	  end
	  (name,mailto,date_id,body,title)=line.split(/<>/)
	  if title && title !=""
	    self.get_thread.set_title(title)
	    tmp = title+ " (#{self.get_size})"
	    self.get_thread.set_title_and_size(tmp)
	    $vvbox.set_title(tmp)
	    hbox = $vvbox.create_tab_label(title,self)
	    notebook = $vvbox.get_notebook
	    notebook.set_tab_label(self,hbox)
	    notebook.set_menu_label(self,Gtk::Label.new(title))
	    $vvbox.show_all
	    $vvbox.write_sessions
	  end
	  break
	rescue
	end
      end
    end
    @file.rewind

# Thread

    i=1 # ߤΥ쥹ֹ
    j=0 # 褷쥹ο

    while line=@file.gets
      begin            
	line=NKF::nkf(NKF_SJIS_TO_EUC,line)
	line.strip!	
	if /^(?:\+OK|-INCR)\s+(\d+)/ =~ line
	  next
	end
	
	if i< @start
	  i+=1
	  next
	end

	line = replace_char(line)
	(name,mailto,date_id,body,title)=line.split(/<>/)
	
	frame = MessageFrame::new(i,name,mailto,date_id,body)
	vbox_view.pack_start frame,false,false

      rescue
      end
      j+=1
      i+=1
#	M.Suzuki
      while Gtk.events_pending
	if  $num_of_background_threads == 0
	  Gtk.main_iteration
	end
      end
      if j>=@view_num
	break
      end
    end

    # ɽΥܥ
    hbox = Gtk::HBox.new false,10
    one_button = Gtk::Button.new('1-')
    prev_button = Gtk::Button.new('Prev')
    next_button = Gtk::Button.new('Next')
    new_button = Gtk::Button.new('ǿ')

    reload_button = Gtk::Button.new('ɹ')

    hbox.pack_start one_button
    hbox.pack_start prev_button
    hbox.pack_start next_button
    hbox.pack_start new_button
    hbox.pack_start reload_button

    if @start > 1
      one_button.set_sensitive true
      prev_button.set_sensitive true
    else
      one_button.set_sensitive false
      prev_button.set_sensitive false
    end

    if @start+@view_num-1 < @size
      next_button.set_sensitive true
    else
      next_button.set_sensitive false
    end

    if @view_num < @size
      new_button.set_sensitive true
    else
      new_button.set_sensitive false
    end

    # activate_ۥ Ȥ̾ɤʤΤǤΤѹ뤳
    one_button.signal_connect('clicked'){
#      $vvbox.activate_one_item
#      self.set_start(1)
#      self.remake_view
      self.activate_one_item
    }
    prev_button.signal_connect('clicked'){
#      $vvbox.activate_prev_item
#      self.set_start(self.get_start-self.get_view_num)
#      self.remake_view      
      self.activate_prev_item
    }

    next_button.signal_connect('clicked'){
#      $vvbox.activate_next_item
#      self.set_start(self.get_start+self.get_view_num)
#      self.remake_view      
      self.activate_next_item
    }


    new_button.signal_connect('clicked'){
#      $vvbox.activate_new_item
#      self.set_start(self.get_size-self.get_view_num+1)
#      self.remake_view
      self.activate_new_item
    }
      
    reload_button.signal_connect('clicked'){
#      $vvbox.activate_reload_item
=begin
      tmp = self.get_thread.load_file
      self.set_file(tmp,self.get_thread.get_file)
      tmp = self.get_thread.get_title  + " (#{self.get_size})"
      $vvbox.set_title(tmp)
      $vvbox.set_notebook_page
=end
      self.activate_reload_item
    }

    vbox_view.pack_start hbox,false,false

    @sw.add_with_viewport vbox_view
    @sw.show_all
    $vvbox.pop_entry_text    
  end

  def activate_one_item
    self.set_start(1)
    self.remake_view
  end

  def activate_prev_item
    self.set_start(self.get_start-self.get_view_num)
    self.remake_view      

  end

  def activate_next_item
    self.set_start(self.get_start+self.get_view_num)
    self.remake_view      
  end

  def activate_new_item
    self.set_start(self.get_size-self.get_view_num+1)
    self.remake_view
  end

  def activate_reload_item
    pre_size=nil
    if $config['background_get']
      $mutex_for_thread.lock
      $num_of_background_threads +=1
      $mutex_for_thread.unlock
      thread=Thread.start{
	pre_size=@thread.load_file
	$mutex_for_thread.lock
	$num_of_background_threads -=1
	$mutex_for_thread.unlock
      }
      while thread.alive?
	sleep 0.05
	#	  Gtk.main_iteration()
      end
    else
      pre_size = self.get_thread.load_file
    end
    if pre_size
      self.set_file(pre_size,self.get_thread.get_file)
      tmp = self.get_thread.get_title  + " (#{self.get_size})"
      $vvbox.set_title(tmp)
      $vvbox.set_notebook_page
    end
  end

  def remake_view
    sw = Gtk::ScrolledWindow.new(nil,nil)
    self.set_sw(sw)
    self.set_file
    self.make_view
    $vvbox.set_item
  end

  def set_file(start=nil,file=nil)

    if file
      @file =file
    end

    @file.rewind
    @size=0

    while line=@file.gets
      line=NKF::nkf(NKF_SJIS_TO_EUC,line)
      if /^(?:\+OK|-INCR)\s+(\d+)/ =~ line
	next
      end
      @size+=1
    end

    if start
      self.set_start(start)
    end

    @file.rewind
  end
end



#ThreadƤ򸫤Box
class ViewVBox < Gtk::VBox


  def initialize()
    super(false,0)
    @v_thread=nil
    
    @sessions=[]
   
    #˥塼  Item
    @mbar = Gtk::MenuBar.new
    @file_item = Gtk::MenuItem.new('File')
    @file_menu = Gtk::Menu.new

#Thanks: >> 63
    @toziru_item = Gtk::MenuItem.new('Ĥ')
    @file_menu.add @toziru_item

    @quit_item = Gtk::MenuItem.new('Quit')
    @file_menu.add @quit_item
    @file_item.set_submenu @file_menu
    @mbar.append @file_item

    @one_item = Gtk::MenuItem.new('1-')
    @mbar.append @one_item

    
    @prev_item = Gtk::MenuItem.new('Prev')
    @mbar.append @prev_item
    @next_item = Gtk::MenuItem.new('Next')
    @mbar.append @next_item

    @new_item = Gtk::MenuItem.new('ǿ')
    @mbar.append @new_item

    @reload_item = Gtk::MenuItem.new('ɹ')
    @mbar.append @reload_item

    @url_item = Gtk::MenuItem.new('URLɽ')
    @mbar.append @url_item

    @check_new_item = Gtk::CheckMenuItem.new('   ɽ')
    if !$config['show_old_message']
      @check_new_item.activate
    end
    @mbar.append @check_new_item

    @bookmark_item = Gtk::MenuItem.new('֥åޡɲ')
    @mbar.append @bookmark_item

    @kakikomi_item = Gtk::MenuItem.new('񤭤')
    @mbar.append @kakikomi_item

    self.pack_start @mbar, false, false, 0

    @title_label = Gtk::Label.new('')
    @title_label.set_name "TitleLabel"

    self.pack_start @title_label,false,false,0

    @entry = Gtk::Entry.new
    self.pack_start @entry,false,false,0
    @entry.set_editable(true)
    
    @entry_text_stack = []

    # Ρȥ֥å
    @notebook = Gtk::Notebook::new()
    @notebook.set_usize $config['view_width'], $config['height']
    @notebook.set_scrollable(true)
    @notebook.popup_enable

    if !$error_of_switch_page
      # 0.27 0.28(4/19snapshot) Ǥ switch_page signal connect
      # 
      # http://sourceforge.net/tracker/?func=detail&atid=415644&aid=534381&group_id=35786
      @notebook.signal_connect("switch_page") { |widget, page, num_page|
	if ! $init
	  self.page_switch(widget, page, num_page)
	end
      }
    end

    self.pack_start @notebook

    # item

    self.set_item

    @url_item.signal_connect('activate'){
      if @v_thread
	@entry.set_text @v_thread.get_thread.get_url
      end
    }


    @quit_item.signal_connect('activate'){
      exit
    }

    @next_item.signal_connect('activate'){
      self.activate_next_item
    }

    @one_item.signal_connect('activate'){
      self.activate_one_item
    }



    @prev_item.signal_connect('activate'){
      self.activate_prev_item
    }

    @new_item.signal_connect('activate'){
      self.activate_new_item
    }

    @reload_item.signal_connect('activate'){
      self.activate_reload_item
    }

    @bookmark_item.signal_connect('activate'){
      if @v_thread
	title=NKF::nkf(NKF_EUC_TO_SJIS,@v_thread.get_thread.get_title)
	url = @v_thread.get_thread.get_url

	if $bookmarks_board 
	  @v_thread.get_thread.set_special($bookmarks_board)
	  $bookmarks_board.append_thread @v_thread.get_thread
	  $bookmarks_board.get_item.set_bookmarks_item
	  write_bookmarks($bookmarks_array,$bookmarks)
	end
      end 
    }

    @kakikomi_item.signal_connect('activate'){
      if @v_thread
	window = PostWindow.new(@v_thread.get_thread)
      end
    }

    @toziru_item.signal_connect('activate'){
      while @v_thread
	@notebook.remove_page(@notebook.page_num(@v_thread))
	if @notebook.get_current_page == -1
	  @v_thread= nil
	else
	  @v_thread=@notebook.cur_page.child
	end
      end
      @sessions = []
      self.write_sessions
      self.set_item
    }



    @entry.signal_connect('activate') {|widget|
      text = @entry.get_text
      text.strip!
      exec_entry_text(text)
    }
  end


  def activate_reload_item
    unless @v_thread
      return
    end
    @v_thread.activate_reload_item
  end

  def activate_one_item
    unless @v_thread 
      return
    end
    @v_thread.activate_one_item
  end

  def activate_new_item
    unless @v_thread
      return
    end
    @v_thread.activate_new_item
  end

  def activate_prev_item
    unless @v_thread
      return
    end
    @v_thread.activate_prev_item
  end

  def activate_next_item
    unless @v_thread
      return
    end
    @v_thread.activate_next_item
  end


  # entryΥƥȤ(UrlMenuItemǤ)
  def exec_entry_text(text)
    if text == "" || !text 
      return
    end

    host,port,path=parse_http_url(text)

    if host
      if /^ttp/ =~ text
	text = "h" +text
      end

      internal=false
      catch(:tag) do
	if /\.(2ch|bbspink)\./=~ host 
	  if %r!^(.*/test/read\.cgi/.+?/[0-9]+?/).*! =~ text
	    text = $1
	    
	  elsif %r!^(.*/test/read\.cgi)\?(.*)! =~ text
	    base = $1
	    tmp = $3
	    if /bbs=([^&]+)&.*key=([^&]+)/i =~ tmp
	      bbs = $1
	      key = $2
	    elsif  /key=([^&]+)&.*bbs=([^&]+)/i =~ tmp
	      bbs = $2
	      key = $1
	    else
	      throw :tag
	    end
	    text = base+"/"+bbs+"/"+key+"/"
	  else
	    throw :tag
	  end
	  internal=true
	  thread = Thread2ch.new("",text,nil,false)
	  pre_size=thread.load_file
	  if pre_size
	    if thread.get_file
	      $vvbox.set_thread(thread,pre_size)
	    end
	  end
	end
      end
      if !internal
	fork do
	  $SAFE = 2
	  if $config['http_command']
	    tmp =$config['http_command'].dup
	    text.gsub!(/\'/,'\\\'')
	    tmp.sub!('%u','\''+text+'\'')
	    tmp.untaint
	    exec(tmp)
	  end
	end
      end
    end

    unless @v_thread
      return
    end
    
    text.sub!(">>","")
    text.strip!
    _size=@v_thread.get_size
      
    if text =~ /^(\d+)$/
      start = Integer($1)
      if start <= _size && start > 0
	@v_thread.set_start(start)
	@v_thread.set_view_num(1)
	self.set_notebook_page
      end
    elsif text =~ /^(\d+)\s*-$/
      start = Integer($1)
      if start < _size && start > 0
	@v_thread.set_start(start)	  
      end
      self.set_notebook_page
    elsif text =~ /^(\d+)\s*-\s*(\d+)$/
      start = Integer($1)
      stop = Integer($2)
      view_num = stop - start + 1
      if start <= _size && start > 0 && view_num > 0
	@v_thread.set_start(start)
	@v_thread.set_view_num(view_num)  
	self.set_notebook_page
      end
    end

  end

  def get_check_new_item
    return @check_new_item 
  end

  def push_entry_text(text)
    @entry_text_stack.push(@entry.get_text)
    @entry.set_text(text)
    if $display_status_iterationp && !$config['background_get']
      while Gtk.main_iteration()
      end
    end 

  end 

  def pop_entry_text
    text=@entry_text_stack.pop
    @entry.set_text(text)
  end 

  
  def set_thread(thread,start)
    sw = Gtk::ScrolledWindow.new(nil,nil)
    @v_thread = ViewThreadVBox.new(thread)
    @v_thread.set_sw(sw)
    @v_thread.set_file(start)
    self.set_notebook_page
  end

  def get_notebook
    return @notebook
  end

  # ΡȤΥڡ
  def set_notebook_page

    self.set_item

    tmp =@notebook.page_num(@v_thread)
    if tmp == -1
      tmp = @v_thread.get_thread.get_title + " (#{@v_thread.get_size})"
      hbox =create_tab_label(tmp,@v_thread)
      hbox.show_all

      @v_thread.make_view

      if  !@notebook.cur_page 
	self.set_title(@v_thread.get_thread.get_title+ " (#{@v_thread.get_size})")
	self.set_item
      end


      @notebook.append_page_menu(@v_thread,hbox,Gtk::Label.new(tmp))


      if ! $init && $config['set_last_page']
	@notebook.set_page(-1)
	if !$error_of_switch_page
	  self.set_title(@v_thread.get_thread.get_title+ " (#{@v_thread.get_size})")
	  self.set_item
	end
      end

      @sessions <<  @v_thread.get_thread
      self.write_sessions
    else
      sw = Gtk::ScrolledWindow.new(nil,nil)
      @v_thread.set_sw(sw)
      @v_thread.set_file
      @v_thread.make_view
    end
  end
=begin
  def set_page_switch(boolean)
    @flag_page_switch = boolean
  end
=end
# sessions եν񤭤
  def write_sessions
    open($sessions,'w') { |file|
      str=""
      @sessions.each{ |thread|
	if thread.get_dat 
	  str +=  "S #{thread.get_url} #{thread.get_title}\n"
	else
	  str += "T #{thread.get_url} #{thread.get_title}\n"	
	end
      }
      file.print NKF::nkf(NKF_EUC_TO_SJIS,str)

    }
  end 


#  餯Ȥʤʤ
  def append_str_to_file(str,filename)
    open(filename,'a') { |file|
      file.print "#{str}\n"
    }
  end 

    
# notebookΥ֤Υ٥κ
  def create_tab_label(str,v_thread)
    hbox = Gtk::HBox.new false,5
#    trunc = trunc_string(str,$title_string_trunc)
    trunc = trunc_string(str,$config['tab_string_size'])
    label = Gtk::Label.new(trunc)
    label.set_name "NotebookTab"
    hbox.pack_start label
    button = Gtk::Button.new
    button.add Gtk::Pixmap.new($batu_pix, $batu_mask)
    button.signal_connect('clicked'){
      @notebook.remove_page(@notebook.page_num(v_thread))
      @sessions.delete(v_thread.get_thread)
      self.write_sessions
      if @notebook.get_current_page == -1
	@v_thread= nil
      else
	@v_thread=@notebook.cur_page.child
      end
      self.set_item
    }
      

    hbox.pack_start button,false,false
    hbox.show_all
    return hbox
  end


#˽Ф?
  def trunc_string(str,trunc)

     if  /^(.{1,#{trunc}}).*$/ =~ str
       return $1
     else
       return str
     end
  end

#notobookΥڡäȤν
  def page_switch(widget, page, page_num)
    oldpage = @notebook.cur_page
    if (page == oldpage)
      return
    end

    @v_thread=page.child
    self.set_title(@v_thread.get_thread.get_title+ " (#{@v_thread.get_size})")
    self.set_item
  end


  def set_title(title)
    @title_label.set title
  end

  def get_new_item
    return @new_item
  end

  def get_one_item
    return @one_item
  end

  def get_prev_item
    return @prev_item
  end

  def get_next_item
    return @next_item
  end


# menu_item
  def set_item
    unless @v_thread
      @one_item.set_sensitive false
      @prev_item.set_sensitive false
      @next_item.set_sensitive false
      @new_item.set_sensitive false
      @reload_item.set_sensitive false
      @url_item.set_sensitive false
      @bookmark_item.set_sensitive false
      @kakikomi_item.set_sensitive false
      @toziru_item.set_sensitive false
      return
    end

    @reload_item.set_sensitive true
    @url_item.set_sensitive true
    @bookmark_item.set_sensitive true
    @kakikomi_item.set_sensitive true
    @toziru_item.set_sensitive true

    start= @v_thread.get_start
    view_num=@v_thread.get_view_num
    size=@v_thread.get_size

    if start > 1
      @one_item.set_sensitive true
      @prev_item.set_sensitive true
    else
      @one_item.set_sensitive false
      @prev_item.set_sensitive false
    end

    if view_num < size
      @new_item.set_sensitive true
    else
      @new_item.set_sensitive false
    end

    if start+view_num-1 < size
      @next_item.set_sensitive true
    else
      @next_item.set_sensitive false
    end
  end

  def set_start (start)

    view_num=@v_thread.get_view_num
    size=@v_thread.get_size

    if  start < @size
      if start+@view_num < 1
	@v_thread.set_start(1)
      else
	@v_thread.set_start(start)
      end
    end
  end

  def set_view_num(num)
    if num > 0
      @v_thread.set_view_num( num)
    end
  end

end 

#åɤ
class Thread2ch
  include GetThread2ch

  def initialize(title,url_base,dat_file,dat,special=false)
    title = replace_char(title)
    @special = special
    @title_and_size = title
    if @special
      @title = title
    else
      @title = title.gsub(/\s+\(\d+\)\s*$/,"")
    end
    @dat = dat
    @bbs = nil
    @key = nil
    @base_path = nil
    if dat_file
      if @dat
	@url = url_base + dat_file
      else
	@url = url_base + dat_file.sub("\.dat$","")+"/"
      end
    else
      url_base.strip!
      @url = url_base
    end



    @file= nil
    @size= 0
    @num_of_statement= 0

    @host,@port,@path = parse_http_url(@url)
    if @host
      @filename = $basedir + "thread/"+ @host + "_" + "#{@port}" + "_" + @path.gsub("/","_")
    # initializeΰ鸫ľ
    # 
      if %r!^(/.*)/(.+?)/(.+?)/?$! =~ @path
	tmp = $1
	@bbs = $2
	@key = $3.sub("\.dat$","")
	@base_path = tmp.sub("test/read\.cgi$","")
      else
	STDERR.print "URL: #{@url}\n"
      end
    else
      @filename =nil
      STDERR.print "бƤURLǤϤޤ: #{@url}\n"
    end

  end

  def get_special
    return @special
  end

  def set_special(special)
    @special = special
  end



  def get_bbs
    return @bbs
  end

  def get_key
    return @key
  end

  def get_base_path
    return @base_path
  end

  def set_title(title)
    @title = title
  end


  def get_title
    return @title
  end

  def set_title_and_size(title)
    @title_and_size = title
  end


  def get_title_and_size
    return @title_and_size
  end

  def get_dat
    return @dat
  end


  def get_url
    return @url
  end

  def get_host
    return @host
  end
  def get_port
    return @port
  end
  def get_path
    return @path
  end
  def get_filename
    return @filename
  end


  def get_file
    return @file
  end

  def load_file

    if $filenames_in_getting.include?(self.get_filename)
      STDERR.print "Ʊե #{self.get_filename} ɤߤǤޤ\nThreadɹߤޤ.\n"
      return nil
    end

    $vvbox.push_entry_text('Threadɹ')
#	M.Suzuki	Gtk-0.27ʹߤ餷
#	$main_window.window.set_cursor(Gdk::Cursor.new(Gdk::WATCH))
    $mutex_for_get.lock
    $filenames_in_getting << self.get_filename
    $mutex_for_get.unlock
    @file,pre_size = get_thread_file(self)
    $mutex_for_get.lock
    $filenames_in_getting.delete(self.get_filename)
    $mutex_for_get.unlock
#	M.Suzuki	Gtk-0.27ʹߤ餷
#	$main_window.window.set_cursor(Gdk::Cursor.new(Gdk::ARROW))
    
    if !pre_size || pre_size==0 
      size=1
    end
    $vvbox.pop_entry_text
    if $vvbox.get_check_new_item.active?
      return pre_size
    end 
    return 1
  end

  def set_size(size)
    @size = size
  end

  def get_size
    return @size 
  end


  def set_num_of_statement(num)
    @num_of_statement = num
  end

  def get_num_of_statement
    return @num_of_statement
  end

end

#Ĥ
class Board2ch
  include GetBoardSubject2ch

  def initialize(title,url,dat,special=false)
    @title = title
    @url = url
    @host,@port,@path = parse_http_url(@url)
    @special=special
    if @host
      @filename = $basedir + "subject/"+ @host + "_" + "#{@port}" + "_" + @path.gsub("/","_")
    else
      @filename =nil
      if @special ==false
	STDERR.print "бƤURLǤϤޤ: #{@url}\n"
      end 
    end
      
    @dat = dat

    @thread_array=[]
    @item = nil
  end

  def get_item
    return @item
  end

  def set_item(item)
    @item = item
  end

  def get_special
    return @special
  end

  def append_thread(thread)
    @thread_array << thread
  end

  def delete_thread(thread)
    @thread_array.delete(thread)
  end


  def get_thread_array
    return @thread_array
  end

  def set_filename(filename)
    @filename = filename
  end

  def get_title
    return @title
  end

  def get_url
    return @url
  end

  def get_host
    return @host
  end
  def get_port
    return @port
  end
  def get_path
    return @path
  end
  def get_filename
    return @filename
  end

  def get_dat
    return @dat
  end

end

#ѤTreeItem
class BoardTreeItem < Gtk::TreeItem

  def initialize(board)
    @board=board    
    super(@board.get_title)
    self.set_name "BoardTreeItem"
    @num_of_thread=0
    @subtree=nil
    @special = @board.get_special

    @board.set_item self
    self.signal_connect('select') { 
      if @special
      else
	if $config['background_get']
	  $mutex_for_thread.lock
	  if !$svbox.sensitive?
	    $mutex_for_thread.unlock
	    break
	  end
	  $svbox.set_sensitive false
	  $num_of_background_threads +=1
	  $mutex_for_thread.unlock
#	  $display_status_iterationp = false
	  thread=Thread.start{
	    self.get_board_subject
	    $mutex_for_thread.lock
	    $num_of_background_threads -=1
	    $svbox.set_sensitive true
	    $mutex_for_thread.unlock
	  }
	  while thread.alive?
	    sleep 0.05
#	    Gtk.main_iteration()
	  end
#	  $display_status_iterationp = true

	else
	  self.get_board_subject
	end
      end
      self.expand
    }
    @destroyed=false
    self.signal_connect('destroy'){
      @destroyed=true
    }
  end



  def set_bookmarks_item
    if @destroyed
      return
    end

    array = @board.get_thread_array
    if array  != [] 
      subtree = Gtk::Tree.new
      self.set_subtree subtree
      i=0
      array.each{ |thread|
	thread_item = Gtk::ThreadTreeItem.new(thread,self)
	subtree.append thread_item
	thread_item.show_all
	i+=1
      }
      self.set_num_of_thread(i)
    end 
    self.show_all
    self.expand
  end

  def get_board_subject
    
    if $filenames_in_getting.include?(@board.get_filename)
      STDERR.print "Ʊե #{@board.get_filename} ɤߤǤޤ\nSubjectɹߤޤ.\n"
      return
    end
    $vvbox.push_entry_text('Subjectɹ')
    $mutex_for_get.lock
    $filenames_in_getting << @board.get_filename
    $mutex_for_get.unlock
    file = @board.get_board_subject_file(@board)
    $mutex_for_get.lock
    $filenames_in_getting.delete(@board.get_filename)
    $mutex_for_get.unlock

    unless file
      return
    end
    
    file.rewind

    subtree = Gtk::Tree.new



    if @board.get_port == 80
      url = "http://" + @board.get_host 
    else
      url = "http://" + @board.get_host + ":#{@board.get_port}" 
    end

    path = @board.get_path 
    

    if @board.get_dat
      url += path + "dat/"
    else
      if /^(\/.*)(\/.+)$/i =~ path
	url += $1
	path = $2
      end
      url += "/test/read.cgi" + path
    end

    i=0
    file.each{ |line|
      line.chop!
#      line=Kconv::kconv(line,Kconv::EUC,Kconv::SJIS)
      line=NKF::nkf(NKF_SJIS_TO_EUC,line)

      if /(.*)<>(.*)/ =~ line
	title = unquote($2)
	thread = Thread2ch.new(title,url,$1,@board.get_dat)
	@board.append_thread thread
	thread_item = Gtk::ThreadTreeItem.new(thread,self)
	subtree.append thread_item
	thread_item.show
	i+=1      
      end
    }
    self.set_num_of_thread(i)
    file.close
    self.set_subtree subtree
    self.show_all
    $vvbox.pop_entry_text
  end


  def get_board
    return @board
  end

  def set_num_of_thread(num)
    @num_of_thread=num
  end
  def get_num_of_thread
    return @num_of_thread
  end

  def set_subtree(subtree)
    if @subtree
      begin
	@subtree.clear_items 0,@num_of_thread
      rescue ArgumentError
      end
    end
    @subtree=subtree
    super
  end
end

#ThreadѤTreeItem
class ThreadTreeItem < Gtk::TreeItem

  def initialize(thread,board_item)
    @thread=thread
    @board_item = board_item
    super(@thread.get_title_and_size)
    self.set_name "ThreadTreeItem"

    tooltips = Gtk::Tooltips.new()
    tooltips.set_tip(self,@thread.get_title_and_size,"")
    tooltips.set_delay($config['thread_tooltips_delay'])
    self.signal_connect('select') { 

#signal_connectΤʤǥåɺäʤɤƤΤΤ?
#̤ThreadؿǤ餻뤫?

      if $config['background_get']
#	$display_status_iterationp = false

	

	$mutex_for_thread.lock
	if !$svbox.sensitive?
	  $mutex_for_thread.unlock
	  break
	end
	$svbox.set_sensitive false
	$num_of_background_threads +=1
	$mutex_for_thread.unlock
	thread=Thread.start{
	  pre_size=@thread.load_file
	  $mutex_for_thread.lock
	  $num_of_background_threads -=1
	  $svbox.set_sensitive true
	  $mutex_for_thread.unlock
	  if pre_size
	    if @thread.get_file
	      $vvbox.set_thread(@thread,pre_size)
	    end
	  end
	}
	while thread.alive?
	  sleep 0.05
#	  Gtk.main_iteration()
	end


#	$display_status_iterationp = true
      else
	pre_size=@thread.load_file
	if pre_size
	  if @thread.get_file
	    $vvbox.set_thread(@thread,pre_size)
	  end
	end
      end
#      $vvbox.set_page(-1)

    }
    self.signal_connect('button_press_event'){|w,e|
      if e.instance_of?(Gdk::EventButton) &&  e.button==3
	if @thread.get_special
	  menu = Gtk::Menu.new
	  menu.signal_connect_after('button_press_event'){
	    menu.popdown
	  }
	  item = Gtk::MenuItem.new('Menu')
	  menu.append item
	  separator = Gtk::MenuItem.new()
	  menu.append separator

	  toziru_item = Gtk::MenuItem.new('Ĥ')
	  menu.append toziru_item
	  
	  toziru_item.signal_connect('button_press_event'){|w,e|
	    @board_item.collapse
	  }
	  sakuzyo_item = Gtk::MenuItem.new('')
	  menu.append sakuzyo_item
	  
	  sakuzyo_item.signal_connect('button_press_event'){|w,e|
	    @thread.get_special.delete_thread(@thread)
	    @board_item.set_bookmarks_item
	    write_bookmarks($bookmarks_array,$bookmarks)
	  }

	  menu.popup(nil, nil, nil, e.button, e.time)
	  menu.show_all

	else
	  @board_item.collapse
	end
      end
    }

  end
  def get_thread
    return @thread
  end

end

class SelectionVBox < Gtk::VBox

  def initialize(board_file_array)

    @board_hash = Hash.new
    @category_array = []
    @sw=nil
    $bookmarks_board =nil

    $bookmarks_array=[]

    bookmarks_flag=true
    board_file_array.each { |board_file|
      while line = board_file.gets
	line=NKF::nkf(NKF_SJIS_TO_EUC,line)	
	line.strip!


	if /^C\s+(.+)/ =~ line
	  category = $1.strip
	  @category_array.push category
	  @board_hash[category] = []
	  if bookmarks_flag
	    $bookmarks_array << "C #{category}"
	  end
	elsif  /^D\s+(.+)/ =~ line
	  board = Board2ch.new($1,"",false,true)
	  unless category
	    category= make_bookmarks_category
	  end
	  @board_hash[category] << board
	  $bookmarks_board =board
	  if bookmarks_flag
	    $bookmarks_array << board
	  end
	elsif  /^T\s+(\S+)\s+(.+)/ =~ line
	  if  $bookmarks_board == nil &&  bookmarks_flag
	    category,board = make_bookmarks_board(category)
	  end
	  thread = Thread2ch.new($2.strip,$1,nil,false,$bookmarks_board)
	  $bookmarks_board.append_thread thread
	elsif  /^S\s+(\S+)\s+(.+)/ =~ line
	  if  $bookmarks_board == nil &&  bookmarks_flag
	    category,board = make_bookmarks_board(category)
	  end
	  thread = Thread2ch.new($2.strip,$1,nil,true,$bookmarks_board)
	  $bookmarks_board.append_thread thread

	elsif  /^B\s+(\S+)\s+(.+)/ =~ line
	  if $gzip
	    board = Board2ch.new($2.strip,$1,false)
	  else
	    board = Board2ch.new($2.strip,$1,true)
	  end
	  @board_hash[category] << board
	  if bookmarks_flag
	    $bookmarks_array << board
	  end

	elsif  /^A\s+(\S+)\s(.+)/ =~ line
	  board = Board2ch.new($2.strip,$1,true)
	  @board_hash[category] << board
	  if bookmarks_flag
	    $bookmarks_array << board
	  end
	else
	  if bookmarks_flag
	    $bookmarks_array << line
	  end
	end
      end
      if bookmarks_flag
	if $bookmarks_board == nil
	  p "aa"
	  category,board = make_bookmarks_board(category)
	end
      end
      bookmarks_flag=false
      board_file.close
    }

    category = $kensaku_kekka
    @category_array.push category
    @board_hash[category] = []
    
    @cur_category = @category_array[0]
    super(false,0)

    @combo = Gtk::Combo.new
    @combo.entry.set_editable(false)
    @combo.set_popdown_strings(@category_array)

#    @combo.entry.add_events( Gdk::ALL_EVENTS_MASK)
    @combo.entry.add_events( Gdk::KEY_RELEASE_MASK)


    @combo.entry.signal_connect('key_release_event'){
      @cur_category = @combo.entry.get_text
      self.set_sw
    }

    @combo.list.signal_connect('button_release_event'){
      @cur_category = @combo.entry.get_text
      self.set_sw
    }

#    @combo.entry.signal_connect('changed'){
#      unless @combo.list.visible?
#	@cur_category = @combo.entry.get_text
#	self.set_sw
#      end
#    }


    self.pack_start @combo,nil


    entry = Gtk::Entry.new
    self.pack_start entry,false,false,0
    entry.set_editable(true)
    self.show_all
    entry.signal_connect('activate'){ |widget|
      text=entry.get_text.strip
      if text == ""
	break
      end 
      re = Regexp.new(text,true)

      kensaku_board = Board2ch.new($kensaku_kekka + ': ' + text,"","",true)
      item = Gtk::BoardTreeItem.new(kensaku_board)
      @board_hash[@cur_category].each{ |board|
	board.get_thread_array.each{|thread|
	  if re =~ thread.get_title_and_size
	    kensaku_board.append_thread(thread)
	  end
	}
      }
      if kensaku_board.get_thread_array == []
	$vvbox.push_entry_text('ޥåThreadϤޤǤ')
      else
	@board_hash[$kensaku_kekka] << kensaku_board
	@combo.entry.set_text($kensaku_kekka)
	# 3ĤǤƤ뤫
	@cur_category = @combo.entry.get_text
	self.set_sw
      end
    }



    self.set_sw

  end
  
  def make_bookmarks_board(category)
    board = Board2ch.new('ThreadΥ֥åޡ',"",false,true)
    unless category
      category= make_bookmarks_category
    end
    @board_hash[category] << board
    $bookmarks_board = board
    $bookmarks_array << board
    return category,board
  end

  def make_bookmarks_category
    category = ''
    @category_array.push category
    @board_hash[category] = []
    $bookmarks_array << "C #{category}"
    return category
  end

  def set_sw
    if @sw
      self.remove @sw
    end
    @sw = set_tree(@board_hash[@combo.entry.get_text])
    self.pack_start @sw      
    @sw.show_all
  end

  def set_tree(hash)
    @tree = Gtk::Tree.new
    @tree_size=0

    sw =  Gtk::ScrolledWindow.new()
#    sw.set_usize $select_width,$select_height
    sw.set_usize $config['select_width'],$config['height']
    sw.add_with_viewport @tree   

    @tree.clear_items 0,@tree_size
    @tree_size=0
    hash.each{ |board|
      @tree_size+=1

      item = Gtk::BoardTreeItem.new(board)
      @tree.append item
      array = board.get_thread_array
      if array  != []
	subtree = Gtk::Tree.new
	item.set_subtree subtree
	i=0
	array.each{ |thread|
	  thread_item = Gtk::ThreadTreeItem.new(thread,item)
	  subtree.append thread_item
	  thread_item.show_all
	  i+=1
	}
	item.set_num_of_thread(i)
	item.show_all
      end 
    }
    @tree.show_all

    return sw
  end

end

board_info = $basedir + "board_info"

if File.exist?(board_info)
  file = open(board_info,'r')
else
  $basedir = ENV["HOME"]+ "/.2ch_ruby_gtk/"
  board_info = $basedir + "board_info"
  if File.exist?(board_info)
    file = open(board_info,'r')
    STDERR.print "~/.2ch_ruby_gtk ǥ쥯ȥ ~/.goRua_2ch ˰ưƤ\n ~/.2ch_ruby_gtk ϥݡȤʤʤޤ\n"
  else
    STDERR.print "not found: ~/.goRua_2ch/board_info and ~/.2ch_ruby_gtk/board_info. see README.\n"
    exit
  end
end

$bookmarks = $basedir + "bookmarks"
$sessions = $basedir + "sessions"
sessions_backup = $basedir + "sessions_backup"


$main_window = Gtk::Window.new(Gtk::WINDOW_TOPLEVEL)
$main_window.set_title("goRua -- Gtk+ on Ruby User Agent for 2ch version #{GORUA_VERSION}")

# Thanks : honeto@mail.goo.ne.jp 
#hbox = Gtk::HBox.new(false,0)
hpaned = Gtk::HPaned.new

$vvbox = ViewVBox.new()

file_array=[]
if File.exist?($bookmarks)
  bm_file = open($bookmarks)
  file_array << bm_file
else
  bm_file = open($bookmarks,'w+')
end 
file_array << file
$svbox = SelectionVBox.new(file_array)

# Thanks : honeto@mail.goo.ne.jp 
#hbox.pack_start $svbox,nil
#hbox.pack_start $vvbox
#window.add hbox
hpaned.pack1 $svbox, nil, true
hpaned.pack2 $vvbox, nil, true
$main_window.add hpaned


$main_window.show_all
$batu_pix, $batu_mask =
  Gdk::Pixmap::create_from_xpm_d($main_window.window, nil, $batu_xpm)

# Thanks: >>73
$main_window.signal_connect("destroy") do exit end

$display_status_iterationp = false

if File.exist?($sessions) 
  open($sessions,'r'){ |file|
    open(sessions_backup,'w'){|backup|
      backup.write file.read
    }
  }
  if !$OPT_s
    $init = true
    open($sessions,'r'){ |file|
      while line=file.gets
	line=NKF::nkf(NKF_TO_EUC,line)
	thread=nil
	line.strip!
	if  /^S\s+(\S+)\s+(.+)/ =~ line
	  thread = Thread2ch.new($2.strip,$1,nil,true)
	elsif  /^T\s+(\S+)\s+(.+)/ =~ line
	  thread = Thread2ch.new($2.strip,$1,nil,false)
	end
	if thread
	  pre_size=thread.load_file
	  if pre_size
	    if thread.get_file
	      $vvbox.set_thread(thread,pre_size)
	    end
	  end
	end
      end
    }
  end
end
$init = false
$display_status_iterationp = true
if $config['background_get']
  Thread.start{
    loop do
      sleep 0.01
      while $num_of_background_threads >0
#	sleep 0.01
	Gtk.main_iteration()	
      end
    end
  }
end
Gtk.main
