#!/usr/bin/env ruby
$KCODE='e'
# goRua -- Gtk+ on Ruby User Agent for 2ch version
GORUA_VERSION = '0.13d'
# ջ  haruyama@unixuser.org
# $Id: goRua.rb,v 1.105 2002/05/19 14:58:31 haruyama Exp $

# ΥեGPLդƤޤ.
# Υץ̵ݾڤǤ.
require 'getopts'
require 'gtk'


if Gtk::BINDING_VERSION.join == "027" ||  Gtk::BINDING_VERSION.join == "028"
  STDERR.print "Ruby/Gtk 0.27,0.28(CVS snapshot)ˤ꤬뤿ᡢεǽưޤ\n"
  ERROR_OF_SWITCH_PAGE = true
else
  ERROR_OF_SWITCH_PAGE = false
end

#require 'kconv'
require 'nkf'
require 'jcode'

require 'net/http'
# require 'thread'
begin
  require 'zlib'
  ENABLE_GZIP =true
rescue LoadError
  STDERR.print "ruby-zlibޤǤ\ngzipǰ̤줿ȥ꡼򰷤ȤǤޤ\nߤread.cgiλͤǤgzipǰ̤줿ȥ꡼Τߤ󶡤褦Ǥ\nruby-zlibΥ󥹥ȡ侩ޤ\n"
  ENABLE_GZIP =false
#  exit
end

require 'connect2ch'

# ƥǥȥӥ塼ѹƤ
# >> ǥȥӥ塼
# Thanks: 餱@kondara 
GORUA_DATADIR = '/usr/share/goRua'

##### Ƽ #####
# ϢեΥ١ǥ쥯ȥ
BASE_DIR = ENV["HOME"]+ "/.goRua_2ch/"

# Thanks: 餱@kondara 
Dir.mkdir(BASE_DIR) unless File.exist?(BASE_DIR)
Dir.mkdir("#{BASE_DIR}/thread") unless File.exist?("#{BASE_DIR}/thread")
Dir.mkdir("#{BASE_DIR}/subject") unless File.exist?("#{BASE_DIR}/subject")
unless File.exist?("#{BASE_DIR}/board_info")
  system "cp #{GORUA_DATADIR}/board_info #{BASE_DIR}/board_info"
end
unless File.exist?("#{BASE_DIR}/bookmarks")
  system "cp #{GORUA_DATADIR}/bookmarks #{BASE_DIR}/bookmarks"
end

#ǥե
$config={
  'proxy_addr' => nil,
  'proxy_port' => nil,
  'get_proxy_addr' => nil,
  'get_proxy_port' => nil,
  'post_proxy_addr' => nil,
  'post_proxy_port' => nil,
  'http_get_timeout' => 60,
  'http_command' => "galeon -n %u",
  'tab_string_size' => 7,
  'height' => 600,
  'select_width' => 250,
  'view_width' => 650,
  'post_width' => 600,
  'post_height' => 400,
  'hankaku_to_zenkaku' => nil,
  'thread_tooltips_delay' => 1500,
  'post_name_candidate' => [''],
  'post_mailto_candidate' => ['','sage'],
  'user_agent' => "goRua.rb #{GORUA_VERSION}",
#  'background_get' => nil,
  'show_old_message' => nil,
  'colored_text' => true,
  'color0' => 'black',
  'color1' => 'red',
  'color2' => 'blue',
  'color3' => 'green',
  'set_last_page' => true,
}

config = BASE_DIR + "config"

# Thanks: 餱@kondara 
#if File.exist?(config)
begin
  unless File.exist?(config)
    config = "#{GORUA_DATADIR}/config"
  end
  open(config,'r'){|file|
    while line=file.gets
      line=NKF::nkf('-ex',line)
      line.chop!
      if /^\#/ =~ line
	next
      elsif /^([a-z_0-9]+)\s*=\s*([0-9\-][0-9]*)\s*$/ =~ line
	tmp1=$1
	tmp2=$2
	if $config[tmp1].is_a? Fixnum  
	  $config[tmp1]=tmp2.to_i
	elsif !$config[tmp1]
	  $config[tmp1]=tmp2.to_i
	elsif $config[tmp1].is_a? String
	  $config[tmp1]=tmp2.strip
	else
	  STDERR.print "#{$1} ʤͤꤵƤޤ\n"
	end
      elsif /^([a-z_0-9]+)\s*=\s*\[(.*)\]\s*$/ =~ line
	if $config[$1].is_a? Array
	  $config[$1]=$2.split(/,/)
	else
	  STDERR.print "#{$1} ϻǤޤ\n"
	end
      elsif /^([a-z_0-9]+)\s*=\s*(.*)\s*$/ =~ line
	tmp1=$1
	tmp2=$2.strip
	if  $config[tmp1].is_a? String
	  $config[tmp1] = tmp2
	elsif  $config[tmp1].is_a? TrueClass
	  if tmp2 == 'true'
	    $config[tmp1] = true
	  elsif tmp2 == 'false'
	    $config[tmp1] = false
	  else
	    STDERR.print "#{tmp1} ˤ truefalseꤹɬפޤ\n"
	  end
	elsif !$config[tmp1]
	  $config[tmp1] = tmp2
	else
	  STDERR.print "#{tmp1} ʸϻǤޤ\n"
	end
      end
    end
  }
rescue
end


if $config['colored_text']
  begin
    require 'color_table'

    if COLOR_TABLE[$config['color0'].downcase]
      COLOR_OTHERS = COLOR_TABLE[$config['color0'].downcase]
    else
      STDERR.print "#{$config['color0'].downcase} ȤϸĤޤǤ\n"
      COLOR_OTHERS = COLOR_TABLE['black']
    end
    
    if COLOR_TABLE[$config['color1'].downcase]
      COLOR_CITE_NUMBER = COLOR_TABLE[$config['color1'].downcase]
    else
      STDERR.print "#{$config['color1'].downcase} ȤϸĤޤǤ\n"
      COLOR_CITE_NUMBER = COLOR_TABLE['red']
    end

    if COLOR_TABLE[$config['color2'].downcase]
      COLOR_CITE = COLOR_TABLE[$config['color2'].downcase]
    else
      STDERR.print "#{$config['color2'].downcase} ȤϸĤޤǤ\n"
      COLOR_CITE = COLOR_TABLE['blue']
    end

    if COLOR_TABLE[$config['color3'].downcase]
      COLOR_URL = COLOR_TABLE[$config['color3'].downcase]
    else
      STDERR.print "#{$config['color3'].downcase} ȤϸĤޤǤ\n"
      COLOR_URL = COLOR_TABLE['green']
    end


    #ꤵ줿뤫å
    
  rescue LoadError
#    $config['colored_text']=false
    STDERR.print "color_table.rb򸫤ĤޤǤ.ɸοȤޤ\n"
    COLOR_OTHERS = Gdk::Color.new(0,0,0)
    COLOR_CITE_NUMBER = Gdk::Color.new(65535,0,0)
    COLOR_CITE = Gdk::Color.new(0,0,65535)
    COLOR_URL = Gdk::Color.new(0,32896,0)
  end
else
  COLOR_OTHERS = nil
  COLOR_CITE_NUMBER = nil
  COLOR_CITE = nil
  COLOR_URL = nil
end


if $config['hankaku_to_zenkaku']
  NKF_SJIS_TO_EUC = '-eS'
  NKF_TO_EUC = '-e'
  NKF_EUC_TO_SJIS = '-sE'
#  NKF_TO_SJIS = '-s'
else
  NKF_SJIS_TO_EUC = '-exS'
  NKF_TO_EUC = '-ex'
  NKF_EUC_TO_SJIS = '-sxE'
#  NKF_TO_SJIS = '-sx'
end

=begin
if $config['background_get']
  if RUBY_RELEASE_DATE >= '2002-01-30'
    STDERR.print "Хå饦ɤߤߤϼ¸ŪʵǽǤ\nղ\n"

  else
    STDERR.print "Хå饦ɤߤߤ 餯RUBY_RELEASE_DATE\n2002-01-30ʹߤrubyǤʤ˵ǽޤ\n"
    $config['background_get'] = nil
  end
end
=end


$config['user_agent'].gsub!('%v',"#{GORUA_VERSION}")

#  183(matzθ)Τˤ
# connect2ch(0.12ʹ)
if $config['get_proxy_addr'] && $config['get_proxy_port']
  $connect2ch_config['get_proxy_addr']=$config['get_proxy_addr']
  $connect2ch_config['get_proxy_port']=$config['get_proxy_port']
elsif $config['proxy_addr'] && $config['proxy_port']
  $connect2ch_config['get_proxy_addr']=$config['proxy_addr']
  $connect2ch_config['get_proxy_port']=$config['proxy_port']
end

if $config['post_proxy_addr'] && $config['post_proxy_port']
  $connect2ch_config['post_proxy_addr']=$config['post_proxy_addr']
  $connect2ch_config['post_proxy_port']=$config['post_proxy_port']
elsif $config['proxy_addr'] && $config['proxy_port']
  $connect2ch_config['post_proxy_addr']=$config['proxy_addr']
  $connect2ch_config['post_proxy_port']=$config['proxy_port']
end
# $connect2ch_config['proxy_addr']=$config['proxy_addr']
# $connect2ch_config['proxy_port']=$config['proxy_port']
$connect2ch_config['http_get_timeout']=$config['http_get_timeout']
$connect2ch_config['user_agent']=  $config['user_agent'] + ' (' +$connect2ch_config['user_agent'] +')'


#ƱƱեؤɤߤߤ򤱤뤿
#mutex,
# ɤ̣ʤʤΤǾä
=begin
$mutex_for_get = Mutex.new
$filenames_in_getting = []
=end

# multi_thread
# $mutex_for_thread = Mutex.new
# $num_of_background_threads = 0
# $background_thread=nil



# ޥɥ饤󥪥ץ
getopts("s")


#եȤ
gtkrc = BASE_DIR + "gtkrc"
if File.exist?(gtkrc)
  Gtk::RC.parse(gtkrc)
# Thanks: 餱@kondara 
elsif File.exist?("#{GORUA_DATADIR}/gtkrc")
  Gtk::RC.parse("#{GORUA_DATADIR}/gtkrc")
else
  Gtk::RC.parse_string <<EOS
style "mona_14"
{
  fontset = "-mona-gothic-medium-r-normal--14-*"
}
widget_class "*" style "mona_14"
style "mona_12"
{
  fontset = "-mona-gothic-medium-r-normal--12-*"
}
widget "*NotebookTab*" style "mona_12"
EOS
end

# Textfontι⤵(եȤθ!)
text = Gtk::Text.new
text.set_name "Text"

style = Gtk::RC.get_style(text)

TEXT_FONT = style.font

# $config['text_font_height'] =  TEXT_FONT.string_height("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
TEXT_FONT_HEIGHT =  TEXT_FONT.string_height("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")

#XPixmap
BATU_XPM = [
"12 12 2 1",
"  c black",
".       c None s None",

"  ........  ",
".  ......  .",
"..  ....  ..",
"...  ..  ...",
"....    ....",
".....  .....",
"....    ....",
"...  ..  ...",
"..  ....  ..",
".  ......  .",
"  ........  ",
"............"

]

# å popup ѿ
$menu_popup = false

# ɽ

# $kensaku_kekka = ''
KENSAKU_KEKKA = ''

=begin
# w3m-0.2.2-inu-1.1 entity.c
LATIN1_EUCJP_MAP =
[
    " ", "!",  "", "", "CUR","", "|",  "",   
    "", "(C)","-a", "", "", "-",  "(R)","",  
    "", "", "^2", "^3", "'",  "", "", "",  
    ",",  "^1", "-o", "", "1/4","1/2","3/4","?",   
    "A`", "A'", "A^", "A~", "A:", "",  "AE","C,",  
    "E`", "E'", "E^", "E", "I`",  "I'", "I^", "I:",  
    "D-", "N~", "O`", "O'", "O^", "O~", "Oe", "",  
    "", "U`", "U'", "U^", "U:", "Y'", "th", "ss",  
    "a`", "a'", "a^", "a~", "a:", "a",  "ae", "c",   
    "e`", "e'", "e^", "e:", "i`", "i'", "i^", "i:",  
    "d-", "n~", "o`", "o'", "o^", "o~", "oe", "",  
    "", "u`", "u'", "u^", "u:", "y'", "th", "y:"   
]


# w3m-0.2.2-inu-1.1 entity.c conv_entity
def unquote_char(num)
  ret = " "
  if num < 0x80
    ret[0] = num 
  elsif num < 0xa0 
    # ϼǻʸˤ뤫...
    ret = " "
  elsif num < 0x100 
    ret = $latin1_eucjp_map[num-0xa0]
  else
    ret = "  "
    # ϼǻʸˤ뤫...
  end
  return ret
end
=end

#EUC١ɽ
=begin
CHAR_TBL_AD = 
[ 
# դ
    ["\xa1", ''],
    ["\xa2", ''],
    ["\xa3", ''],
    ["\xa4", ''],
    ["\xa5", ''],
    ["\xa6", ''],
    ["\xa7", ''],
    ["\xa8", ''],
    ["\xa9", ''],
    ["\xaa", '10'],
    ["\xab", '11'],
    ["\xac", '12'],
    ["\xad", '13'],
    ["\xae", '14'],
    ["\xaf", '15'],
    ["\xb0", '16'],
    ["\xb1", '17'],
    ["\xb2", '18'],
    ["\xb3", '19'],
    ["\xb4", '20'],
# ޿
    ["\xb5", 'I'],
    ["\xb6", 'II'],
    ["\xb7", 'III'],
    ["\xb8", 'IV'],
    ["\xb9", 'V'],
    ["\xba", 'VI'],
    ["\xbb", 'VII'],
    ["\xbc", 'VIII'],
    ["\xbd", 'IX'],
    ["\xbe", 'X'],
# ñ    
    ["\xc0", 'Ў'],
    ["\xc1", ''],
    ["\xc2", 'ݎ'],
    ["\xc3", '-Ď'],
    ["\xc4", 'ގ׎'],
    ["\xc5", 'Ď'],
    ["\xc6", '-'],
    ["\xc7", '͎-'],
    ["\xc8", '؎Ď'],
    ["\xc9", '܎'],
    ["\xca", 'ێ-'],
    ["\xcb", 'Ďގ'],
    ["\xcc", 'ݎ'],
    ["\xcd", 'ʎ-ݎ'],
    ["\xce", 'Ў؎-Ď'],
    ["\xcf", '͎-'],
# ñ
    ["\xd0", 'mm'],
    ["\xd1", 'cm'],
    ["\xd2", 'km'],
    ["\xd3", 'mg'],
    ["\xd4", 'kg'],
    ["\xd5", 'cc'],
    ["\xd6", 'm^2'],
    
    ["\xdf", 'ʿ'],
# ¾
    ["\xe0", '``'],
    ["\xe1", ',,'],
    ["\xe2", 'No'],
    ["\xe3", 'KK'],
    ["\xe4", 'Tel'],
    ["\xe5", ''],
    ["\xe6", ''],
    ["\xe7", ''],
    ["\xe8", ''],
    ["\xe9", ''],
    ["\xea", '()'],
    ["\xeb", '(ͭ)'],
    ["\xec", '()'],
    ["\xed", ''],
    ["\xee", ''],
    ["\xef", ''],
    ["\xf0", ''],
    ["\xf1", ''],
    ["\xf2", ''],
    ["\xf3", ''], #Ȳ.. 
    ["\xf4", ''],
    ["\xf5", ''],
    ["\xf6", ''],
    ["\xf7", ''],
    ["\xf8", ''],
    ["\xf9", ''],
    ["\xfa", ''],
    ["\xfb", ''],
    ["\xfc", ''],
  ]

# ΤɽǤƤʤ
CHAR_TBL_AC = [
["\xa3",''], #ºݤȾ?
]

CHAR_TBL_FC = [
["\xa3",'  '], #??
]
=end



CHAR_HASH_AD = 
  {
# դ
    0xa1 => '',
    0xa2 => '',
    0xa3 => '',
    0xa4 => '',
    0xa5 => '',
    0xa6 => '',
    0xa7 => '',
    0xa8 => '',
    0xa9 => '',
    0xaa => '10',
    0xab => '11',
    0xac => '12',
    0xad => '13',
    0xae => '14',
    0xaf => '15',
    0xb0 => '16',
    0xb1 => '17',
    0xb2 => '18',
    0xb3 => '19',
    0xb4 => '20',

# ޿
    0xb5 => 'I',
    0xb6 => 'II',
    0xb7 => 'III',
    0xb8 => 'IV',
    0xb9 => 'V',
    0xba => 'VI',
    0xbb => 'VII',
    0xbc => 'VIII',
    0xbd => 'IX',
    0xbe => 'X',
# ñ    
    0xc0 => 'Ў',
    0xc1 => '',
    0xc2 => 'ݎ',
    0xc3 => '-Ď',
    0xc4 => 'ގ׎',
    0xc5 => 'Ď',
    0xc6 => '-',
    0xc7 => '͎-',
    0xc8 => '؎Ď',
    0xc9 => '܎',
    0xca => 'ێ-',
    0xcb => 'Ďގ',
    0xcc => 'ݎ',
    0xcd => 'ʎ-ݎ',
    0xce => 'Ў؎-Ď',
    0xcf => '͎-',
# ñ
    0xd0 => 'mm',
    0xd1 => 'cm',
    0xd2 => 'km',
    0xd3 => 'mg',
    0xd4 => 'kg',
    0xd5 => 'cc',
    0xd6 => 'm^2',
    
    0xdf => 'ʿ',
# ¾
    0xe0 => '``',
    0xe1 => ',,',
    0xe2 => 'No',
    0xe3 => 'KK',
    0xe4 => 'Tel',
    0xe5 => '',
    0xe6 => '',
    0xe7 => '',
    0xe8 => '',
    0xe9 => '',
    0xea => '()',
    0xeb => '(ͭ)',
    0xec => '()',
    0xed => '',
    0xee => '',
    0xef => '',
    0xf0 => '',
    0xf1 => '',
    0xf2 => '',
    0xf3 => '', # Ȳ.. 
    0xf4 => '',
    0xf5 => '',
    0xf6 => '',
    0xf7 => '',
    0xf8 => '',
    0xf9 => '',
    0xfa => '',
    0xfb => '',
    0xfc => '', 
}

# ΤɽǤƤʤ
CHAR_HASH_AC = {
  0xa3 => '',  #ºݤȾ?
}

CHAR_HASH_FC = {
  0xa3 => '  ',  #??
}

# 褯Ȥconfigѿ(ưŪ꤬ǽˤʤäȤ᤹)

#Text礭
# ޤΤȤưŪˤȤäƤʤΤˤ
# $text_width = $config['view_width']-32
TEXT_WIDTH = $config['view_width']-32
SELECT_WIDTH = $config['select_width']
HEIGHT = $config['height']
THREAD_TOOLTIPS_DELAY = $config['thread_tooltips_delay']
TAB_STRING_SIZE = $config['tab_string_size']
SET_LAST_PAGE = $config['set_last_page']
VIEW_WIDTH = $config['view_width']
COLORED_TEXT =  $config['colored_text']


#¿ʴؿ

=begin
# http://www.ruby-lang.org/~rubikitch/computer/myruby/replace-char/ ĥ
def replace_char(text)
# ȤꤢٹŪ
#  CHAR_TBL.each do |a, b|
  CHAR_TBL_AD.each do |a, b|
    text.gsub!(/#{"\xad"+a}/, b)
  end

  CHAR_TBL_AC.each do |a, b|
    text.gsub!(/#{"\xac"+a}/, b)
  end

  CHAR_TBL_FC.each do |a, b|
    text.gsub!(/#{"\xfc"+a}/, b)
  end


  return text
end
=end

#® require 'jcode' ɬ
def replace_char(text)
  ret = ""
  text.each_char{|char|
    if char[0] == 0xad && CHAR_HASH_AD[char[1]]
      ret += CHAR_HASH_AD[char[1]]
    elsif  char[0] == 0xac && CHAR_HASH_AC[char[1]]
      ret += CHAR_HASH_AC[char[1]]
    elsif  char[0] == 0xfc && CHAR_HASH_FC[char[1]]
      ret += CHAR_HASH_FC[char[1]]
    else
      ret += char
    end

  }

  return ret
end


def unquote(str)
  if str 
  #ȴ
    str.gsub! '&gt;', '>'
    str.gsub! '&lt;', '<'
    str.gsub! '&nbsp;', ' '
    str.gsub! '&quot;', '"'

#ΤѤAAʤɤ?
#    str.gsub! "&reg;","\$"
#    str.gsub! "&copy;","@"
#    str.gsub! "&shy;","-"

#uuencodeƤΤʤɤʤǽ
#toggleǤ褦ˤ
#    str = str.gsub(/&#(\d+);/){ |s|
#      unquote_char($1.to_i)
#    }

#    str = str.gsub (/&#x([\da-fA-F]+);/){
#      unquote_char($1.hex)
#    }

#ɤϤƤʤ?
#    str.gsub! "&amp;", "&"
#ʤäƤΤ.....
#    str.gsub! "&amp", "&"

  end
  return str
end


# bookmarksե
def write_bookmarks(array,filename)

  open(filename,'w') { |file|
    str = ""
    array.each{|e|
      if e.is_a? String
	# ƥ꡼ȥ
#	str += "C #{e}\n"
	str += "#{e}\n"
      elsif e.is_a? Board2ch
	if e.get_special
	  str += "D #{e.get_title}\n"
	  e.get_thread_array.each { |thread|
	    if thread.get_dat 
	      str +=  "S #{thread.get_url} #{thread.get_title}\n"
	    else
	      str += "T #{thread.get_url} #{thread.get_title}\n"	
	    end
	  }

	elsif e.get_dat
	  str += "A #{e.get_url} #{e.get_title}\n"
	else
	  str += "B #{e.get_url} #{e.get_title}\n"
	end
#      elsif e.is_a? Thread2ch
#	if e.get_dat 
#	  str += "S #{e.get_url} #{e.get_title}\n"
#	else
#	  str += "T #{e.get_url} #{e.get_title}\n"	
#	end
      end
    }
    file.print NKF::nkf(NKF_EUC_TO_SJIS,str)
  }
end

#TextǱåݤ˽Ф˥塼Item
class UrlMenuItem < Gtk::MenuItem
  def initialize(text)
    @url = text
#2Ť˽뤳ȤˤʤΤǡޤ
#
    @text=nil
    host,port,path=parse_http_url(text)

    if host
# offlaw.cgi ǧھɬפˤʤä
#      if /\.(2ch|bbspink)\./=~ host  && %r!/test/(read|offlaw)\.cgi! =~ path
      if /\.(2ch|bbspink)\./=~ host  && %r!/test/read\.cgi! =~ path

	# Thanks: >>66
	@text = "goRuaǽ: " +text
      else
	@text = "֥饦ǽ: " +text
      end
    else
      @text = text
    end
    
    super @text
    self.set_name "UrlMenuItem"
    
    self.signal_connect('button_press_event'){|w,e|
      VVBOX.exec_entry_text(@url)
    }

  end

end

# ȯ1åȤޤե졼
class MessageFrame < Gtk::Frame
  def initialize(num,name,mailto,date_id,body)
    super "#{num}"
    self.set_label_align(0, 0)
    self.border_width(1)

    url = []

    table = Gtk::Table.new(2,2,false)
    self.add table
    name.gsub!("<.+?>","")
    name=unquote(name)

    # mailto ʤ Buttonˤtooltipsդ
    if mailto && mailto != "" 
      mailto.gsub!("<.+?>","")
      mailto=unquote(mailto)
      name_label = Gtk::Button.new(name)
      tooltips = Gtk::Tooltips::new()
      tooltips.set_tip(name_label,mailto,"")
      name_label.set_name "NameLabel"
    else
      name_label = Gtk::Label.new(name)
      name_label.set_name "NameLabel"
    end

    table.attach name_label,0,1,0,1,0,0

    date_id_label =  Gtk::Label.new(date_id)
    date_id_label.set_name "DateIdLabel"

    table.attach date_id_label,1,2,0,1,0,0

    if body
      lines  = body.split("<br>")
      text = Gtk::Text.new
      text.set_name "Text"

      text.set_word_wrap false
      table.attach text,0,2,1,2,nil,0
      
      tmp = lines.size+1
      
      lines.each { |tmp_line|
	
	tmp_line.sub!("\s+$","")
	# Ƭ˶򤬤ϤäƤΤ
	tmp_line.sub!("^ ","") 
	
	tmp_line.gsub!("<.*?>","")
	tmp_line=unquote(tmp_line)	    

# ŬˤäԤʤȤդ
	tmp+=TEXT_FONT.string_width(tmp_line)/ (TEXT_WIDTH-20)


# ʸ
#	Thanks: M.Suzuki
	while true
	  case tmp_line
	  when /^(>+(\d+-\d+))(.*)$/  #ֹ
	    url << $2	      
	    text.insert nil,COLOR_CITE_NUMBER,nil, $1
	    tmp_line = $3
	  when /^(>+(\d+-))(.*)$/
	    url << $2	      
	    text.insert nil,COLOR_CITE_NUMBER,nil, $1
	    tmp_line = $3
	  when /^(>+(\d+))(.*)$/
	    url << $2    
	    text.insert nil,COLOR_CITE_NUMBER,nil, $1
	    tmp_line = $3
	  when /^(>)/     # 
	    text.insert nil,COLOR_CITE,nil, tmp_line
	    tmp_line = ''
	  when /^(.*?)(h?ttps?:[a-zA-Z0-9%&\?\/\;\:\@\&\=\+\$\,\-\_\.\!\~\*\'\\(\)\#]+)(.*)$/	# url
	    text.insert nil,COLOR_OTHERS,nil, $1
	    text.insert nil,COLOR_URL,nil, $2
	    host,port,path=parse_http_url($2)
	    tmp_line = $3
	    if host
	      url << $2
	    end
	  else
	    text.insert nil,COLOR_OTHERS,nil, tmp_line + "\n"	    
	    break
	  end
	end
      }
      
#      text.set_usize TEXT_WIDTH,tmp*$config['text_font_height']
      text.set_usize TEXT_WIDTH,tmp*TEXT_FONT_HEIGHT

# ˥塼
      text.signal_connect('button_press_event'){|w,e|
	if e.instance_of?(Gdk::EventButton) &&  e.button==3
	  $menu_popup = true
	  menu = Gtk::Menu.new
	  menu.signal_connect('button_press_event'){
	    menu.popdown
	  }

	  item = Gtk::MenuItem.new('Menu')
	  menu.append item
	  separator = Gtk::MenuItem.new()
	  menu.append separator

	  url.each{ |text|
	    item = UrlMenuItem.new(text)
	    menu.append item
	  }
	  menu.popup(nil, nil, nil, e.button, e.time)
	  menu.show_all
	end
      }
=begin      
      text.signal_connect('key_press_event'){|w,e|
	$key_press_in_text = true
      }
=end
    end

# Ȥ
=begin
    @name = name
    @mailto= mailto
    @date_id=date_id
    @body=body
=end
  end

end

# Window
class PostWindow < Gtk::Window
  include PostMessage2ch

  def initialize(thread)
    super Gtk::WINDOW_TOPLEVEL
    @thread = thread
    title = @thread.get_title
    self.set_title('񤭤: ' + title)
    self.set_position(Gtk::WIN_POS_CENTER)
    self.set_transient_for(MAIN_WINDOW)

    vbox = Gtk::VBox.new false,0
    
    title_label = Gtk::Label.new(title + ' ؤν񤭤')
    vbox.pack_start title_label,false,false

    table = Gtk::Table.new(2,2,false)
    name_label = Gtk::Label.new('̾:')
    @name_combo = Gtk::Combo.new
    @name_combo.entry.set_editable(true)
    @name_combo.set_popdown_strings($config['post_name_candidate'])

    table.attach name_label,0,1,0,1,0,0
    table.attach @name_combo,1,2,0,1

    mailto_label = Gtk::Label.new('mailto:')
    @mailto_combo = Gtk::Combo.new
    @mailto_combo.entry.set_editable(true)
    @mailto_combo.set_popdown_strings($config['post_mailto_candidate'])
    table.attach mailto_label,0,1,1,2,0,0
    table.attach @mailto_combo,1,2,1,2
    vbox.pack_start table,false,false

    @message = Gtk::Text.new
    @message.set_name "PostText"
    @message.set_editable(true)
    vbox.pack_start @message

    self.add vbox

    hbox = Gtk::HBox.new false,10
    #񤭤ܥ
    kakikomu_button = Gtk::Button.new('񤭤')
    #󥻥ܥ
    cancel_button = Gtk::Button.new('󥻥')
    
    hbox.pack_start kakikomu_button
    hbox.pack_start cancel_button
    vbox.pack_start hbox,false,false
    self.set_usize $config['post_width'], $config['post_height']
    self.show_all

    cancel_button.signal_connect('clicked'){
      self.hide
    }

    kakikomu_button.signal_connect('clicked'){
      name = @name_combo.entry.get_text
      mailto = @mailto_combo.entry.get_text
      message=@message.get_chars(0,@message.get_length)
      if post_message(thread,name,mailto,message)
	VVBOX.push_entry_text('񤭤')
	self.hide
      else
	VVBOX.push_entry_text('񤭤߼')
      #Ԥݤɤ뤫
      end
    }

  end
end

#ThreadƤɽVBox
class ViewThreadVBox < Gtk::VBox

  def initialize(thread)
    @sw=nil
    super false,0

    @start = 1
    @view_num = 100
    @size = 0
    @thread = thread
    @file = @thread.get_file
    self.show


    self.signal_connect_after('button_press_event'){|w,e|
      if e.instance_of?(Gdk::EventButton) &&  e.button==3
	if $menu_popup
	  $menu_popup=false
	  break
	end

	menu = Gtk::Menu.new
	menu.signal_connect('button_press_event'){
	  menu.popdown
	}
	item = Gtk::MenuItem.new('Menu')
	menu.append item

	separator = Gtk::MenuItem.new()
	menu.append separator

	prev_item = Gtk::MenuItem.new('Prev')
	menu.append prev_item
	if @start > 1
	  prev_item.set_sensitive true
	else
	  prev_item.set_sensitive false
	end
	next_item = Gtk::MenuItem.new('Next')
	menu.append next_item
	if @start+@view_num-1 < @size
	  next_item.set_sensitive true
	else
	  next_item.set_sensitive false
	end
	menu.popup(nil, nil, nil, e.button, e.time)
	menu.show_all
	
	prev_item.signal_connect('button_press_event'){
	  self.set_start(@start-@view_num)
	  VVBOX.set_notebook_page(self)
	}
	  
	next_item.signal_connect('button_press_event'){
	  self.set_start(@start+@view_num)
	  VVBOX.set_notebook_page(self)
	}
      end
    }
  end

# ThreadΤɤƤ뤫
  def get_start
    return @start 
  end

# ThreadΥ쥹򲿸ıƤ뤫
  def get_view_num
    return @view_num 
  end

# ThreadΤΥ
  def get_size
    return @size 
  end

# ThreadαϾΥå
  def set_start(num)
    if num>0
      @start = num
    else
      @start =1
    end
  end

# ThreadΥ쥹αĿΥå
  def set_view_num(num)
    @view_num   = num
  end

# Υå
  def set_size(num)
    @size  = num
  end

# ScrollWindowΥå
  def set_sw(sw)
    if @sw
      self.remove @sw
    end
    @sw  = sw
    

    self.pack_start @sw
  end

  def get_sw
    return @sw
  end

  def get_thread
    return @thread
  end

  #ThreadƤparseɽ
  def make_view  
    
    if @view_num <= 0
      return
    end

    GC.disable

    VVBOX.push_entry_text('')
    vbox_view = Gtk::VBox.new(false,0)

    prev_title = self.get_thread.get_title 


    @file.rewind

    if  prev_title ==nil || prev_title== ""
# åɤΥȥ뤬狼ʤ
# ȥ򥻥å
      begin
	while line=@file.gets
	  line=NKF::nkf(NKF_SJIS_TO_EUC,line)
	  if /^(?:\+OK|-INCR)\s+(\d+)/ =~ line
	    next
	  end
	  (name,mailto,date_id,body,title)=line.split(/<>/)

	  title.strip!
	  if title && title !=""
	    self.get_thread.set_title(title)
	    tmp = title+ " (#{self.get_size})"
	    self.get_thread.set_title_and_size(tmp)
# ʲϤʤ?
#	    hbox = VVBOX.create_tab_label(tmp,self)
#	    notebook = VVBOX.get_notebook
#	    if notebook
#	      notebook.set_tab_label(self,hbox)
#	      notebook.set_menu_label(self,Gtk::Label.new(tmp))
#	    end
	    VVBOX.set_title(tmp)
	    VVBOX.show_all
	    VVBOX.write_sessions
	  end

	  break

	end
      rescue
      end
      @file.rewind
    end

# Thread
    @sw.add_with_viewport vbox_view

    i=1 # ߤΥ쥹ֹ
    j=0 # 褷쥹ο
    while line=@file.gets
      begin            
	line=NKF::nkf(NKF_SJIS_TO_EUC,line)
	if /^(?:\+OK|-INCR)\s+(\d+)/ =~ line
	  next
	end
	
	if i< @start
	  i+=1
	  next
	end

	line.strip!	

#	line = replace_char(line)
#	(name,mailto,date_id,body,title)=line.split(/<>/)
	
	(name,mailto,date_id,body,title)= replace_char(line).split(/<>/)

#	frame = MessageFrame::new(i,name,mailto,date_id,body)
#	vbox_view.pack_start frame,false,false

	vbox_view.pack_start MessageFrame::new(i,name,mailto,date_id,body),false,false

      rescue
      end

      j+=1
      if j>=@view_num
	break
      end

      i+=1

#	M.Suzuki
      while Gtk.events_pending
	@sw.show_all
#	if  $num_of_background_threads == 0
	  Gtk.main_iteration
#	end
      end
    end 

    # ɽΥܥ
    hbox = Gtk::HBox.new false,10

    one_button = Gtk::Button.new('1-')
    prev_button = Gtk::Button.new('Prev')
    next_button = Gtk::Button.new('Next')
    new_button = Gtk::Button.new('ǿ')
    reload_button = Gtk::Button.new('ɹ')

    hbox.pack_start one_button
    hbox.pack_start prev_button
    hbox.pack_start next_button
    hbox.pack_start new_button
    hbox.pack_start reload_button

    if @start > 1
      one_button.set_sensitive true
      prev_button.set_sensitive true
    else
      one_button.set_sensitive false
      prev_button.set_sensitive false
    end

    if @start+@view_num-1 < @size
      next_button.set_sensitive true
    else
      next_button.set_sensitive false
    end

    if @view_num < @size
      new_button.set_sensitive true
    else
      new_button.set_sensitive false
    end

    # activate_ۥ Ȥ̾ɤʤΤǤΤѹ뤳
    one_button.signal_connect('clicked'){
#      VVBOX.activate_one_item
#      self.set_start(1)
#      self.remake_view
      self.activate_one_item
    }
    prev_button.signal_connect('clicked'){
#      VVBOX.activate_prev_item
#      self.set_start(self.get_start-self.get_view_num)
#      self.remake_view      
      self.activate_prev_item
    }

    next_button.signal_connect('clicked'){
#      VVBOX.activate_next_item
#      self.set_start(self.get_start+self.get_view_num)
#      self.remake_view      
      self.activate_next_item
    }


    new_button.signal_connect('clicked'){
#      VVBOX.activate_new_item
#      self.set_start(self.get_size-self.get_view_num+1)
#      self.remake_view
      self.activate_new_item
    }
      
    reload_button.signal_connect('clicked'){
#      VVBOX.activate_reload_item
=begin
      tmp = self.get_thread.load_file
      self.set_file(tmp,self.get_thread.get_file)
      tmp = self.get_thread.get_title  + " (#{self.get_size})"
      VVBOX.set_title(tmp)
      VVBOX.set_notebook_page(self)
=end
      self.activate_reload_item
    }

    vbox_view.pack_start hbox,false,false
#    @sw.add_with_viewport vbox_view
    @sw.show_all
    VVBOX.pop_entry_text    
    GC.enable
    GC.start
  end

  def activate_one_item
    self.set_start(1)
    self.remake_view
  end

  def activate_prev_item
    self.set_start(self.get_start-self.get_view_num)
    self.remake_view      

  end

  def activate_next_item
    self.set_start(self.get_start+self.get_view_num)
    self.remake_view      
  end

  def activate_new_item
    self.set_start(self.get_size-self.get_view_num+1)
    self.remake_view
  end

  def activate_reload_item
    pre_size=nil
=begin
    if $config['background_get']
      $mutex_for_thread.lock
      $num_of_background_threads +=1
      $mutex_for_thread.unlock
      thread=Thread.start{
	pre_size=@thread.load_file
	$mutex_for_thread.lock
	$num_of_background_threads -=1
	$mutex_for_thread.unlock
      }
      while thread.alive?
	sleep 0.05
      end
    else
=end
      pre_size = self.get_thread.load_file
#    end
    if pre_size
      self.set_file(pre_size,self.get_thread.get_file)
      tmp = self.get_thread.get_title  + " (#{self.get_size})"
      VVBOX.set_title(tmp)
      VVBOX.set_notebook_page(self)
    end
  end

  def remake_view
    sw = Gtk::ScrolledWindow.new(nil,nil)
    self.set_sw(sw)
#    self.set_file
    self.make_view
    VVBOX.set_item
  end

  def set_file(start=nil,file=nil)
    GC.disable

    if start
      self.set_start(start)
    end

    if file
      @file =file
    end

    @file.rewind
    @size=0

    while line=@file.gets
      if /^(?:\+OK|-INCR)\s+(\d+)/ =~ NKF::nkf(NKF_SJIS_TO_EUC,line)
	next
      end
      @size+=1
    end
    @file.rewind

    GC.enable
    GC.start
  end
end



#ThreadƤ򸫤Box
class ViewVBox < Gtk::VBox


  def initialize()
    super(false,0)
    


    
    @sessions=[]
   
    #˥塼  Item
    @mbar = Gtk::MenuBar.new
    @file_item = Gtk::MenuItem.new('File')
    @file_menu = Gtk::Menu.new

#Thanks: >> 63
    @toziru_item = Gtk::MenuItem.new('Ĥ')
    @file_menu.add @toziru_item

    @quit_item = Gtk::MenuItem.new('Quit')
    @file_menu.add @quit_item
    @file_item.set_submenu @file_menu
    @mbar.append @file_item

    @one_item = Gtk::MenuItem.new('1-')
    @mbar.append @one_item

    
    @prev_item = Gtk::MenuItem.new('Prev')
    @mbar.append @prev_item
    @next_item = Gtk::MenuItem.new('Next')
    @mbar.append @next_item

    @new_item = Gtk::MenuItem.new('ǿ')
    @mbar.append @new_item

    @reload_item = Gtk::MenuItem.new('ɹ')
    @mbar.append @reload_item

    @url_item = Gtk::MenuItem.new('URLɽ')
    @mbar.append @url_item

    @check_new_item = Gtk::CheckMenuItem.new('   ɽ')
    if !$config['show_old_message']
      @check_new_item.activate
    end
    @mbar.append @check_new_item

    @bookmark_item = Gtk::MenuItem.new('֥åޡɲ')
    @mbar.append @bookmark_item

    @kakikomi_item = Gtk::MenuItem.new('񤭤')
    @mbar.append @kakikomi_item

    self.pack_start @mbar, false, false, 0

    @title_label = Gtk::Label.new('')
    @title_label.set_name "TitleLabel"

    self.pack_start @title_label,false,false,0

    @entry = Gtk::Entry.new
    self.pack_start @entry,false,false,0
    @entry.set_editable(true)
    
    @entry_text_stack = []

    # Ρȥ֥å
    @notebook = Gtk::Notebook::new()
#    @notebook.set_usize $config['view_width'], $config['height']
    @notebook.set_usize VIEW_WIDTH, HEIGHT
    @notebook.set_scrollable(true)
    @notebook.popup_enable

#    if !$error_of_switch_page
    unless ERROR_OF_SWITCH_PAGE
      # 0.27 0.28(4/19snapshot) Ǥ switch_page signal connect
      # 
      # http://sourceforge.net/tracker/?func=detail&atid=415644&aid=534381&group_id=35786
      @notebook.signal_connect_after("switch_page") { |widget, page, num_page|
#	if ! $init
	self.page_switch(widget, page, num_page)
#	end
      }
    end

    self.pack_start @notebook

    # item

    self.set_item

    @url_item.signal_connect('activate'){
#      if @v_thread
      page = @notebook.cur_page
      if page
	if page.child
	  @entry.set_text page.child.get_thread.get_url
	end
      end
    }


    @quit_item.signal_connect('activate'){
#      exit
      Gtk.main_quit
    }

    @next_item.signal_connect('activate'){
      self.activate_next_item
    }

    @one_item.signal_connect('activate'){
      self.activate_one_item
    }



    @prev_item.signal_connect('activate'){
      self.activate_prev_item
    }

    @new_item.signal_connect('activate'){
      self.activate_new_item
    }

    @reload_item.signal_connect('activate'){
      self.activate_reload_item
    }

    @bookmark_item.signal_connect('activate'){
#      if @v_thread
      page = @notebook.cur_page
      if page
	if page.child
	  title=NKF::nkf(NKF_EUC_TO_SJIS,page.child.get_thread.get_title)
	  url = page.child.get_thread.get_url
	  if $bookmarks_board 
	    page.child.get_thread.set_special($bookmarks_board)
	    $bookmarks_board.append_thread page.child.get_thread
	    $bookmarks_board.get_item.set_bookmarks_item
	    write_bookmarks($bookmarks_array,BOOKMARKS_FILE)
	  end
	end 
      end
    }

    @kakikomi_item.signal_connect('activate'){
#      if @v_thread
#	window = PostWindow.new(@v_thread.get_thread)
#      end
      page = @notebook.cur_page
      if page
	if page.child
	  window = PostWindow.new(page.child.get_thread)
	end
      end

    }

    @toziru_item.signal_connect('activate'){
      page = @notebook.cur_page
      if page
	v_thread = page.child
	while v_thread
	  @notebook.remove_page(@notebook.page_num(v_thread))
	  if @notebook.get_current_page == -1
	    v_thread= nil
	  else
	    v_thread=@notebook.cur_page.child
	  end
	end
      end
      @sessions = []
      self.write_sessions
      self.set_item
    }



    @entry.signal_connect('activate') {|widget|
      text = @entry.get_text
      text.strip!
      exec_entry_text(text)
    }
  end


  def activate_reload_item
    page = @notebook.cur_page
    if page
      if page.child
	page.child.activate_reload_item
      end
    end
  end

  def activate_one_item
    page = @notebook.cur_page
    if page
      if page.child
	page.child.activate_one_item
      end
    end
  end

  def activate_new_item
    page = @notebook.cur_page
    if page
      if page.child
	page.child.activate_new_item
      end
    end
  end

  def activate_prev_item
    page = @notebook.cur_page
    if page
      if page.child
	page.child.activate_prev_item
      end
    end
  end

  def activate_next_item
    page = @notebook.cur_page
    if page
      if page.child
	page.child.activate_next_item
      end
    end
  end


  # entryΥƥȤ(UrlMenuItemǤ)
  def exec_entry_text(text)
    if text == "" || !text 
      return
    end

    host,port,path=parse_http_url(text)

    if host
      if /^ttp/ =~ text
	text = "h" +text
      end

      internal=false
      catch(:tag) do
	if /\.(2ch|bbspink)\./=~ host 
	  if %r!^(.*/test/read\.cgi/.+?/[0-9]+?/).*! =~ text
	    text = $1
	    
	  elsif %r!^(.*/test/read\.cgi)\?(.*)! =~ text
	    base = $1
	    tmp = $3
	    if /bbs=([^&]+)&.*key=([^&]+)/i =~ tmp
	      bbs = $1
	      key = $2
	    elsif  /key=([^&]+)&.*bbs=([^&]+)/i =~ tmp
	      bbs = $2
	      key = $1
	    else
	      throw :tag
	    end
	    text = base+"/"+bbs+"/"+key+"/"
	  else
	    throw :tag
	  end
	  internal=true
	  thread = Thread2ch.new("",text,nil,false)
	  pre_size=thread.load_file
	  if pre_size
	    if thread.get_file
	      VVBOX.set_thread(thread,pre_size)
	    end
	  end
	end
      end
      if !internal
	fork do
	  $SAFE = 2
	  if $config['http_command']
	    tmp =$config['http_command'].dup
	    text.gsub!(/\'/,'\\\'')
	    tmp.sub!('%u','\''+text+'\'')
	    tmp.untaint
	    exec(tmp)
	  end
	end
      end
    end

#    unless @v_thread
#      return
#    end

    page = @notebook.cur_page
    unless page
      return
    end
    unless page.child
      return
    end
    v_thread = page.child
    
    text.sub!(">>","")
    text.strip!
    _size=v_thread.get_size
      
    if text =~ /^(\d+)$/
      start = Integer($1)
      if start <= _size && start > 0
	v_thread.set_start(start)
	v_thread.set_view_num(1)
	self.set_notebook_page(v_thread)
      end
    elsif text =~ /^(\d+)\s*-$/
      start = Integer($1)
      if start < _size && start > 0
	v_thread.set_start(start)	  
      end
      self.set_notebook_page(v_thread)
    elsif text =~ /^(\d+)\s*-\s*(\d+)$/
      start = Integer($1)
      stop = Integer($2)
      view_num = stop - start + 1
      if start <= _size && start > 0 && view_num > 0
	v_thread.set_start(start)
	v_thread.set_view_num(view_num)  
	self.set_notebook_page(v_thread)
      end
    end

  end

  def get_check_new_item
    return @check_new_item 
  end

  def push_entry_text(text)
    @entry_text_stack.push(@entry.get_text)
    @entry.set_text(text)
    if $display_status_iterationp
# && !$config['background_get']
      while Gtk.main_iteration()
      end
    end 

  end 

  def pop_entry_text
    text=@entry_text_stack.pop
    @entry.set_text(text)
  end 

  
  def set_thread(thread,start)
    sw = Gtk::ScrolledWindow.new(nil,nil)
    v_thread = ViewThreadVBox.new(thread)
    v_thread.set_sw(sw)
    v_thread.set_file(start)
    self.set_notebook_page(v_thread)
  end

  def get_notebook
    return @notebook
  end

  # ΡȤΥڡ
  def set_notebook_page(v_thread)

#    self.set_item

    tmp =@notebook.page_num(v_thread)
    if tmp == -1
      v_thread.make_view

      tmp = v_thread.get_thread.get_title + " (#{v_thread.get_size})"

      hbox =create_tab_label(tmp,v_thread)
      hbox.show_all

      @notebook.append_page_menu(v_thread,hbox,Gtk::Label.new(tmp))

#      if ! $init && $config['set_last_page']
      if ! $init  && SET_LAST_PAGE
	@notebook.set_page(-1)
      end

      @sessions <<  v_thread.get_thread
      self.write_sessions
    else
      sw = Gtk::ScrolledWindow.new(nil,nil)
      v_thread.set_sw(sw)
#      @v_thread.set_file
      v_thread.make_view
    end
  end
=begin
  def set_page_switch(boolean)
    @flag_page_switch = boolean
  end
=end
# sessions եν񤭤
  def write_sessions
    open(SESSIONS_FILE,'w') { |file|
      str=""
      @sessions.each{ |thread|
	if thread.get_dat 
	  str +=  "S #{thread.get_url} #{thread.get_title}\n"
	else
	  str += "T #{thread.get_url} #{thread.get_title}\n"	
	end
      }
      file.print NKF::nkf(NKF_EUC_TO_SJIS,str)

    }
  end 


#  餯Ȥʤʤ
  def append_str_to_file(str,filename)
    open(filename,'a') { |file|
      file.print "#{str}\n"
    }
  end 

    
# notebookΥ֤Υ٥κ
  def create_tab_label(str,v_thread)
    hbox = Gtk::HBox.new false,5
#    trunc = trunc_string(str,$title_string_trunc)
#    trunc = trunc_string(str,$config['tab_string_size'])
    trunc = trunc_string(str,TAB_STRING_SIZE)
    label = Gtk::Label.new(trunc)
    label.set_name "NotebookTab"
    hbox.pack_start label
    button = Gtk::Button.new
#    button.add Gtk::Pixmap.new($batu_pix, $batu_mask)
    button.add Gtk::Pixmap.new(BATU_PIX, BATU_MASK)
    button.signal_connect('clicked'){
      num = @notebook.page_num(v_thread)
      @notebook.remove_page(@notebook.page_num(v_thread))
#      @sessions.delete(v_thread.get_thread)
      @sessions.delete_at(num)

      

      self.write_sessions
=begin
      if @notebook.get_current_page == -1
	@v_thread= nil
      else
	@v_thread=@notebook.cur_page.child
      end
=end
      self.set_item
    }
      

    hbox.pack_start button,false,false
    hbox.show_all
    return hbox
  end


#˽Ф?
  def trunc_string(str,trunc)

     if  /^(.{1,#{trunc}}).*$/ =~ str
       return $1
     else
       return str
     end
  end

#notobookΥڡäȤν
  def page_switch(widget, page, page_num)
    oldpage = @notebook.cur_page
    if (page == oldpage)
      return
    end

    v_thread=page.child
    self.set_title(v_thread.get_thread.get_title+ " (#{v_thread.get_size})")
    self.set_item
  end


  def set_title(title)
    @title_label.set title
  end

  def get_new_item
    return @new_item
  end

  def get_one_item
    return @one_item
  end

  def get_prev_item
    return @prev_item
  end

  def get_next_item
    return @next_item
  end


# menu_item
  def set_item
    page = @notebook.cur_page
    if page
      v_thread=page.child
    else
      v_thread=nil
    end

    unless v_thread
      @one_item.set_sensitive false
      @prev_item.set_sensitive false
      @next_item.set_sensitive false
      @new_item.set_sensitive false
      @reload_item.set_sensitive false
      @url_item.set_sensitive false
      @bookmark_item.set_sensitive false
      @kakikomi_item.set_sensitive false
      @toziru_item.set_sensitive false
      return
    end

    @reload_item.set_sensitive true
    @url_item.set_sensitive true
    @bookmark_item.set_sensitive true
    @kakikomi_item.set_sensitive true
    @toziru_item.set_sensitive true

    start= v_thread.get_start
    view_num=v_thread.get_view_num
    size=v_thread.get_size

    if start > 1
      @one_item.set_sensitive true
      @prev_item.set_sensitive true
    else
      @one_item.set_sensitive false
      @prev_item.set_sensitive false
    end

    if view_num < size
      @new_item.set_sensitive true
    else
      @new_item.set_sensitive false
    end

    if start+view_num-1 < size
      @next_item.set_sensitive true
    else
      @next_item.set_sensitive false
    end
  end
=begin
  def set_start (start)

    view_num=@v_thread.get_view_num
    size=@v_thread.get_size

    if  start < @size
      if start+@view_num < 1
	@v_thread.set_start(1)
      else
	@v_thread.set_start(start)
      end
    end
  end

  def set_view_num(num)
    if num > 0
      @v_thread.set_view_num( num)
    end
  end
=end
end 

#åɤ
class Thread2ch
  include GetThread2ch

  def initialize(title,url_base,dat_file,dat,special=false)
    title = replace_char(title)
    @special = special
    @title_and_size = title
    if @special
      @title = title
    else
      @title = title.gsub(/\s+\(\d+\)\s*$/,"")
    end
    @dat = dat
    @bbs = nil
    @key = nil
    @base_path = nil
    if dat_file
      if @dat
	@url = url_base + dat_file
      else
	@url = url_base + dat_file.sub("\.dat$","")+"/"
      end
    else
      url_base.strip!
      @url = url_base
    end



    @file= nil
    @size= 0
    @num_of_statement= 0

    @host,@port,@path = parse_http_url(@url)
    if @host
      @filename = BASE_DIR + "thread/"+ @host + "_" + "#{@port}" + "_" + @path.gsub("/","_")
    # initializeΰ鸫ľ
    # 
      if %r!^(/.*)/(.+?)/(.+?)/?$! =~ @path
	tmp = $1
	@bbs = $2
	@key = $3.sub("\.dat$","")
	@base_path = tmp.sub("test/read\.cgi$","")
      else
	STDERR.print "URL: #{@url}\n"
      end
    else
      @filename =nil
      STDERR.print "бƤURLǤϤޤ: #{@url}\n"
    end

  end

  def get_special
    return @special
  end

  def set_special(special)
    @special = special
  end



  def get_bbs
    return @bbs
  end

  def get_key
    return @key
  end

  def get_base_path
    return @base_path
  end

  def set_title(title)
    @title = title
  end


  def get_title
    return @title
  end

  def set_title_and_size(title)
    @title_and_size = title
  end


  def get_title_and_size
    return @title_and_size
  end

  def get_dat
    return @dat
  end


  def get_url
    return @url
  end

  def get_host
    return @host
  end
  def get_port
    return @port
  end
  def get_path
    return @path
  end
  def get_filename
    return @filename
  end


  def get_file
    return @file
  end

  def load_file
=begin
    $mutex_for_get.lock
    if $filenames_in_getting.include?(self.get_filename)
      STDERR.print "Ʊե #{self.get_filename} ɤߤǤޤ\nThreadɹߤޤ.\n"
      $mutex_for_get.unlock
      return nil
    end
    $filenames_in_getting << self.get_filename
    $mutex_for_get.unlock
=end
    VVBOX.push_entry_text('Threadɹ')
#	M.Suzuki	Gtk-0.27ʹߤ餷
#	$main_window.window.set_cursor(Gdk::Cursor.new(Gdk::WATCH))
    @file,pre_size = get_thread_file(self)
=begin
    $mutex_for_get.lock
    $filenames_in_getting.delete(self.get_filename)
    $mutex_for_get.unlock
=end

#	M.Suzuki	Gtk-0.27ʹߤ餷
#    $main_window.window.set_cursor(Gdk::Cursor.new(Gdk::ARROW))
    
    if !pre_size || pre_size==0 
      size=1
    end
    VVBOX.pop_entry_text
    if VVBOX.get_check_new_item.active?
      return pre_size
    end 
    return 1
  end

  def set_size(size)
    @size = size
  end

  def get_size
    return @size 
  end


  def set_num_of_statement(num)
    @num_of_statement = num
  end

  def get_num_of_statement
    return @num_of_statement
  end

end

#Ĥ
class Board2ch
  include GetBoardSubject2ch

  def initialize(title,url,dat,special=false)
    @title = title
    @url = url
    @host,@port,@path = parse_http_url(@url)
    @special=special
    if @host
      @filename = BASE_DIR + "subject/"+ @host + "_" + "#{@port}" + "_" + @path.gsub("/","_")
    else
      @filename =nil
      if @special ==false
	STDERR.print "бƤURLǤϤޤ: #{@url}\n"
      end 
    end
      
    @dat = dat
    @thread_array=[]
    @item = nil
  end

  def get_item
    return @item
  end

  def set_item(item)
    @item = item
  end

  def get_special
    return @special
  end

  def append_thread(thread)
    @thread_array << thread
  end

  def delete_thread(thread)
    @thread_array.delete(thread)
  end


  def get_thread_array
    return @thread_array
  end

  def set_filename(filename)
    @filename = filename
  end

  def get_title
    return @title
  end

  def get_url
    return @url
  end

  def get_host
    return @host
  end
  def get_port
    return @port
  end
  def get_path
    return @path
  end
  def get_filename
    return @filename
  end

  def get_dat
    return @dat
  end

end

#ѤTreeItem
class BoardTreeItem < Gtk::TreeItem

  def initialize(board)
    @board=board    
    super(@board.get_title)
    self.set_name "BoardTreeItem"
    @num_of_thread=0
    @subtree=nil
    @special = @board.get_special

    @board.set_item self
    self.signal_connect('select') { 
      if @special
      else
#	GC.disable
=begin
	if $config['background_get']
	  $mutex_for_thread.lock
	  if !SVBOX.sensitive?
	    $mutex_for_thread.unlock
	    break
	  end
	  SVBOX.set_sensitive false
	  $num_of_background_threads +=1
	  $mutex_for_thread.unlock
#	  $display_status_iterationp = false
	  thread=Thread.start{
	    self.get_board_subject
	    $mutex_for_thread.lock
	    $num_of_background_threads -=1
	    SVBOX.set_sensitive true
	    $mutex_for_thread.unlock
	  }
	  while thread.alive?
	    sleep 0.05
	  end
#	  $display_status_iterationp = true

	else
=end
	  self.get_board_subject
#	end
      end
      self.expand
#      GC.enable
#      GC.start
    }
    @destroyed=false
    self.signal_connect('destroy'){
      @destroyed=true
    }
  end



  def set_bookmarks_item
    if @destroyed
      return
    end

    array = @board.get_thread_array
    if array  != [] 
      subtree = Gtk::Tree.new
      self.set_subtree subtree
      i=0
      array.each{ |thread|
	thread_item = Gtk::ThreadTreeItem.new(thread,self)
	subtree.append thread_item
	thread_item.show_all
	i+=1
      }
      self.set_num_of_thread(i)
    end 
    self.show_all
    self.expand
  end

  def get_board_subject

=begin
    $mutex_for_get.lock
    if $filenames_in_getting.include?(@board.get_filename)
      STDERR.print "Ʊե #{@board.get_filename} ɤߤǤޤ\nSubjectɹߤޤ.\n"
      $mutex_for_get.unlock
      return
    end
    $filenames_in_getting << @board.get_filename
    $mutex_for_get.unlock
=end
    VVBOX.push_entry_text('Subjectɹ')
    file = @board.get_board_subject_file(@board)
=begin
    $mutex_for_get.lock
    $filenames_in_getting.delete(@board.get_filename)
    $mutex_for_get.unlock
=end
    unless file
      return
    end
    
    file.rewind

    subtree = Gtk::Tree.new

    if @board.get_port == 80
      url = "http://" + @board.get_host 
    else
      url = "http://" + @board.get_host + ":#{@board.get_port}" 
    end

    path = @board.get_path 
    

    if @board.get_dat
      url += path + "dat/"
    else
      if /^(\/.*)(\/.+)$/i =~ path
	url += $1
	path = $2
      end
      url += "/test/read.cgi" + path
    end

#   subtree㤦褬
#    self.set_subtree subtree
#    self.expand
    i=0
    file.each{ |line|
#      line.chop!
#      line=Kconv::kconv(line,Kconv::EUC,Kconv::SJIS)
#      line=NKF::nkf(NKF_SJIS_TO_EUC,line.chop!)

#      if /<>/ =~ line
      if /<>/ =~ NKF::nkf(NKF_SJIS_TO_EUC,line.chop!)
	thread = Thread2ch.new(unquote($'),url,$`,@board.get_dat)

	@board.append_thread thread
	thread_item = Gtk::ThreadTreeItem.new(thread,self)
	subtree.append thread_item
	thread_item.show
# M.Suzuki
#	unless $config['background_get']
	  while Gtk.events_pending
#	    self.show_all
	    
#	    if  $num_of_background_threads == 0
	    Gtk.main_iteration
#	    end
	  end
#	end
	i+=1      
      end
    }
    self.set_num_of_thread(i)
    file.close
    self.set_subtree subtree
    self.show_all
    VVBOX.pop_entry_text
  end


  def get_board
    return @board
  end

  def set_num_of_thread(num)
    @num_of_thread=num
  end
  def get_num_of_thread
    return @num_of_thread
  end

  def set_subtree(subtree)
    if @subtree
      begin
	@subtree.clear_items 0,@num_of_thread
      rescue ArgumentError
      end
    end
    @subtree=subtree
    super
  end
end

#ThreadѤTreeItem
class ThreadTreeItem < Gtk::TreeItem

  def initialize(thread,board_item)
    @thread=thread
    @board_item = board_item
    super(@thread.get_title_and_size)
    self.set_name "ThreadTreeItem"

    tooltips = Gtk::Tooltips.new()
    tooltips.set_tip(self,@thread.get_title_and_size,"")
#    tooltips.set_delay($config['thread_tooltips_delay'])
    tooltips.set_delay(THREAD_TOOLTIPS_DELAY)
    self.signal_connect('select') { 

#signal_connectΤʤǥåɺäʤɤƤΤΤ?
#̤ThreadؿǤ餻뤫?
#      GC.disable
=begin
      if $config['background_get']
#	$display_status_iterationp = false

	

	$mutex_for_thread.lock
	if !SVBOX.sensitive?
	  $mutex_for_thread.unlock
	  break
	end
	SVBOX.set_sensitive false
	$num_of_background_threads +=1
	$mutex_for_thread.unlock
	thread=Thread.start{
	  pre_size=@thread.load_file
	  $mutex_for_thread.lock
	  $num_of_background_threads -=1
	  SVBOX.set_sensitive true
	  $mutex_for_thread.unlock
	  if pre_size
	    if @thread.get_file
	      VVBOX.set_thread(@thread,pre_size)
	    end
	  end
	}
	while thread.alive?
	  sleep 0.05
#	  Gtk.main_iteration()
	end


#	$display_status_iterationp = true
      else
=end
	pre_size=@thread.load_file
	if pre_size
	  if @thread.get_file
	    VVBOX.set_thread(@thread,pre_size)
	  end
	end
#      end
#      VVBOX.set_page(-1)
#      GC.enable
#      GC.start
    }
    self.signal_connect('button_press_event'){|w,e|
      if e.instance_of?(Gdk::EventButton) &&  e.button==3
	if @thread.get_special
	  menu = Gtk::Menu.new
	  menu.signal_connect_after('button_press_event'){
	    menu.popdown
	  }
	  item = Gtk::MenuItem.new('Menu')
	  menu.append item
	  separator = Gtk::MenuItem.new()
	  menu.append separator

	  toziru_item = Gtk::MenuItem.new('Ĥ')
	  menu.append toziru_item
	  
	  toziru_item.signal_connect('button_press_event'){|w,e|
	    @board_item.collapse
	  }
	  sakuzyo_item = Gtk::MenuItem.new('')
	  menu.append sakuzyo_item
	  
	  sakuzyo_item.signal_connect('button_press_event'){|w,e|
	    @thread.get_special.delete_thread(@thread)
	    @board_item.set_bookmarks_item
	    write_bookmarks($bookmarks_array,BOOKMARKS_FILE)
	  }

	  menu.popup(nil, nil, nil, e.button, e.time)
	  menu.show_all

	else
	  @board_item.collapse
	end
      end
    }

  end
  def get_thread
    return @thread
  end

end

class SelectionVBox < Gtk::VBox

  def initialize(board_file_array)

    @board_hash = Hash.new
    @category_array = []
    @sw=nil
    $bookmarks_board =nil

    $bookmarks_array=[]

    bookmarks_flag=true
    board_file_array.each { |board_file|
      while line = board_file.gets

	line=NKF::nkf(NKF_SJIS_TO_EUC,line).strip

	case line
	when /^C\s+(.+)/
	  category = $1.strip
	  @category_array.push category
	  @board_hash[category] = []
	  if bookmarks_flag
	    $bookmarks_array << "C #{category}"
	  end

	when /^D\s+(.+)/
	  board = Board2ch.new($1,"",false,true)
	  unless category
	    category= make_bookmarks_category
	  end
	  @board_hash[category] << board
	  $bookmarks_board =board
	  if bookmarks_flag
	    $bookmarks_array << board
	  end

	when /^T\s+(\S+)\s+(.+)/
	  if  $bookmarks_board == nil &&  bookmarks_flag
	    category,board = make_bookmarks_board(category)
	  end
	  thread = Thread2ch.new($2.strip,$1,nil,false,$bookmarks_board)
	  $bookmarks_board.append_thread thread

	when /^S\s+(\S+)\s+(.+)/
	  if  $bookmarks_board == nil &&  bookmarks_flag
	    category,board = make_bookmarks_board(category)
	  end
	  thread = Thread2ch.new($2.strip,$1,nil,true,$bookmarks_board)
	  $bookmarks_board.append_thread thread

	when /^B\s+(\S+)\s+(.+)/
	  if ENABLE_GZIP
	    board = Board2ch.new($2.strip,$1,false)
	  else
	    board = Board2ch.new($2.strip,$1,true)
	  end
	  @board_hash[category] << board
	  if bookmarks_flag
	    $bookmarks_array << board
	  end

	when /^A\s+(\S+)\s(.+)/
	  board = Board2ch.new($2.strip,$1,true)
	  @board_hash[category] << board
	  if bookmarks_flag
	    $bookmarks_array << board
	  end
	else
	  if bookmarks_flag
	    $bookmarks_array << line
	  end
	end
      end
      if bookmarks_flag
	if $bookmarks_board == nil
	  p "aa"
	  category,board = make_bookmarks_board(category)
	end
      end
      bookmarks_flag=false
      board_file.close
    }

    category = KENSAKU_KEKKA
    @category_array.push category
    @board_hash[category] = []
    
    @cur_category = @category_array[0]
    super(false,0)

    @combo = Gtk::Combo.new
    @combo.entry.set_editable(false)
    @combo.set_popdown_strings(@category_array)

#    @combo.entry.add_events( Gdk::ALL_EVENTS_MASK)
    @combo.entry.add_events( Gdk::KEY_RELEASE_MASK)


    @combo.entry.signal_connect('key_release_event'){
      @cur_category = @combo.entry.get_text
      self.set_sw
    }

    @combo.list.signal_connect('button_release_event'){
      @cur_category = @combo.entry.get_text
      self.set_sw
    }

#    @combo.entry.signal_connect('changed'){
#      unless @combo.list.visible?
#	@cur_category = @combo.entry.get_text
#	self.set_sw
#      end
#    }


    self.pack_start @combo,nil


    entry = Gtk::Entry.new
    self.pack_start entry,false,false,0
    entry.set_editable(true)
    self.show_all
    entry.signal_connect('activate'){ |widget|
      text=entry.get_text.strip
      if text == ""
	break
      end 
      re = Regexp.new(text,true)

      kensaku_board = Board2ch.new(KENSAKU_KEKKA + ': ' + text,"","",true)
      item = Gtk::BoardTreeItem.new(kensaku_board)
      @board_hash[@cur_category].each{ |board|
	board.get_thread_array.each{|thread|
	  if re =~ thread.get_title_and_size
	    kensaku_board.append_thread(thread)
	  end
	}
      }
      if kensaku_board.get_thread_array == []
	VVBOX.push_entry_text('ޥåThreadϤޤǤ')
      else
	@board_hash[KENSAKU_KEKKA] << kensaku_board
	@combo.entry.set_text(KENSAKU_KEKKA)
	# 3ĤǤƤ뤫
	@cur_category = @combo.entry.get_text
	self.set_sw
      end
    }



    self.set_sw

  end
  
  def make_bookmarks_board(category)
    board = Board2ch.new('ThreadΥ֥åޡ',"",false,true)
    unless category
      category= make_bookmarks_category
    end
    @board_hash[category] << board
    $bookmarks_board = board
    $bookmarks_array << board
    return category,board
  end

  def make_bookmarks_category
    category = ''
    @category_array.push category
    @board_hash[category] = []
    $bookmarks_array << "C #{category}"
    return category
  end

  def set_sw
    GC.disable

    if @sw
      self.remove @sw
    end
    @sw = set_tree(@board_hash[@combo.entry.get_text])
    self.pack_start @sw      
    @sw.show_all
    
    GC.enable
    GC.start

  end

  def set_tree(hash)
    @tree = Gtk::Tree.new
    @tree_size=0

    sw =  Gtk::ScrolledWindow.new()
#    sw.set_usize $select_width,$select_height
#    sw.set_usize $config['select_width'],$config['height']
    sw.set_usize SELECT_WIDTH,HEIGHT
    sw.add_with_viewport @tree   

    @tree.clear_items 0,@tree_size
    @tree_size=0
    hash.each{ |board|
      @tree_size+=1

      item = Gtk::BoardTreeItem.new(board)
      @tree.append item
      array = board.get_thread_array
      if array  != []
	subtree = Gtk::Tree.new
	item.set_subtree subtree
	i=0
	array.each{ |thread|
	  thread_item = Gtk::ThreadTreeItem.new(thread,item)
	  subtree.append thread_item
	  thread_item.show_all
	  i+=1
	}
	item.set_num_of_thread(i)
	item.show_all
      end 
    }
    @tree.show_all

    return sw
  end

end

board_info = BASE_DIR + "board_info"

if File.exist?(board_info)
  file = open(board_info,'r')
=begin
else
  BASE_DIR = ENV["HOME"]+ "/.2ch_ruby_gtk/"
  board_info = BASE_DIR + "board_info"
  if File.exist?(board_info)
    file = open(board_info,'r')
    STDERR.print "~/.2ch_ruby_gtk ǥ쥯ȥ ~/.goRua_2ch ˰ưƤ\n ~/.2ch_ruby_gtk ϥݡȤʤʤޤ\n"
  else
    STDERR.print "not found: ~/.goRua_2ch/board_info and ~/.2ch_ruby_gtk/board_info. see README.\n"
    exit
  end
=end
else
  STDERR.print "not found: ~/.goRua_2ch/board_info. see README.\n"
end

BOOKMARKS_FILE = BASE_DIR + "bookmarks"
SESSIONS_FILE = BASE_DIR + "sessions"
sessions_backup = BASE_DIR + "sessions_backup"


MAIN_WINDOW = Gtk::Window.new(Gtk::WINDOW_TOPLEVEL)
MAIN_WINDOW.set_title("goRua -- Gtk+ on Ruby User Agent for 2ch version #{GORUA_VERSION}")

# Thanks : honeto@mail.goo.ne.jp 
#hbox = Gtk::HBox.new(false,0)
hpaned = Gtk::HPaned.new

VVBOX = ViewVBox.new()

file_array=[]
if File.exist?(BOOKMARKS_FILE)
  bm_file = open(BOOKMARKS_FILE)
  file_array << bm_file
else
  bm_file = open(BOOKMARKS_FILE,'w+')
end 
file_array << file
SVBOX = SelectionVBox.new(file_array)

# Thanks : honeto@mail.goo.ne.jp 
#hbox.pack_start SVBOX,nil
#hbox.pack_start VVBOX
#window.add hbox
hpaned.pack1 SVBOX, nil, true
hpaned.pack2 VVBOX, nil, true
MAIN_WINDOW.add hpaned


MAIN_WINDOW.show_all
# $batu_pix, $batu_mask =
BATU_PIX, BATU_MASK =
  Gdk::Pixmap::create_from_xpm_d(MAIN_WINDOW.window, nil, BATU_XPM)

# Thanks: >>73
MAIN_WINDOW.signal_connect('destroy') {
  exit
#  Gtk.main_quit
}

# $key_press_in_text = false

MAIN_WINDOW.signal_connect_after('key_press_event') { |w,event|
=begin      
  if $key_press_in_text
    $key_press_in_text = false
    break
  end
=end
  notebook = VVBOX.get_notebook
  page = notebook.cur_page
  if page && page.child
    v_thread=page.child
  else
    break
  end
  vadj = v_thread.get_sw.get_vadjustment
  
  tmp = vadj.value
  case event.keyval
  when Gdk::GDK_Up,Gdk::GDK_KP_Up
    tmp -= vadj.page_size/2
  when Gdk::GDK_Down,Gdk::GDK_KP_Down
    tmp  += vadj.page_size/2
  when Gdk::GDK_space,Gdk::GDK_KP_Space
    tmp  += vadj.page_size/2
  when Gdk::GDK_Page_Up,Gdk::GDK_KP_Page_Up
    tmp -=  vadj.page_size
  when Gdk::GDK_Page_Down,Gdk::GDK_KP_Page_Down
    tmp += vadj.page_size    
    else
#    Thanks: >>175
    break
  end
  if tmp > vadj.upper - vadj.page_size
    tmp =  vadj.upper - vadj.page_size
  end
  vadj.set_value(tmp)
}

$display_status_iterationp = false

if File.exist?(SESSIONS_FILE) 
  open(SESSIONS_FILE,'r'){ |file|
    open(sessions_backup,'w'){|backup|
      backup.write file.read
    }
  }
  if !$OPT_s
    $init = true
    open(SESSIONS_FILE,'r'){ |file|
      while line=file.gets
	line=NKF::nkf(NKF_TO_EUC,line)
	thread=nil
	line.strip!
	if  /^S\s+(\S+)\s+(.+)/ =~ line
	  thread = Thread2ch.new($2.strip,$1,nil,true)
	elsif  /^T\s+(\S+)\s+(.+)/ =~ line
	  thread = Thread2ch.new($2.strip,$1,nil,false)
	end
	if thread
	  pre_size=thread.load_file
	  if pre_size
	    if thread.get_file
	      VVBOX.set_thread(thread,pre_size)
	    end
	  end
	end
      end
    }
  end
end
$init = false
$display_status_iterationp = true
=begin
if $config['background_get']
  Thread.start{
    loop do
      sleep 0.01
      while $num_of_background_threads >0
#	sleep 0.01
	Gtk.main_iteration()	
      end
    end
  }
end
=end

Gtk.main
