<?php
  /**************************************************************************\
  * phpGroupWare - Inventory                                                 *
  * http://www.phpgroupware.org                                              *
  * Written by Joseph Engo <jengo@phpgroupware.org>                          *
  *            Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: class.inventory.inc.php,v 1.7 2001/05/01 02:16:37 bettina Exp $ */

    class inventory 
    {
	    var $db;
	    var $orders;
	    var $grants;
	    var $total_records;
	    var $status_id;

	function inventory() 
	{
		global $phpgw;
		$this->db		= $phpgw->db;
		$this->db2		= $this->db;
		$this->total_records	= $this->db->num_rows();
		$this->grants 		= $phpgw->acl->get_grants('inv');
		$this->status_id	= $this->get_status_id($status_name);
		$this->orders		= $this->read_orders($start, $limit, $query, $filter, $sort, $order);

	}

	function check_rights($id,$table='', $required_rights) 
	{
	    global $phpgw_info;

	    if ($table == 'cat') 
	    {
		$this->db->query("select cat_owner from phpgw_categories where cat_id='$id'");
		$this->db->next_record();

		if (! $this->check_perms($this->grants[$this->db->f('cat_owner')],$required_rights) && $this->db->f('cat_owner') != $phpgw_info['user']['account_id']) 
		{
		    return False;
		}
		else 
		{
		    return True;
		}
	    }
	    if ($table == 'order') 
	    {
		$this->db->query("select owner from phpgw_inv_orders where id='$id'");
		$this->db->next_record();

		if (! $this->check_perms($this->grants[$this->db->f('owner')],$required_rights) && $this->db->f('owner') != $phpgw_info['user']['account_id']) 
		{
		    return False;
		}
		else 
		{
		    return True;
		}
	    }
	}

	function check_perms($has, $needed) 
	{
	    return (!!($has & $needed) == True);
	}

	function read_orders($start, $limit, $query = '', $filter = '', $sort = '', $order = '',$status = 'active') 
	{
	    global $phpgw,$phpgw_info;

	    if ($status == 'archive') 
	    { 
		$statussort = " AND status='archive' "; 
	    }
	    else 
	    { 
		$statussort = " AND status != 'archive' "; 
	    } 

	    if (!$sort) 
	    { 
		$sort = "ASC";  
	    }

	    if ($order) 
	    { 
		$ordermethod = "order by $order $sort "; 
	    }
	    else 
	    { 
		$ordermethod = "order by num asc"; 
	    }

    	    if (! $filter) 
	    { 
		$filter = 'none'; 
	    }

    	    if ($filter != 'private') 
	    {
        	if ($filter != 'none') 
		{ 
		    $filtermethod = " access like '%,$filter,%' "; 
		}
        	else 
		{
        	    $filtermethod = " ( owner=" . $phpgw_info['user']['account_id'];
            	    if (is_array($this->grants)) 
		    {
			$grants = $this->grants;
                        while (list($user) = each($grants)) 
			{
                                        $public_user_list[] = $user;
                        }
                        reset($public_user_list);
                        $filtermethod .= " OR (access='public' AND owner in(" . implode(',',$public_user_list) . ")))"; 
		    }
                    else 
		    {
                	$filtermethod .= ' )';
                    }
        	}
    	    }
    	    else 
	    {
        	$filtermethod = ' owner=' . $phpgw_info['user']['account_id'] . ' ';
    	    }

	    if ($query) 
	    {
    		$querymethod = " AND (num like '%$query%' OR descr like '%$query%') ";
	    }

    	    $sql = "select * from phpgw_inv_orders WHERE $filtermethod $querymethod $statussort $ordermethod";

	    $this->db2->query($sql,__LINE__,__FILE__);
	    $this->total_records = $this->db2->num_rows();
	    $this->db->query($sql. " " . $this->db->limit($start),__LINE__,__FILE__);

	    $i = 0;
	    while ($this->db->next_record()) 
	    {
		    $orders[$i]['id']		= $this->db->f('id');
		    $orders[$i]['owner']	= $this->db->f('owner');
		    $orders[$i]['access']	= $this->db->f('access');
		    $orders[$i]['num']		= $this->db->f('num');
		    $orders[$i]['date']		= $this->db->f('date');
		    $orders[$i]['customer']	= $this->db->f('customer');
		    $orders[$i]['descr']	= $this->db->f('descr');
		    $orders[$i]['status']	= $this->db->f('status');
		    $i++;
    	    }
    	    return $orders;
	}

	function get_status_id($status_name='archive') 
	{
    	    global $phpgw;

            $this->db->query("SELECT status_id from phpgw_inv_statuslist WHERE status_name='archive'",__LINE__,__FILE__);
            $this->db->next_record();
            $status_id = $this->db->f('status_id');
    	    return $status_id;
	}

	function read_products($start, $limit, $query = '', $object = 'category',$filter = '', $sort = '', $order = '',$status = 'active') 
	{
	    global $phpgw;

	    if ($order) 
	    { 
		$ordermethod = " order by $order $sort "; 
	    }
	    else 
	    { 
		$ordermethod = " order by id asc "; 
	    }

	    if ($query) 
	    { 
		$querymethod = " AND (name like '%$query%' OR descr like '%$query%' OR id like '%$query%') "; 
	    }

	    if ($status == 'active') : $status_sort = " status !='" . $this->status_id . "'";
	    elseif ($status == 'minstock') : $status_sort = " status !='" . $this->status_id . "' AND mstock >= stock AND mstock != '0'";
	    elseif ($status == 'archive') : $status_sort = " status ='" . $this->status_id . "'";
	    endif;

	    $sql = "SELECT * from phpgw_inv_products WHERE $object='$filter' AND $status_sort $querymethod $ordermethod";

	    $this->db2->query($sql,__LINE__,__FILE__);
	    $this->total_records = $this->db2->num_rows();
	    $this->db->query($sql . " " . $this->db->limit($start),__LINE__,__FILE__);

	    $i = 0;
	    while($this->db->next_record()) 
	    {
		$products[$i]['con']		=	$this->db->f('con');
		$products[$i]['id']		=	$this->db->f('id');
		$products[$i]['serial']		=	$this->db->f('serial');
		$products[$i]['name']		=	$this->db->f('name');
		$products[$i]['descr']		=	$this->db->f('descr');
		$products[$i]['category']	=	$this->db->f('category');
		$products[$i]['status']		=	$this->db->f('status');
		$products[$i]['weight']		=	$this->db->f('weight');
		$products[$i]['cost']		=	$this->db->f('cost');
		$products[$i]['price']		=	$this->db->f('price');
		$products[$i]['retail']		=	$this->db->f('retail');
		$products[$i]['stock']		=	$this->db->f('stock');
		$products[$i]['mstock']		=	$this->db->f('mstock');
		$products[$i]['url']		=	$this->db->f('url');
		$products[$i]['ftp']		=	$this->db->f('ftp');
		$products[$i]['dist']		=	$this->db->f('dist');
		$products[$i]['pdate']		=	$this->db->f('pdate');
		$products[$i]['sdate']		=	$this->db->f('sdate');
		$i++;
	    }
	    return $products;
	}


	function get_owner($id) 
	{
	    global $phpgw;

                $this->db->query("select cat_owner from phpgw_categories where cat_id='$id'");
                $this->db->next_record();
		$owner = $this->db->f('cat_owner');
		return $owner;
	}

    }
?>
