<?php
  /**************************************************************************\
  * phpGroupWare API - CharSet code convert class                            *
  * (C) Copyright 2001 Yoshihiro Kamimura your@itheart.com                   *
  * ------------------------------------------------------------------------ *
  * This is not part of phpGroupWare, but is used by phpGroupWare.           * 
  * http://www.phpgroupware.org/                                             * 
  * ------------------------------------------------------------------------ *
  * This program is free software; you can redistribute it and/or modify it  *
  * under the terms of the GNU Lesser General Public License as published    *
  * by the Free Software Foundation; either version 2.1 of the License, or   *
  * any later version.                                                       *
  \**************************************************************************/


class codecv {

	var $m_inside;
	var $m_outside;
	var $m_needconv;

	function codecv() {
		global	$phpgw;

		$this->m_inside = strtolower(lang('charset'));
		$this->m_outside = strtolower(lang('outcharset'));
		$this->m_needconv = ($this->m_inside != $this->m_outside);
	}

	function get_charcode($str) {
		$b = unpack('C*', $str);
		$n = count($b);
		$is_ascii = TRUE;

		for ($i = 1; $i < $n; $i++){
			if ($b[$i] == 0x1B && $b[$i+1] == 0x24)
			{
				return 'JIS';
			}

			if ($b[$i] <= 0x7F)
			{
				continue;
			}

			$is_ascii = FALSE;

			if ($b[$i] <= 0x9F)
			{
				return 'SJIS';
			}

			if ($b[$i] <= 0xDF)
			{
				return 'EUC';
			}

			if ($b[$i] >= 0xF0)
			{
				return 'SJIS';
			}

			if ($b[$i+1] <= 0xA0)
			{
				return 'SJIS';
			}

			if ($b[$i+1] >= 0xFD)
			{
				return 'EUC';
			}

			$i++;
		}

		if ($is_ascii)
		{
			return 'US-ASCII';
		}

		return 'UNKNOWN';
	}

	function jistoeuc($str_jis) {
		$str_euc = '';
		$mode = 0;
		$b = unpack('C*', $str_jis);
		$n = count($b);

		for ($i = 1; $i <= $n; $i++) {
			if ($b[$i] == 0x1B) {
				if (($b[$i+1] == 0x24 && $b[$i+2] == 0x42) ||
			   	($b[$i+1] == 0x24 && $b[$i+2] == 0x40)) {
					$mode = 1;
				} elseif (($b[$i+1] == 0x28 && $b[$i+2] == 0x49)){
					$mode = 2;
				} else {
					$mode = 0;
				}
				$i += 3;
			}

			if ($mode == 1) {
				$b[$i] |= 0x80; $b[$i+1] |= 0x80;
				$str_euc .= pack('CC', $b[$i], $b[$i+1]);
				$i++;
			} elseif ($mode == 2) {
				$b[$i] |= 0x80;
				$str_euc .= pack('CC', 0x8E, $b[$i]);
			} else {
				$str_euc .= pack('C', $b[$i]);
			}
		}

		return $str_euc;
	}

	function euctojis($str_euc) {
		$str_jis = '';
		$mode = 0;
		$b = unpack('C*', $str_euc);
		$n = count($b);

		for ($i = 1; $i <= $n; $i++) {
			if ($b[$i] == 0x8E) {
				if ($mode != 2) {
					$mode = 2;
					$str_jis .= pack('CCC', 0x1B, 0x28, 0x49);
				}
				$b[$i+1] &= ~0x80;
				$str_JIS .= pack('C', $b[$i+1]);
				$i++;
			} elseif ($b[$i] > 0x8E) {
				if ($mode != 1) {
					$mode = 1;
					$str_jis .= pack('CCC', 0x1B, 0x24, 0x42);
				}
				$b[$i] &= ~0x80; $b[$i+1] &= ~0x80;
				$str_jis .= pack('CC', $b[$i], $b[$i+1]);
				$i++;
			} else {
				if ($mode != 0) {
					$mode = 0;
					$str_jis .= pack('CCC', 0x1B, 0x28, 0x42);
				}
				$str_jis .= pack("C", $b[$i]);
			}
		}

		if ($mode != 0)
		{
			$str_jis .= pack('CCC', 0x1B, 0x28, 0x42);
		}

		return $str_jis;
	}

	function in2out($str) {
		if ($this->m_needconv)
		{
			return	$this->euctojis($str);
		}
		else
		{
			return	$str;
		}
	}

	function out2in($str) {
		if ($this->m_needconv)
		{
			return	$this->jistoeuc($str);
		}
		else
		{
			return	$str;
		}
	}
}
?>
